/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.UnsupportedEncodingException;
import org.jacorb.util.Debug;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class BTCConverter {
    private ByteToCharConverter converter;

    public BTCConverter(String encoding) {
        try {
            this.converter = ByteToCharConverter.getConverter((String)encoding);
            this.converter.setSubstitutionMode(false);
        }
        catch (UnsupportedEncodingException ex) {
            if (Debug.isDebugEnabled()) {
                Debug.output(4, ex);
            }
            throw new DATA_CONVERSION(ex.getMessage());
        }
    }

    public char[] convert(byte[] value, int offset, int length) {
        char[] result = null;
        try {
            int resultingNumChars = 0;
            result = new char[length * this.converter.getMaxCharsPerByte()];
            this.converter.reset();
            resultingNumChars = this.converter.convert(value, offset, offset + length, result, 0, result.length);
            if ((resultingNumChars += this.converter.flush(result, 0, result.length)) < result.length) {
                char[] trimResult = new char[resultingNumChars];
                System.arraycopy(result, 0, trimResult, 0, resultingNumChars);
                result = trimResult;
            }
        }
        catch (MalformedInputException ex) {
            if (Debug.isDebugEnabled()) {
                Debug.output(4, ex);
            }
            throw new DATA_CONVERSION(ex.getMessage());
        }
        catch (UnknownCharacterException ex) {
            if (Debug.isDebugEnabled()) {
                Debug.output(4, ex);
            }
            throw new DATA_CONVERSION(ex.getMessage());
        }
        catch (ConversionBufferFullException ex) {
            if (Debug.isDebugEnabled()) {
                Debug.output(4, ex);
            }
            throw new INTERNAL(ex.getMessage());
        }
        return result;
    }
}

