/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.gui.pm;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.List;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Constructor;
import org.jacorb.poa.gui.POAManagerMonitorController;
import org.jacorb.poa.gui.POAManagerMonitorView;
import org.jacorb.poa.gui.beans.CloseButtonPanel;
import org.jacorb.poa.gui.beans.CloseButtonPanelController;
import org.jacorb.poa.gui.beans.ConsolePanel;
import org.jacorb.poa.gui.pm.POAManagerStatePanel;
import org.jacorb.poa.gui.pm.RegisterPanelController;
import org.jacorb.poa.gui.pm.StatePanelController;

public class POAManagerFrame
extends Frame
implements CloseButtonPanelController,
RegisterPanelController,
StatePanelController,
POAManagerMonitorView,
WindowListener {
    private POAManagerMonitorController controller;
    private String[] stateChoiceItems = new String[]{"Active", "Holding", "Discarding", "Inactive"};
    private String currentStateItem = this.stateChoiceItems[1];
    private List poaList = null;
    private Choice stateChoice = null;
    private Checkbox waitCheckbox = null;
    private Checkbox etherializeCheckbox = null;
    private Panel ivjContentsPane = null;
    private CloseButtonPanel ivjButtonPanel = null;
    private POAManagerStatePanel ivjPOAManagerStatePanel = null;
    private BorderLayout ivjContentsPaneBorderLayout = null;
    private ConsolePanel ivjConsolePanel = null;
    private BorderLayout ivjPOAManagerFrameBorderLayout = null;

    public POAManagerFrame() {
        this.initialize();
    }

    public POAManagerFrame(POAManagerMonitorController _controller) {
        this.controller = _controller;
        this.initialize();
    }

    public POAManagerFrame(String title) {
        super(title);
    }

    public void _actionCloseButtonPressed() {
        if (this.controller != null) {
            this.controller.actionCloseView();
        }
    }

    public void _actionClosePOAMonitor(String name) {
        if (this.controller != null) {
            this.controller.actionClosePOAMonitor(name);
        }
    }

    public void _actionDestroyPOA(String name) {
        if (this.controller != null) {
            this.controller.actionDestroyPOA(name);
        }
    }

    public void _actionOpenPOAMonitor(String name) {
        if (this.controller != null) {
            this.controller.actionOpenPOAMonitor(name);
        }
    }

    public void _addPOA(String name) {
        this._getPOAList().add(name);
    }

    public void _destroy() {
        this.dispose();
    }

    private Checkbox _getEtherializeCheckbox() {
        if (this.etherializeCheckbox == null) {
            this.etherializeCheckbox = this.getPOAManagerStatePanel()._getStatePanel()._getEtherializeCheckbox();
        }
        return this.etherializeCheckbox;
    }

    private List _getPOAList() {
        if (this.poaList == null) {
            this.poaList = this.getPOAManagerStatePanel()._getRegisterPanel()._getPOAList();
        }
        return this.poaList;
    }

    private Choice _getStateChoice() {
        if (this.stateChoice == null) {
            this.stateChoice = this.getPOAManagerStatePanel()._getStatePanel()._getStateChoice();
        }
        return this.stateChoice;
    }

    private Checkbox _getWaitCheckbox() {
        if (this.waitCheckbox == null) {
            this.waitCheckbox = this.getPOAManagerStatePanel()._getStatePanel()._getWaitCheckbox();
        }
        return this.waitCheckbox;
    }

    public void _printMessage(String str) {
        this.getConsolePanel()._printMessage(str);
    }

    public void _removePOA(String name) {
        this._getPOAList().remove(name);
    }

    public void _resetState() {
        this._getStateChoice().select(this.currentStateItem);
    }

    public void _setToActive() {
        this.currentStateItem = this.stateChoiceItems[0];
        this._getStateChoice().select(this.currentStateItem);
        this._getWaitCheckbox().setState(false);
        this._getEtherializeCheckbox().setState(false);
    }

    public void _setToDiscarding(boolean wait) {
        this.currentStateItem = this.stateChoiceItems[2];
        this._getStateChoice().select(this.currentStateItem);
        this._getWaitCheckbox().setState(wait);
        this._getEtherializeCheckbox().setState(false);
    }

    public void _setToHolding(boolean wait) {
        this.currentStateItem = this.stateChoiceItems[1];
        this._getStateChoice().select(this.currentStateItem);
        this._getWaitCheckbox().setState(wait);
        this._getEtherializeCheckbox().setState(false);
    }

    public void _setToInactive(boolean wait, boolean etherialize) {
        this.currentStateItem = this.stateChoiceItems[3];
        this._getStateChoice().select(this.currentStateItem);
        this._getWaitCheckbox().setState(wait);
        this._getEtherializeCheckbox().setState(etherialize);
    }

    public void _setVisible(boolean visible) {
        this.setVisible(visible);
    }

    public void _stateItemChanged(String item, boolean wait, boolean etherialize) {
        if (item.equals(this.currentStateItem)) {
            return;
        }
        if (this.controller != null) {
            if (item.equals(this.stateChoiceItems[0])) {
                this.controller.actionSetToActive();
            } else if (item.equals(this.stateChoiceItems[1])) {
                this.controller.actionSetToHolding(wait);
            } else if (item.equals(this.stateChoiceItems[2])) {
                this.controller.actionSetToDiscarding(wait);
            } else if (item.equals(this.stateChoiceItems[3])) {
                this.controller.actionSetToInactive(wait, etherialize);
            }
        }
    }

    private void connEtoC1(WindowEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private CloseButtonPanel getButtonPanel() {
        if (this.ivjButtonPanel == null) {
            try {
                this.ivjButtonPanel = new CloseButtonPanel();
                this.ivjButtonPanel.setName("ButtonPanel");
                this.ivjButtonPanel.setBackground(SystemColor.control);
                this.ivjButtonPanel.setSize(427, 34);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonPanel;
    }

    private ConsolePanel getConsolePanel() {
        if (this.ivjConsolePanel == null) {
            try {
                this.ivjConsolePanel = new ConsolePanel();
                this.ivjConsolePanel.setName("ConsolePanel");
                this.ivjConsolePanel.setBackground(SystemColor.control);
                this.ivjConsolePanel.setSize(426, 240);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjConsolePanel;
    }

    private Panel getContentsPane() {
        if (this.ivjContentsPane == null) {
            try {
                this.ivjContentsPane = new Panel();
                this.ivjContentsPane.setName("ContentsPane");
                this.ivjContentsPane.setLayout(this.getContentsPaneBorderLayout());
                this.ivjContentsPane.setBackground(SystemColor.control);
                this.getContentsPane().add((Component)this.getButtonPanel(), "South");
                this.getContentsPane().add((Component)this.getConsolePanel(), "Center");
                this.getContentsPane().add((Component)this.getPOAManagerStatePanel(), "North");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjContentsPane;
    }

    private BorderLayout getContentsPaneBorderLayout() {
        BorderLayout ivjContentsPaneBorderLayout = null;
        try {
            ivjContentsPaneBorderLayout = new BorderLayout();
            ivjContentsPaneBorderLayout.setVgap(0);
            ivjContentsPaneBorderLayout.setHgap(0);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjContentsPaneBorderLayout;
    }

    private BorderLayout getPOAManagerFrameBorderLayout() {
        BorderLayout ivjPOAManagerFrameBorderLayout = null;
        try {
            ivjPOAManagerFrameBorderLayout = new BorderLayout();
            ivjPOAManagerFrameBorderLayout.setVgap(0);
            ivjPOAManagerFrameBorderLayout.setHgap(0);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjPOAManagerFrameBorderLayout;
    }

    private POAManagerStatePanel getPOAManagerStatePanel() {
        if (this.ivjPOAManagerStatePanel == null) {
            try {
                this.ivjPOAManagerStatePanel = new POAManagerStatePanel();
                this.ivjPOAManagerStatePanel.setName("POAManagerStatePanel");
                this.ivjPOAManagerStatePanel.setBackground(SystemColor.control);
                this.ivjPOAManagerStatePanel.setSize(310, 100);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPOAManagerStatePanel;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() {
        this.addWindowListener(this);
    }

    private void initialize() {
        this.setName("POAManagerFrame");
        this.setLayout(this.getPOAManagerFrameBorderLayout());
        this.setBackground(SystemColor.control);
        this.setSize(318, 210);
        this.setTitle("POAManager Monitor");
        this.add((Component)this.getContentsPane(), "Center");
        this.initConnections();
        for (int i = 0; i < this.stateChoiceItems.length; ++i) {
            this._getStateChoice().addItem(this.stateChoiceItems[i]);
        }
        this._getStateChoice().select(this.stateChoiceItems[1]);
        this.getPOAManagerStatePanel()._getStatePanel()._init(this);
        this.getPOAManagerStatePanel()._getRegisterPanel()._init(this);
        this.getButtonPanel()._init(this, "Close");
    }

    public static void main(String[] args) {
        try {
            POAManagerFrame aPOAManagerFrame = new POAManagerFrame();
            try {
                Class<?> aCloserClass = Class.forName("com.ibm.uvm.abt.edit.WindowCloser");
                Class[] parmTypes = new Class[]{Window.class};
                Object[] parms = new Object[]{aPOAManagerFrame};
                Constructor<?> aCtor = aCloserClass.getConstructor(parmTypes);
                aCtor.newInstance(parms);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            aPOAManagerFrame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of java.awt.Frame");
            exception.printStackTrace(System.out);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.connEtoC1(e);
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

