/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import org.jacorb.util.Debug;

public class KeyStoreUtil {
    public static KeyStore getKeyStore(String file_name, char[] storepass) throws Exception {
        String name;
        File f = new File(file_name);
        if (!f.exists() && !(f = new File(name = System.getProperty("user.home") + System.getProperty("file.separator") + file_name)).exists()) {
            Debug.output(1, "ERROR: Unable to find keystore file");
            Debug.output(1, "It neither isn't in " + new File(file_name).getAbsolutePath());
            Debug.output(1, "nor in " + f.getAbsolutePath());
            return null;
        }
        FileInputStream in = new FileInputStream(f);
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(in, storepass);
        in.close();
        return ks;
    }
}

