/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms;

import cerent.cms.IPlatformFactory;
import cerent.util.SDebug;
import java.util.HashMap;

public class PlatformFactoryManager {
    private static final String[] NE_TYPES = new String[]{"15454", "com.cisco.ctc454.PlatformFactory", "15454SDH", "com.cisco.ctc455.PlatformFactory", "15327", "com.cisco.ctc327.PlatformFactory", "15600", "com.cisco.ctc600.PlatformFactory", "15310CL", "com.cisco.ctc310cl.PlatformFactory", "15310MA", "com.cisco.ctc310ma.PlatformFactory"};
    private static HashMap platformFactoryMap = new HashMap();
    private static final SDebug dbg = new SDebug("PlatformFactoryManager");

    private PlatformFactoryManager() {
    }

    public static IPlatformFactory getPlatformFactory(String string, String string2) {
        IPlatformFactory iPlatformFactory;
        if (dbg.on()) {
            dbg.println("getPlatformFactory hostName=" + string + " neType=" + string2);
        }
        if ((iPlatformFactory = (IPlatformFactory)platformFactoryMap.get(string2)) == null) {
            String string3 = null;
            for (int i = 0; i < NE_TYPES.length; i += 2) {
                if (!string2.equals(NE_TYPES[i])) continue;
                string3 = NE_TYPES[i + 1];
                break;
            }
            if (string3 != null) {
                ReflectiveOperationException reflectiveOperationException = null;
                try {
                    Class<?> clazz = PlatformFactoryManager.class.getClassLoader().loadClass(string3);
                    iPlatformFactory = (IPlatformFactory)clazz.newInstance();
                    platformFactoryMap.put(string2, iPlatformFactory);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    reflectiveOperationException = classNotFoundException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    reflectiveOperationException = illegalAccessException;
                }
                catch (InstantiationException instantiationException) {
                    reflectiveOperationException = instantiationException;
                }
                if (reflectiveOperationException != null) {
                    dbg.severe("neType=" + string2 + " className=" + string3 + " " + reflectiveOperationException);
                    SDebug.printStackTrace((Throwable)reflectiveOperationException);
                }
            } else {
                dbg.severe("Unknown neType=" + string2);
            }
        }
        if (dbg.on()) {
            dbg.println("IPlatformFactory=" + iPlatformFactory);
        }
        return iPlatformFactory;
    }
}

