/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.loader;

import cerent.cms.IPlatformFactory;
import cerent.cms.PlatformFactoryManager;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.loader.INodeFactory;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.EntityModel;
import cerent.cms.model.Feature;
import cerent.cms.model.IEqType;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOspfTopologyModel;
import cerent.cms.model.IPoolModels;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PoolModelsDelegate;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.IViewController;
import cerent.cms.ui.MultishelfViewController;
import cerent.cms.ui.ShelfViewController;
import cerent.util.ConcurrentReaderMap;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Image;
import java.net.UnknownHostException;
import java.util.HashSet;

public class NodeFactory
implements INodeFactory {
    private static ConcurrentReaderMap knownDynamicFeatures = new ConcurrentReaderMap();
    private static final SDebug db = new SDebug("NodeFactory");
    private static final HashSet featureSet = new HashSet();
    private static final NodeFactory _instance;

    public IViewController createSVC(IViewController iViewController, INodeModel iNodeModel, IUiToolkit iUiToolkit) {
        NodeModelDelegate nodeModelDelegate;
        if (db.on()) {
            db.println("createSVC( " + iViewController + "," + iNodeModel + "," + iUiToolkit + ")");
        }
        if ((nodeModelDelegate = (NodeModelDelegate)iNodeModel.getDelegate()).isMultishelf()) {
            return new MultishelfViewController(iViewController, iNodeModel, iUiToolkit);
        }
        return new ShelfViewController(iViewController, nodeModelDelegate.getNcChassis(), iUiToolkit, false);
    }

    public INodeModel createNodeModel(INodeModel iNodeModel, KDebug kDebug, String string, int n) {
        NodeModelDelegate nodeModelDelegate;
        block5: {
            nodeModelDelegate = null;
            IPlatformFactory iPlatformFactory = PlatformFactoryManager.getPlatformFactory(string, iNodeModel.getNeType());
            if (iPlatformFactory != null) {
                try {
                    nodeModelDelegate = iPlatformFactory.getPlatformNodeModel(iNodeModel, kDebug, string, n);
                }
                catch (UnknownHostException unknownHostException) {
                    if (kDebug.on()) {
                        kDebug.println("NodeFactory.createNodeModel() " + unknownHostException);
                        KDebug.printStackTrace((Throwable)unknownHostException);
                    }
                }
                catch (CTCUserException cTCUserException) {
                    if (!kDebug.on()) break block5;
                    kDebug.println("NodeFactory.createNodeModel() " + (Object)((Object)cTCUserException));
                    KDebug.printStackTrace((Throwable)cTCUserException);
                }
            }
        }
        return nodeModelDelegate;
    }

    public IOspfTopologyModel createOspfTopologyModel(INodeModel iNodeModel) {
        return ((NodeModelDelegate)iNodeModel.getDelegate()).getOspfTopologyModel();
    }

    public boolean isCardViewAvailable(IModuleModel iModuleModel) {
        return false;
    }

    public Image[] getIconSet() {
        return null;
    }

    public Image[] getIconSet(INodeModel iNodeModel) {
        if (db.on()) {
            db.println("getIconSet nm=" + iNodeModel.getName());
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)iNodeModel.getDelegate();
        return nodeModelDelegate.getPlatform().getIcons(nodeModelDelegate);
    }

    public IPoolModels createPoolModels(INodeModel iNodeModel) {
        return PoolModelsDelegate.getInstance((NodeModelDelegate)iNodeModel.getDelegate());
    }

    public IEntityCellRenderer createEntityCellRenderer() {
        return new EntityCellRenderer();
    }

    public IEntityCellRenderer createEntityCellRenderer(boolean bl) {
        return new EntityCellRenderer(bl);
    }

    public IEntityCellRenderer createEntityCellRenderer(String string) {
        return new EntityCellRenderer(string);
    }

    public String getConstString(INodeModel iNodeModel, Class clazz, int n) {
        if (clazz == IEqType.class) {
            TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
            return EntityModel.eqType2Name(tDMTerminology, eEqType.from_int(n));
        }
        return null;
    }

    public String getConstString(Class clazz, int n) {
        throw new DeprecatedMethodCalled("FTG deprecated getConstString(Class, int)");
    }

    public boolean provides(Feature feature) {
        if (db.on()) {
            db.println("provides( " + feature.toString() + " ) -> " + featureSet.contains(feature));
        }
        return featureSet.contains(feature);
    }

    public Boolean isKnownDynamic(Feature feature) {
        return (Boolean)knownDynamicFeatures.get((Object)feature);
    }

    public void setDynamic(Feature feature, boolean bl) {
        knownDynamicFeatures.put((Object)feature, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
    }

    public static synchronized NodeFactory instance() {
        return _instance;
    }

    static {
        featureSet.add(Feature.IDL_200);
        featureSet.add(Feature.IDL_201);
        featureSet.add(Feature.IDL_203);
        featureSet.add(Feature.IDL_210);
        featureSet.add(Feature.IDL_211);
        featureSet.add(Feature.IDL_212);
        featureSet.add(Feature.IDL_220);
        featureSet.add(Feature.IDL_230);
        featureSet.add(Feature.IDL_CASE_INSENSITIVE_IDL);
        featureSet.add(Feature.IDL_RMON);
        featureSet.add(Feature.REV_PROT_OP);
        featureSet.add(Feature.PROVIDES_V2);
        featureSet.add(Feature.STS_IFACE);
        featureSet.add(Feature.LOOPBACK_IFACE);
        featureSet.add(Feature.MONITOR_CKTS);
        featureSet.add(Feature.STS_CONNS_USING_PATH);
        featureSet.add(Feature.PATH_WIDTH);
        featureSet.add(Feature.CONDITIONS_WITH_EXCLUSION);
        featureSet.add(Feature.SEC_GET_USERS);
        featureSet.add(Feature.SEC_CLR_VIOLATION_ALM);
        featureSet.add(Feature.BACKEND_STP);
        featureSet.add(Feature.NODE_POLLER_INTERFACE);
        featureSet.add(Feature.CTM_SUPPORT_INTERFACE);
        featureSet.add(Feature.VT_PATHWIDTH);
        featureSet.add(Feature.J1_NOAIS);
        featureSet.add(Feature.UPSR_ATTRIBUTES);
        featureSet.add(Feature.UPSR_REVERSE_SWITCH_COUNTS);
        featureSet.add(Feature.PCA);
        featureSet.add(Feature.HTTP_DATA_TRANSFER);
        featureSet.add(Feature.FTG);
        featureSet.add(Feature.HASLPBK_IFACE);
        featureSet.add(Feature.NET_BLSR_WIZ);
        featureSet.add(Feature.MULTI_OSPF_AREAS);
        featureSet.add(Feature.TOPO_LIFECYCLE_MGMT);
        featureSet.add(Feature.NODE_STATUS_LIST);
        featureSet.add(Feature.ALARM_EVENT_FILTER);
        featureSet.add(Feature.PARTIAL_PCA_CIRCUITS);
        featureSet.add(Feature.OSPF_TLV);
        featureSet.add(Feature.FEATURE_VERSIONING);
        featureSet.add(Feature.GCC_PROVISIONING);
        featureSet.add(Feature.SECURITY_USER_STATUS);
        featureSet.add(Feature.SECURITY_POLICY);
        featureSet.add(Feature.SPAN_PROT_DISPLAY);
        featureSet.add(Feature.HASXCLPBK_IFACE);
        featureSet.add(Feature.XML_ARCH15);
        featureSet.add(Feature.J2_NOAIS);
        featureSet.add(Feature.XML_ASSOCIATION);
        featureSet.add(Feature.OCHNC_PROVISIONING);
        featureSet.add(Feature.OCHNC_BIDI_PROVISIONING);
        featureSet.add(Feature.OPTIONAL_ALARM_FIELDS);
        featureSet.add(Feature.NODE_DEFAULTS);
        featureSet.add(Feature.SUPPORTS_MAINTENANCE_DOWNLOAD);
        featureSet.add(Feature.CTM_ALARM_LOG_FILTER);
        featureSet.add(Feature.CTM_ALARM_HISTORY);
        featureSet.add(Feature.BLSR_PATRIOT_EXTENSIONS);
        featureSet.add(Feature.SECURITY_TICKET);
        featureSet.add(Feature.ENHANCED_DCC);
        featureSet.add(Feature.SEC_FORCE_PASSWD_CHANGE);
        featureSet.add(Feature.SEC_PASSWD_AGING);
        featureSet.add(Feature.SEC_PASSWD_FLIPPING);
        featureSet.add(Feature.SEC_DISABLE_USERID);
        featureSet.add(Feature.DOM_NODE_IN_OUT);
        featureSet.add(Feature.CTM_RESYNC);
        featureSet.add(Feature.CTM_RESTART);
        featureSet.add(Feature.HASTACC_IFACE);
        featureSet.add(Feature.BLSR_UPSR_DRI);
        featureSet.add(Feature.SYSTEM_TIME);
        featureSet.add(Feature.UPSR_VT_THRESH);
        featureSet.add(Feature.EXP_PORT_NUM);
        featureSet.add(Feature.DS3XM12);
        featureSet.add(Feature.PATH_TRACE_CLEANUP);
        featureSet.add(Feature.VLINK_PROVISIONING);
        featureSet.add(Feature.GET_PORTS_IN_GROUP);
        featureSet.add(Feature.NODE_ALARM_INTERFACE);
        featureSet.add(Feature.TCC2P_SECURITY_MODE);
        featureSet.add(Feature.EID_REMOVAL);
        featureSet.add(Feature.COLLAPSED_CIRCUIT_CREATE);
        featureSet.add(Feature.SF_SD_CLEANUP);
        featureSet.add(Feature.ENTITY_ALARM_STATUS);
        featureSet.add(Feature.MEMORY_FOOTPRINT);
        featureSet.add(Feature.DOM_REUSE);
        featureSet.add(Feature.VT_GROOMING);
        featureSet.add(Feature.TCCU);
        featureSet.add(Feature.FORCE_DESTROY);
        featureSet.add(Feature.ADDNODE2OPO);
        featureSet.add(Feature.ENHANCED_BRIDGE_AND_ROLL);
        featureSet.add(Feature.PROV_ALM_SEV);
        featureSet.add(Feature.MRC_PORT_GROUPING);
        featureSet.add(Feature.MRC_CHANGE_EQ_TYPE);
        featureSet.add(Feature.SELECTOR_ADDED_ATTRS);
        featureSet.add(Feature.GET_LINE_INTERFACE_MODEL);
        featureSet.add(Feature.SET_PROTECTION_1P1);
        featureSet.add(Feature.REMOTE_ELE_V1);
        featureSet.add(Feature.SECURITY_VERSIONING);
        featureSet.add(Feature.DS1_E1_56);
        featureSet.add(Feature.MULTISHELF);
        featureSet.add(Feature.VT_SQUELCHING);
        featureSet.add(Feature.OCH_TRAIL_PROVISIONING);
        featureSet.add(Feature.SERVER_TRAIL);
        featureSet.add(Feature.BNR_CONN_RTRV);
        featureSet.add(Feature.TCA_DIRECTION);
        featureSet.add(Feature.C310MA);
        featureSet.add(Feature.NMD_BASED_CM_DESTROY);
        featureSet.add(Feature.ML2_CIRCUIT);
        featureSet.add(Feature.RPR_802_17);
        _instance = new NodeFactory();
    }
}

