/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ANS;

import cerent.cms.model.ANS.ANSNode;
import cerent.cms.model.ANS.IANSElement;
import cerent.cms.model.ANS.IANSNode;
import cerent.cms.model.ProvisionError;
import java.util.ArrayList;

public class ANSElement
extends ANSNode
implements IANSElement,
Comparable {
    private String myUnits = null;
    private String myValue = null;
    private String oldValue = null;
    private String mykeyString = null;
    private int myClass = 0;
    private Object myElemKey = null;
    private ArrayList validEnumValues = null;
    private boolean reprovisions = false;
    private boolean destructive = false;
    private int index = -1;
    private boolean readOnly = false;

    public ANSElement(String string, Object object, String string2, int n, ANSNode aNSNode, String string3, String string4, int n2, ArrayList arrayList, boolean bl, boolean bl2) {
        super(string, aNSNode);
        this.myValue = string3;
        this.myElemKey = object;
        this.mykeyString = string2;
        this.index = n;
        this.myUnits = string4;
        this.myClass = n2;
        this.validEnumValues = arrayList;
        this.dirty = false;
        this.reprovisions = bl;
        this.destructive = bl2;
        if (this.destructive) {
            this.reprovisions = true;
        }
        if (this.myUnits != null && this.myUnits.length() == 0) {
            this.myUnits = null;
        }
    }

    public ANSElement(String string, Object object, String string2, int n, String string3, int n2, ArrayList arrayList) {
        this(string, object, string2, n, null, "", string3, n2, arrayList, true, false);
    }

    public int compareTo(Object object) {
        return this.mykeyString.compareTo(((ANSElement)object).getKeyStr());
    }

    public void setValue(String string) throws ProvisionError {
        this.checkValue(string);
        if (!this.myValue.equals(string)) {
            this.oldValue = this.myValue;
            this.myValue = string;
            if (!string.equals("UNKNOWN")) {
                this.setDirty();
            } else {
                this.makeClean();
                this.recalcDirty();
            }
        }
    }

    public boolean reprovisions() {
        return this.reprovisions;
    }

    public boolean causesReboot() {
        return this.destructive;
    }

    public void resetValue() {
        this.myValue = this.oldValue;
        this.recalcDirty();
    }

    public void initValue(String string) throws ProvisionError {
        this.myValue = string;
    }

    private IANSElement getSiblingElement(String string) {
        IANSElement iANSElement = null;
        if (string != this.getName()) {
            IANSNode[] iANSNodeArray = this.getParent().getChildren();
            for (int i = 0; i < iANSNodeArray.length; ++i) {
                if (!iANSNodeArray[i].getName().equals(string)) continue;
                if (!(iANSNodeArray[i] instanceof IANSElement)) break;
                iANSElement = (IANSElement)iANSNodeArray[i];
                break;
            }
        }
        return iANSElement;
    }

    public void checkValue(String string) throws ProvisionError {
        if (this.myClass == 0) {
            if (this.validEnumValues != null && this.validEnumValues.size() == 2) {
                try {
                    float f = Float.parseFloat((String)this.validEnumValues.get(0));
                    float f2 = Float.parseFloat((String)this.validEnumValues.get(1));
                    try {
                        float f3 = Float.parseFloat(string);
                        if (f3 < f || f3 > f2) {
                            throw new ProvisionError("value \"" + string + "\" out of range [" + f + ".." + f2 + "]");
                        }
                        if (!this.checkdecimalNum(f3)) {
                            throw new ProvisionError("value \"" + string + "\" has too many decimal points " + "\" [xx.0 .. xx.9]");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ProvisionError("value \"" + string + "\" must be an integer [" + f + ".." + f2 + "]");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ProvisionError("range " + (String)this.validEnumValues.get(0) + "-" + (String)this.validEnumValues.get(1) + " must be integral");
                }
            }
        } else if (this.myClass == 2 || this.myClass == 7) {
            if (this.getCurrentlyValidEnumValues().indexOf(string) > -1) {
                return;
            }
            throw new ProvisionError("\"" + string + "\" is not a valid enum value");
        }
    }

    private boolean checkdecimalNum(float f) {
        if (f < 0.0f || f > 0.0f) {
            return f * 10.0f % (float)((int)(f * 10.0f)) == 0.0f;
        }
        return true;
    }

    public String getValue() {
        return this.myValue;
    }

    public int getIntValue() {
        int n = -1;
        if (this.myClass == 0) {
            n = (int)(Float.parseFloat(this.getValue()) * 10.0f);
        } else if (this.myClass == 2) {
            n = this.getCurrentlyValidEnumValues().indexOf(this.getValue());
        }
        return n;
    }

    public Object getKey() {
        return this.myElemKey;
    }

    public String getKeyStr() {
        return this.mykeyString;
    }

    public String getUnits() {
        return this.myUnits;
    }

    public int getDefElemClass() {
        return this.myClass;
    }

    public void clearValidEnumValues() {
        this.validEnumValues.clear();
    }

    public void setValidEnumValues(ArrayList arrayList) {
        this.validEnumValues = arrayList;
    }

    private ArrayList getCurrentlyValidEnumValues() {
        ArrayList arrayList = this.validEnumValues;
        return arrayList;
    }

    public String[] getValidEnumValues() {
        return this.getCurrentlyValidEnumValues().toArray(new String[0]);
    }

    public void applyToNode() {
        this.dirty = false;
    }

    public String getFullName() {
        return this.name;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        int n = this.name.lastIndexOf(".");
        return this.name.substring(n + 1);
    }

    public void makeClean() {
        this.dirty = false;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }
}

