/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.If.eIfType;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.Optics.General;
import cerent.cms.idl.Optics.eLaserStatus;
import cerent.cms.idl.Optics.eOSRIStatus;
import cerent.cms.idl.Optics.eOpticalPortType;
import cerent.cms.idl.Optics.eRingDirection;
import cerent.cms.idl.Optics.eSwitchablePortState;
import cerent.cms.idl.Optics.eVOAControlMode;
import cerent.cms.idl.Optics.sActualOpticsAttributes;
import cerent.cms.idl.Optics.sAlarmThresholds;
import cerent.cms.idl.Optics.sGeneralOpticsAttributes;
import cerent.cms.idl.Optics.sOpticsAlmThresholds;
import cerent.cms.idl.Optics.sOpticsPmStats;
import cerent.cms.idl.Optics.sOpticsTCAThresholds;
import cerent.cms.idl.Optics.sValThresholds;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.idl.Optics.xProvisioningError;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IAdminLineAccess;
import cerent.cms.model.IOpticsModel;
import cerent.cms.model.IParserIfName;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ParserIfName;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ProvisionExceptionData;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import org.omg.CORBA.UserException;

public abstract class AbstractOpticsLineModel
extends InterfaceModel
implements IOpticsModel,
IAdminLineAccess {
    protected AlmThresholds almTh;
    protected TCAThresholds tcaTh15Min;
    protected TCAThresholds tcaThDay;
    protected General ifReference;
    private OpticsStats opticsStats;
    private ActualOpticsAttributes actualOpticsAttr;
    private Directionality dir;
    private GeneralAttributes genAttr;
    private VOAAttenuation voaAtt;
    private VOAPower voaPower;
    private LaserStatus laserStatus;
    private ManualRestart manualRestart;
    private OSRI osri;
    private IParserIfName parserIfName;
    private CalibratedPower calPower;
    private AddPTPortState addptPortStatus;
    private AddPTPowerThreshold addptTh;
    public static final int OPTICS_PORT_NONE = 0;
    public static final int OPTICS_PORT_RX = 1;
    public static final int OPTICS_PORT_TX = 2;
    public static final int OPTICS_PORT_PT = 3;
    public static final int OPTICS_PORT_IN = 4;
    public static final int OPTICS_PORT_OUT = 5;
    public static final int OPTICS_PORT_EXP = 6;
    public static final int OPTICS_PORT_LINE = 7;
    public static final int OPTICS_PORT_COM = 8;
    public static final int OPTICS_PORT_DC = 9;
    public static final int OPTICS_PORT_CHAN = 10;
    public static final int OPTICS_PORT_OSC = 11;
    public static final int OPTICS_PORT_ADD = 12;
    public static final int OPTICS_PORT_DROP = 13;

    public AbstractOpticsLineModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2, General general, SDebug sDebug) {
        super(nodeModelDelegate, n, sInterface2, sDebug);
        this.ifReference = general;
        this.tcaTh15Min = new TCAThresholds("TCAThresholds15Min", nodeModelDelegate);
        this.tcaThDay = new TCAThresholds("TCAThresholdsDay", nodeModelDelegate);
        this.almTh = new AlmThresholds("AlarmThresholds", nodeModelDelegate);
        this.opticsStats = new OpticsStats("opticsStats", nodeModelDelegate);
        this.actualOpticsAttr = new ActualOpticsAttributes("ActualOpticsAttributes", nodeModelDelegate);
        this.dir = new Directionality(nodeModelDelegate, "Directionality");
        this.genAttr = new GeneralAttributes(nodeModelDelegate, "GeneralAttributes");
        this.voaAtt = new VOAAttenuation(nodeModelDelegate, "VOAAttenuation");
        this.voaPower = new VOAPower(nodeModelDelegate, "VOAPower");
        this.laserStatus = new LaserStatus(nodeModelDelegate, "LaserStatus");
        this.manualRestart = new ManualRestart(nodeModelDelegate, "ManualRestart");
        this.osri = new OSRI(nodeModelDelegate, "OSRI");
        this.calPower = new CalibratedPower(nodeModelDelegate, "PowerReference");
        this.addptPortStatus = new AddPTPortState(nodeModelDelegate, "AddPtPortState");
        this.addptTh = new AddPTPowerThreshold("AddPTPowerThreshold", nodeModelDelegate);
    }

    public void destroy() {
        super.destroy();
    }

    public void dispose() {
        this.genAttr.dispose();
        this.laserStatus.dispose();
        this.addptPortStatus.dispose();
        this.almTh.dispose();
        this.tcaTh15Min.dispose();
        this.tcaThDay.dispose();
        this.addptTh.dispose();
        super.dispose();
    }

    protected void updateLocal(long l) {
        this.genAttr.update();
        this.laserStatus.update();
        this.addptPortStatus.update();
        this.almTh.update();
        this.tcaTh15Min.update();
        this.tcaThDay.update();
        this.addptTh.update();
        super.updateLocal(l);
    }

    protected ProvisionExceptionData getProvisioningExceptionInfo(xProvisioningError xProvisioningError2) {
        ProvisionExceptionData provisionExceptionData = new ProvisionExceptionData();
        provisionExceptionData.discriminator = xProvisioningError2.errorExtraInfo.discriminator().value();
        if (provisionExceptionData.discriminator == 3) {
            provisionExceptionData.lowValue = xProvisioningError2.errorExtraInfo.range().lowValue;
            provisionExceptionData.hiValue = xProvisioningError2.errorExtraInfo.range().hiValue;
        }
        return provisionExceptionData;
    }

    public int getPortNumber() throws NoSuchInterface {
        return this.getInfo().portNumber;
    }

    public String getPortName() throws NoSuchInterface {
        return this.getInfo().descr;
    }

    public eRingDirection getRingDirection() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
            return sGeneralOpticsAttributes2.directionality;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getRingDirection", userException);
        }
    }

    public int getOptDirection() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
            return sGeneralOpticsAttributes2.directionality.value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOptDirection", userException);
        }
    }

    public void setRingDirection(eRingDirection eRingDirection2) throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError {
        try {
            this.dir.set(eRingDirection2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setRingDirection", userException);
        }
    }

    public eOpticalPortType getPortType() throws NoSuchInterface, WrongInterfaceType {
        try {
            sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
            return sGeneralOpticsAttributes2.type;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPortType", userException);
        }
    }

    public String getPortTypeString() throws NoSuchInterface, WrongInterfaceType {
        eOpticalPortType eOpticalPortType2 = this.getPortType();
        if (eOpticalPortType2 == eOpticalPortType.INPUT) {
            return new String("Input");
        }
        if (eOpticalPortType2 == eOpticalPortType.OUTPUT) {
            return new String("Output");
        }
        if (eOpticalPortType2 == eOpticalPortType.ADD) {
            return new String("CHAN-RX");
        }
        if (eOpticalPortType2 == eOpticalPortType.DROP) {
            return new String("CHAN-TX");
        }
        if (eOpticalPortType2 == eOpticalPortType.IN_EXPRESS) {
            return new String("EXP-RX");
        }
        if (eOpticalPortType2 == eOpticalPortType.OUT_EXPRESS) {
            return new String("EXP-TX");
        }
        if (eOpticalPortType2 == eOpticalPortType.IN_LINE) {
            return new String("LINE-RX");
        }
        if (eOpticalPortType2 == eOpticalPortType.OUT_LINE) {
            return new String("LINE-TX");
        }
        if (eOpticalPortType2 == eOpticalPortType.IN_COM) {
            return new String("COM-RX");
        }
        if (eOpticalPortType2 == eOpticalPortType.OUT_COM) {
            return new String("COM-TX");
        }
        if (eOpticalPortType2 == eOpticalPortType.IN_OSC) {
            return new String("OSC-RX");
        }
        if (eOpticalPortType2 == eOpticalPortType.OUT_OSC) {
            return new String("OSC-TX");
        }
        if (eOpticalPortType2 == eOpticalPortType.IN_DC) {
            return new String("DC-RX");
        }
        if (eOpticalPortType2 == eOpticalPortType.OUT_DC) {
            return new String("DC-TX");
        }
        if (eOpticalPortType2 == eOpticalPortType.IN_PASS_THROUGH) {
            return new String("PASS-THROUGH");
        }
        if (eOpticalPortType2 == eOpticalPortType.IN_EXPRESS_A) {
            return new String("EXP A-RX");
        }
        if (eOpticalPortType2 == eOpticalPortType.OUT_EXPRESS_A) {
            return new String("EXP A-TX");
        }
        return new String("N/A");
    }

    public boolean isPortTypeTX() {
        return this.getPortTypeDir() == 2;
    }

    public boolean isPortTypeRX() {
        return this.getPortTypeDir() == 1;
    }

    public eIfType getOptIfType() throws NoSuchInterface {
        return this.getInfo().ifType;
    }

    public int getPortTypeDir() {
        int n = 0;
        eOpticalPortType eOpticalPortType2 = null;
        try {
            eOpticalPortType2 = this.getPortType();
        }
        catch (Exception exception) {
            return n;
        }
        switch (eOpticalPortType2.value()) {
            case 0: {
                n = 4;
                break;
            }
            case 1: {
                n = 5;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: {
                n = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: {
                n = 1;
                break;
            }
            case 14: {
                n = 3;
                break;
            }
        }
        return n;
    }

    public short getFeatures() throws NoSuchInterface, WrongInterfaceType {
        try {
            sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
            return sGeneralOpticsAttributes2.features;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getFeatures", userException);
        }
    }

    eLaserStatus getLaserStatus() throws NoSuchInterface, WrongInterfaceType, InternalCommError, FeatureUnsupported {
        try {
            return (eLaserStatus)this.laserStatus.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported("getLaserStatus");
        }
        catch (UserException userException) {
            throw this.doUnknown("getLaserStatus", userException);
        }
    }

    public int getActualPower() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            sActualOpticsAttributes sActualOpticsAttributes2 = (sActualOpticsAttributes)this.actualOpticsAttr.get();
            return sActualOpticsAttributes2.power;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getActualPower", userException);
        }
    }

    public int getAddPower() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if ((this.getFeatures() & 0x10) == 16) {
            try {
                sActualOpticsAttributes sActualOpticsAttributes2 = (sActualOpticsAttributes)this.actualOpticsAttr.get();
                return sActualOpticsAttributes2.addPower;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (xInternalCommError xInternalCommError2) {
                throw new InternalCommError((UserException)xInternalCommError2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getAddPower", userException);
            }
        }
        throw new WrongInterfaceType("getAddPower");
    }

    public int getInsertionLoss() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 4) == 4) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.insertionLoss;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getInsertionLoss", userException);
            }
        }
        throw new FeatureUnsupported("getInsertionLoss");
    }

    public boolean isPMSupported() {
        try {
            return (this.getFeatures() & 8) == 8;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setVOAAttenuation(int n) throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, ProvisionError {
        try {
            this.voaAtt.set(new Integer(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
        }
        catch (UserException userException) {
            throw this.doUnknown("setVOAAttenuation", userException);
        }
    }

    public eVOAControlMode getVoaMode() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 1) == 1) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.voa.mode;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getVoaMode", userException);
            }
        }
        throw new FeatureUnsupported("getVoaMode");
    }

    void execManualRestart() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            this.manualRestart.set();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("execManualRestart", userException);
        }
    }

    public int getVoaRefPower() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 1) == 1) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.voa.referencePower;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getVoaRefPower", userException);
            }
        }
        throw new FeatureUnsupported("getVoaRefPower");
    }

    public void setOSRIStatus(eOSRIStatus eOSRIStatus2) throws NoSuchInterface, WrongInterfaceType, InternalCommError, FeatureUnsupported {
        if ((this.getFeatures() & 2) == 2) {
            try {
                this.osri.set(eOSRIStatus2);
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (xInternalCommError xInternalCommError2) {
                throw new InternalCommError((UserException)xInternalCommError2);
            }
            catch (UserException userException) {
                throw this.doUnknown("setOSRIStatus", userException);
            }
        } else {
            throw new FeatureUnsupported("setOSRIStatus");
        }
    }

    public eOSRIStatus getOSRIStatus() throws NoSuchInterface, WrongInterfaceType, FeatureUnsupported {
        if ((this.getFeatures() & 2) == 2) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.osriState;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getOSRIStatus", userException);
            }
        }
        throw new FeatureUnsupported("getOSRIStatus");
    }

    public sOpticsTCAThresholds getOpticsTCAThresholds(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType {
        Object object = null;
        try {
            object = eIntervalType2 == eIntervalType.INTERVAL_15_MIN ? this.tcaTh15Min.get(eIntervalType2) : this.tcaThDay.get(eIntervalType2);
            return (sOpticsTCAThresholds)object;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsTCAThresholds", userException);
        }
    }

    public void setOpticsTCAThresholds(sOpticsTCAThresholds sOpticsTCAThresholds2, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            Object[] objectArray = new Object[]{sOpticsTCAThresholds2, eIntervalType2};
            if (eIntervalType2 == eIntervalType.INTERVAL_15_MIN) {
                this.tcaTh15Min.set(objectArray);
            } else {
                this.tcaThDay.set(objectArray);
            }
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
        }
        catch (UserException userException) {
            throw this.doUnknown("setOpticsTCAThresholds", userException);
        }
    }

    public int getOpticsTCAPowerHigh(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType {
        int n = 0;
        try {
            n = eIntervalType2 == eIntervalType.INTERVAL_15_MIN ? ((sOpticsTCAThresholds)this.tcaTh15Min.get((Object)eIntervalType2)).opticalPowerPMTh.high : ((sOpticsTCAThresholds)this.tcaThDay.get((Object)eIntervalType2)).opticalPowerPMTh.high;
            return n;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsTCAPowerHigh", userException);
        }
    }

    public int getOpticsTCAPowerLow(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType {
        int n = 0;
        try {
            n = eIntervalType2 == eIntervalType.INTERVAL_15_MIN ? ((sOpticsTCAThresholds)this.tcaTh15Min.get((Object)eIntervalType2)).opticalPowerPMTh.low : ((sOpticsTCAThresholds)this.tcaThDay.get((Object)eIntervalType2)).opticalPowerPMTh.low;
            return n;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsTCAPowerLow", userException);
        }
    }

    public sOpticsAlmThresholds getOpticsAlmThresholds() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sOpticsAlmThresholds)this.almTh.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsAlmThresholds", userException);
        }
    }

    public int getOpticsAlmPowerThresholdDegradeHigh() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sOpticsAlmThresholds)this.almTh.get()).opticalPowerAlmTh.degrade.high;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsAlmGainThresholdDegradeHigh", userException);
        }
    }

    public int getOpticsAlmPowerThresholdDegradeLow() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sOpticsAlmThresholds)this.almTh.get()).opticalPowerAlmTh.degrade.low;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsAlmPowerThresholdDegradeLow", userException);
        }
    }

    public int getOpticsAlmPowerThresholdFailLow() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sOpticsAlmThresholds)this.almTh.get()).opticalPowerAlmTh.fail.low;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsAlmPowerThresholdFailLow", userException);
        }
    }

    public int getOpticsAlmGainThresholdDegradeHigh() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sOpticsAlmThresholds)this.almTh.get()).gainAlmTh.degrade.high;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsAlmGainThresholdDegradeHigh", userException);
        }
    }

    public int getOpticsAlmGainThresholdDegradeLow() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sOpticsAlmThresholds)this.almTh.get()).gainAlmTh.degrade.low;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsAlmGainThresholdDegradeLow", userException);
        }
    }

    public int getOpticsAlmGainThresholdFailLow() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sOpticsAlmThresholds)this.almTh.get()).gainAlmTh.fail.low;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsAlmGainThresholdFailLow", userException);
        }
    }

    public int getOpticsAlmVOAThresholdDegradeHigh() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sOpticsAlmThresholds)this.almTh.get()).voaAlmTh.degrade.high;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsAlmVOAThresholdDegradeHigh", userException);
        }
    }

    public int getOpticsAlmVOAThresholdDegradeLow() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sOpticsAlmThresholds)this.almTh.get()).voaAlmTh.degrade.low;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsAlmVOAThresholdDegradeLow", userException);
        }
    }

    public int getOpticsAlmVOAThresholdFailLow() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sOpticsAlmThresholds)this.almTh.get()).voaAlmTh.fail.low;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsAlmVOAThresholdFailLow", userException);
        }
    }

    public void setOpticsAlmThresholds(sOpticsAlmThresholds sOpticsAlmThresholds2) throws NoSuchInterface, WrongInterfaceType, ProvisionError, ConfigError {
        try {
            this.almTh.set(sOpticsAlmThresholds2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setOpticsAlmThresholds", userException);
        }
    }

    public int getAddPTThresholdFailHigh() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sAlarmThresholds)this.addptTh.get()).fail.high;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAddPTThresholdFailHigh", userException);
        }
    }

    public int getAddPTThresholdFailLow() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sAlarmThresholds)this.addptTh.get()).fail.low;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAddPTThresholdFailLow", userException);
        }
    }

    public int getAddPTThresholdDegradeHigh() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sAlarmThresholds)this.addptTh.get()).degrade.high;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAddPTThresholdDegradeHigh", userException);
        }
    }

    public int getAddPTThresholdDegradeLow() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sAlarmThresholds)this.addptTh.get()).degrade.low;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAddPTThresholdDegradeLow", userException);
        }
    }

    public void setAddPTThresholds(sAlarmThresholds sAlarmThresholds2) throws NoSuchInterface, WrongInterfaceType, ProvisionError, ConfigError {
        try {
            this.addptTh.set(sAlarmThresholds2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setAddPTThresholds", userException);
        }
    }

    public sAlarmThresholds getAddPTThresholds() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sAlarmThresholds)this.addptTh.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAddPTThresholds", userException);
        }
    }

    public sOpticsPmStats getOpticsStats(eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = eIntervalType2;
            objectArray[1] = new Short(s);
            sOpticsPmStats sOpticsPmStats2 = (sOpticsPmStats)this.opticsStats.get(objectArray);
            return sOpticsPmStats2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsStats", userException);
        }
    }

    public IParserIfName getParserName() {
        if (this.parserIfName == null) {
            this.parserIfName = new ParserIfName(this);
        }
        return this.parserIfName;
    }

    public void clearOpticsStats(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            this.opticsStats.set(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearStats", userException);
        }
    }

    private String strPmStat(sPmStat sPmStat2) {
        if (sPmStat2.valid) {
            return Integer.toString(sPmStat2.cnt);
        }
        return "#";
    }

    public int getVoaCalibrationAttenuation() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 1) == 1) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.voa.calibrationAttenuation;
            }
            catch (UserException userException) {
                throw this.doUnknown("getVoaCalibrationAttenuation", userException);
            }
        }
        throw new FeatureUnsupported("getVoaCalibrationAttenuation");
    }

    public void setVoaCalibrationAttenuation(int n) throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, ProvisionError {
        if ((this.getFeatures() & 1) == 1) {
            try {
                this.voaAtt.set(new Integer(n));
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (xInternalCommError xInternalCommError2) {
                throw new InternalCommError((UserException)xInternalCommError2);
            }
            catch (xConfigError xConfigError2) {
                throw new ConfigError((UserException)xConfigError2);
            }
            catch (xFeatureUnsupported xFeatureUnsupported2) {
                throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
            }
            catch (xProvisioningError xProvisioningError2) {
                throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
            }
            catch (UserException userException) {
                throw this.doUnknown("setVoaCalibrationAttenuation", userException);
            }
        } else {
            throw new FeatureUnsupported("setVoaCalibrationAttenuation");
        }
    }

    public int getVoaReferenceAttenuation() throws NoSuchInterface, FeatureUnsupported, WrongInterfaceType {
        if ((this.getFeatures() & 1) == 1) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.voa.referenceAttenuation;
            }
            catch (UserException userException) {
                throw this.doUnknown("getVoaReferenceAttenuation", userException);
            }
        }
        throw new FeatureUnsupported("getVoaReferenceAttenuation");
    }

    public int getVoaCalibrationPower() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 0x20) != 32 && (this.getFeatures() & 1) == 1) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.voa.calibrationPower;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getVoaCalibrationPower", userException);
            }
        }
        throw new FeatureUnsupported("getVoaCalibrationPower");
    }

    public void setVOACalibrationPower(int n) throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, ProvisionError {
        if ((this.getFeatures() & 0x20) != 32 && (this.getFeatures() & 1) == 1) {
            try {
                this.voaPower.set(new Integer(n));
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (xInternalCommError xInternalCommError2) {
                throw new InternalCommError((UserException)xInternalCommError2);
            }
            catch (xConfigError xConfigError2) {
                throw new ConfigError((UserException)xConfigError2);
            }
            catch (xFeatureUnsupported xFeatureUnsupported2) {
                throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
            }
            catch (xProvisioningError xProvisioningError2) {
                throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
            }
            catch (UserException userException) {
                throw this.doUnknown("setVOACalibrationPower", userException);
            }
        } else {
            throw new FeatureUnsupported("setVOACalibrationPower");
        }
    }

    public int getVoaReferencePower() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 0x20) != 32 && (this.getFeatures() & 1) == 1) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.voa.referencePower;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getVoaReferencePower", userException);
            }
        }
        throw new FeatureUnsupported("getVoaReferencePower");
    }

    public int getCalibratedPower() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 0x20) == 32) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.calibratedPower;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getCalibratedPower", userException);
            }
        }
        throw new FeatureUnsupported("getCalibratedPower");
    }

    public void setCalibratedPower(int n) throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType, ProvisionError {
        if ((this.getFeatures() & 0x20) == 32) {
            try {
                this.calPower.set(new Integer(n));
            }
            catch (xProvisioningError xProvisioningError2) {
                throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
            }
            catch (UserException userException) {
                throw this.doUnknown("setCalibratedPower", userException);
            }
        } else {
            throw new FeatureUnsupported("FeatureUnsupported");
        }
    }

    public int getReferencePower() throws NoSuchInterface, FeatureUnsupported, WrongInterfaceType {
        if ((this.getFeatures() & 0x20) == 32) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.referencePower;
            }
            catch (UserException userException) {
                throw this.doUnknown("getReferencePower", userException);
            }
        }
        throw new FeatureUnsupported("getReferencePower");
    }

    public void setAddPTPortState(eSwitchablePortState eSwitchablePortState2) throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.addptPortStatus.set(eSwitchablePortState2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError(xProvisioningError2.errorExtraInfo.message());
        }
        catch (UserException userException) {
            throw this.doUnknown("setAddPTPortState", userException);
        }
    }

    public int getAddPTPortState() throws NoSuchInterface, FeatureUnsupported, WrongInterfaceType {
        try {
            eSwitchablePortState eSwitchablePortState2 = (eSwitchablePortState)this.addptPortStatus.get();
            return eSwitchablePortState2.value();
        }
        catch (UserException userException) {
            throw this.doUnknown("getAddPTPortState", userException);
        }
    }

    public void setAttributes(sGeneralOpticsAttributes sGeneralOpticsAttributes2, long l) {
        super.setAttributes(sGeneralOpticsAttributes2.base, l);
        this.genAttr.setValueExternally(sGeneralOpticsAttributes2);
    }

    public int getLoopbackAsInt() {
        return 0;
    }

    public boolean isWavelengthSupported() throws NoSuchInterface, WrongInterfaceType {
        throw new WrongInterfaceType("Non optics channel model do not support wavelength attributes");
    }

    public int getActualWaveLength() throws WrongInterfaceType, NoSuchInterface {
        throw new WrongInterfaceType("Non optics channel model do not support wavelength attributes");
    }

    public int getExpectedWaveLength() throws WrongInterfaceType, NoSuchInterface {
        throw new WrongInterfaceType("Non optics channel model do not support wavelength attributes");
    }

    public void setWaveLength(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        throw new WrongInterfaceType("Non optics channel model do not support wavelength attributes");
    }

    private class AddPTPortState
    extends CachedValue {
        private AddPTPortState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return AbstractOpticsLineModel.this.ifReference.getPortState(AbstractOpticsLineModel.this.getIndex());
        }

        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.setPortState(AbstractOpticsLineModel.this.getIndex(), (eSwitchablePortState)object);
        }
    }

    private class OSRI
    extends NonCachedValue {
        public OSRI(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.setOSRI(AbstractOpticsLineModel.this.getIndex(), (eOSRIStatus)object);
        }
    }

    private class ManualRestart
    extends NonCachedValue {
        public ManualRestart(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws UserException {
            AbstractOpticsLineModel.this.ifReference.manualRestart(AbstractOpticsLineModel.this.getIndex());
        }
    }

    private class CalibratedPower
    extends NonCachedValue {
        public CalibratedPower(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.setPowerCalibration(AbstractOpticsLineModel.this.getIndex(), (Integer)object);
        }

        public Object outer() {
            return this;
        }
    }

    private class GeneralAttributes
    extends CachedValue {
        private GeneralAttributes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return AbstractOpticsLineModel.this.ifReference.getGeneralOpticsAttributes(AbstractOpticsLineModel.this.getIndex());
        }
    }

    private class Directionality
    extends NonCachedValue {
        private Directionality(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return AbstractOpticsLineModel.this.ifReference.getDirectionality(AbstractOpticsLineModel.this.getIndex());
        }

        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.setDirectionality(AbstractOpticsLineModel.this.getIndex(), (eRingDirection)object);
        }
    }

    private class VOAAttenuation
    extends NonCachedValue {
        public VOAAttenuation(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.setVOAAttenuation(AbstractOpticsLineModel.this.getIndex(), (Integer)object);
        }
    }

    private class LaserStatus
    extends CachedValue {
        public LaserStatus(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return AbstractOpticsLineModel.this.ifReference.getLaserStatus(AbstractOpticsLineModel.this.getIndex());
        }
    }

    private class VOAPower
    extends NonCachedValue {
        public VOAPower(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.setVOAPower(AbstractOpticsLineModel.this.getIndex(), (Integer)object);
        }
    }

    private class AddPTPowerThreshold
    extends CachedValue {
        public AddPTPowerThreshold(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            sAlarmThresholds sAlarmThresholds2 = AbstractOpticsLineModel.this.ifReference.getAddPowerThreshold(AbstractOpticsLineModel.this.getIndex());
            return sAlarmThresholds2;
        }

        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.setAddPowerThreshold(AbstractOpticsLineModel.this.getIndex(), (sAlarmThresholds)object);
        }

        public Object outer() {
            return this;
        }

        protected Object cloneValue() {
            sAlarmThresholds sAlarmThresholds2 = (sAlarmThresholds)this.value;
            sValThresholds sValThresholds2 = new sValThresholds(sAlarmThresholds2.fail.high, sAlarmThresholds2.fail.low);
            sValThresholds sValThresholds3 = new sValThresholds(sAlarmThresholds2.degrade.high, sAlarmThresholds2.degrade.low);
            sAlarmThresholds sAlarmThresholds3 = new sAlarmThresholds(sValThresholds2, sValThresholds3);
            return sAlarmThresholds3;
        }
    }

    private class AlmThresholds
    extends CachedValue {
        public AlmThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            sOpticsAlmThresholds sOpticsAlmThresholds2 = AbstractOpticsLineModel.this.ifReference.getOpticsAlmThresholds(AbstractOpticsLineModel.this.getIndex());
            return sOpticsAlmThresholds2;
        }

        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.setOpticsAlmThresholds(AbstractOpticsLineModel.this.getIndex(), (sOpticsAlmThresholds)object);
        }

        public Object outer() {
            return this;
        }

        protected Object cloneValue() {
            sOpticsAlmThresholds sOpticsAlmThresholds2 = (sOpticsAlmThresholds)this.value;
            sValThresholds sValThresholds2 = new sValThresholds(sOpticsAlmThresholds2.opticalPowerAlmTh.fail.high, sOpticsAlmThresholds2.opticalPowerAlmTh.fail.low);
            sValThresholds sValThresholds3 = new sValThresholds(sOpticsAlmThresholds2.opticalPowerAlmTh.degrade.high, sOpticsAlmThresholds2.opticalPowerAlmTh.degrade.low);
            sAlarmThresholds sAlarmThresholds2 = new sAlarmThresholds(sValThresholds2, sValThresholds3);
            sValThresholds sValThresholds4 = new sValThresholds(sOpticsAlmThresholds2.voaAlmTh.fail.high, sOpticsAlmThresholds2.voaAlmTh.fail.low);
            sValThresholds sValThresholds5 = new sValThresholds(sOpticsAlmThresholds2.voaAlmTh.degrade.high, sOpticsAlmThresholds2.voaAlmTh.degrade.low);
            sAlarmThresholds sAlarmThresholds3 = new sAlarmThresholds(sValThresholds4, sValThresholds5);
            sValThresholds sValThresholds6 = new sValThresholds(sOpticsAlmThresholds2.gainAlmTh.fail.high, sOpticsAlmThresholds2.gainAlmTh.fail.low);
            sValThresholds sValThresholds7 = new sValThresholds(sOpticsAlmThresholds2.gainAlmTh.degrade.high, sOpticsAlmThresholds2.gainAlmTh.degrade.low);
            sAlarmThresholds sAlarmThresholds4 = new sAlarmThresholds(sValThresholds6, sValThresholds7);
            sOpticsAlmThresholds sOpticsAlmThresholds3 = new sOpticsAlmThresholds(sOpticsAlmThresholds2.ifIndex, sAlarmThresholds2, sAlarmThresholds3, sAlarmThresholds4);
            return sOpticsAlmThresholds3;
        }
    }

    private class TCAThresholds
    extends CachedValue {
        public TCAThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            sOpticsTCAThresholds sOpticsTCAThresholds2 = AbstractOpticsLineModel.this.ifReference.getOpticsTCAThresholds(AbstractOpticsLineModel.this.getIndex(), (eIntervalType)object);
            return sOpticsTCAThresholds2;
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            AbstractOpticsLineModel.this.ifReference.setOpticsTCAThresholds(AbstractOpticsLineModel.this.getIndex(), (sOpticsTCAThresholds)objectArray[0], (eIntervalType)objectArray[1]);
        }

        protected Object cloneValue() {
            sOpticsTCAThresholds sOpticsTCAThresholds2 = (sOpticsTCAThresholds)this.value;
            sValThresholds sValThresholds2 = new sValThresholds(sOpticsTCAThresholds2.opticalPowerPMTh.high, sOpticsTCAThresholds2.opticalPowerPMTh.low);
            sOpticsTCAThresholds sOpticsTCAThresholds3 = new sOpticsTCAThresholds(sOpticsTCAThresholds2.ifIndex, sValThresholds2);
            return sOpticsTCAThresholds3;
        }

        public Object outer() {
            return this;
        }
    }

    private class ActualOpticsAttributes
    extends NonCachedValue {
        public ActualOpticsAttributes(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return AbstractOpticsLineModel.this.ifReference.getActualOpticsAttributes(AbstractOpticsLineModel.this.getIndex());
        }
    }

    private class OpticsStats
    extends NonCachedValue {
        public OpticsStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.clearOpticsStats(AbstractOpticsLineModel.this.getIndex(), (eIntervalType)object);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            short s = (Short)objectArray[1];
            sOpticsPmStats sOpticsPmStats2 = AbstractOpticsLineModel.this.ifReference.getOpticsStats(AbstractOpticsLineModel.this.getIndex(), (eIntervalType)objectArray[0], s);
            return sOpticsPmStats2;
        }
    }
}

