/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ICORBAStreamable;
import cerent.cms.model.IModelPersistenceConstants;
import cerent.cms.model.IModelPersistenceStrategy;
import cerent.cms.model.IModelStatePersistedMarker;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PersistableCachedValue;
import cerent.cms.model.PersistableModel;
import cerent.cms.model.PersistenceException;
import cerent.cms.model.ReflectionUtil;
import cerent.cms.model.StateBatchInfo;
import cerent.util.CORBAOutputStream;
import cerent.util.ISequenceNumberConstants;
import cerent.util.SDebug;
import cerent.util.TimeLRUMap;
import cerent.util.id.INetwideModelIdentity;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public abstract class AbstractPersistableModelState
implements IModelStatePersistedMarker,
ICORBAStreamable {
    private static FieldNameComparator fieldNameComparator = new FieldNameComparator();
    private static final Field[] FieldArrayTemplate = new Field[0];
    private PersistableModel model;
    private boolean needsPersisting;
    private static HashMap persistableCVs = new HashMap();
    public static final long UNINITIALIZED_SEQ_NUM = -1L;
    public static final Long UNINITIALIZED_SEQ_NUM_OBJ = ISequenceNumberConstants.UNINITIALIZED_SEQ_NUM_OBJ;
    private Long sequenceNumber = UNINITIALIZED_SEQ_NUM_OBJ;

    protected AbstractPersistableModelState() {
    }

    static final Field[] getPcvFields(Class clazz) {
        if (clazz == null) {
            return FieldArrayTemplate;
        }
        Field[] fieldArray = (Field[])persistableCVs.get(clazz);
        if (fieldArray == null) {
            fieldArray = ReflectionUtil.getPersistableCVs(clazz);
            Arrays.sort(fieldArray, fieldNameComparator);
            persistableCVs.put(clazz, fieldArray);
        }
        return fieldArray;
    }

    static final Field[] getNcvFields(Class clazz) {
        Field[] fieldArray;
        Field[] fieldArray2 = AbstractPersistableModelState.getPcvFields(clazz);
        Field[] fieldArray3 = ReflectionUtil.getNCVNotPersistableCVs(clazz);
        if (fieldArray3.length == 0) {
            fieldArray = fieldArray2;
        } else {
            fieldArray = new Field[fieldArray2.length + fieldArray3.length];
            System.arraycopy(fieldArray2, 0, fieldArray, 0, fieldArray2.length);
            System.arraycopy(fieldArray3, 0, fieldArray, fieldArray2.length, fieldArray3.length);
        }
        return fieldArray;
    }

    protected void setAttrNode(Model model) {
        if (model != null) {
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)model.getNodeModel();
            Field[] fieldArray = this.getPersistableCVs();
            if (fieldArray == null) {
                return;
            }
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field field = fieldArray[i];
                field.setAccessible(true);
                try {
                    PersistableCachedValue persistableCachedValue = (PersistableCachedValue)field.get(this);
                    persistableCachedValue.setNode(nodeModelDelegate);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    synchronized void resetPersistenceNeeded() {
        this.needsPersisting = false;
    }

    void setPersistenceNeeded() {
        this.setPersistenceNeeded(-1L);
    }

    synchronized void setPersistenceNeeded(long l) {
        boolean bl = !this.needsPersisting;
        PersistableModel persistableModel = this.getModel();
        IModelPersistenceStrategy iModelPersistenceStrategy = persistableModel == null ? null : persistableModel.getPersistenceStrategy();
        boolean bl2 = this.needsPersisting = iModelPersistenceStrategy == null ? IModelPersistenceConstants.ENABLE_PERSISTENCE : iModelPersistenceStrategy.doesGetReallyPersisted(this);
        if (persistableModel != null && bl && this.needsPersisting) {
            SDebug sDebug;
            SDebug sDebug2 = sDebug = persistableModel == null ? null : persistableModel.getDebug();
            if (persistableModel.wasNeDeleted()) {
                this.needsPersisting = false;
            } else {
                this.indicateWriteAccess(l);
            }
            if (sDebug != null && sDebug.on()) {
                sDebug.display("model state persistence is needed for " + this.displayid() + " (" + this.modelDisplayId() + ")");
            }
        }
    }

    public PersistableModel getModel() {
        return this.model;
    }

    protected final void _linkModel(int n, PersistableModel persistableModel) {
        if (persistableModel == this.model) {
            return;
        }
        if (this.model != null) {
            if (persistableModel == null) {
                this.model.removeFromLRUManager(this);
            }
            this.model.linkState(n, null);
        }
        if (persistableModel != null) {
            persistableModel.linkState(n, this);
        }
        this.setModel(persistableModel);
    }

    void setModel(PersistableModel persistableModel) {
        this.model = persistableModel;
    }

    void linkModel(PersistableModel persistableModel) {
        this.model = persistableModel;
        this.setAttrNode(persistableModel);
    }

    protected int getIndex() {
        return this.model == null ? 0 : this.model.getIndex();
    }

    private Field[] getPersistableCVs() {
        Field[] fieldArray = (Field[])persistableCVs.get(this.getClass());
        return fieldArray;
    }

    public void read(InputStream inputStream) throws IOException {
        Field[] fieldArray = this.getPersistableCVs();
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Field field = fieldArray[i];
            field.setAccessible(true);
            try {
                PersistableCachedValue persistableCachedValue = (PersistableCachedValue)field.get(this);
                persistableCachedValue.read(inputStream);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (RuntimeException runtimeException) {
                PersistableModel persistableModel = this.getModel();
                SDebug sDebug = persistableModel == null ? null : persistableModel.getDebug();
                String string = "Error reading attribute: " + runtimeException + " for " + this.displayid() + " (" + this.modelDisplayId() + ")";
                if (sDebug != null) {
                    sDebug.println(string);
                    SDebug.printStackTrace((Throwable)runtimeException);
                }
                throw new IOException(string);
            }
        }
    }

    public void write(OutputStream outputStream) throws IOException, UserException {
        Field[] fieldArray = this.getPersistableCVs();
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Field field = fieldArray[i];
            field.setAccessible(true);
            try {
                PersistableCachedValue persistableCachedValue = (PersistableCachedValue)field.get(this);
                if (persistableCachedValue == null) {
                    throw new IllegalStateException("Field value for field: " + field.getName() + " could not be found. Encapsulating model state class must create this field instance when constructed");
                }
                persistableCachedValue.write(outputStream);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public void update(long l) {
        Field[] fieldArray = this.getPersistableCVs();
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Field field = fieldArray[i];
            field.setAccessible(true);
            try {
                PersistableCachedValue persistableCachedValue = (PersistableCachedValue)field.get(this);
                if (!this.permitPcvUpdate(persistableCachedValue)) continue;
                persistableCachedValue.update();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        this.indicateWriteAccess(l);
    }

    protected boolean permitPcvUpdate(PersistableCachedValue persistableCachedValue) {
        return true;
    }

    void dispose() {
        Field[] fieldArray = this.getPersistableCVs();
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Field field = fieldArray[i];
            field.setAccessible(true);
            try {
                PersistableCachedValue persistableCachedValue = (PersistableCachedValue)field.get(this);
                persistableCachedValue.dispose();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public void destroy() {
        PersistableModel persistableModel = this.getModel();
        if (persistableModel != null) {
            this._linkModel(persistableModel.getModelType(this), null);
        }
        Field[] fieldArray = this.getPersistableCVs();
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Field field = fieldArray[i];
            field.setAccessible(true);
            try {
                field.set(this, null);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        this.resetPersistenceNeeded();
    }

    protected SDebug getDb() {
        return this.model == null ? null : this.model.getDebug();
    }

    final void indicateAccess(TimeLRUMap timeLRUMap) {
        this.indicateAccess(timeLRUMap, -1L);
    }

    protected final void indicateAccess(TimeLRUMap timeLRUMap, long l) {
        this.indicateAccess(timeLRUMap, l, false);
    }

    final void indicateAccess(TimeLRUMap timeLRUMap, long l, boolean bl) {
        if (timeLRUMap != null) {
            PersistableModel persistableModel;
            SDebug sDebug;
            Long l2 = this.sequenceNumber;
            if (bl) {
                this.changeSequenceNumber(l);
            }
            SDebug sDebug2 = sDebug = (persistableModel = this.getModel()) == null ? null : persistableModel.getDebug();
            if (sDebug != null && sDebug.isFinestEnabled()) {
                sDebug.finest("indicateAccess: " + this.getClass().getName() + " " + this.sequenceNumber + " " + bl + " " + this.needsPersisting);
            }
            timeLRUMap.touchSeq(this, l2);
        }
    }

    protected final void changeSequenceNumber(long l) {
        if (this.sequenceNumber != l) {
            SDebug sDebug;
            this.sequenceNumber = l == -1L ? UNINITIALIZED_SEQ_NUM_OBJ : new Long(l);
            PersistableModel persistableModel = this.getModel();
            SDebug sDebug2 = sDebug = persistableModel == null ? null : persistableModel.getDebug();
            if (persistableModel != null && sDebug.isFinestEnabled()) {
                sDebug.println(this + " - " + l);
                SDebug.printStackTrace((Throwable)new Exception());
            }
        }
    }

    protected final void indicateAccess(long l) {
        if (this.model != null) {
            this.model.indicateAccess(this, l);
        }
    }

    protected final void indicateWriteAccess(long l) {
        if (this.model != null) {
            this.model.indicateWriteAccess(this, l);
        }
    }

    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    private static int compare(Object object, Object object2) {
        int n = 0;
        if (object != object2) {
            Class<?> clazz;
            Class<?> clazz2;
            n = object == null ? 1 : (object2 == null ? -1 : (!(clazz2 = object.getClass()).equals(clazz = object2.getClass()) ? clazz2.hashCode() - clazz.hashCode() : System.identityHashCode(object) - System.identityHashCode(object2)));
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = object == this;
        if (!bl && object != null && object instanceof AbstractPersistableModelState) {
            bl = AbstractPersistableModelState.compare(object, this) == 0;
        }
        return bl;
    }

    public int hashCode() {
        int n = System.identityHashCode(this);
        return n += 17 * this.getClass().hashCode();
    }

    synchronized boolean save(IModelPersistenceStrategy iModelPersistenceStrategy, INetwideModelIdentity iNetwideModelIdentity, long l) throws PersistenceException {
        boolean bl = true;
        if (this.needsPersisting) {
            boolean bl2 = l == -1L ? iModelPersistenceStrategy.save(iNetwideModelIdentity, this) : iModelPersistenceStrategy.save(iNetwideModelIdentity, this, l);
            this.needsPersisting = false;
        }
        return bl;
    }

    static boolean batchSave(StateBatchInfo[] stateBatchInfoArray) throws PersistenceException {
        if (stateBatchInfoArray == null) {
            return true;
        }
        boolean bl = AbstractPersistableModelState.batchSaveWithLocking(stateBatchInfoArray, 0);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean batchSaveWithLocking(StateBatchInfo[] stateBatchInfoArray, int n) throws PersistenceException {
        boolean bl;
        StateBatchInfo stateBatchInfo = stateBatchInfoArray[n];
        AbstractPersistableModelState abstractPersistableModelState = (AbstractPersistableModelState)stateBatchInfo.state;
        if (abstractPersistableModelState == null) {
            stateBatchInfo.doSkip = true;
            boolean bl2 = AbstractPersistableModelState._batchSaveWithLocking(stateBatchInfoArray, n);
            return bl2;
        }
        AbstractPersistableModelState abstractPersistableModelState2 = abstractPersistableModelState;
        synchronized (abstractPersistableModelState2) {
            if (!abstractPersistableModelState.needsPersisting) {
                stateBatchInfo.doSkip = true;
            }
            bl = AbstractPersistableModelState._batchSaveWithLocking(stateBatchInfoArray, n);
        }
        return bl;
    }

    private static boolean _batchSaveWithLocking(StateBatchInfo[] stateBatchInfoArray, int n) throws PersistenceException {
        boolean bl;
        StateBatchInfo stateBatchInfo = stateBatchInfoArray[n];
        if (n == stateBatchInfoArray.length - 1) {
            IModelPersistenceStrategy iModelPersistenceStrategy = null;
            for (int i = 0; i < stateBatchInfoArray.length; ++i) {
                stateBatchInfo = stateBatchInfoArray[i];
                if (iModelPersistenceStrategy != null || stateBatchInfo.model == null) continue;
                iModelPersistenceStrategy = stateBatchInfo.model.getPersistenceStrategy();
                break;
            }
            bl = iModelPersistenceStrategy == null ? true : iModelPersistenceStrategy.batchSave(stateBatchInfoArray);
        } else {
            bl = AbstractPersistableModelState.batchSaveWithLocking(stateBatchInfoArray, n + 1);
        }
        return bl;
    }

    static AbstractPersistableModelState _retrieve(IModelPersistenceStrategy iModelPersistenceStrategy, INetwideModelIdentity iNetwideModelIdentity, PersistableModel persistableModel) throws PersistenceException {
        AbstractPersistableModelState abstractPersistableModelState = (AbstractPersistableModelState)iModelPersistenceStrategy.retrieve(iNetwideModelIdentity, persistableModel);
        return abstractPersistableModelState;
    }

    public String displayid() {
        return this.toString();
    }

    private String modelDisplayId() {
        return this.model == null ? "null" : AbstractPersistableModelState.modelDisplayId(this.model);
    }

    private static String modelDisplayId(Model model) {
        String string = model.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1) + " " + model.getIndex();
        return string2;
    }

    public String prettyPrintAccessCounts(String string) {
        Class<?> clazz = this.getClass();
        Field[] fieldArray = AbstractPersistableModelState.getPcvFields(clazz);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            PersistableCachedValue persistableCachedValue;
            Field field = fieldArray[i];
            field.setAccessible(true);
            try {
                persistableCachedValue = (PersistableCachedValue)field.get(this);
            }
            catch (IllegalAccessException illegalAccessException) {
                persistableCachedValue = null;
                continue;
            }
            String string2 = persistableCachedValue.getAttributeName();
            long l = persistableCachedValue.getAccessCount();
            if (l == 0L) continue;
            stringBuffer.append("\n  ");
            stringBuffer.append(string2);
            stringBuffer.append(": ");
            stringBuffer.append(Long.toString(l));
        }
        return stringBuffer.toString();
    }

    public String compare(AbstractPersistableModelState abstractPersistableModelState, boolean bl) {
        String string = null;
        String string2 = null;
        try {
            Class<?> clazz = this.getClass();
            if (abstractPersistableModelState == null) {
                string = "rhs null";
            } else if (!abstractPersistableModelState.getClass().equals(clazz)) {
                string = "rhs is a different class: " + abstractPersistableModelState.getClass();
            }
            if (string != null) {
                return string;
            }
            Field[] fieldArray = AbstractPersistableModelState.getPcvFields(clazz);
            int n = fieldArray.length;
            for (int i = 0; i < n && string == null; ++i) {
                Object object;
                Object object2;
                Field field = fieldArray[i];
                string2 = field.getName();
                field.setAccessible(true);
                CachedValue cachedValue = (CachedValue)field.get(this);
                CachedValue cachedValue2 = (CachedValue)field.get(abstractPersistableModelState);
                int n2 = cachedValue2.getState();
                if (cachedValue.getState() != n2) {
                    if (bl) continue;
                    string = "rhs field: " + string2 + " has a different state of " + n2;
                    continue;
                }
                try {
                    object2 = cachedValue.get();
                    object = cachedValue2.get();
                }
                catch (xWrongInterfaceType xWrongInterfaceType2) {
                    continue;
                }
                catch (xUnsupportedOperation xUnsupportedOperation2) {
                    continue;
                }
                catch (xInternalCommError xInternalCommError2) {
                    continue;
                }
                if (object2 == null ^ abstractPersistableModelState == null) {
                    string = "rhs field: " + string2 + " value not same nullness";
                    continue;
                }
                if (object2 == null) continue;
                string = CORBAOutputStream.compare(object2, object, string2, 0);
            }
        }
        catch (Exception exception) {
            string = "exception: " + exception + " detected. Current field is " + string2;
            string = string + "\n" + AbstractPersistableModelState.getStackTrace(exception);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getStackTrace(Exception exception) {
        if (exception == null) {
            return "";
        }
        Exception exception2 = exception;
        exception2.printStackTrace();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            exception2.printStackTrace(printWriter);
        }
        finally {
            printWriter.close();
        }
        return stringWriter.toString();
    }

    private static class FieldNameComparator
    implements Comparator {
        private FieldNameComparator() {
        }

        public int compare(Object object, Object object2) {
            String string;
            Field field = (Field)object;
            Field field2 = (Field)object2;
            String string2 = field.getDeclaringClass().getName();
            int n = string2.compareTo(string = field2.getDeclaringClass().getName());
            if (n == 0) {
                string2 = field.getName();
                string = field2.getName();
                n = string2.compareTo(string);
            }
            return n;
        }

        public boolean equals(Object object) {
            boolean bl = object != null && object instanceof FieldNameComparator;
            return bl;
        }
    }
}

