/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.sMfgData_2_01;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SlotModel;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSlotPolicy {
    protected final String DSN_GROUP;
    protected final String ETH_GROUP;
    protected final String OCN_GROUP;
    protected final String WDM_GROUP;
    protected final String OADM_GROUP;
    protected final String OSC_GROUP;
    protected final String AMPLI_GROUP;
    protected final String MD_GROUP;
    protected static final String TOP_LEVEL = null;
    protected Map slotMap = new HashMap();
    protected final String DWDM_FAMILY;
    protected TDMTerminology terms;
    protected static final SDebug db = new SDebug("SlotPolicy");

    public AbstractSlotPolicy(NodeModelDelegate nodeModelDelegate) {
        this.terms = nodeModelDelegate.getTDMTerminology();
        this.DSN_GROUP = this.terms.getTermForAddCard(1);
        this.OCN_GROUP = this.terms.getTermForAddCard(0);
        this.ETH_GROUP = this.terms.getTermForAddCard(2);
        this.DWDM_FAMILY = this.terms.getTermForAddFamilyCard(0);
        this.WDM_GROUP = this.terms.getTermForAddCard(3);
        this.OADM_GROUP = this.terms.getTermForAddCard(4);
        this.OSC_GROUP = this.terms.getTermForAddCard(5);
        this.AMPLI_GROUP = this.terms.getTermForAddCard(6);
        this.MD_GROUP = this.terms.getTermForAddCard(7);
        this.initSlotMap();
    }

    protected abstract void initSlotMap();

    public abstract Map getMapOfValidModules(SlotModel var1);

    public abstract List getListOfValidUpgradeType(SlotModel var1, int var2);

    public abstract List getListOfValidChangeType(SlotModel var1, eEqType var2);

    public List getListOfValidPortTypes(SlotModel slotModel, int n) {
        return new ArrayList();
    }

    public abstract boolean needDs1Ifs(int var1);

    public boolean needInterfaceTypeBasedDs123Ifs(int n) {
        return false;
    }

    protected void addCardToMap(String string, eEqType eEqType2) {
        this.addCardToMap(TOP_LEVEL, string, eEqType2, this.slotMap);
    }

    protected void addCardToMap(eEqType eEqType2, Map map) {
        this.addCardToMap(TOP_LEVEL, TOP_LEVEL, eEqType2, map);
    }

    protected void addCardToMap(String string, String string2, eEqType eEqType2) {
        this.addCardToMap(string, string2, eEqType2, this.slotMap);
    }

    protected void addCardToMap(String string, String string2, eEqType eEqType2, Map map) {
        Map map2 = null;
        if (string != TOP_LEVEL) {
            map2 = this.getFamily(string, map);
            if (map2 == null) {
                db.severe("Error on building menu (family '" + string + "' not found)!");
            }
        } else {
            map2 = map;
        }
        if (map2 != null) {
            if (string2 != TOP_LEVEL) {
                HashSet<eEqType> hashSet = (HashSet<eEqType>)map2.get(string2);
                if (hashSet == null) {
                    hashSet = new HashSet<eEqType>();
                    map2.put(string2, hashSet);
                }
                hashSet.add(eEqType2);
            } else {
                map2.put(eEqType2, null);
            }
        }
    }

    protected void remCardFromMap(String string, eEqType eEqType2, Map map) {
        if (string != TOP_LEVEL) {
            Set set = this.getSetForMenu(string, map);
            if (set != null) {
                set.remove(eEqType2);
            }
        } else {
            map.remove(eEqType2);
        }
    }

    protected void remCardFromMap(String string, String string2, eEqType eEqType2, Map map) {
        Map map2 = null;
        if (string != TOP_LEVEL) {
            map2 = this.getFamily(string, map);
            if (map2 == null) {
                db.severe("Error attempting to remove card from non-existant menu (" + string + ")");
            }
        } else {
            map2 = map;
        }
        if (map2 != null) {
            if (string2 != TOP_LEVEL) {
                Set set = (Set)map2.get(string2);
                if (set != null) {
                    set.remove(eEqType2);
                }
            } else {
                map2.remove(eEqType2);
            }
        }
    }

    protected Map getFamily(String string, Map map) {
        Map map2 = null;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof String)) continue;
            String string2 = (String)k;
            Object v = map.get(string2);
            if (!string2.equals(string) || !(v instanceof Map)) continue;
            map2 = (Map)v;
            break;
        }
        return map2;
    }

    protected void showMap(Map map) {
        this.showMap(map, 0);
    }

    protected void showMap(Map map, int n) {
        Iterator iterator = map.keySet().iterator();
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        while (iterator.hasNext()) {
            Object object;
            Object k = iterator.next();
            if (k instanceof String) {
                object = (String)k;
                Object v = map.get(object);
                if (v instanceof Map) {
                    db.fine(stringBuffer + "KEY = " + (String)object);
                    this.showMap((Map)v, ++n);
                    continue;
                }
                if (v instanceof Set) {
                    Set set = (Set)v;
                    db.fine(stringBuffer + "KEY = " + (String)object);
                    Iterator iterator2 = set.iterator();
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        String string = e.toString();
                        if (e instanceof eEqType) {
                            string = EqTypeHelper.eqType2Name((TDMTerminology)this.terms, (int)((eEqType)e).value());
                        }
                        db.fine("\t" + stringBuffer + string);
                    }
                    continue;
                }
                db.fine(stringBuffer + "KEY = " + (String)object + ", value = " + v + "[ERR]");
                continue;
            }
            if (!(k instanceof eEqType)) continue;
            object = (eEqType)k;
            db.fine(stringBuffer + "KEY = " + EqTypeHelper.eqType2Name((TDMTerminology)this.terms, (int)((eEqType)object).value()));
        }
    }

    protected void addMenuToMap(String string, String string2) {
        this.addFamilyToMap(string, string2, this.slotMap);
    }

    protected void addFamilyToMap(String string, String string2, Map map) {
        Map map2 = this.getFamily(string, map);
        if (map2 == null) {
            HashMap hashMap = new HashMap();
            hashMap.put(string2, new HashSet());
            map.put(string, hashMap);
        }
    }

    protected void remFamilyFromMap(String string, Map map) {
        if (map.containsKey(string)) {
            map.remove(string);
        } else {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = map.get(k);
                if (!(v instanceof Map)) continue;
                this.remFamilyFromMap(string, (Map)v);
            }
        }
    }

    protected void remEmptyFamiliesFromMap(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Set set;
            Object k = iterator.next();
            Object v = map.get(k);
            if (v instanceof Map) {
                this.remEmptyFamiliesFromMap((Map)v);
                continue;
            }
            if (!(v instanceof Set) || !(set = (Set)v).isEmpty()) continue;
            iterator.remove();
        }
    }

    protected Set getSetForMenu(String string, Map map) {
        Set set = null;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof String)) continue;
            String string2 = (String)k;
            Object v = map.get(string2);
            if (!string2.equals(string) || !(v instanceof Set)) continue;
            set = (Set)v;
            break;
        }
        return set;
    }

    protected String getFamilyMenu(String string, Map map) {
        String string2 = null;
        Object var4_4 = null;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string3;
            Object v;
            Object k = iterator.next();
            if (!(k instanceof String) || !((v = map.get(string3 = (String)k)) instanceof Map)) continue;
            Map map2 = (Map)v;
            Iterator iterator2 = map2.keySet().iterator();
            while (iterator2.hasNext()) {
                Object k2 = iterator2.next();
                if (!(k2 instanceof String)) continue;
                String string4 = (String)k2;
                Object v2 = map.get(string4);
                if (!string4.equals(string)) continue;
                var4_4 = k2;
                string2 = string3;
            }
            if (var4_4 == null) continue;
            map2.remove(var4_4);
            var4_4 = null;
        }
        return string2;
    }

    protected boolean isLowSpeedSlot(int n) {
        boolean bl = false;
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 14: 
            case 16: 
            case 17: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected boolean isLowSpeedProtectSlot(int n) {
        boolean bl = false;
        switch (n) {
            case 3: 
            case 15: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected boolean isHighSpeedSlot(int n) {
        boolean bl = false;
        switch (n) {
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean slotHasCardView(SlotModel slotModel) {
        return true;
    }

    protected boolean hasEqType(SlotModel slotModel, eEqType eEqType2) {
        EntityModel entityModel = (EntityModel)slotModel.getParent();
        return entityModel != null && entityModel.getDescendantsOfType(eEqType2).size() > 0;
    }

    protected boolean hasOc48As(SlotModel slotModel) {
        EntityModel entityModel = (EntityModel)slotModel.getParent();
        Iterator iterator = entityModel.getDescendantsOfType(eEqType.OC48_LINE_CARD).iterator();
        while (iterator.hasNext()) {
            ModuleModel moduleModel = (ModuleModel)iterator.next();
            int n = moduleModel.getSlot();
            if (!this.isLowSpeedSlot(n) && !this.isLowSpeedProtectSlot(n)) continue;
            return true;
        }
        return false;
    }

    protected void addToChangeTypeList(Map map, eEqType eEqType2, eEqType eEqType3, List list) {
        if (eEqType2 != eEqType3 && this.eqTypeInMap(map, eEqType2)) {
            list.add(eEqType2);
        }
    }

    protected boolean eqTypeInMap(Map map, eEqType eEqType2) {
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getKey() == eEqType2) {
                bl = true;
                break;
            }
            if (entry.getValue() instanceof Map && this.eqTypeInMap((Map)entry.getValue(), eEqType2)) {
                bl = true;
                break;
            }
            if (!(entry.getValue() instanceof Set) || !((Set)entry.getValue()).contains(eEqType2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected Map deepCopyMap(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            if (v != null) {
                if (v instanceof Map) {
                    hashMap.put(k, this.deepCopyMap((Map)v));
                    continue;
                }
                hashMap.put(k, new HashSet((Set)v));
                continue;
            }
            hashMap.put(k, null);
        }
        return hashMap;
    }

    protected boolean testEmptySlot(SlotModel slotModel) {
        int n = slotModel.getSlot();
        boolean bl = false;
        if (n > 0 && n < 17) {
            List list;
            IChassisModel iChassisModel = slotModel.getChassis();
            List list2 = iChassisModel.getChildren();
            EntityModel entityModel = null;
            if (list2 != null && list2.size() > 0 && (list = (entityModel = (EntityModel)list2.get(0)).getChildren()) != null) {
                EntityModel entityModel2 = (EntityModel)list.get(n);
                List list3 = entityModel2.getChildren();
                if (list3.size() > 0) {
                    MfgEntityModel mfgEntityModel = (MfgEntityModel)((EntityModel)list3.get(0));
                    sMfgData_2_01 sMfgData_2_012 = mfgEntityModel.getMfgData();
                    String string = sMfgData_2_012.name;
                    if (mfgEntityModel.getState().value() == 6 || string.equals("FILLER")) {
                        bl = true;
                    }
                } else if (n != 6) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    protected boolean IsOSCProvisioned(IChassisModel iChassisModel) {
        MfgEntityModel mfgEntityModel;
        boolean bl = false;
        IPlatform iPlatform = iChassisModel.getPlatform();
        List list = iChassisModel.getChildren();
        List list2 = ((EntityModel)list.get(0)).getChildren();
        EntityModel entityModel = (EntityModel)list2.get(iPlatform.getXconASlot() - 1);
        EntityModel entityModel2 = (EntityModel)list2.get(iPlatform.getXconBSlot() - 1);
        if (entityModel.getChildren().size() > 0 && (mfgEntityModel = (MfgEntityModel)entityModel.getChildren().get(0)).getEqType() == 127 && mfgEntityModel.getState().value() != 6) {
            bl = true;
        }
        if (!bl && entityModel2.getChildren().size() > 0 && (mfgEntityModel = (MfgEntityModel)entityModel2.getChildren().get(0)).getEqType() == 127 && mfgEntityModel.getState().value() != 6) {
            bl = true;
        }
        return bl;
    }

    protected boolean IsXCProvisioned(IChassisModel iChassisModel) {
        MfgEntityModel mfgEntityModel;
        int n;
        boolean bl = false;
        IPlatform iPlatform = iChassisModel.getPlatform();
        List list = iChassisModel.getChildren();
        List list2 = ((EntityModel)list.get(0)).getChildren();
        EntityModel entityModel = (EntityModel)list2.get(iPlatform.getXconASlot() - 1);
        EntityModel entityModel2 = (EntityModel)list2.get(iPlatform.getXconBSlot() - 1);
        if (entityModel.getChildren().size() > 0 && ((n = (mfgEntityModel = (MfgEntityModel)entityModel.getChildren().get(0)).getEqType()) == 3 || n == 43 || n == 59 || n == 107 || n == 84 || n == 216 || n == 47 || n == 91 || n == 232) && mfgEntityModel.getState().value() != 6) {
            bl = true;
        }
        if (!(bl || entityModel2.getChildren().size() <= 0 || (n = (mfgEntityModel = (MfgEntityModel)entityModel2.getChildren().get(0)).getEqType()) != 3 && n != 43 && n != 59 && n != 107 && n != 84 && n != 216 && n != 47 && n != 91 && n != 232 || mfgEntityModel.getState().value() == 6)) {
            bl = true;
        }
        db.fine("IsXCProvisioned? " + bl);
        return bl;
    }
}

