/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Dwdm.eGccRate;
import cerent.cms.idl.OSI.sLapdTerm;
import cerent.cms.idl.OSI.sSubnet;
import cerent.cms.idl.SonetMedia.eOverheadChannelType;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Busy;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.ITermConnectionModel;
import cerent.cms.model.InvalidOhTerm;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoLanAccess;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchTerm;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannel;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhMaxConnections;
import cerent.cms.model.OhTerm;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.OhTerms;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public abstract class AbstractTermConnectionModel
extends Model
implements ITermConnectionModel {
    protected NodeModelDelegate nmd;
    private HashSet terms;
    private boolean initialized;
    private HashMap portToTermMap;
    private OhTerms termsCollection;

    protected AbstractTermConnectionModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(AbstractTermConnectionModel.class));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.initialized = false;
        this.terms = new HashSet();
        this.portToTermMap = new HashMap();
        this.termsCollection = null;
    }

    public void init() {
        super.init0();
        this.termsCollection = ((OhConnectionModelsDelegate)this.nmd.getOhConnectionModels()).getOhTerms();
        if (this.termsCollection != null) {
            this.termsCollection.addObserver(this);
        }
    }

    public INodeModel getNodeModel() {
        return this.getNodeModelDelegate();
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    public String getTitle() {
        return "Create " + this.getTypeName() + " Termination";
    }

    protected abstract String getTypeName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOhTermModel getTermModel(int n) {
        if (this.db.on()) {
            this.db.println("Get TermModel for index " + n);
        }
        HashSet hashSet = this.getTerms();
        synchronized (hashSet) {
            Iterator iterator = this.terms.iterator();
            while (iterator.hasNext()) {
                try {
                    IOhTermModel iOhTermModel = (IOhTermModel)iterator.next();
                    if (iOhTermModel.getOpticalPortIndex() != n) continue;
                    if (this.db.on()) {
                        this.db.println("Found TermModel = " + iOhTermModel);
                    }
                    return iOhTermModel;
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    this.db.println("Caught CmsIoException in getTermModel()");
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        }
        return null;
    }

    public void addTermObserver(int n, Observer observer) throws NoSuchTerm {
        this.addTermObserver(n, (IObserver)observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTermObserver(int n, IObserver iObserver) throws NoSuchTerm {
        if (this.db.on()) {
            this.db.println("Called addTermObserver for index " + n + ": from " + iObserver);
        }
        IOhTermModel iOhTermModel = this.getTermModel(n);
        if (this.db.on()) {
            this.db.println("Found corresponding TermModel = " + iOhTermModel);
        }
        if (iOhTermModel != null) {
            HashMap hashMap = this.portToTermMap;
            synchronized (hashMap) {
                this.portToTermMap.put(new Integer(n), iOhTermModel);
            }
        } else {
            throw new NoSuchTerm("No " + this.getTypeName() + " at port index = " + n);
        }
        iOhTermModel.addObserver(iObserver);
    }

    public void deleteTermObserver(int n, Observer observer) {
        this.deleteTermObserver(n, (IObserver)observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTermObserver(int n, IObserver iObserver) {
        if (this.db.on()) {
            this.db.println("Called deleteTermObserver for index " + n + ": from " + iObserver);
        }
        Integer n2 = new Integer(n);
        HashMap hashMap = this.portToTermMap;
        synchronized (hashMap) {
            IOhTermModel iOhTermModel = (IOhTermModel)this.portToTermMap.get(n2);
            if (this.db.on()) {
                this.db.println("Find corresponding TermModel = " + iOhTermModel);
            }
            if (iOhTermModel != null) {
                iOhTermModel.deleteObserver(iObserver);
                this.portToTermMap.remove(n2);
            }
        }
    }

    protected Set excludeUcpTerms(Set set) {
        HashSet<EntityModel> hashSet = new HashSet<EntityModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            if (this.nmd.getUcpNodeModel().getUcpInterfaces().isUcpPortIndex(entityModel.getIndex())) continue;
            hashSet.add(entityModel);
        }
        return hashSet;
    }

    protected Set dwdmTrunkPorts(Set set) {
        HashSet<DwdmPortModel> hashSet = new HashSet<DwdmPortModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DwdmPortModel dwdmPortModel = (DwdmPortModel)iterator.next();
            if (dwdmPortModel.isClientPort()) continue;
            hashSet.add(dwdmPortModel);
        }
        return hashSet;
    }

    protected Set nonOTNPorts(Set set) {
        HashSet<DwdmPortModel> hashSet = new HashSet<DwdmPortModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DwdmPortModel dwdmPortModel = (DwdmPortModel)iterator.next();
            if (dwdmPortModel.isClientPort()) continue;
            DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)dwdmPortModel.getDwdmLineModel();
            try {
                if (dwdmTrkLineModel.getOTNStatus()) continue;
                hashSet.add(dwdmPortModel);
            }
            catch (NoSuchInterface noSuchInterface) {
                this.db.println("Caught NoSuchInterface in nonOTNPorts");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.db.println("Caught NoSuchInterface in nonOTNPorts");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return hashSet;
    }

    protected Set otnEnabledPorts(Set set) {
        HashSet<DwdmPortModel> hashSet = new HashSet<DwdmPortModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DwdmPortModel dwdmPortModel = (DwdmPortModel)iterator.next();
            if (dwdmPortModel.isClientPort()) continue;
            DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)dwdmPortModel.getDwdmLineModel();
            try {
                if (!dwdmTrkLineModel.getOTNStatus()) continue;
                hashSet.add(dwdmPortModel);
            }
            catch (NoSuchInterface noSuchInterface) {
                this.db.println("Caught NoSuchInterface in nonOTNPorts");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.db.println("Caught NoSuchInterface in nonOTNPorts");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return hashSet;
    }

    protected Set dwdmPayloadPorts(Set set, int n) {
        HashSet<DwdmPortModel> hashSet = new HashSet<DwdmPortModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                DwdmPortModel dwdmPortModel = (DwdmPortModel)iterator.next();
                AbstractDwdmLineModel abstractDwdmLineModel = (AbstractDwdmLineModel)dwdmPortModel.getInterfaceModel();
                if (abstractDwdmLineModel.getPayloadType() != n) continue;
                hashSet.add(dwdmPortModel);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                this.db.println("Caught NoSuchInterface in nonOTNPorts");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            catch (NoSuchInterface noSuchInterface) {
                this.db.println("Caught NoSuchInterface in nonOTNPorts");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.db.println("Caught NoSuchInterface in nonOTNPorts");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return hashSet;
    }

    protected Set dwdmEtherPorts(Set set) {
        return this.dwdmPayloadPorts(set, 2);
    }

    protected Set dwdmUnframedPorts(Set set) {
        return this.dwdmPayloadPorts(set, 4);
    }

    public abstract IEntityModel[] getTermCandidates();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConnectionModel[] getTermModels() {
        IConnectionModel[] iConnectionModelArray;
        HashSet hashSet = this.getTerms();
        synchronized (hashSet) {
            if (this.db.on()) {
                this.db.println("dcc/gccterms: " + this.terms.size() + "(size), " + this.terms);
            }
            iConnectionModelArray = this.terms.toArray(new ConnectionModel[this.terms.size()]);
        }
        return iConnectionModelArray;
    }

    public abstract OhChannelType getChannelType(eGccRate var1);

    public void createTermination(IEntityModel iEntityModel, Object object) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections, ProvisionError {
        this.createTermination(iEntityModel, (Serializable[])object);
    }

    public void createTermination(IEntityModel iEntityModel, Serializable[] serializableArray) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections, ProvisionError {
        Object[] objectArray = serializableArray;
        boolean bl = (Boolean)objectArray[0];
        boolean bl2 = (Boolean)objectArray[1];
        this.createTermination(iEntityModel, bl, bl2);
    }

    public void createTermination(IEntityModel iEntityModel, boolean bl) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections, ProvisionError {
        this.createTermination(iEntityModel, bl, false);
    }

    public void createTermination(IEntityModel iEntityModel, boolean bl, boolean bl2) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections, ProvisionError {
        this.createTermination(iEntityModel, bl, bl2, eGccRate.GCC_RATE_192K);
    }

    public void createTermination(IEntityModel iEntityModel, boolean bl, boolean bl2, eGccRate eGccRate2) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections, ProvisionError {
        CircuitId circuitId = new CircuitId(-1, -1);
        OhTerm ohTerm = new OhTerm(new OhChannel(iEntityModel.getEntityIndex(), this.getChannelType(eGccRate2).getIndex()), -1);
        OhTermModel ohTermModel = (OhTermModel)((OhConnectionModelsDelegate)this.nmd.getOhConnectionModels()).createOverheadTerm(circuitId, ohTerm);
        if (ohTermModel != null) {
            ohTermModel.setOspfEnable(bl);
            ohTermModel.setFarEndIsForeign(bl2);
            this.addModels();
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
        }
    }

    public void createTermination(IEntityModel iEntityModel, boolean bl, boolean bl2, eGccRate eGccRate2, sSubnet sSubnet2) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections, ConfigError {
        CircuitId circuitId = new CircuitId(-1, -1);
        OhTerm ohTerm = new OhTerm(new OhChannel(iEntityModel.getEntityIndex(), this.getChannelType(eGccRate2).getIndex()), -1);
        OhTermModel ohTermModel = (OhTermModel)((OhConnectionModelsDelegate)this.nmd.getOhConnectionModels()).createOverheadTermWithOsi(circuitId, ohTerm, sSubnet2);
        if (ohTermModel != null) {
            ohTermModel.setOspfEnable(bl);
            ohTermModel.setFarEndIsForeign(bl2);
            this.addModels();
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
        }
    }

    public void createTermination(IEntityModel iEntityModel, boolean bl, boolean bl2, eGccRate eGccRate2, sSubnet sSubnet2, sLapdTerm sLapdTerm2) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections, ConfigError {
        CircuitId circuitId = new CircuitId(-1, -1);
        OhTerm ohTerm = new OhTerm(new OhChannel(iEntityModel.getEntityIndex(), this.getChannelType(eGccRate2).getIndex()), -1);
        sLapdTerm2.type = eOverheadChannelType.from_int(this.getChannelType(eGccRate2).getIndex());
        OhTermModel ohTermModel = (OhTermModel)((OhConnectionModelsDelegate)this.nmd.getOhConnectionModels()).createOverheadTermWithLapd(circuitId, ohTerm, sSubnet2, sLapdTerm2);
        if (ohTermModel != null) {
            ohTermModel.setOspfEnable(bl);
            ohTermModel.setFarEndIsForeign(bl2);
            this.addModels();
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
        }
    }

    public void deleteTermination(IOhTermModel iOhTermModel) throws Busy, NoLanAccess {
        if (iOhTermModel != null) {
            iOhTermModel.localDestroy();
            this.deleteModel((OhTermModel)iOhTermModel);
        }
    }

    public IEntityModel getPortModelByLineIndex(int n) throws AbstractCmsNoSuchEntityException {
        return this.nmd.getEntityTableModel().getEntityModelByIndex(n);
    }

    public abstract boolean entityExistsInTerminations(IEntityModel var1);

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.info("update: src = " + observable + ", evt = " + object);
        }
        if (observable instanceof OhTerms && object == ModelUpdateType.ADDED) {
            this.addModels();
            this.setChanged();
            this.notifyObservers(object);
        }
    }

    protected final void initialize() {
        if (!this.initialized) {
            this.addModels();
            this.initialized = true;
            if (this.db.on()) {
                this.db.println("initialized: " + this);
            }
        }
    }

    protected abstract boolean termQualifies(OhTermModel var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addModels() {
        if (this.db.on()) {
            this.db.fine("add Models");
        }
        HashSet hashSet = new HashSet(((OhConnectionModelsDelegate)this.nmd.getOhConnectionModels()).getOhTerms().cloneConnectionModels().values());
        HashSet hashSet2 = this.terms;
        synchronized (hashSet2) {
            hashSet.removeAll(this.terms);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                OhTermModel ohTermModel = (OhTermModel)iterator.next();
                if (!this.termQualifies(ohTermModel)) continue;
                this.terms.add(ohTermModel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteModel(OhTermModel ohTermModel) {
        if (this.db.on()) {
            this.db.fine("deleteModel - " + ohTermModel);
        }
        HashSet hashSet = this.terms;
        synchronized (hashSet) {
            this.terms.remove(ohTermModel);
        }
    }

    protected boolean isGccTerm(OhTermModel ohTermModel) {
        boolean bl;
        block6: {
            DwdmTrkLineModel dwdmTrkLineModel;
            DwdmPortModel dwdmPortModel;
            bl = false;
            IEntityModel iEntityModel = ohTermModel.getOpticalPortModel();
            int n = ohTermModel.getChannelType();
            if ((n == 0 || n == 4) && iEntityModel instanceof DwdmPortModel && !(dwdmPortModel = (DwdmPortModel)iEntityModel).isClientPort() && (dwdmTrkLineModel = (DwdmTrkLineModel)dwdmPortModel.getDwdmLineModel()) != null) {
                try {
                    if (dwdmTrkLineModel.getOTNStatus()) {
                        bl = true;
                    }
                }
                catch (NoSuchInterface noSuchInterface) {
                    this.db.println("Caught NoSuchInterface in nonOTNPorts");
                    if (this.db.on()) {
                        SDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    this.db.println("Caught NoSuchInterface in nonOTNPorts");
                    if (!this.db.on()) break block6;
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
        }
        return bl;
    }

    protected boolean isOscTerm(OhTermModel ohTermModel) {
        IModuleModel iModuleModel = ohTermModel.getOpticalPortModel().getModuleModel();
        if (iModuleModel == null) {
            return false;
        }
        return iModuleModel.getEqType() == 128 || iModuleModel.getEqType() == 127;
    }

    protected HashSet getTerms() {
        this.initialize();
        return this.terms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose(): " + this);
        }
        if (this.termsCollection != null) {
            this.termsCollection.deleteObserver(this);
        }
        Cloneable cloneable = this.portToTermMap;
        synchronized (cloneable) {
            if (this.portToTermMap.size() > 0) {
                this.db.println("PortToTermMap is not empty!!");
                this.portToTermMap.clear();
            }
        }
        cloneable = this.terms;
        synchronized (cloneable) {
            this.terms.clear();
        }
        this.initialized = false;
        super.dispose();
    }

    protected Set getNonTransparentTermDwdmEntities() {
        Set set = this.nmd.getElementModels().getNonProtectDwdmEntities();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                IEntityModel iEntityModel = (IEntityModel)iterator.next();
                if (!(iEntityModel instanceof DwdmPortModel) || ((DwdmPortModel)iEntityModel).getDwdmLineModel().getTermMode() != 0) continue;
                iterator.remove();
            }
            catch (NoSuchInterface noSuchInterface) {
                this.db.println("Caught NoSuchInterface in getNonTransparentTermDwdmEntities");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.db.println("Caught WrongInterfaceType in getNonTransparentTermDwdmEntities");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return set;
    }
}

