/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.sTime;
import cerent.cms.idl.Security.eSecurityLevel;
import cerent.cms.idl.Security.eSessionType;
import cerent.cms.idl.Security.sActiveUserInfo;
import cerent.cms.model.CtcTimeZone;
import cerent.cms.model.IActiveUserInfoModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class ActiveUserInfoModel
implements IActiveUserInfoModel {
    private static final SDebug db = new SDebug("ActiveUserInfoModel");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
    private String userId;
    private eSecurityLevel securityLevel;
    private IIpAddr clientIp;
    private eSessionType sessionType;
    private Date loginTime;
    private Date activityTime;
    private int ticket;

    public ActiveUserInfoModel(NodeModelDelegate nodeModelDelegate, sActiveUserInfo sActiveUserInfo2) {
        this.userId = sActiveUserInfo2.userId;
        this.securityLevel = eSecurityLevel.from_int(sActiveUserInfo2.securityLevel.value());
        this.clientIp = IpAddrFactory.getIIpAddr(sActiveUserInfo2.clientIpAddress);
        this.sessionType = eSessionType.from_int(sActiveUserInfo2.sessionType.value());
        if (sActiveUserInfo2.loginTime.year != 0) {
            this.loginTime = this.getDate(nodeModelDelegate, sActiveUserInfo2.loginTime);
        }
        if (sActiveUserInfo2.activityTime.year != 0) {
            this.activityTime = this.getDate(nodeModelDelegate, sActiveUserInfo2.activityTime);
        }
        this.ticket = sActiveUserInfo2.ticket;
    }

    private Date getDate(NodeModelDelegate nodeModelDelegate, sTime sTime2) {
        Date date = null;
        CtcTimeZone ctcTimeZone = nodeModelDelegate.getCtcTimeZone();
        String string = "" + sTime2.month + "/" + sTime2.day + "/" + sTime2.year + " " + sTime2.hour + ":" + sTime2.minute + ":" + sTime2.second + " " + (sTime2.dstInEffect ? ctcTimeZone.getDstTzAbbreviation() : ctcTimeZone.getStandTzAbbreviation());
        try {
            date = sdf.parse(string);
        }
        catch (ParseException parseException) {
            db.info("failed to parse date(" + string + "): ");
        }
        return date;
    }

    public String getUserId() {
        return this.userId;
    }

    public int getPermissionLevel() {
        return this.securityLevel.value();
    }

    public eSecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public IIpAddr getClientIpAddress() {
        return this.clientIp;
    }

    public String getSessionType() {
        return EnumStrings.getString((Class)eSessionType.class, (int)this.sessionType.value());
    }

    public Date getLoginTime() {
        return this.loginTime;
    }

    public Date getActivityTime() {
        return this.activityTime;
    }

    public int getSessionTicket() {
        return this.ticket;
    }

    public String toString() {
        return this.userId;
    }

    public boolean equals(Object object) {
        if (object instanceof ActiveUserInfoModel) {
            ActiveUserInfoModel activeUserInfoModel = (ActiveUserInfoModel)object;
            byte[] byArray = this.clientIp.getAddr();
            byte[] byArray2 = activeUserInfoModel.getClientIpAddress().getAddr();
            return activeUserInfoModel.getUserId().equals(this.userId) && activeUserInfoModel.getPermissionLevel() == this.getPermissionLevel() && Arrays.equals(byArray, byArray2);
        }
        return false;
    }

    public int compareTo(Object object) {
        if (object instanceof IActiveUserInfoModel) {
            IActiveUserInfoModel iActiveUserInfoModel = (IActiveUserInfoModel)object;
            return this.userId.compareTo(iActiveUserInfoModel.getUserId());
        }
        return -1;
    }

    public int hashCode() {
        return this.userId.hashCode();
    }
}

