/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.FramingType;
import cerent.cms.model.IAdminLineAccess;
import cerent.cms.model.IAdminState;
import cerent.cms.ui.IAdminTableAccess;
import cerent.util.SDHTDMTerminology;
import cerent.util.SONETTDMTerminology;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AdminState
implements IAdminState,
Comparator {
    private static final String SONET_BASE_OOS_WARN = "Some lines will go out of service.";
    private static final String SDH_BASE_OOS_WARN = "Some lines will be locked.";
    public static final String OOS_MT_WARNING = "Action may be service affecting.";
    public static final String OOS_DSBLD_WARNING = "Action will be service affecting.";
    public static final String AIS_WARNING = "AIS will be injected upstream and downstream.";
    public static final String AINS_WARNING = "Changing Admin State.";
    public static final String OOS_MT_WARNING_EQPT = "Action may be service affecting.";
    public static final AdminState IS = new AdminState(eAdminState.ADMIN_IS);
    public static final AdminState IS_ETSI = new AdminState(eAdminState.ADMIN_IS);
    public static final AdminState OOS_DSBLD = new AdminState(eAdminState.ADMIN_OOS_DSBLD);
    public static final AdminState OOS_DSBLD_ETSI = new AdminState(eAdminState.ADMIN_OOS_DSBLD);
    public static final AdminState OOS_MT = new AdminState(eAdminState.ADMIN_OOS_MT);
    public static final AdminState OOS_MT_ETSI = new AdminState(eAdminState.ADMIN_OOS_MT);
    public static final AdminState IS_AINS = new AdminState(eAdminState.ADMIN_IS_AINS);
    public static final AdminState IS_AINS_ETSI = new AdminState(eAdminState.ADMIN_IS_AINS);
    public static final AdminState OOS_OOG = new AdminState(eAdminState.ADMIN_OOS_OOG);
    public static final AdminState OOS_OOG_ETSI = new AdminState(eAdminState.ADMIN_OOS_OOG);
    public static final AdminState NULL_STATE = new AdminState(null, "", true);
    static HashMap stateOrderingMap;
    private eAdminState adminStateEnum;
    private String adminStateStr = "";
    private boolean isSonet = true;

    private AdminState(eAdminState eAdminState2) {
        this.adminStateEnum = eAdminState2;
    }

    private AdminState(eAdminState eAdminState2, String string, boolean bl) {
        this.adminStateEnum = eAdminState2;
        this.adminStateStr = string;
        this.isSonet = bl;
    }

    private static void init(AdminState adminState, TDMTerminology tDMTerminology) {
        adminState.adminStateStr = AdminState.getTerm(tDMTerminology, adminState.adminStateEnum.value());
        adminState.isSonet = AdminState.isANSI(tDMTerminology);
    }

    public static String getBaseOosWarning(TDMTerminology tDMTerminology) {
        if (tDMTerminology instanceof SDHTDMTerminology) {
            return SDH_BASE_OOS_WARN;
        }
        return SONET_BASE_OOS_WARN;
    }

    public static String intAdminStateToStr(int n, TDMTerminology tDMTerminology) {
        String string;
        try {
            eAdminState eAdminState2 = eAdminState.from_int(n);
            string = AdminState.enumAdminStateToStr(eAdminState2, tDMTerminology);
        }
        catch (Exception exception) {
            string = "Unknown";
        }
        return string;
    }

    public static String enumAdminStateToStr(eAdminState eAdminState2) {
        return AdminState.enumAdminStateToStr(eAdminState2, true);
    }

    public static String enumAdminStateToStr(eAdminState eAdminState2, TDMTerminology tDMTerminology) {
        if (tDMTerminology instanceof SDHTDMTerminology) {
            return AdminState.enumAdminStateToStr(eAdminState2, false);
        }
        return AdminState.enumAdminStateToStr(eAdminState2, true);
    }

    public static String enumAdminStateToStr(eAdminState eAdminState2, boolean bl) {
        String string = null;
        if (eAdminState2 == null) {
            return NULL_STATE.toString();
        }
        switch (eAdminState2.value()) {
            case 0: {
                string = bl ? IS.toString() : IS_ETSI.toString();
                break;
            }
            case 1: {
                string = bl ? OOS_DSBLD.toString() : OOS_DSBLD_ETSI.toString();
                break;
            }
            case 3: {
                string = bl ? IS_AINS.toString() : IS_AINS_ETSI.toString();
                break;
            }
            case 2: {
                string = bl ? OOS_MT.toString() : OOS_MT_ETSI.toString();
                break;
            }
            case 4: {
                string = bl ? OOS_OOG.toString() : OOS_OOG_ETSI.toString();
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public static AdminState enumToAdminState(eAdminState eAdminState2) {
        return AdminState.enumToAdminState(eAdminState2, true);
    }

    public static AdminState enumToAdminState(eAdminState eAdminState2, boolean bl) {
        AdminState adminState;
        if (eAdminState2 == null) {
            return NULL_STATE;
        }
        switch (eAdminState2.value()) {
            case 0: {
                adminState = bl ? IS : IS_ETSI;
                break;
            }
            case 1: {
                adminState = bl ? OOS_DSBLD : OOS_DSBLD_ETSI;
                break;
            }
            case 3: {
                adminState = bl ? IS_AINS : IS_AINS_ETSI;
                break;
            }
            case 2: {
                adminState = bl ? OOS_MT : OOS_MT_ETSI;
                break;
            }
            case 4: {
                adminState = bl ? OOS_OOG : OOS_OOG_ETSI;
                break;
            }
            default: {
                adminState = NULL_STATE;
            }
        }
        return adminState;
    }

    public static AdminState[] getDefaultAdminStates(boolean bl) {
        int n = 4;
        AdminState[] adminStateArray = new AdminState[n];
        adminStateArray[0] = bl ? IS : IS_ETSI;
        adminStateArray[1] = bl ? OOS_DSBLD : OOS_DSBLD_ETSI;
        adminStateArray[2] = bl ? OOS_MT : OOS_MT_ETSI;
        adminStateArray[3] = bl ? IS_AINS : IS_AINS_ETSI;
        return adminStateArray;
    }

    public static AdminState[] getEquipmentAdminStates(boolean bl) {
        int n = 2;
        AdminState[] adminStateArray = new AdminState[n];
        adminStateArray[0] = bl ? IS : IS_ETSI;
        adminStateArray[1] = bl ? OOS_MT : OOS_MT_ETSI;
        return adminStateArray;
    }

    public static AdminState[] getDataCardAdminStates(boolean bl) {
        return AdminState.getAdminStatesNoAINS(bl);
    }

    public static AdminState[] getAdminStatesNoAINS(boolean bl) {
        int n = 3;
        AdminState[] adminStateArray = new AdminState[n];
        adminStateArray[0] = bl ? IS : IS_ETSI;
        adminStateArray[1] = bl ? OOS_DSBLD : OOS_DSBLD_ETSI;
        adminStateArray[2] = bl ? OOS_MT : OOS_MT_ETSI;
        return adminStateArray;
    }

    public static AdminState[] getAdminStatesNoDSBLD(boolean bl) {
        int n = 2;
        AdminState[] adminStateArray = new AdminState[n];
        adminStateArray[0] = bl ? OOS_MT : OOS_MT_ETSI;
        adminStateArray[1] = bl ? IS_AINS : IS_AINS_ETSI;
        return adminStateArray;
    }

    public static AdminState[] getAdminStatesNoIS(boolean bl) {
        int n = 3;
        AdminState[] adminStateArray = new AdminState[n];
        adminStateArray[0] = bl ? OOS_DSBLD : OOS_DSBLD_ETSI;
        adminStateArray[1] = bl ? OOS_MT : OOS_MT_ETSI;
        adminStateArray[2] = bl ? IS_AINS : IS_AINS_ETSI;
        return adminStateArray;
    }

    public static AdminState[] getAdminStatesIS_DSBLD(boolean bl) {
        int n = 2;
        AdminState[] adminStateArray = new AdminState[n];
        adminStateArray[0] = bl ? IS : IS_ETSI;
        adminStateArray[1] = bl ? OOS_DSBLD : OOS_DSBLD_ETSI;
        return adminStateArray;
    }

    public static AdminState[] getAdminStatesDSBLD(boolean bl) {
        AdminState[] adminStateArray = new AdminState[]{bl ? OOS_DSBLD : OOS_DSBLD_ETSI};
        return adminStateArray;
    }

    public eAdminState getAdminStateEnum() {
        return this.adminStateEnum;
    }

    public boolean equals(AdminState adminState) {
        if (adminState == null) {
            return false;
        }
        if (adminState.getAdminStateEnum() == null || this.adminStateEnum == null) {
            return adminState.getAdminStateEnum() == null && this.adminStateEnum == null;
        }
        return this.adminStateEnum.value() == adminState.getAdminStateEnum().value();
    }

    public int hashCode() {
        if (this.adminStateEnum == null) {
            return -1;
        }
        return this.adminStateEnum.value();
    }

    public int compare(Object object, Object object2) {
        AdminState adminState = (AdminState)object;
        AdminState adminState2 = (AdminState)object2;
        return AdminState.compare(adminState, adminState2);
    }

    public static int compare(AdminState adminState, AdminState adminState2) {
        int n;
        Integer n2 = (Integer)stateOrderingMap.get(adminState.getAdminStateEnum());
        Integer n3 = (Integer)stateOrderingMap.get(adminState2.getAdminStateEnum());
        int n4 = n2;
        if (n4 < (n = n3.intValue())) {
            return -1;
        }
        if (n < n4) {
            return 1;
        }
        return 0;
    }

    public static boolean isANSI(int n) {
        return FramingType.getFramingType((int)n).isSonet();
    }

    public static boolean isANSI(TDMTerminology tDMTerminology) {
        return !(tDMTerminology instanceof SDHTDMTerminology);
    }

    public static TDMTerminology getSONETTermInstance() {
        return SONETTDMTerminology.instance();
    }

    public static String getAdminTermIS(TDMTerminology tDMTerminology) {
        if (tDMTerminology == null) {
            tDMTerminology = AdminState.getSONETTermInstance();
        }
        return tDMTerminology.getTermForAdminState(0);
    }

    public static String getAdminTermAINS(TDMTerminology tDMTerminology) {
        if (tDMTerminology == null) {
            tDMTerminology = AdminState.getSONETTermInstance();
        }
        return tDMTerminology.getTermForAdminState(3);
    }

    public static String getAdminTermMT(TDMTerminology tDMTerminology) {
        if (tDMTerminology == null) {
            tDMTerminology = AdminState.getSONETTermInstance();
        }
        return tDMTerminology.getTermForAdminState(2);
    }

    public static String getAdminTermDSBLD(TDMTerminology tDMTerminology) {
        if (tDMTerminology == null) {
            tDMTerminology = AdminState.getSONETTermInstance();
        }
        return tDMTerminology.getTermForAdminState(1);
    }

    public static String getAdminTermOOG(TDMTerminology tDMTerminology) {
        if (tDMTerminology == null) {
            tDMTerminology = AdminState.getSONETTermInstance();
        }
        return tDMTerminology.getTermForAdminState(4);
    }

    public String toString() {
        return this.adminStateStr;
    }

    public String toString(TDMTerminology tDMTerminology) {
        if (this.adminStateEnum == null) {
            return "";
        }
        return AdminState.getTerm(tDMTerminology, this.adminStateEnum.value());
    }

    private static String getTerm(TDMTerminology tDMTerminology, int n) {
        return tDMTerminology.getTermForAdminState(n);
    }

    public static boolean isFormOfIS(eAdminState eAdminState2) {
        switch (eAdminState2.value()) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFormOfISOrAINS(eAdminState eAdminState2) {
        switch (eAdminState2.value()) {
            case 0: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFormOfOOS(eAdminState eAdminState2) {
        switch (eAdminState2.value()) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    public static boolean admitsSoakTime(eAdminState eAdminState2) {
        switch (eAdminState2.value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean admitsLoopback(eAdminState eAdminState2) {
        switch (eAdminState2.value()) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean admitsSendCode(eAdminState eAdminState2) {
        switch (eAdminState2.value()) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean admitsFarEndLoopbackInhibition(eAdminState eAdminState2) {
        switch (eAdminState2.value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean warnOnMediaChange(eAdminState eAdminState2) {
        switch (eAdminState2.value()) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAdminState(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTransitionToOOS(eAdminState eAdminState2, eAdminState eAdminState3) {
        int n;
        int n2 = eAdminState2.value();
        if (n2 == (n = eAdminState3.value()) || n2 == 0) {
            return false;
        }
        if (n2 == 1) {
            return true;
        }
        if (n2 == 2 && n != 1) {
            return true;
        }
        return n2 == 3 && n == 0;
    }

    public static String getAdminStateChangeMsg(AdminState adminState) {
        return AdminState.getAdminStateChangeMsg(adminState, false);
    }

    public static String getAdminStateChangeMsg(AdminState adminState, boolean bl) {
        String string = "Changing the Admin State.";
        if (AdminState.nullCheck(adminState)) {
            return string;
        }
        eAdminState eAdminState2 = adminState.getAdminStateEnum();
        switch (eAdminState2.value()) {
            case 3: {
                return AINS_WARNING;
            }
            case 2: {
                return "Action may be service affecting.";
            }
            case 1: {
                if (bl) {
                    return OOS_DSBLD_WARNING;
                }
                return "Action will be service affecting.\nAIS will be injected upstream and downstream.";
            }
        }
        return string;
    }

    public static String computeAdminStateChangeMsg(List list) {
        return AdminState.computeAdminStateChangeMsg(list, false);
    }

    public static String computeAdminStateChangeMsg(List list, boolean bl) {
        AdminState adminState = IS;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AdminState adminState2 = (AdminState)iterator.next();
            if (AdminState.compare(adminState2, adminState) <= 0) continue;
            adminState = adminState2;
        }
        return AdminState.getAdminStateChangeMsg(adminState, bl);
    }

    private static boolean nullCheck(AdminState adminState) {
        return adminState == null || adminState.equals(NULL_STATE);
    }

    public static boolean adminStateChangedToFormOfOOS(IAdminTableAccess iAdminTableAccess, IAdminLineAccess[] iAdminLineAccessArray) throws Exception {
        for (int i = 0; i < iAdminLineAccessArray.length; ++i) {
            if (!iAdminTableAccess.isAdminStateDirty(i) || !AdminState.isTransitionToOOS(iAdminTableAccess.getAdminState(i).getAdminStateEnum(), iAdminLineAccessArray[i].getAdminStateEnum())) continue;
            return true;
        }
        return false;
    }

    public static boolean adminStateChangedToFormOfOOSWhilePeerIsIS(IAdminTableAccess iAdminTableAccess, IAdminLineAccess[] iAdminLineAccessArray) throws Exception {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < iAdminLineAccessArray.length; ++i) {
            if (iAdminTableAccess.isAdminStateDirty(i) && AdminState.isTransitionToOOS(iAdminTableAccess.getAdminState(i).getAdminStateEnum(), iAdminLineAccessArray[i].getAdminStateEnum())) {
                ++n;
                continue;
            }
            if (!AdminState.isFormOfIS(iAdminLineAccessArray[i].getAdminStateEnum()) && !AdminState.isFormOfIS(iAdminTableAccess.getAdminState(i).getAdminStateEnum())) continue;
            ++n2;
        }
        return n > 0 && n2 > 0;
    }

    public static String getSevWarningMsg(IAdminTableAccess iAdminTableAccess, IAdminLineAccess[] iAdminLineAccessArray, boolean bl) throws Exception {
        return AdminState.getSevWarningMsg(iAdminTableAccess, iAdminLineAccessArray, bl, false);
    }

    public static String getSevWarningMsg(IAdminTableAccess iAdminTableAccess, IAdminLineAccess[] iAdminLineAccessArray, boolean bl, boolean bl2) throws Exception {
        ArrayList<AdminState> arrayList = new ArrayList<AdminState>();
        for (int i = 0; i < iAdminLineAccessArray.length; ++i) {
            if (!iAdminTableAccess.isAdminStateDirty(i) || !AdminState.isTransitionToOOS(iAdminTableAccess.getAdminState(i).getAdminStateEnum(), iAdminLineAccessArray[i].getAdminStateEnum())) continue;
            arrayList.add(iAdminTableAccess.getAdminState(i));
        }
        if (bl) {
            arrayList.add(OOS_MT);
        }
        if (arrayList.size() == 0) {
            return "";
        }
        return AdminState.computeAdminStateChangeMsg(arrayList, bl2);
    }

    public static boolean needRemoveLoopback(IAdminTableAccess iAdminTableAccess, IAdminLineAccess[] iAdminLineAccessArray) throws Exception {
        for (int i = 0; i < iAdminLineAccessArray.length; ++i) {
            eAdminState eAdminState2;
            if (!iAdminTableAccess.isAdminStateDirty(i) || AdminState.admitsLoopback(eAdminState2 = iAdminTableAccess.getAdminState(i).getAdminStateEnum()) || iAdminLineAccessArray[i].getLoopbackAsInt() == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean notApplicable(eEqType eEqType2) {
        return eEqType2 == eEqType.FILLER_CARD;
    }

    static {
        SONETTDMTerminology sONETTDMTerminology = SONETTDMTerminology.instance();
        AdminState.init(IS, (TDMTerminology)sONETTDMTerminology);
        AdminState.init(OOS_DSBLD, (TDMTerminology)sONETTDMTerminology);
        AdminState.init(OOS_MT, (TDMTerminology)sONETTDMTerminology);
        AdminState.init(IS_AINS, (TDMTerminology)sONETTDMTerminology);
        AdminState.init(OOS_OOG, (TDMTerminology)sONETTDMTerminology);
        sONETTDMTerminology = SDHTDMTerminology.instance();
        AdminState.init(IS_ETSI, (TDMTerminology)sONETTDMTerminology);
        AdminState.init(OOS_DSBLD_ETSI, (TDMTerminology)sONETTDMTerminology);
        AdminState.init(OOS_MT_ETSI, (TDMTerminology)sONETTDMTerminology);
        AdminState.init(IS_AINS_ETSI, (TDMTerminology)sONETTDMTerminology);
        AdminState.init(OOS_OOG_ETSI, (TDMTerminology)sONETTDMTerminology);
        stateOrderingMap = new HashMap();
        stateOrderingMap.put(eAdminState.ADMIN_IS, new Integer(0));
        stateOrderingMap.put(eAdminState.ADMIN_IS_AINS, new Integer(1));
        stateOrderingMap.put(eAdminState.ADMIN_OOS_MT, new Integer(2));
        stateOrderingMap.put(eAdminState.ADMIN_OOS_OOG, new Integer(3));
        stateOrderingMap.put(eAdminState.ADMIN_OOS_DSBLD, new Integer(4));
    }
}

