/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.ChassisModule;
import cerent.cms.idl.Equipment.ChassisModuleHelper;
import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.idl.Equipment.eMultishelfLanConfig;
import cerent.cms.idl.Equipment.sShelfInfo;
import cerent.cms.idl.Equipment.sShelfInfoSubset;
import cerent.cms.idl.Equipment.xAlreadyLocked;
import cerent.cms.idl.Equipment.xBusy;
import cerent.cms.idl.Equipment.xDuplexLocked;
import cerent.cms.idl.Equipment.xDuplexUnlocked;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.Equipment.xInvalidData;
import cerent.cms.idl.Equipment.xInvalidState;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.Equipment.xProtectActive;
import cerent.cms.idl.Equipment.xProtectFailedOrMissing;
import cerent.cms.idl.Equipment.xProtectLocked;
import cerent.cms.idl.Equipment.xWorkingFailedOrMissing;
import cerent.cms.idl.Equipment.xWorkingLocked;
import cerent.cms.idl.Node.sPwrMonVoltage;
import cerent.cms.idl.Node.xInvalidOperation;
import cerent.cms.idl.Node.xPwrMonInvalidHi;
import cerent.cms.idl.Node.xPwrMonInvalidInc;
import cerent.cms.idl.Node.xPwrMonInvalidLo;
import cerent.cms.idl.Node.xPwrMonOrderError;
import cerent.cms.idl.Node.xPwrMonSavLimits;
import cerent.cms.idl.OnsError.eProvDataError;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AlreadyLocked;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.DuplexLocked;
import cerent.cms.model.DuplexUnlocked;
import cerent.cms.model.DwdmOpticalSetupModel;
import cerent.cms.model.DwdmRingModelDelegate;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EnvAlarmTable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IAlarmModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IEtherBridgeModel;
import cerent.cms.model.ITermConnectionModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.InvalidState;
import cerent.cms.model.IorRepository;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.ProtectActive;
import cerent.cms.model.ProtectFailedOrMissing;
import cerent.cms.model.ProtectLocked;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.PwrMonInvalidHi;
import cerent.cms.model.PwrMonInvalidInc;
import cerent.cms.model.PwrMonInvalidLo;
import cerent.cms.model.PwrMonOrderError;
import cerent.cms.model.PwrMonSavLimits;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.ShelfInfo;
import cerent.cms.model.ShelfInfoFactory;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.model.WorkingFailedOrMissing;
import cerent.cms.model.WorkingLocked;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.ElementEventStore;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.model.event.IEventStore;
import cerent.cms.model.nedefaults.DefaultsManager;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.omg.CORBA.UserException;

public class ChassisModel
extends MfgEntityModel
implements IChassisModel {
    private ChassisModule chassisModuleRef;
    private SynchronizationModel syncModel;
    private EnvAlarmTable envModel;
    private PowerMonitor powerMonitorNcv;
    private ShelfInfoCV shelfInfoCv;
    private LanConfig lanConfigNcv;
    private ScMultishelf scMultishelfNcv;
    private NcMultishelf ncMultishelfNcv;
    private DisableMultishelf disableMultishelfNcv;
    private UnprovisionChassis unprovisionNcv;
    private TestLamp testLamp;

    public ChassisModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, null);
        this.setDebug(nodeModelDelegate.getDebug().getChildDebug("Chassis" + this.getShelfId()));
        this.chassisModuleRef = ChassisModuleHelper.narrow(entity);
        this.syncModel = null;
        this.envModel = null;
        this.powerMonitorNcv = new PowerMonitor(nodeModelDelegate, "ChassisModel.powerMonitor");
        this.shelfInfoCv = new ShelfInfoCV(nodeModelDelegate, "ChassisModel.shelfInfo");
        this.lanConfigNcv = new LanConfig(nodeModelDelegate, "ChassisModel.lanConfig");
        this.unprovisionNcv = new UnprovisionChassis(nodeModelDelegate, "ChassisModel.UnprovisionChassis");
        this.ncMultishelfNcv = new NcMultishelf(nodeModelDelegate, "ChassisModel.enableMultishelfAsNc");
        this.scMultishelfNcv = new ScMultishelf(nodeModelDelegate, "ChassisModel.enableMultishelfAsSc");
        this.disableMultishelfNcv = new DisableMultishelf(nodeModelDelegate, "ChassisModel.disableMultishelf");
        this.testLamp = new TestLamp(nodeModelDelegate, "ChassisModel.testLamp");
    }

    protected void updateLocal() {
        Exception exception = this.updateCV(this.shelfInfoCv);
        if (exception != null) {
            this.db.println("updateLocal caught " + exception);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.setChanged();
        super.updateLocal();
    }

    public void dispose() {
        Exception exception = this.disposeCV(this.shelfInfoCv);
        exception = this.disposeModel(this.syncModel);
        exception = this.disposeEnvModel(this.envModel);
        if (exception != null) {
            this.db.println("dispose caught " + exception);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        super.dispose();
    }

    public void destroy() {
        super.destroy();
        Exception exception = this.destroyModel(this.syncModel);
        if (exception != null) {
            this.db.println("destroy caught " + exception);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void init() {
        super.init();
        if (this.db.on()) {
            this.db.println("init(): synchronizationModel.init()");
        }
        this.getSyncModel().init();
        if (this.db.on()) {
            this.db.println("init(): envAlarmTable.init()");
        }
        this.getEnvAlarmTable().init();
    }

    public int getShelfId() {
        return this.getShelfId(this.isMultishelf());
    }

    public int getShelfId(boolean bl) {
        return bl ? this.getPositionInParent() : 1;
    }

    public void setShelfId(int n) throws ProvisionError {
        throw new EMCProvisionError(eProvDataError.FAIL_SHELF_ID_PROVISION, this.getPlatform());
    }

    public ShelfInfo getShelfInfo() {
        try {
            block4: {
                sShelfInfo sShelfInfo2 = (sShelfInfo)this.shelfInfoCv.get();
                try {
                    sShelfInfoSubset sShelfInfoSubset2 = ChassisModels.getInstance(this.getNodeModelDelegate()).getShelfInfoForChassis(this);
                    sShelfInfo2.position = sShelfInfoSubset2.position;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            return ShelfInfoFactory.getShelfInfo((sShelfInfo)this.shelfInfoCv.get(), this.isMultishelf());
        }
        catch (UserException userException) {
            throw this.doUnknown("getShelfInfo", userException);
        }
    }

    public void setLanConfig(eMultishelfLanConfig eMultishelfLanConfig2) throws ProvisionError {
        try {
            this.lanConfigNcv.set(eMultishelfLanConfig2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setMultishelfLanConfig", userException);
        }
    }

    public void disableMultishelf() throws ProvisionError, ResourceInUse, NotSupportedOnEquipment {
        if (this.getShelfInfo().getShelfRole() == ShelfInfo.IShelfRole.SHELF_ROLE_SC) {
            throw new EMCProvisionError(eProvDataError.MS_DISABLE_NOT_ALLOWED, new String[]{"It must be disabled using the LCD."}, this.getPlatform());
        }
        try {
            this.disableMultishelfNcv.set();
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment(xNotSupportedOnEquipment2.message);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, "Multishelf is not enabled on this node!", this.getPlatform());
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw this.doUnknown("disableMultishelf", userException);
        }
    }

    public void enableMultishelfAsSc(short s) throws ProvisionError, NotSupportedOnEquipment, InvalidData {
        try {
            this.scMultishelfNcv.set(new Short(s));
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment(xNotSupportedOnEquipment2.message);
        }
        catch (xInvalidData xInvalidData2) {
            throw new InvalidData((UserException)xInvalidData2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, "This shelf is already in SC mode.", this.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setMultishelfAsSc", userException);
        }
    }

    public void testChassisLamp() throws ProtectFailedOrMissing, WorkingFailedOrMissing, AlreadyLocked, ProtectLocked, WorkingLocked, ProtectActive, InvalidState, DuplexLocked, DuplexUnlocked, ProvisionError, Busy {
        try {
            if (this.db.on()) {
                this.db.println("doCommand(): " + EnumStrings.getStrings((Object)eModuleOp.TEST_LEDS) + " for " + Integer.toHexString(this.getEntityIndex()));
            }
            this.testLamp.set(eModuleOp.TEST_LEDS);
        }
        catch (xProtectFailedOrMissing xProtectFailedOrMissing2) {
            throw new ProtectFailedOrMissing((UserException)xProtectFailedOrMissing2);
        }
        catch (xWorkingFailedOrMissing xWorkingFailedOrMissing2) {
            throw new WorkingFailedOrMissing((UserException)xWorkingFailedOrMissing2);
        }
        catch (xAlreadyLocked xAlreadyLocked2) {
            throw new AlreadyLocked((UserException)xAlreadyLocked2);
        }
        catch (xProtectLocked xProtectLocked2) {
            throw new ProtectLocked((UserException)xProtectLocked2);
        }
        catch (xWorkingLocked xWorkingLocked2) {
            throw new WorkingLocked((UserException)xWorkingLocked2);
        }
        catch (xProtectActive xProtectActive2) {
            throw new ProtectActive((UserException)xProtectActive2);
        }
        catch (xInvalidState xInvalidState2) {
            throw new InvalidState((UserException)xInvalidState2);
        }
        catch (xDuplexLocked xDuplexLocked2) {
            throw new DuplexLocked((UserException)xDuplexLocked2);
        }
        catch (xDuplexUnlocked xDuplexUnlocked2) {
            throw new DuplexUnlocked((UserException)xDuplexUnlocked2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getPlatform());
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (UserException userException) {
            throw this.doUnknown("doCommand", userException);
        }
    }

    public void enableMultishelfAsNc(eMultishelfLanConfig eMultishelfLanConfig2) throws ProvisionError, NotSupportedOnEquipment {
        try {
            this.ncMultishelfNcv.set(eMultishelfLanConfig2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment(xNotSupportedOnEquipment2.message);
        }
        catch (xProvisionError xProvisionError2) {
            switch (xProvisionError2.dataError.value()) {
                case 71: {
                    throw new EMCProvisionError(xProvisionError2, "This shelf is already in NC mode!", this.getPlatform());
                }
            }
            throw new EMCProvisionError(xProvisionError2, this.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setMultishelfAsNc", userException);
        }
    }

    public void unprovision() throws ProvisionError, ResourceInUse {
        try {
            this.unprovisionNcv.set();
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getPlatform());
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw this.doUnknown("unprovisionShelf", userException);
        }
    }

    public SynchronizationModel getSyncModel() {
        if (this.syncModel == null) {
            this.syncModel = new SynchronizationModel(this);
        }
        return this.syncModel;
    }

    public DwdmRingModelDelegate getDwdmRingModelDelegate() {
        return this.node.getDwdmRingModelDelegate();
    }

    public IEtherBridgeModel getEtherBridgeModel() {
        return this.node.getEtherBridgeModel();
    }

    public OhConnectionModelsDelegate getOhConnectionModels() {
        return (OhConnectionModelsDelegate)this.node.getOhConnectionModels();
    }

    public ElementModelsDelegate getElementModels() {
        return this.node.getElementModelsDelegate();
    }

    public EntityTableModel getEntityTableModel() {
        return this.node.getEntityTableModel();
    }

    public IEntityTableModel getEntityTable() {
        return this.getEntityTableModel();
    }

    public EnvAlarmTable getEnvAlarmTable() {
        if (this.envModel == null) {
            this.envModel = new EnvAlarmTable(this);
        }
        return this.envModel;
    }

    public DwdmOpticalSetupModel getDwdmOpticalSetupModel() {
        return this.node.getDwdmOpticalSetupModel();
    }

    public ITermConnectionModel getSdccTermConnectionModel() {
        return this.node.getSdccTermConnectionModel();
    }

    public ITermConnectionModel getLdccTermConnectionModel() {
        return this.node.getLdccTermConnectionModel();
    }

    public ITermConnectionModel getGccTermConnectionModel() {
        return this.node.getGccTermConnectionModel();
    }

    public ITermConnectionModel getOscTermConnectionModel() {
        return this.node.getOscTermConnectionModel();
    }

    public IPlatform getPlatform() {
        return this.node.getPlatform();
    }

    public EventDispatcher getDispatcher() {
        return this.node.getDispatcher();
    }

    public IorRepository getIorRepository() {
        return this.node.getIorRepository();
    }

    public TDMTerminology getTDMTerminology() {
        return this.node.getTDMTerminology();
    }

    public IAlarmModel getAlarmModel() {
        return this.node.getAlarmModel();
    }

    public IConnectionModels getConnectionModels() {
        return this.node.getConnectionModels();
    }

    public DefaultsManager getDefaultsManager() {
        return this.node.getDefaultsManager();
    }

    public int getFramingType() {
        return this.node.getFramingType();
    }

    public IAlarmStore getShelfAlarmStore() {
        ElementAlarmStore elementAlarmStore = (ElementAlarmStore)this.getNodeModel().getElementAlarmStore();
        return this.isMultishelf() ? elementAlarmStore.getShelfAlarmStore(this.getShelfId()) : elementAlarmStore;
    }

    public IEventStore getShelfEventStore() {
        ElementEventStore elementEventStore = (ElementEventStore)this.getNodeModel().getElementEventStore();
        return this.isMultishelf() ? elementEventStore.getShelfEventStore(this.getShelfId()) : elementEventStore;
    }

    public sPwrMonVoltage getPowerMonitor() {
        try {
            return (sPwrMonVoltage)this.powerMonitorNcv.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getPowerMonitor", userException);
        }
    }

    public void setPowerMonitor(sPwrMonVoltage sPwrMonVoltage2) throws AbstractCmsIOException, PwrMonOrderError, PwrMonInvalidHi, PwrMonInvalidLo, PwrMonInvalidInc, PwrMonSavLimits, NotSupportedOnEquipment, InvalidOperation {
        try {
            this.powerMonitorNcv.set(sPwrMonVoltage2);
        }
        catch (xPwrMonOrderError xPwrMonOrderError2) {
            throw new PwrMonOrderError(xPwrMonOrderError2);
        }
        catch (xPwrMonInvalidHi xPwrMonInvalidHi2) {
            throw new PwrMonInvalidHi(xPwrMonInvalidHi2);
        }
        catch (xPwrMonInvalidLo xPwrMonInvalidLo2) {
            throw new PwrMonInvalidLo(xPwrMonInvalidLo2);
        }
        catch (xPwrMonInvalidInc xPwrMonInvalidInc2) {
            throw new PwrMonInvalidInc(xPwrMonInvalidInc2);
        }
        catch (xPwrMonSavLimits xPwrMonSavLimits2) {
            throw new PwrMonSavLimits(xPwrMonSavLimits2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (xInvalidOperation xInvalidOperation2) {
            throw new InvalidOperation("Platform does not support power monitoring");
        }
        catch (UserException userException) {
            throw this.doUnknown("setPowerMonitor", userException);
        }
    }

    public String toString() {
        return "ChassisModel[" + this.toShortString() + "]";
    }

    public String getEqTypeName() {
        return this.isMultishelf() ? this.getShelfInfo().getShelfRole().toString() : super.getEqTypeName();
    }

    public boolean isMultishelf() {
        return this.getNodeModelDelegate().isMultishelf();
    }

    public List getProvAlarmEntities() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getDescendantsOfClassType(6));
        arrayList.addAll(this.getDescendantsOfClassType(1));
        if (this.getNodeModelDelegate().getPlatform().isFanTrayAlarmable()) {
            arrayList.addAll(this.getDescendantsOfClassType(4));
        }
        return arrayList;
    }

    public Observable[] getProvAlarmObservables() {
        List list = this.getDescendantsOfClassType(2);
        List list2 = this.getDescendantsOfClassType(7);
        list.addAll(list2);
        return list.toArray(new Observable[list.size()]);
    }

    public Boolean getSuppressAlarmsFlag() {
        return new Boolean(this.getSuppressAlarms());
    }

    private Exception disposeEnvModel(EnvAlarmTable envAlarmTable) {
        try {
            if (envAlarmTable != null) {
                envAlarmTable.dispose();
            }
        }
        catch (Exception exception) {
            this.db.println("Exception occurred while trying to dispose " + envAlarmTable);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return exception;
        }
        return null;
    }

    int eventIndexBase() {
        return this.getEntityIndex() - 1;
    }

    public boolean hasActiveTCC2P() {
        boolean bl = false;
        EntityTableModel entityTableModel = this.getEntityTableModel();
        if (entityTableModel != null) {
            bl = entityTableModel.hasActiveTCC2P(this.getShelfId());
        }
        return bl;
    }

    public boolean hasStandbyTCC2P() {
        boolean bl = false;
        EntityTableModel entityTableModel = this.getEntityTableModel();
        if (entityTableModel != null) {
            bl = entityTableModel.hasStandbyTCC2P(this.getShelfId());
        }
        return bl;
    }

    private class TestLamp
    extends NonCachedValue {
        public TestLamp(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            ChassisModel.this.chassisModuleRef.doCommand((eModuleOp)object);
        }
    }

    private class UnprovisionChassis
    extends NonCachedValue {
        public UnprovisionChassis(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws xProvisionError, xInUse {
            ChassisModel.this.db.fine("unprovision");
            ChassisModel.this.chassisModuleRef.unprovision();
        }

        public Object outer() {
            return ChassisModel.this;
        }
    }

    private class NcMultishelf
    extends NonCachedValue {
        public NcMultishelf(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xProvisionError, xNotSupportedOnEquipment {
            ChassisModel.this.db.fine("NcMultishelf.setValue");
            ChassisModel.this.chassisModuleRef.enableMultishelfAsNc((eMultishelfLanConfig)object);
        }

        public Object outer() {
            return ChassisModel.this;
        }
    }

    private class DisableMultishelf
    extends NonCachedValue {
        public DisableMultishelf(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws xProvisionError, xNotSupportedOnEquipment, xInUse {
            ChassisModel.this.db.fine("DisableMultishelf.setValue");
            ChassisModel.this.chassisModuleRef.disableMultishelf();
        }

        public Object outer() {
            return ChassisModel.this;
        }
    }

    private class ScMultishelf
    extends NonCachedValue {
        public ScMultishelf(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xProvisionError, xNotSupportedOnEquipment, xInvalidData {
            ChassisModel.this.db.fine("ScMultishelf.setValue");
            ChassisModel.this.chassisModuleRef.enableMultishelfAsSc((Short)object);
        }

        public Object outer() {
            return ChassisModel.this;
        }
    }

    private class ShelfInfoCV
    extends CachedValue {
        public ShelfInfoCV(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            ChassisModel.this.db.fine("ShelfInfoCV.getValue");
            return ChassisModel.this.chassisModuleRef.getShelfInfo();
        }

        public Object outer() {
            return ChassisModel.this;
        }
    }

    private class LanConfig
    extends NonCachedValue {
        public LanConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xProvisionError, xNotSupportedOnEquipment {
            ChassisModel.this.db.fine("LanConfig.setValue");
            ChassisModel.this.chassisModuleRef.setMultishelfLanConfig((eMultishelfLanConfig)object);
        }

        public Object outer() {
            return ChassisModel.this;
        }
    }

    private class PowerMonitor
    extends NonCachedValue {
        public PowerMonitor(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xPwrMonSavLimits, xPwrMonOrderError, xPwrMonInvalidHi, xPwrMonInvalidLo, xPwrMonInvalidInc, xNotSupportedOnEquipment {
            if (ChassisModel.this.db.on()) {
                ChassisModel.this.db.println("PowerMonitor.setValue");
            }
            ChassisModel.this.chassisModuleRef.setPwrMonValues((sPwrMonVoltage)object);
        }

        protected Object getValue() throws xNotSupportedOnEquipment {
            if (ChassisModel.this.db.on()) {
                ChassisModel.this.db.println("PowerMonitor.getValue");
            }
            return ChassisModel.this.chassisModuleRef.getPwrMonValues();
        }

        public Object outer() {
            return ChassisModel.this;
        }
    }
}

