/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Equipment.EntityTable;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.sShelfInfoSubset;
import cerent.cms.idl.Equipment.sShelfPosition;
import cerent.cms.idl.Equipment.xInvalidData;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.ChassisModelUpdate;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ShelfInfo;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class ChassisModels
extends Model {
    private NodeModelDelegate nmd;
    private Object chassisMapLock = new Object();
    private HashMap chassisMap;
    private EventDispatcher dispatcher;
    private ShelfInfoList shelfInfoList;
    private ObservableManager observableManager;
    private static ModelSingletonCollection chassisModelsSingletons;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChassisModels(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(ChassisModels.class));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        Object object = this.chassisMapLock;
        synchronized (object) {
            this.chassisMap = new HashMap(8);
        }
        this.shelfInfoList = new ShelfInfoList(this.nmd, "ChassisModels.shelfInfoList");
        this.observableManager = new ObservableManager(this, false);
        this.observableManager.setPassing(true);
    }

    public static synchronized ChassisModels getInstance(NodeModelDelegate nodeModelDelegate) {
        ChassisModels chassisModels;
        if (chassisModelsSingletons == null) {
            chassisModelsSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"chassisModels");
        }
        if ((chassisModels = (ChassisModels)chassisModelsSingletons.get((Object)nodeModelDelegate)) == null) {
            chassisModels = new ChassisModels(nodeModelDelegate);
            chassisModelsSingletons.add((Object)nodeModelDelegate, (Object)chassisModels);
        }
        return chassisModels;
    }

    protected void updateLocal() {
        this.db.fine("updateLocal() ");
        Exception exception = this.updateCV(this.shelfInfoList);
        if (exception != null) {
            this.db.severe("updateLocal caught " + exception);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.setChanged();
        super.updateLocal();
    }

    public void update(Observable observable, Object object) {
        int n;
        this.db.fine("Got update from = " + observable + " arg = " + object);
        int n2 = -1;
        if (object instanceof IObjectMessageInfo) {
            IObjectMessageInfo iObjectMessageInfo = (IObjectMessageInfo)object;
            n = iObjectMessageInfo.getUpdateType();
            n2 = iObjectMessageInfo.getChildIndex();
        } else {
            n = (Integer)object;
        }
        switch (n) {
            case 2: {
                if (observable instanceof ChassisModel) break;
                this.addChassis(n2);
                break;
            }
            case 0: {
                try {
                    if (!(observable instanceof ChassisModel)) break;
                    this.removeChassis((ChassisModel)((Object)observable));
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.db.warning("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in update.");
                }
                break;
            }
            case 1: {
                this.updateLocal();
                break;
            }
            default: {
                this.db.warning("Unknown update type: " + n);
            }
        }
    }

    public void init() {
        super.init0();
        this.observableManager.setActive(true);
        this.db.addCommand(this, "dump", "Dump the chassisMap.");
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectChassisList, 1, (Observer)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Exception exception;
        this.observableManager.reset();
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectChassisList, 1, (Observer)this);
        }
        if ((exception = this.disposeCV(this.shelfInfoList)) != null) {
            this.db.severe("dispose caught " + exception);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        Object object = this.chassisMapLock;
        synchronized (object) {
            this.chassisMap.clear();
        }
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChassis(IChassisModel iChassisModel) {
        Integer n = new Integer(iChassisModel.getShelfId());
        Object object = this.chassisMapLock;
        synchronized (object) {
            IChassisModel iChassisModel2 = (IChassisModel)this.chassisMap.get(n);
            if (iChassisModel2 != null && iChassisModel2 != iChassisModel) {
                this.db.warning("WARNING: Chassis with shelf ID " + n + " already exists!");
                this.observableManager.removeObservable((Observable)((Object)((ChassisModel)iChassisModel2)));
            } else if (iChassisModel2 == null) {
                this.db.fine("Adding " + iChassisModel + " #" + n);
                this.chassisMap.put(n, iChassisModel);
                this.observableManager.addObservable((Observable)((Object)((ChassisModel)iChassisModel)));
            } else {
                this.db.fine("No op: " + iChassisModel2 + " == " + iChassisModel);
            }
        }
        object = iChassisModel.getShelfInfo();
        this.updateCV(this.shelfInfoList);
        this.setChanged();
        this.notifyObservers(new ChassisModelUpdate(iChassisModel, 2, ((ShelfInfo)object).getRackNum(), ((ShelfInfo)object).getRackPos()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChassis(IChassisModel iChassisModel) throws AbstractCmsNoSuchEntityException {
        Integer n = new Integer(iChassisModel.getShelfId());
        Object object = this.chassisMapLock;
        synchronized (object) {
            ChassisModel chassisModel = (ChassisModel)this.chassisMap.remove(n);
            this.db.fine("Removing " + chassisModel);
            if (chassisModel == null) {
                throw new CmsNoSuchEntityException("No such chassis with shelf ID " + n);
            }
            this.observableManager.removeObservable((Observable)((Object)chassisModel));
        }
        this.updateCV(this.shelfInfoList);
    }

    private void addChassis(int n) {
        block12: {
            this.db.fine("--------- addChassis entry -----------");
            try {
                ChassisModel chassisModel;
                EntityTableModel entityTableModel = this.nmd.getEntityTableModel();
                long l = System.currentTimeMillis();
                EntityTableModel entityTableModel2 = new EntityTableModel(this.nmd);
                entityTableModel2.discoverEntityTableByChassis(n);
                try {
                    chassisModel = (ChassisModel)entityTableModel.getEntityModelByIndex(n);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    chassisModel = null;
                }
                List list = entityTableModel2.getEntityModelsByClass(eClass.CHASSIS);
                if (chassisModel != null) {
                    if (this.db.isFineEnabled()) {
                        this.db.fine("undelete chassis: index=0x" + Integer.toHexString(n));
                    }
                    chassisModel.updateStructure(entityTableModel2, l);
                    this.addChassis(chassisModel);
                } else {
                    Object object;
                    Object object2;
                    if (this.db.isFineEnabled()) {
                        object2 = new StringBuffer();
                        ((StringBuffer)object2).append("adding chassis: index=0x");
                        ((StringBuffer)object2).append(Integer.toHexString(n));
                        ((StringBuffer)object2).append(" length=");
                        ((StringBuffer)object2).append(list.size());
                        object = list.iterator();
                        while (object.hasNext()) {
                            ChassisModel chassisModel2 = (ChassisModel)object.next();
                            ((StringBuffer)object2).append(" 0x");
                            ((StringBuffer)object2).append(Integer.toHexString(chassisModel2.getIndex()));
                        }
                        this.db.fine(((StringBuffer)object2).toString());
                    }
                    object2 = list.iterator();
                    while (object2.hasNext()) {
                        object = (ChassisModel)object2.next();
                        ((EntityModel)object).updateStructure(entityTableModel2, l);
                        this.addChassis((IChassisModel)object);
                        l = System.currentTimeMillis();
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.db.severe("Caught " + illegalStateException + " in addChassis.");
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)illegalStateException);
                }
            }
            catch (NullPointerException nullPointerException) {
                this.db.severe("Caught " + nullPointerException + " in addChassis");
                if (!this.db.on()) break block12;
                SDebug.printStackTrace((Throwable)nullPointerException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChassisModel[] getChassisModelsArray() {
        Collection collection;
        Object object = this.chassisMapLock;
        synchronized (object) {
            collection = this.chassisMap.values();
        }
        return collection.toArray(new IChassisModel[collection.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChassisModel getChassisByShelfId(int n) {
        IChassisModel iChassisModel;
        Object object = this.chassisMapLock;
        synchronized (object) {
            iChassisModel = (IChassisModel)this.chassisMap.get(new Integer(n));
        }
        return iChassisModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getShelfIdByChassisIndex(int n) {
        int n2 = -1;
        Object object = this.chassisMapLock;
        synchronized (object) {
            Iterator iterator = this.chassisMap.keySet().iterator();
            while (iterator.hasNext()) {
                Integer n3 = (Integer)iterator.next();
                ChassisModel chassisModel = (ChassisModel)this.chassisMap.get(n3);
                if (chassisModel.getEntityIndex() != n) continue;
                n2 = n3;
                break;
            }
        }
        return n2;
    }

    private EntityTable getEntityTableRef() {
        return this.nmd.getIorRepository().getEntityTableRef();
    }

    public sShelfInfoSubset[] getShelfInfoList() {
        try {
            return (sShelfInfoSubset[])this.shelfInfoList.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "ChassisModel.getShelfInfoList", userException);
        }
    }

    public sShelfInfoSubset getShelfInfoForChassis(ChassisModel chassisModel) throws AbstractCmsNoSuchEntityException {
        sShelfInfoSubset[] sShelfInfoSubsetArray = this.getShelfInfoList();
        for (int i = 0; i < sShelfInfoSubsetArray.length; ++i) {
            if (sShelfInfoSubsetArray[i].chassisIndex != chassisModel.getIndex()) continue;
            return sShelfInfoSubsetArray[i];
        }
        throw new CmsNoSuchEntityException("No shelf information for " + chassisModel);
    }

    public void setShelfInfoList(sShelfInfoSubset[] sShelfInfoSubsetArray) throws InvalidData, ProvisionError {
        try {
            this.shelfInfoList.set(sShelfInfoSubsetArray);
        }
        catch (xInvalidData xInvalidData2) {
            throw new InvalidData((UserException)xInvalidData2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "ChassisModel.setShelfInfoList", userException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelfInfo[] getShelfPositions() {
        HashSet<ShelfInfo> hashSet = new HashSet<ShelfInfo>(8);
        Object object = this.chassisMapLock;
        synchronized (object) {
            Iterator iterator = this.chassisMap.values().iterator();
            while (iterator.hasNext()) {
                IChassisModel iChassisModel = (IChassisModel)iterator.next();
                hashSet.add(iChassisModel.getShelfInfo());
            }
        }
        return hashSet.toArray(new ShelfInfo[0]);
    }

    public void setShelfPositions(ShelfInfo[] shelfInfoArray) throws InvalidData, ProvisionError {
        sShelfInfoSubset[] sShelfInfoSubsetArray = new sShelfInfoSubset[shelfInfoArray.length];
        for (int i = 0; i < shelfInfoArray.length; ++i) {
            IChassisModel iChassisModel = this.getChassisByShelfId(shelfInfoArray[i].getShelfId());
            sShelfInfoSubsetArray[i] = new sShelfInfoSubset(iChassisModel.getEntityIndex(), new sShelfPosition(shelfInfoArray[i].getRackNum(), shelfInfoArray[i].getRackPos()));
        }
        this.setShelfInfoList(sShelfInfoSubsetArray);
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump() {
        this.db.println("ChassisMap contents:");
        Object object = this.chassisMapLock;
        synchronized (object) {
            Iterator iterator = this.chassisMap.keySet().iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                IChassisModel iChassisModel = (IChassisModel)this.chassisMap.get(n);
                this.db.println(n + " -> " + iChassisModel);
            }
        }
    }

    private class ShelfInfoList
    extends CachedValue {
        public ShelfInfoList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            ChassisModels.this.db.fine("ShelfInfoList.getValue()");
            sShelfInfoSubset[] sShelfInfoSubsetArray = ChassisModels.this.getEntityTableRef().getShelfInfo();
            return sShelfInfoSubsetArray;
        }

        protected void setValue(Object object) throws xInvalidData, xProvisionError {
            ChassisModels.this.db.fine("ShelfInfoList.setValue()");
            sShelfInfoSubset[] sShelfInfoSubsetArray = (sShelfInfoSubset[])object;
            ChassisModels.this.getEntityTableRef().setShelfInfo(sShelfInfoSubsetArray);
        }
    }
}

