/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.CircuitInfo;
import cerent.cms.idl.Circuits.sCircuitInfoItem;
import cerent.cms.idl.Circuits.xCannotDeleteLastDrop;
import cerent.cms.idl.Circuits.xErrorWritingToDb;
import cerent.cms.idl.Circuits.xInvalidCircuitName;
import cerent.cms.idl.Circuits.xOnlyOneDropPerBidirCktAllowed;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.Vlan.sVlanInfo;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CircuitDropInfo;
import cerent.cms.model.CircuitDropInfoFactory;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitEndFactory;
import cerent.cms.model.CircuitFactoryModelDelegate;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CircuitInfoFactory;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DummyVlanModel;
import cerent.cms.model.ErrorWritingToDb;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ICircuitDropInfo;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OnlyOneDropPerBidirCktAllowed;
import cerent.cms.model.VlanModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.IHoLoNum;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class CircuitModel
extends Model
implements ICircuitModel {
    private Id id;
    private Info info;
    private Rename rename;
    private AddDrop addDrop;
    private DeleteDrop deleteDrop;
    private AddVlan addVlan;
    private DeleteVlan deleteVlan;
    private UpdateVlanList updateVlanList;
    private Delete delete;
    private int uniqueId = -1;
    private NodeModelDelegate node;
    private EventDispatcher dispatcher;
    private CircuitInfo circuitRef;
    private String myString;

    public CircuitModel(NodeModelDelegate nodeModelDelegate, CircuitInfo circuitInfo) {
        super(nodeModelDelegate.getChildDebug(CircuitModel.class));
        this.node = nodeModelDelegate;
        this.circuitRef = circuitInfo;
        this.id = new Id("CircuitModel.id", nodeModelDelegate);
        this.info = new Info("CircuitModel.info", nodeModelDelegate);
        this.rename = new Rename("CircuitModel.info", nodeModelDelegate);
        this.addDrop = new AddDrop("CircuitModel.addDrop", nodeModelDelegate);
        this.deleteDrop = new DeleteDrop("CircuitModel.deleteDrop", nodeModelDelegate);
        this.addVlan = new AddVlan("CircuitModel.addVlan", nodeModelDelegate);
        this.deleteVlan = new DeleteVlan("CircuitModel.deleteVlan", nodeModelDelegate);
        this.updateVlanList = new UpdateVlanList("CircuitModel.updateVlanList", nodeModelDelegate);
        this.delete = new Delete("CircuitModel.delete", nodeModelDelegate);
        this.myString = null;
    }

    public CircuitModel(NodeModelDelegate nodeModelDelegate, sCircuitInfoItem sCircuitInfoItem2) {
        this(nodeModelDelegate, sCircuitInfoItem2.circuit);
        this.setAttributes(sCircuitInfoItem2);
    }

    public void init() {
        if (this.db.on()) {
            this.db.println("CircuitModel::init() for : " + this.getName());
        }
        super.init0();
        this.dispatcher = this.getNodeModelDelegate().getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectCircuit, this.getUniquePart(), (Observer)this);
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectCircuit, this.getUniquePart(), (Observer)this);
        }
        this.info.dispose();
        this.id.dispose();
        this.myString = null;
        super.dispose();
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("CircuitModel::destroy()");
        }
        super.destroy();
        this.circuitRef = null;
    }

    public INodeModel getNodeModel() {
        return this.getNodeModelDelegate();
    }

    protected NodeModelDelegate getNodeModelDelegate() {
        return this.node;
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("CircuitModel::update()");
        }
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            if (this.db.on()) {
                this.db.println("update(): this=" + EnumStrings.getStrings((Class)eUpdateType.class)[n]);
            }
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println("Object deleted.");
                    }
                    try {
                        ((CircuitFactoryModelDelegate)this.getNodeModelDelegate().getCircuitFactoryModel()).removeContainee(this, true);
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        this.db.println("Caught exception " + (Object)((Object)abstractCmsIOException) + " during delete");
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                    this.destroy();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println("Making local changes.");
                    }
                    this.id.update();
                    this.info.update();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            if (object instanceof CircuitModel) {
                return this.getUniquePart() == ((CircuitModel)object).getUniquePart();
            }
            return false;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println("Caught AbstractCmsIOException in CircuitModel::equals");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            return false;
        }
    }

    public int hashCode() {
        return this.getUniquePart();
    }

    private ICircuitInfo getInfo() {
        try {
            return (ICircuitInfo)this.info.get();
        }
        catch (UserException userException) {
            this.db.println("Caught UserException in CircuitModel::getInfo");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    protected boolean isEquivalent(CircuitInfo circuitInfo) {
        return this.circuitRef._is_equivalent(circuitInfo);
    }

    public short getProvVersion() {
        return this.getInfo().getCircuitProvVersion();
    }

    public short getSla() {
        return this.getInfo().getSla();
    }

    public void setSla(short s) {
        this.getInfo().setSla(s);
    }

    public int getCktOptDir() {
        return this.getInfo().getCktOptDir();
    }

    public void setCktOptDir(int n) {
        this.getInfo().setCktOptDir(n);
    }

    public int getCktOptChannel() {
        return this.getInfo().getCktOptChannel();
    }

    public void setCktOptChannel(int n) {
        this.getInfo().setCktOptChannel(n);
    }

    public ICircuitEnd getSrcPoint() {
        ICircuitEnd iCircuitEnd = this.getInfo().getSrcPoint();
        IHoLoNum iHoLoNum = iCircuitEnd.getHoLoNum();
        return new CircuitEnd(iCircuitEnd.getNodeId(), iCircuitEnd.getPortNum(), iHoLoNum.getHoNum(), iHoLoNum.getLoNum(), iCircuitEnd.getDropProt(), iCircuitEnd.getPathIdentifier());
    }

    public ICircuitEnd getSecSrcPoint() {
        ICircuitEnd iCircuitEnd = this.getInfo().getSecSrcPoint();
        IHoLoNum iHoLoNum = iCircuitEnd.getHoLoNum();
        return new CircuitEnd(iCircuitEnd.getNodeId(), iCircuitEnd.getPortNum(), iHoLoNum.getHoNum(), iHoLoNum.getLoNum(), iCircuitEnd.getDropProt(), iCircuitEnd.getPathIdentifier());
    }

    public ICircuitDropInfo[] getDropInfo() {
        ICircuitInfo iCircuitInfo = this.getInfo();
        ICircuitDropInfo[] iCircuitDropInfoArray = iCircuitInfo.getDropInfo();
        int n = iCircuitDropInfoArray.length;
        ICircuitDropInfo[] iCircuitDropInfoArray2 = new ICircuitDropInfo[n];
        for (int i = 0; i < n; ++i) {
            ICircuitEnd iCircuitEnd = iCircuitDropInfoArray[i].getDropPoint();
            IHoLoNum iHoLoNum = iCircuitEnd.getHoLoNum();
            CircuitEnd circuitEnd = new CircuitEnd(iCircuitEnd.getNodeId(), iCircuitEnd.getPortNum(), iHoLoNum.getHoNum(), iHoLoNum.getLoNum(), iCircuitEnd.getDropProt(), iCircuitEnd.getPathIdentifier());
            iCircuitDropInfoArray2[i] = new CircuitDropInfo(circuitEnd, iCircuitDropInfoArray[i].getPathProt());
        }
        return iCircuitDropInfoArray2;
    }

    public boolean getMonitor() {
        return this.getInfo().getMonitor();
    }

    public int getSize() {
        return this.getInfo().getCircuitSize();
    }

    public Integer getKey() {
        return new Integer(this.getId().getUniquePart().getUniqueId());
    }

    public int getType() {
        return this.getInfo().getCircuitType();
    }

    public int getDirection() {
        return this.getInfo().getDir();
    }

    public String getName() {
        return this.getInfo().getCircuitName();
    }

    public void setName(String string) throws InvalidCircuitName {
        try {
            this.rename.set(string);
        }
        catch (xInvalidCircuitName xInvalidCircuitName2) {
            throw new InvalidCircuitName((UserException)xInvalidCircuitName2);
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitModel::setName");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public ICircuitId getId() {
        try {
            return (ICircuitId)this.id.get();
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitModel::getId");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public int getNodeId() {
        return this.getId().getNodeId();
    }

    public int getUniquePart() {
        if (this.uniqueId == -1) {
            this.uniqueId = this.getId().getUniquePart().getUniqueId();
        }
        return this.uniqueId;
    }

    public void addDrop(ICircuitDropInfo iCircuitDropInfo) throws OnlyOneDropPerBidirCktAllowed {
        try {
            this.addDrop.set(iCircuitDropInfo);
        }
        catch (xOnlyOneDropPerBidirCktAllowed xOnlyOneDropPerBidirCktAllowed2) {
            throw new OnlyOneDropPerBidirCktAllowed((UserException)xOnlyOneDropPerBidirCktAllowed2);
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitModel::addDrop");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void delDrop(ICircuitEnd iCircuitEnd) throws CannotDeleteLastDrop {
        try {
            this.deleteDrop.set(iCircuitEnd);
        }
        catch (xCannotDeleteLastDrop xCannotDeleteLastDrop2) {
            throw new CannotDeleteLastDrop((UserException)xCannotDeleteLastDrop2);
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitModel::delDrop");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public IVlanModel[] getVlanList() {
        if (this.getNodeModelDelegate().getEtherBridgeModel() == null) {
            return new IVlanModel[0];
        }
        IVlanModel[] iVlanModelArray = this.getNodeModelDelegate().getEtherBridgeModel().getVlanList();
        IVlanInfo[] iVlanInfoArray = this.getInfo().getVlans();
        int n = iVlanInfoArray.length;
        IVlanModel[] iVlanModelArray2 = new IVlanModel[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < iVlanModelArray.length; ++j) {
                if (iVlanModelArray[j].getId() != iVlanInfoArray[i].getVlanId()) continue;
                iVlanModelArray2[i] = iVlanModelArray[j];
                break;
            }
            if (iVlanModelArray2[i] != null || !this.node.getPlatform().is600()) continue;
            iVlanModelArray2[i] = new DummyVlanModel(this.node, iVlanInfoArray[i].getVlanId(), iVlanInfoArray[i].getVlanName());
        }
        return iVlanModelArray2;
    }

    public void addVlan(IVlanModel iVlanModel) {
        try {
            this.addVlan.set(iVlanModel);
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitModel::addVlan");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void delVlan(IVlanModel iVlanModel) {
        try {
            this.deleteVlan.set(iVlanModel);
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitModel::delVlan");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void updateVlanList(IVlanModel[] iVlanModelArray) {
        try {
            this.updateVlanList.set(iVlanModelArray);
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitModel::updateVlanList");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void delete() throws ErrorWritingToDb {
        try {
            this.delete.set();
        }
        catch (xErrorWritingToDb xErrorWritingToDb2) {
            throw new ErrorWritingToDb((UserException)xErrorWritingToDb2);
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitModel::delete");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    protected void printString(KDebug kDebug) {
        kDebug.println("CircuitModel info ");
        kDebug.println("Circuit Name " + this.getName());
        kDebug.println("Observers are :");
        this.printObservers();
    }

    public String toString() {
        if (this.myString == null) {
            try {
                this.myString = "Circuit[nodeId=" + this.getNodeId() + ", uniquePart=" + this.getUniquePart() + ",  name=" + this.getName() + "]";
            }
            catch (Exception exception) {
                return "Circuit[deleted/inaccessible]";
            }
        }
        return this.myString;
    }

    public void setAttributes(sCircuitInfoItem sCircuitInfoItem2) {
        this.id.setValueExternally(CircuitIdFactory.getICircuitId(sCircuitInfoItem2.id));
        this.info.setValueExternally(CircuitInfoFactory.getICircuitInfo(sCircuitInfoItem2.info, this.getNodeModel().getFramingType()));
    }

    private CircuitInfo getCircuitRef() {
        if (this.circuitRef == null) {
            throw new CmsObjectNotExistException("Attempt to access a Circuit that has been destroyed.");
        }
        return this.circuitRef;
    }

    public ICircuitId setId() {
        return null;
    }

    public void freeId() {
    }

    public int getVcatRoutingPref() {
        return this.getInfo().getVcatRoutingPref();
    }

    class Delete
    extends NonCachedValue {
        public Delete(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws UserException {
            CircuitModel.this.getCircuitRef().deleteCircuit();
        }

        public Object outer() {
            return CircuitModel.this;
        }
    }

    class UpdateVlanList
    extends NonCachedValue {
        public UpdateVlanList(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            IVlanModel[] iVlanModelArray = (IVlanModel[])object;
            sVlanInfo[] sVlanInfoArray = new sVlanInfo[iVlanModelArray.length];
            for (int i = 0; i < iVlanModelArray.length; ++i) {
                sVlanInfoArray[i] = new sVlanInfo(iVlanModelArray[i].getId(), iVlanModelArray[i].getName());
            }
            CircuitModel.this.getCircuitRef().updateVlanList(sVlanInfoArray);
        }

        public Object outer() {
            return CircuitModel.this;
        }
    }

    class DeleteVlan
    extends NonCachedValue {
        public DeleteVlan(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            VlanModel vlanModel = (VlanModel)object;
            sVlanInfo sVlanInfo2 = new sVlanInfo(vlanModel.getId(), vlanModel.getName());
            CircuitModel.this.getCircuitRef().delVlan(sVlanInfo2);
        }

        public Object outer() {
            return CircuitModel.this;
        }
    }

    class AddVlan
    extends NonCachedValue {
        public AddVlan(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            VlanModel vlanModel = (VlanModel)object;
            sVlanInfo sVlanInfo2 = new sVlanInfo(vlanModel.getId(), vlanModel.getName());
            CircuitModel.this.getCircuitRef().addVlan(sVlanInfo2);
        }

        public Object outer() {
            return CircuitModel.this;
        }
    }

    class DeleteDrop
    extends NonCachedValue {
        public DeleteDrop(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            CircuitModel.this.getCircuitRef().delDrop(CircuitEndFactory.getCircuitEnd((ICircuitEnd)object));
        }

        public Object outer() {
            return CircuitModel.this;
        }
    }

    class AddDrop
    extends NonCachedValue {
        public AddDrop(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            CircuitModel.this.getCircuitRef().addDrop(CircuitDropInfoFactory.getCircuitDropInfo((ICircuitDropInfo)object));
        }

        public Object outer() {
            return CircuitModel.this;
        }
    }

    class Rename
    extends NonCachedValue {
        public Rename(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            CircuitModel.this.getCircuitRef().renameCircuit((String)object);
        }

        public Object outer() {
            return CircuitModel.this;
        }
    }

    class Info
    extends CachedValue {
        public Info(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            INodeModel iNodeModel = CircuitModel.this.getNodeModel();
            int n = iNodeModel.getFramingType();
            return CircuitInfoFactory.getICircuitInfo(CircuitModel.this.getCircuitRef().cktInfo(), n);
        }

        public Object outer() {
            return CircuitModel.this;
        }
    }

    private class Id
    extends CachedValue {
        public Id(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return CircuitIdFactory.getICircuitId(CircuitModel.this.getCircuitRef().circuitId());
        }

        public Object outer() {
            return CircuitModel.this;
        }
    }
}

