/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.DataComm;
import cerent.cms.model.NodeModelDelegate;
import cerent.launcher.CtcHttpRetriever;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.job.IJobProgressControl;
import java.net.URL;

public class DataReboot {
    private String hostName;
    private String userName;
    private String password;
    private String session;
    private IJobProgressControl observer;
    private CtcHttpRetriever retriever;
    private int operation;
    private String operationName;
    private int error;
    private String errorMsg;
    private String ccName;
    private TDMTerminology terms;
    private static SDebug db = new SDebug("DataReboot");

    public DataReboot(NodeModelDelegate nodeModelDelegate, int n, IJobProgressControl iJobProgressControl) {
        this.observer = iJobProgressControl;
        this.operation = n;
        this.hostName = nodeModelDelegate.getHostName();
        this.userName = nodeModelDelegate.getUserName();
        this.password = nodeModelDelegate.getUserPassword();
        this.terms = nodeModelDelegate.getTDMTerminology();
        this.session = DataComm.getSession(nodeModelDelegate);
        this.retriever = null;
        this.error = 200;
        this.errorMsg = null;
        this.operationName = n == 4 ? "Activate" : "Revert";
        this.ccName = nodeModelDelegate.getPlatform().getControlCardName();
    }

    public void start() {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            URL uRL = null;
            switch (this.operation) {
                case 4: {
                    uRL = new URL("http://" + this.hostName + "/activate/");
                    break;
                }
                case 5: {
                    uRL = new URL("http://" + this.hostName + "/revert/");
                    break;
                }
                default: {
                    throw new Exception("Unexpected request for Data Reboot Operation " + this.operation);
                }
            }
            this.retriever = new CtcHttpRetriever();
            this.error = this.retriever.transferContent(uRL, this.session + this.userName + ":" + this.password);
            this.errorMsg = DataComm.getErrorMsg(this.error, this.operationName, this.ccName, this.terms);
            if (db.on()) {
                db.println("Returning from DataReboot.run() with value " + this.error);
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in DataReboot.run()");
            SDebug.printStackTrace((Throwable)exception);
            this.error = -1;
            this.errorMsg = exception.getMessage();
        }
        finally {
            this.dispose();
        }
    }

    public boolean aborted() {
        return this.retriever == null ? false : this.retriever.aborted();
    }

    public void abort() {
    }

    public boolean failed() {
        return this.error != 200;
    }

    public void dispose() {
    }

    public int getErrorCode() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }
}

