/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.DataReceive;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobStatus;

public class DataReceiveJob
implements IJobControl {
    protected NodeModelDelegate nodeModel;
    protected String fileName;
    protected IJobProgressControl observer;
    private DataReceive dataReceive;
    protected int operation;
    protected String operationName;
    protected String errorMessage;

    public DataReceiveJob(NodeModelDelegate nodeModelDelegate, String string, IJobProgressControl iJobProgressControl) {
        this(nodeModelDelegate, 1, string, iJobProgressControl);
    }

    public DataReceiveJob(NodeModelDelegate nodeModelDelegate, int n, String string, IJobProgressControl iJobProgressControl) {
        this.nodeModel = nodeModelDelegate;
        this.operation = n;
        this.fileName = string;
        this.observer = iJobProgressControl;
        this.dataReceive = null;
        this.errorMessage = null;
        this.operationName = n == 1 ? "Backup Database" : "Retrieve Diagnostics";
    }

    public String getName() {
        return this.nodeModel.getHostName() + " - data receive";
    }

    public JobStatus executeJob() {
        this.dataReceive = new DataReceive(this.nodeModel, this.operation, this.fileName, this.observer);
        this.dataReceive.start();
        if (this.dataReceive.aborted()) {
            return new JobStatus(3, (Object)new Exception("Cancelled by user"));
        }
        if (this.dataReceive.failed()) {
            this.errorMessage = this.dataReceive.getErrorMessage();
            return new JobStatus(2, (Object)new Exception(this.errorMessage));
        }
        return new JobStatus(4);
    }

    public void abortJob() {
        if (this.dataReceive != null) {
            this.dataReceive.abort();
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

