/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Node.eSwUpgradeActivity;
import cerent.cms.idl.Node.eSwUpgradeState;
import cerent.cms.idl.Node.sSwUpgradeUpdate;
import cerent.cms.model.DataComm;
import cerent.cms.model.DatabaseHeader;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SwUpgradeModel;
import cerent.launcher.CtcHttpRetriever;
import cerent.launcher.DownloadState;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.job.IJobProgressControl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import java.util.zip.GZIPInputStream;

public class DataTransfer
implements Observer {
    private String hostName;
    private String userName;
    private String session;
    private String password;
    private String fileName;
    private IJobProgressControl observer;
    private CtcHttpRetriever retriever;
    private DownloadState state;
    private int operation;
    private String operationName;
    private int error;
    private String errorMsg;
    private boolean is600SwUpgrade;
    private String dbTypes;
    private SwUpgradeModel swUpgradeModel;
    private NodeModelDelegate nodeModel;
    private TDMTerminology terms;
    private static final SDebug db = new SDebug("DataTransfer");

    public DataTransfer(NodeModelDelegate nodeModelDelegate, String string, int n, IJobProgressControl iJobProgressControl) {
        this.fileName = string;
        this.operation = n;
        this.observer = iJobProgressControl;
        this.hostName = nodeModelDelegate.getHostName();
        this.userName = nodeModelDelegate.getUserName();
        this.password = nodeModelDelegate.getUserPassword();
        this.terms = nodeModelDelegate.getTDMTerminology();
        this.session = DataComm.getSession(nodeModelDelegate);
        this.retriever = null;
        this.state = null;
        this.error = 200;
        this.errorMsg = null;
        this.dbTypes = "";
        this.nodeModel = nodeModelDelegate;
        if (n == 3) {
            this.operationName = "downloading";
        } else {
            this.operationName = "Database Restore";
            this.dbTypes = nodeModelDelegate.getDbTypes();
        }
        this.is600SwUpgrade = false;
    }

    public void start() {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        InputStream inputStream = null;
        try {
            Serializable serializable = null;
            long l = 0L;
            switch (this.operation) {
                case 2: {
                    try {
                        serializable = new URL("http://" + this.hostName + "/database/");
                        bl = DatabaseHeader.fileWithHeader(this.fileName);
                        if (bl) {
                            this.fileName = DatabaseHeader.stripHeader(this.fileName);
                        }
                        if (!this.nodeModel.getPlatform().is600()) {
                            l = DataComm.findGZIPRealLength(this.fileName);
                            inputStream = new GZIPInputStream(new FileInputStream(this.fileName));
                            break;
                        }
                        File file = new File(this.fileName);
                        l = file.length();
                        inputStream = new FileInputStream(file);
                        break;
                    }
                    catch (IOException iOException) {
                        throw new AnnotatedException("The selected file may be corrupted\nor it's not a correct file type.", (Exception)iOException);
                    }
                }
                case 7: {
                    try {
                        serializable = new URL("http://" + this.hostName + "/configureNode/");
                        File file = new File(this.fileName);
                        l = file.length();
                        inputStream = new FileInputStream(file);
                        break;
                    }
                    catch (IOException iOException) {
                        throw new AnnotatedException("The selected file may be corrupted\nor it's not a correct file type.", (Exception)iOException);
                    }
                }
                case 3: {
                    serializable = new URL("http://" + this.hostName + "/software/");
                    File file = new File(this.fileName);
                    l = file.length();
                    inputStream = new FileInputStream(file);
                    break;
                }
                default: {
                    throw new Exception("Unexpected request for Data Transfer Operation " + this.operation);
                }
            }
            this.state = new DownloadState(this.operationName);
            this.state.addObserver((Observer)this);
            if (this.operation == 3 && this.nodeModel.getPlatform().is600()) {
                this.is600SwUpgrade = true;
                this.swUpgradeModel = SwUpgradeModel.getInstance(this.nodeModel);
                if (!this.swUpgradeModel.isInited()) {
                    this.swUpgradeModel.init();
                    db.severe("SwUpgradeModel should be always be inited at this point. Somethins broken");
                }
            }
            this.retriever = new CtcHttpRetriever();
            this.error = this.retriever.transferContent((URL)serializable, this.session + this.dbTypes + this.userName + ":" + this.password, inputStream, l, this.state);
            this.errorMsg = DataComm.getErrorMsg(this.error, this.operationName, this.nodeModel.getPlatform().getControlCardName(), this.terms);
            if (db.on()) {
                db.println("Returning from DataTransfer.run() with value " + this.error);
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in DataTransfer.run()");
            SDebug.printStackTrace((Throwable)exception);
            this.error = -1;
            this.errorMsg = exception.getMessage();
        }
        finally {
            try {
                if (bl && this.operation == 2) {
                    File file = new File(this.fileName);
                    file.delete();
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.dispose();
        }
    }

    public boolean aborted() {
        return this.retriever == null ? false : this.retriever.aborted();
    }

    public void abort() {
        block5: {
            if (this.operation == 3 && this.nodeModel.getPlatform().is600()) {
                this.swUpgradeModel = SwUpgradeModel.getInstance(this.nodeModel);
                sSwUpgradeUpdate sSwUpgradeUpdate2 = this.swUpgradeModel.getLocalSwUpgradeUpdateInfo();
                if (sSwUpgradeUpdate2.swUpgradeState == eSwUpgradeState.SWUP_DOWNLOAD && sSwUpgradeUpdate2.swUpgradeActivity != eSwUpgradeActivity.SWACT_DOWNLOAD) {
                    try {
                        this.swUpgradeModel.cancelSwUpgrade();
                        return;
                    }
                    catch (Exception exception) {
                        ErrorMsg.displayError(null, (EID)EMC.EID_SW_UPGRADE_CANCEL);
                        if (!db.on()) break block5;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
        }
        if (this.retriever != null) {
            this.retriever.abort();
        }
    }

    public boolean failed() {
        return this.error != 200;
    }

    public void dispose() {
        if (this.state != null) {
            this.state.deleteObserver((Observer)this);
        }
    }

    public void update(Observable observable, Object object) {
        if (!this.is600SwUpgrade) {
            if (object instanceof String) {
                if (this.observer != null) {
                    this.observer.setProgressText(this.getCopyMsg(this.state));
                    this.observer.setPercentCompleted(0);
                }
            } else if (this.observer != null) {
                this.observer.setPercentCompleted(this.state.getPercent());
            }
        }
    }

    private String getCopyMsg(DownloadState downloadState) {
        String string = "";
        string = this.nodeModel.isMultishelf() ? "copying to other TCCs" : downloadState.sourceName() + " " + this.nodeModel.getPlatform().getControlCardName();
        return string;
    }

    public int getErrorCode() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }
}

