/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IModelPersistenceStrategy;
import cerent.cms.model.InterfaceModelTypeUtil;
import cerent.cms.model.PersistenceException;
import cerent.util.ISequenceNumberConstants;
import cerent.util.id.INetwideModelIdentity;
import cerent.util.id.INetwideModelTypeIdentity;

public class DeletionToken {
    protected static final long UNINITIALIZED_SEQ_NUM = -1L;
    protected static final Long UNINITIALIZED_SEQ_NUM_OBJ = ISequenceNumberConstants.UNINITIALIZED_SEQ_NUM_OBJ;
    public static final int MODEL_DELETE = 1;
    public static final int PARTITION_DELETE = 2;
    private Long seqNum;
    private INetwideModelIdentity id;
    private IModelPersistenceStrategy strategy;
    private byte deletionType;

    public DeletionToken(long l, INetwideModelIdentity iNetwideModelIdentity, IModelPersistenceStrategy iModelPersistenceStrategy) {
        this(1, l, iNetwideModelIdentity, iModelPersistenceStrategy);
    }

    public DeletionToken(INetwideModelTypeIdentity iNetwideModelTypeIdentity, IModelPersistenceStrategy iModelPersistenceStrategy) {
        this(2, -1L, (INetwideModelIdentity)iNetwideModelTypeIdentity, iModelPersistenceStrategy);
    }

    public DeletionToken(int n, long l, INetwideModelIdentity iNetwideModelIdentity, IModelPersistenceStrategy iModelPersistenceStrategy) {
        this.deletionType = (byte)n;
        this.seqNum = l == -1L ? UNINITIALIZED_SEQ_NUM_OBJ : new Long(l);
        this.id = iNetwideModelIdentity;
        this.strategy = iModelPersistenceStrategy;
    }

    public Long getSequenceNumber() {
        return this.seqNum;
    }

    public IModelPersistenceStrategy getStrategy() {
        return this.strategy;
    }

    public INetwideModelIdentity getId() {
        return this.id;
    }

    public short getSlotNum() {
        int n = this.id.getModelType();
        short s = (short)InterfaceModelTypeUtil.getSlotNum(n);
        return s;
    }

    public void delete() throws PersistenceException {
        if (this.strategy != null) {
            switch (this.deletionType) {
                case 1: {
                    this.strategy.deleteIndex(this.id, this.seqNum);
                    break;
                }
                case 2: {
                    this.strategy.deletePartition((INetwideModelTypeIdentity)this.id);
                }
            }
        }
    }
}

