/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Dwdm.ePayloadType;
import cerent.cms.idl.Dwdm.eTermMode;
import cerent.cms.idl.Dwdm.sDwdmCardConfig;
import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.GfpLineModel;
import cerent.cms.model.GfpPortModel;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IOpticsPmModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.ISupportsRMON;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.MfgPortModel;
import cerent.cms.model.MrSlot;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.RmonModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DwdmModuleModel
extends PluggableCarrierModel
implements IDwdmModuleModel {
    public final String C_BAND = "C";
    public final String L_BAND = "L";
    private final String DEFAULT_BAND = "UNAVAILABLE";
    private final String DEFAULT_CARD_TYPE_NAME = "UNKNOWN";
    public final String SRB_CARD_TYPE_NAME = "Skane, Rockwell, Bernina";
    public final String MARMOLADA_CARD_TYPE_NAME = "Marmolada";
    public final String MONVISO_CARD_TYPE_NAME = "Monviso";
    public final String BADILE_CARD_TYPE_NAME = "Badile";
    public final String ADAMELLO_CARD_TYPE_NAME = "Adamello";
    private final String BADILE_TXP_C_BAND_ACT_EQ_TYPE = "10E-L1-C";
    private final String BADILE_TXP_L_BAND_ACT_EQ_TYPE = "10E-L1-L";
    private final String BADILE_MXP_C_BAND_ACT_EQ_TYPE = "10ME-L1-C";
    private final String BADILE_MXP_L_BAND_ACT_EQ_TYPE = "10ME-L1-L";
    private final String MARMOLADA_WAVELENGTHS = "77.4 80.7 84.1 87.4 90.4";
    private static final int TRK_UPPER_IF_INDEX = 0;
    private String workingBand;
    private String cardTypeName;
    private static final int WL_PREFIX = 3;
    private static final String[] WL_ARRAY = EnumStrings.getStrings((Class)eWavelength.class);
    private static final SDebug db;

    public DwdmModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, db);
    }

    public DwdmModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, sDebug);
        this.index = n;
        this.setWorkingBand();
    }

    private void setEqLabel() {
        String string = this.getEqTypeName();
        switch (this.getEqType()) {
            case 181: 
            case 182: {
                if (!this.cardTypeName.equals("Badile")) break;
            }
            case 243: {
                if (this.getState().value() == 0) break;
                string = string + "_";
                string = string + this.workingBand;
            }
        }
        this.setEqLabel(string);
    }

    private boolean isMarmoladaWl(String string) {
        int n = string.lastIndexOf(45) + 1;
        try {
            String string2 = string.substring(n, n + 4);
            return "77.4 80.7 84.1 87.4 90.4".indexOf(string2) != -1;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return false;
        }
    }

    private void setWorkingBand() {
        this.workingBand = "UNAVAILABLE";
        this.cardTypeName = "UNKNOWN";
        int n = this.getEqType();
        if (n == 118 || n == 119 || n == 120 || n == 121 || n == 183 || n == 184) {
            this.cardTypeName = "Skane, Rockwell, Bernina";
            this.workingBand = "C";
        } else if (n == 181 || n == 182) {
            if (this.getState().value() != 0) {
                String string = this.getMfgData().name;
                if (db.on()) {
                    db.println("Actual Equipment type from Mfg data" + string);
                }
                if (string.indexOf("10E-L1-C") != -1 || string.indexOf("10ME-L1-C") != -1) {
                    this.cardTypeName = "Badile";
                    this.workingBand = "C";
                } else if (string.indexOf("10E-L1-L") != -1 || string.indexOf("10ME-L1-L") != -1) {
                    this.cardTypeName = "Badile";
                    this.workingBand = "L";
                } else if (this.isMarmoladaWl(string)) {
                    this.cardTypeName = "Marmolada";
                    this.workingBand = "L";
                } else {
                    this.cardTypeName = "Monviso";
                    this.workingBand = "C";
                }
            }
        } else if (n == 243) {
            this.cardTypeName = "Adamello";
            this.workingBand = this.getMfgData().name.indexOf("10DME-L") != -1 ? "L" : "C";
        }
        this.setEqLabel();
    }

    public boolean isLBandCard() {
        return this.workingBand == "L";
    }

    public String getEqLabel() {
        return super.getEqLabel();
    }

    public String getWorkingBand() {
        return this.workingBand;
    }

    public boolean supportsCLBand() {
        switch (this.getEqType()) {
            case 181: 
            case 182: 
            case 243: {
                return true;
            }
        }
        return false;
    }

    protected void updateLocal() {
        super.updateLocal();
        this.setWorkingBand();
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        InterfaceModel[] interfaceModelArray;
        block4: {
            PortModel[] portModelArray;
            block6: {
                block5: {
                    block3: {
                        portModelArray = this.getPortModels(eEqType2);
                        interfaceModelArray = null;
                        if (eEqType2 != null) break block3;
                        interfaceModelArray = super.getLineModels(null);
                        break block4;
                    }
                    if (eEqType2 != eEqType.DWDM_CLIENT_PORT) break block5;
                    interfaceModelArray = new DwdmCliLineModel[portModelArray.length];
                    for (int i = 0; i < portModelArray.length; ++i) {
                        interfaceModelArray[i] = (DwdmCliLineModel)portModelArray[i].getInterfaceModel();
                    }
                    break block4;
                }
                if (eEqType2 != eEqType.DWDM_TRUNK_PORT) break block6;
                interfaceModelArray = new DwdmTrkLineModel[portModelArray.length];
                for (int i = 0; i < portModelArray.length; ++i) {
                    interfaceModelArray[i] = (DwdmTrkLineModel)portModelArray[i].getInterfaceModel();
                }
                break block4;
            }
            if (eEqType2 != eEqType.GFP_PORT) break block4;
            interfaceModelArray = new GfpLineModel[portModelArray.length];
            for (int i = 0; i < portModelArray.length; ++i) {
                interfaceModelArray[i] = (GfpLineModel)portModelArray[i].getInterfaceModel();
            }
        }
        return interfaceModelArray == null ? new InterfaceModel[]{} : interfaceModelArray;
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        if (eEqType2 == null) {
            portModelArray = super.getPortModels(eEqType2);
        } else {
            switch (eEqType2.value()) {
                case 186: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new GfpPortModel[0]);
                    break;
                }
                case 122: 
                case 123: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new DwdmPortModel[0]);
                    break;
                }
                default: {
                    db.println("Could not get ports for DWDM Card!");
                    if (!db.on()) break;
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
        }
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    public DwdmPortModel[] getDwdmPorts() {
        DwdmPortModel[] dwdmPortModelArray = this.getDwdmCliPorts();
        DwdmPortModel[] dwdmPortModelArray2 = this.getDwdmTrkPorts();
        DwdmPortModel[] dwdmPortModelArray3 = new DwdmPortModel[dwdmPortModelArray.length + dwdmPortModelArray2.length];
        System.arraycopy(dwdmPortModelArray, 0, dwdmPortModelArray3, 0, dwdmPortModelArray.length);
        System.arraycopy(dwdmPortModelArray2, 0, dwdmPortModelArray3, dwdmPortModelArray.length, dwdmPortModelArray2.length);
        return dwdmPortModelArray3;
    }

    public GfpPortModel[] getGfpPorts() {
        return (GfpPortModel[])this.getPortModels(eEqType.GFP_PORT);
    }

    public AbstractDwdmLineModel[] getDwdmLineModels() {
        DwdmCliLineModel[] dwdmCliLineModelArray = this.getDwdmCliLineModels();
        DwdmTrkLineModel[] dwdmTrkLineModelArray = this.getDwdmTrkLineModels();
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = new AbstractDwdmLineModel[dwdmCliLineModelArray.length + dwdmTrkLineModelArray.length];
        System.arraycopy(dwdmCliLineModelArray, 0, abstractDwdmLineModelArray, 0, dwdmCliLineModelArray.length);
        System.arraycopy(dwdmTrkLineModelArray, 0, abstractDwdmLineModelArray, dwdmCliLineModelArray.length, dwdmTrkLineModelArray.length);
        return abstractDwdmLineModelArray;
    }

    public IOpticsPmModel[] getOpticsModels() {
        return this.getDwdmLineModels();
    }

    public GfpLineModel[] getGfpLineModels() {
        return (GfpLineModel[])this.getLineModels(eEqType.GFP_PORT);
    }

    public DwdmCliLineModel[] getDwdmCliLineModels() {
        return (DwdmCliLineModel[])this.getLineModels(eEqType.DWDM_CLIENT_PORT);
    }

    public DwdmTrkLineModel[] getDwdmTrkLineModels() {
        return (DwdmTrkLineModel[])this.getLineModels(eEqType.DWDM_TRUNK_PORT);
    }

    public int getFirstTrunkPort() {
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = this.getDwdmLineModels();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            if (!(abstractDwdmLineModelArray[i] instanceof DwdmTrkLineModel)) continue;
            return i;
        }
        return 0;
    }

    public DwdmTrkLineModel getFirstTrunkLine() {
        DwdmTrkLineModel[] dwdmTrkLineModelArray = this.getDwdmTrkLineModels();
        return dwdmTrkLineModelArray != null && dwdmTrkLineModelArray.length > 0 ? dwdmTrkLineModelArray[0] : null;
    }

    public int getFirstTrunkEntityIndex() throws AbstractCmsNoSuchEntityException {
        DwdmTrkLineModel[] dwdmTrkLineModelArray = this.getDwdmTrkLineModels();
        if (dwdmTrkLineModelArray != null && dwdmTrkLineModelArray.length > 0) {
            return dwdmTrkLineModelArray[0].getPortModel().getEntityIndex();
        }
        return 0;
    }

    public void setPayloadTypeEnum(ePayloadType ePayloadType2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        dwdmTrkLineModel.setPayloadTypeEnum(ePayloadType2);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            SDebug.printStackTrace((Throwable)interruptedException);
        }
    }

    public void setTermModeEnum(eTermMode eTermMode2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        dwdmTrkLineModel.setTermModeEnum(eTermMode2);
    }

    public void setWavelengthEnum(eWavelength eWavelength2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        dwdmTrkLineModel.setWavelengthEnum(eWavelength2);
    }

    public void setRegenPeer(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        dwdmTrkLineModel.setRegenPeer((short)n);
    }

    public void setDwdmCardConfig(sDwdmCardConfig sDwdmCardConfig2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        this.getFirstTrunkLine().setDwdmCardConfig(sDwdmCardConfig2);
    }

    public short getRegenPeer() throws NoSuchInterface, WrongInterfaceType {
        return this.getFirstTrunkLine().getRegenPeer();
    }

    public boolean hasRegenPeer() {
        try {
            return this.getRegenPeer() != 0;
        }
        catch (NoSuchInterface noSuchInterface) {
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return "Dwdm" + super.toString();
    }

    public List getMfgPorts() {
        ArrayList<DwdmPortModel> arrayList = new ArrayList<DwdmPortModel>();
        if (this.supportSfpPort()) {
            DwdmPortModel[] dwdmPortModelArray = this.getDwdmCliPorts();
            for (int i = 0; i < dwdmPortModelArray.length; ++i) {
                if (!(dwdmPortModelArray[i] instanceof MfgPortModel)) continue;
                arrayList.add(dwdmPortModelArray[i]);
            }
        }
        return arrayList;
    }

    public boolean supportSfpPort() {
        switch (this.getEqType()) {
            case 118: {
                return false;
            }
        }
        return true;
    }

    public boolean supportsGfpPort() {
        switch (this.getEqType()) {
            case 183: 
            case 184: 
            case 243: {
                return true;
            }
        }
        return false;
    }

    public boolean supportTiming() {
        switch (this.getEqType()) {
            case 118: 
            case 120: 
            case 121: 
            case 184: {
                return false;
            }
        }
        return true;
    }

    public boolean supportRegenGroup() {
        switch (this.getEqType()) {
            case 118: 
            case 120: 
            case 121: 
            case 181: {
                return true;
            }
        }
        return false;
    }

    public boolean supportSplitter() {
        switch (this.getEqType()) {
            case 121: 
            case 184: {
                return true;
            }
        }
        return false;
    }

    public boolean isDWDM10GCard() {
        switch (this.getEqType()) {
            case 118: 
            case 119: 
            case 181: 
            case 182: {
                return true;
            }
        }
        return false;
    }

    public boolean supportSectionTermMode() {
        boolean bl = true;
        int n = this.getEqType();
        if (n == 118 || n == 119) {
            bl = false;
        }
        return bl;
    }

    public boolean supportTCM() {
        return false;
    }

    public String getWavelengthAsString() {
        try {
            int n = this.getFirstTrunkLine().getActualWaveLength();
            if (n == 0) {
                return (String)this.getExtraInfoMap().get("WL");
            }
            return WL_ARRAY[n];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean hasOhCircuits() {
        HashSet<PortModel> hashSet = new HashSet<PortModel>();
        hashSet.addAll(Arrays.asList(this.getPortModels()));
        HashSet hashSet2 = new HashSet();
        OhConnectionModelsDelegate ohConnectionModelsDelegate = this.getChassis().getOhConnectionModels();
        ArrayList arrayList = new ArrayList(ohConnectionModelsDelegate.getOhTerms().getConnectionModels(this.getChassis()));
        arrayList.addAll(ohConnectionModelsDelegate.getOhXcons().getConnectionModels(this.getChassis()));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ConnectionModel connectionModel = (ConnectionModel)iterator.next();
            hashSet2.addAll(connectionModel.getPortModels());
        }
        hashSet2.retainAll(hashSet);
        return !hashSet2.isEmpty();
    }

    public boolean testHigherLayer() {
        boolean bl = true;
        InterfaceModel[] interfaceModelArray = this.getLineModels();
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            InterfaceModel[] interfaceModelArray2 = interfaceModelArray[i].getHigherLayerModels();
            if (interfaceModelArray2 != null && interfaceModelArray2.length >= 1) continue;
            db.info("Higher is NULL!!! for " + interfaceModelArray[i]);
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isLineTerminated() {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        return dwdmTrkLineModel.isLineTerminated();
    }

    public boolean isSectionTerminated() {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        return dwdmTrkLineModel.isSectionTerminated();
    }

    public boolean isTransparent() {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        return dwdmTrkLineModel.isTransparent();
    }

    public boolean supportsOTN() {
        switch (this.getEqType()) {
            case 183: 
            case 184: {
                return false;
            }
        }
        return true;
    }

    public boolean supportsAls() {
        return true;
    }

    public IRmonModel[] getRmonModels() {
        int n;
        DwdmTrkLineModel[] dwdmTrkLineModelArray = this.getDwdmTrkLineModels();
        if (dwdmTrkLineModelArray.length > 0 && (n = this.getEqType()) != 183 && n != 184 && n != 243 && dwdmTrkLineModelArray[0].getRmonModel() == null) {
            return new IRmonModel[0];
        }
        ArrayList<InterfaceModel> arrayList = new ArrayList<InterfaceModel>();
        ArrayList<InterfaceModel> arrayList2 = new ArrayList<InterfaceModel>();
        arrayList.addAll(Arrays.asList(this.getLineModels()));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            InterfaceModel interfaceModel = (InterfaceModel)iterator.next();
            if (interfaceModel instanceof DwdmTrkLineModel) {
                InterfaceModel[] interfaceModelArray = ((DwdmTrkLineModel)interfaceModel).getHigherLayerModels();
                if (interfaceModelArray[0] != null && interfaceModelArray[0] instanceof ISupportsRMON) {
                    arrayList2.add(interfaceModelArray[0]);
                }
                iterator.remove();
                continue;
            }
            if (interfaceModel instanceof ISupportsRMON) continue;
            iterator.remove();
        }
        arrayList.addAll(arrayList2);
        return RmonModel.getRmonModels(arrayList.toArray(new ISupportsRMON[arrayList.size()]));
    }

    public TdmLineModel[] getSonetLines() {
        return DwdmModuleModel.getTdmLineModels(this.getDwdmLineModels());
    }

    public static TdmLineModel[] getTdmLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        ArrayList<TdmLineModel> arrayList = new ArrayList<TdmLineModel>();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            try {
                arrayList.add(abstractDwdmLineModelArray[i].getTdmLineModel());
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                // empty catch block
            }
        }
        return arrayList.toArray(new TdmLineModel[arrayList.size()]);
    }

    public static FcmrLineModel[] getFcmrLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        ArrayList<FcmrLineModel> arrayList = new ArrayList<FcmrLineModel>();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            try {
                arrayList.add(abstractDwdmLineModelArray[i].getFcmrLineModel());
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                // empty catch block
            }
        }
        return arrayList.toArray(new FcmrLineModel[arrayList.size()]);
    }

    public static EtherLineModel[] getEtherLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        ArrayList<EtherLineModel> arrayList = new ArrayList<EtherLineModel>();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            try {
                arrayList.add(abstractDwdmLineModelArray[i].getEtherLineModel());
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                // empty catch block
            }
        }
        return arrayList.toArray(new EtherLineModel[arrayList.size()]);
    }

    public static AbstractDwdmLineModel[] getTdmDwdmLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        ArrayList<AbstractDwdmLineModel> arrayList = new ArrayList<AbstractDwdmLineModel>();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            if (!abstractDwdmLineModelArray[i].isSonetSdhPayload()) continue;
            arrayList.add(abstractDwdmLineModelArray[i]);
        }
        return arrayList.toArray(new AbstractDwdmLineModel[arrayList.size()]);
    }

    public DwdmPortModel[] getDwdmCliPorts() {
        return (DwdmPortModel[])this.getPortModels(eEqType.DWDM_CLIENT_PORT);
    }

    public DwdmPortModel[] getDwdmTrkPorts() {
        return (DwdmPortModel[])this.getPortModels(eEqType.DWDM_TRUNK_PORT);
    }

    public boolean isMxpMr25G() {
        switch (this.getEqType()) {
            case 183: 
            case 184: {
                return true;
            }
        }
        return false;
    }

    public boolean supportPPM() {
        switch (this.getEqType()) {
            case 118: {
                return false;
            }
        }
        return true;
    }

    public boolean supportUtilization() {
        switch (this.getEqType()) {
            case 120: 
            case 121: {
                return false;
            }
        }
        return true;
    }

    public MrSlot getMrSlot() {
        List list = this.getChildrenOfType(eEqType.MR_SLOT);
        int n = list == null ? 0 : list.size();
        return n == 1 ? (MrSlot)list.get(0) : null;
    }

    boolean isPortNumUnique(int n) {
        return false;
    }

    boolean allowsPortEditing(PpmModel ppmModel) {
        return false;
    }

    public PortModel[] getAlarmablePorts() {
        ArrayList<PortModel> arrayList = new ArrayList<PortModel>(Arrays.asList(this.getPortModels()));
        arrayList.removeAll(Arrays.asList(this.getDwdmCliPorts()));
        return arrayList.toArray(new PortModel[arrayList.size()]);
    }

    public IPortModel getPayloadPortModel(DwdmPortModel dwdmPortModel) throws AbstractCmsNoSuchEntityException {
        return ((AbstractDwdmLineModel)dwdmPortModel.getInterfaceModel()).getPayloadModel().getPortModel();
    }

    public boolean requireDEDirectionCompatible() {
        switch (this.getEqType()) {
            case 183: 
            case 184: 
            case 243: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsDEParams() {
        switch (this.getEqType()) {
            case 183: 
            case 184: {
                return true;
            }
        }
        return false;
    }

    public boolean hasDWDMPatchCord() {
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        return nodeModelDelegate.getOpticalPatchCordModel().hasCardDWDMOpticalPatch(Integer.parseInt(this.getLocation()));
    }

    public boolean supportsPortGroupMode() {
        switch (this.getEqType()) {
            case 243: {
                return true;
            }
        }
        return false;
    }

    static {
        for (int i = 0; i < WL_ARRAY.length; ++i) {
            DwdmModuleModel.WL_ARRAY[i] = WL_ARRAY[i].substring(3).replace('_', '.');
        }
        db = new SDebug("DwdmModuleModel");
    }
}

