/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.idl.OpticsTopology.DwdmOpticalSetup;
import cerent.cms.idl.OpticsTopology.sOscRingParams;
import cerent.cms.idl.OpticsTopology.xCannotPerform;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.ObjectMessageInfo;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class DwdmRingParamsModel
extends Model {
    private NodeModelDelegate nmd;
    private static ModelSingletonCollection dwdmRingParamsModelSingletons;
    RingParameters ringParametersRef;
    RemoveRingPars removeRingParsRef;
    EventDispatcher dispatcher;

    private DwdmRingParamsModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(DwdmRingParamsModel.class));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.ringParametersRef = new RingParameters(nodeModelDelegate, "RingParameters");
        this.removeRingParsRef = new RemoveRingPars(nodeModelDelegate, "RemoveRingPars");
        this.dispatcher = null;
    }

    public static synchronized DwdmRingParamsModel getInstance(NodeModelDelegate nodeModelDelegate) {
        DwdmRingParamsModel dwdmRingParamsModel;
        if (dwdmRingParamsModelSingletons == null) {
            dwdmRingParamsModelSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"dwdmRingParamsModel");
        }
        if ((dwdmRingParamsModel = (DwdmRingParamsModel)dwdmRingParamsModelSingletons.get((Object)nodeModelDelegate)) == null) {
            dwdmRingParamsModel = new DwdmRingParamsModel(nodeModelDelegate);
            dwdmRingParamsModelSingletons.add((Object)nodeModelDelegate, (Object)dwdmRingParamsModel);
        }
        return dwdmRingParamsModel;
    }

    public sOscRingParams[] getRingParameters() throws FeatureUnsupported, CannotPerform {
        try {
            return (sOscRingParams[])this.ringParametersRef.get();
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xCannotPerform xCannotPerform2) {
            throw new CannotPerform((UserException)xCannotPerform2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getRingParameters", userException);
        }
    }

    public void setRingParameters(sOscRingParams sOscRingParams2) throws FeatureUnsupported, CannotPerform {
        try {
            this.ringParametersRef.set(sOscRingParams2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xCannotPerform xCannotPerform2) {
            throw new CannotPerform((UserException)xCannotPerform2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setRingParameters", userException);
        }
    }

    public void delRingParameters(sOscRingParams sOscRingParams2) throws FeatureUnsupported, CannotPerform {
        try {
            if (this.db.on()) {
                this.db.println("delete RingParameters ringNodeId :" + sOscRingParams2.ringNodeId + " eastPort:" + sOscRingParams2.eastPort + " westPort:" + sOscRingParams2.westPort + " ringName:" + sOscRingParams2.ringName);
            }
            this.removeRingParsRef.set(sOscRingParams2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xCannotPerform xCannotPerform2) {
            throw new CannotPerform((UserException)xCannotPerform2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "delRingParameters", userException);
        }
    }

    public void init() {
        super.init0();
        if (this.db.on()) {
            this.db.println("DwdmRingParamsModel::init()");
        }
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectDwdmOpticalSetup, 4, (Observer)this);
        }
    }

    public void dispose() {
        if (this.db.on) {
            this.db.println("Enter DwdmRingParamsModel::dispose()");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectDwdmOpticalSetup, 4, (Observer)this);
        }
        super.dispose();
        if (this.db.on) {
            this.db.println("Exit DwdmRingParamsModel dispose()");
        }
    }

    public void update(Observable observable, Object object) {
        int n = ((ObjectMessageInfo)object).getUpdateType();
        switch (n) {
            case 0: {
                if (this.db.on()) {
                    this.db.println("Object deleted.");
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.DELETED);
                break;
            }
            case 1: {
                if (this.db.on()) {
                    this.db.println("Object changed.");
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.CHANGED);
                break;
            }
            case 2: {
                if (this.db.on()) {
                    this.db.println("Object added.");
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.ADDED);
                break;
            }
        }
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    private DwdmOpticalSetup getDwdmOpticalSetupRef() {
        return this.nmd.getIorRepository().getDwdmOpticalSetupRef();
    }

    private class RemoveRingPars
    extends NonCachedValue {
        public RemoveRingPars(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xFeatureUnsupported, xCannotPerform {
            DwdmRingParamsModel.this.getDwdmOpticalSetupRef().removeOscRingParameters((sOscRingParams)object);
        }

        public Object outer() {
            return DwdmRingParamsModel.this;
        }
    }

    private class RingParameters
    extends NonCachedValue {
        public RingParameters(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xFeatureUnsupported, xCannotPerform {
            return DwdmRingParamsModel.this.getDwdmOpticalSetupRef().getOscRingParameters();
        }

        protected void setValue(Object object) throws xFeatureUnsupported, xCannotPerform {
            DwdmRingParamsModel.this.getDwdmOpticalSetupRef().setOscRingParameters((sOscRingParams)object);
        }

        public Object outer() {
            return DwdmRingParamsModel.this;
        }
    }
}

