/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Dwdm.General;
import cerent.cms.idl.Dwdm.Trunk;
import cerent.cms.idl.Dwdm.eDwdmFecMode;
import cerent.cms.idl.Dwdm.eMappingType;
import cerent.cms.idl.Dwdm.eMonitorType;
import cerent.cms.idl.Dwdm.eTraceFormat;
import cerent.cms.idl.Dwdm.eTraceMode;
import cerent.cms.idl.Dwdm.sDwdmFECPmStats;
import cerent.cms.idl.Dwdm.sFECPmThresholds;
import cerent.cms.idl.Dwdm.sOTNLinePmStats;
import cerent.cms.idl.Dwdm.sOTNThresholds;
import cerent.cms.idl.Dwdm.sTrunkLineAttributes;
import cerent.cms.idl.Dwdm.tTraceArrayHolder;
import cerent.cms.idl.Dwdm.xDetailedConfigError;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.IDwdmTrkLineModel;
import cerent.cms.model.IGenericTraceLine;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.ISupportsRMON;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OhCircuitType;
import cerent.cms.model.RmonModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.UserException;

public class DwdmTrkLineModel
extends AbstractDwdmLineModel
implements IDwdmTrkLineModel,
IGenericTraceLine,
ISupportsRMON {
    private static final SDebug db = new SDebug("DwdmTrkLineModel");
    private Wavelength wavelength;
    private TunableWlList tunableWlList;
    private RegenPeer regenPeer;
    private OTNStatus otnStatus;
    private FTFLStatus ftflStatus;
    private OTNStats otnStats;
    private FECStats fecStats;
    private OTNThresholds otnThresholds;
    private FECThresholds fecThresholds;
    private CurrentPayloadLabel currentPayloadLabel;
    private SendTTI sendTTI;
    private ExpectedTTI expectedTTI;
    private ReceivedTTI receivedTTI;
    private TTIMode ttiMode;
    private TTIFormat ttiFormat;
    private SdBerLevel sdBerLevel;
    private SfBerLevel sfBerLevel;
    private FECMode fecMode;
    private MappingType mappingType;
    private OTNData otnData;
    private RmonModel rmonModel;
    private eMonitorType monitoringLevel = eMonitorType.MON_SECTION;

    public DwdmTrkLineModel(NodeModelDelegate nodeModelDelegate, int n) {
        this(nodeModelDelegate, n, (sInterface)null);
    }

    public DwdmTrkLineModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2) {
        super(nodeModelDelegate, n, sInterface2);
        this.index = n;
        this.rmonModel = new RmonModel(nodeModelDelegate, this, false);
        this.wavelength = new Wavelength("DwdmTrkLineModel::wavelength", nodeModelDelegate);
        this.tunableWlList = new TunableWlList("DwdmTrkLineModel::tunableWlList", nodeModelDelegate);
        this.regenPeer = new RegenPeer("DwdmTrkLineModel::regenPeer", nodeModelDelegate);
        this.otnStatus = new OTNStatus("DwdmTrkLineModel::otnStatus", nodeModelDelegate);
        this.ftflStatus = new FTFLStatus("DwdmTrkLineModel::ftflStatus", nodeModelDelegate);
        this.otnStats = new OTNStats("DwdmTrkLineModel::otnStats", nodeModelDelegate);
        this.fecStats = new FECStats("DwdmTrkLineModel::fecStats", nodeModelDelegate);
        this.otnThresholds = new OTNThresholds("DwdmTrkLineModel::otnThresholds", nodeModelDelegate);
        this.fecThresholds = new FECThresholds("DwdmTrkLineModel::fecThresholds", nodeModelDelegate);
        this.currentPayloadLabel = new CurrentPayloadLabel(nodeModelDelegate, "DwdmTrkLineModel::currentPayloadLabel");
        this.sendTTI = new SendTTI(nodeModelDelegate, "DwdmTrkLineModel::sendTTI");
        this.expectedTTI = new ExpectedTTI(nodeModelDelegate, "DwdmTrkLineModel::expectedTTI");
        this.receivedTTI = new ReceivedTTI(nodeModelDelegate, "DwdmTrkLineModel::receivedTTI");
        this.ttiMode = new TTIMode(nodeModelDelegate, "DwdmTrkLineModel::ttiMode");
        this.ttiFormat = new TTIFormat(nodeModelDelegate, "DwdmTrkLineModel::ttiFormat");
        this.sdBerLevel = new SdBerLevel(nodeModelDelegate, "DwdmTrkLineModel::sdBer");
        this.sfBerLevel = new SfBerLevel(nodeModelDelegate, "DwdmTrkLineModel::sfBer");
        this.fecMode = new FECMode("DwdmTrkLineModel::fecMode", nodeModelDelegate);
        this.mappingType = new MappingType("DwdmTrkLineModel::mappingType", nodeModelDelegate);
        this.otnData = new OTNData("DwdmTrkLineModel::otnData", nodeModelDelegate);
    }

    public void dispose() {
        this.wavelength.dispose();
        this.tunableWlList.dispose();
        this.regenPeer.dispose();
        this.otnStatus.dispose();
        this.ftflStatus.dispose();
        this.sdBerLevel.dispose();
        this.sfBerLevel.dispose();
        this.fecMode.dispose();
        this.mappingType.dispose();
        this.otnData.dispose();
        this.rmonModel.dispose();
        super.dispose();
    }

    public void destroy() {
        this.rmonModel.destroy();
        super.destroy();
    }

    protected void updateLocal(long l) {
        this.wavelength.update();
        this.tunableWlList.update();
        this.regenPeer.update();
        this.otnStatus.update();
        this.ftflStatus.update();
        this.sdBerLevel.update();
        this.sfBerLevel.update();
        this.fecMode.update();
        this.mappingType.update();
        this.otnData.update();
        super.updateLocal(l);
    }

    public void setWavelengthEnum(eWavelength eWavelength2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        try {
            this.wavelength.set(eWavelength2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (UserException userException) {
            throw this.doUnknown("setWavelengthEnum", userException);
        }
    }

    public void setWaveLength(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        this.setWavelengthEnum(eWavelength.from_int(n));
    }

    public eWavelength getWavelengthEnum() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eWavelength)this.wavelength.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getWavelengthEnum", userException);
        }
    }

    public boolean isWavelengthSupported() throws NoSuchInterface, WrongInterfaceType {
        return true;
    }

    public int getExpectedWaveLength() throws NoSuchInterface, WrongInterfaceType {
        return this.getWavelengthEnum().value();
    }

    public int getActualWaveLength() throws NoSuchInterface, WrongInterfaceType {
        return this.getWavelengthEnum().value();
    }

    public int getWavelength() throws NoSuchInterface, WrongInterfaceType {
        return this.getWavelengthEnum().value();
    }

    public int[] getTunableWavelengthList() throws NoSuchInterface, WrongInterfaceType {
        eWavelength[] eWavelengthArray = this.getTunableWls();
        if (eWavelengthArray == null) {
            if (db.on()) {
                db.println("Got void tunable wavelengths list");
            }
            return null;
        }
        int[] nArray = new int[eWavelengthArray.length];
        if (db.on()) {
            db.println("Got " + eWavelengthArray.length + " tunable wavelengths");
        }
        for (int i = 0; i < eWavelengthArray.length; ++i) {
            nArray[i] = eWavelengthArray[i].value();
            if (!db.on()) continue;
            db.print(i + 1 + ") " + nArray[i] + "; ");
            if (i != eWavelengthArray.length - 1) continue;
            db.println("");
        }
        return nArray;
    }

    public eWavelength[] getTunableWls() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eWavelength[])this.tunableWlList.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getTunableWls", userException);
        }
    }

    public void setRegenPeer(short s) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            this.regenPeer.set(new Short(s));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setRegenPeer", userException);
        }
    }

    public short getRegenPeer() throws NoSuchInterface, WrongInterfaceType {
        short s = 0;
        try {
            s = (Short)this.regenPeer.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getRegenPeer", userException);
        }
        return s;
    }

    public void setOTNStatus(boolean bl) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, AbstractCmsNoSuchEntityException {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), this.getFECMode(), eMappingType.MAP_NOTUSED};
            ModuleModel moduleModel = this.getModuleModel();
            if (moduleModel.getEqType() == 181 || moduleModel.getEqType() == 182) {
                objectArray[2] = this.getMappingType();
            }
            this.otnStatus.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (UserException userException) {
            throw this.doUnknown("setOTNStatus", userException);
        }
    }

    public boolean getOTNStatus() throws NoSuchInterface, WrongInterfaceType {
        boolean bl = false;
        try {
            bl = (Boolean)this.otnStatus.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNStatus", userException);
        }
        return bl;
    }

    public void setFTFLStatus(boolean bl) throws NoSuchInterface, WrongInterfaceType {
        try {
            this.ftflStatus.set(new Boolean(bl));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setFTFLStatus", userException);
        }
    }

    public boolean getFTFLStatus() throws NoSuchInterface, WrongInterfaceType {
        boolean bl = false;
        try {
            bl = (Boolean)this.ftflStatus.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getFTFLStatus", userException);
        }
        return bl;
    }

    public eDwdmFecMode getFECMode() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eDwdmFecMode)this.fecMode.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getFECMode", userException);
        }
    }

    public int getFECModeValue() throws NoSuchInterface, WrongInterfaceType {
        return this.getFECMode().value();
    }

    public void setFECModeValue(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, AbstractCmsNoSuchEntityException {
        this.setFECMode(eDwdmFecMode.from_int(n));
    }

    public void setFECMode(eDwdmFecMode eDwdmFecMode2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, AbstractCmsNoSuchEntityException {
        try {
            Object[] objectArray = new Object[]{new Boolean(this.getOTNStatus()), eDwdmFecMode2, eMappingType.MAP_NOTUSED};
            ModuleModel moduleModel = this.getModuleModel();
            if (moduleModel.getEqType() == 181 || moduleModel.getEqType() == 182) {
                objectArray[2] = this.getMappingType();
            }
            this.fecMode.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (UserException userException) {
            throw this.doUnknown("setFECMode", userException);
        }
    }

    public void setOTNData(boolean bl, int n, int n2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        this.setOTNData(bl, eDwdmFecMode.from_int(n), eMappingType.from_int(n2));
    }

    public void setOTNData(boolean bl, eDwdmFecMode eDwdmFecMode2, eMappingType eMappingType2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eDwdmFecMode2, eMappingType2};
            this.otnData.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (UserException userException) {
            throw this.doUnknown("setOTNData", userException);
        }
    }

    public eMappingType getMappingType() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eMappingType)this.mappingType.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMappingType", userException);
        }
    }

    public int getMappingTypeValue() throws NoSuchInterface, WrongInterfaceType {
        return this.getMappingType().value();
    }

    public void setMappingType(eMappingType eMappingType2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        try {
            Object[] objectArray = new Object[]{new Boolean(this.getOTNStatus()), this.getFECMode(), eMappingType2};
            this.mappingType.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (UserException userException) {
            throw this.doUnknown("setMappingType", userException);
        }
    }

    public void setMappingType(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        this.setMappingType(eMappingType.from_int(n));
    }

    public void clearOTNStats(boolean bl, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2};
            this.otnStats.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearOTNStats", userException);
        }
    }

    public sOTNLinePmStats getOTNStats(boolean bl, eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, new Short(s)};
            return (sOTNLinePmStats)this.otnStats.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNStats", userException);
        }
    }

    public void clearFECStats(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            this.fecStats.set(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearFECStats", userException);
        }
    }

    public sDwdmFECPmStats getFECStats(eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{eIntervalType2, new Short(s)};
            return (sDwdmFECPmStats)this.fecStats.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getFECStats", userException);
        }
    }

    public sOTNThresholds getOTNThresholds(boolean bl, eIntervalType eIntervalType2, eMonitorType eMonitorType2) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, eMonitorType2};
            return (sOTNThresholds)this.otnThresholds.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNThresholds", userException);
        }
    }

    public void setOTNThresholds(sOTNThresholds sOTNThresholds2, boolean bl, eIntervalType eIntervalType2, eMonitorType eMonitorType2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{sOTNThresholds2, new Boolean(bl), eIntervalType2, eMonitorType2};
            this.otnThresholds.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setOTNThresholds", userException);
        }
    }

    public sFECPmThresholds getFECThresholds(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sFECPmThresholds)this.fecThresholds.get(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getFECThresholds", userException);
        }
    }

    public void setFECThresholds(sFECPmThresholds sFECPmThresholds2, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, ConfigError, EMCProvisionError {
        try {
            Object[] objectArray = new Object[]{sFECPmThresholds2, eIntervalType2};
            this.fecThresholds.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setFECThresholds", userException);
        }
    }

    public void setAttributes(sTrunkLineAttributes sTrunkLineAttributes2, long l) {
        super.setAttributes(sTrunkLineAttributes2.general, l);
    }

    public int getTraceMode() throws NoSuchInterface, WrongInterfaceType {
        try {
            eTraceMode eTraceMode2 = (eTraceMode)this.ttiMode.get(this.monitoringLevel);
            return eTraceMode2.value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getTraceMode", userException);
        }
    }

    public int getTTIMode(eMonitorType eMonitorType2) throws NoSuchInterface, WrongInterfaceType {
        try {
            eTraceMode eTraceMode2 = (eTraceMode)this.ttiMode.get(eMonitorType2);
            return eTraceMode2.value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getTTIMode", userException);
        }
    }

    public eTraceMode getTraceModeEnum() throws NoSuchInterface, WrongInterfaceType {
        return eTraceMode.from_int(this.getTraceMode());
    }

    public void setTraceMode(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{this.monitoringLevel, eTraceMode.from_int(n)};
            this.ttiMode.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setTTIMode", userException);
        }
    }

    public void setTraceModeEnum(eTraceMode eTraceMode2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        this.setTraceMode(eTraceMode2.value());
    }

    public byte getCurrentPayloadLabel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Byte)this.currentPayloadLabel.get(this.monitoringLevel);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getCurrentPayloadLabel", userException);
        }
    }

    public void setTraceFormat(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{this.monitoringLevel, eTraceFormat.from_int(n)};
            this.ttiFormat.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setTraceFormat", userException);
        }
    }

    public void setTraceFormatEnum(eTraceFormat eTraceFormat2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        this.setTraceFormat(eTraceFormat2.value());
    }

    public int getTraceFormat() throws NoSuchInterface, WrongInterfaceType {
        int n = -1;
        try {
            n = ((eTraceFormat)this.ttiFormat.get(this.monitoringLevel)).value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getTraceFormat", userException);
        }
        return n;
    }

    public eTraceFormat getTraceFormatEnum() throws NoSuchInterface, WrongInterfaceType {
        return eTraceFormat.from_int(this.getTraceFormat());
    }

    public void setSendTrace(String string) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{this.monitoringLevel, string};
            this.sendTTI.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSendTrace()", userException);
        }
    }

    public char[] getSendTraceAsCharArray() throws NoSuchInterface, WrongInterfaceType {
        IGenericTraceLine.Trace trace = this.getSendTraceAsTrace();
        return trace.getTrace();
    }

    public IGenericTraceLine.Trace getSendTraceAsTrace() throws NoSuchInterface, WrongInterfaceType {
        try {
            return new IGenericTraceLine.Trace(((String)this.sendTTI.get(this.monitoringLevel)).toCharArray(), true);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSendTraceAsTrace()", userException);
        }
    }

    public void setExpectedTrace(String string) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{this.monitoringLevel, string};
            this.expectedTTI.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setExpectedTrace()", userException);
        }
    }

    public IGenericTraceLine.Trace getExpectedTraceAsTrace() throws NoSuchInterface, WrongInterfaceType {
        try {
            return new IGenericTraceLine.Trace((char[])this.expectedTTI.get(this.monitoringLevel), true);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getExpectedTraceAsTrace()", userException);
        }
    }

    public IGenericTraceLine.Trace getReceivedTraceAsTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            return new IGenericTraceLine.Trace((char[])this.receivedTTI.get(this.monitoringLevel), true);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getReceivedTraceAsTrace()", userException);
        }
    }

    public void setMonitoringLevel(int n) {
        this.monitoringLevel = eMonitorType.from_int(n);
    }

    public void setMonitoringLevelEnum(eMonitorType eMonitorType2) {
        this.setMonitoringLevel(eMonitorType2.value());
    }

    public int getMonitoringLevel() {
        return this.monitoringLevel.value();
    }

    public eMonitorType getMonitoringLevelEnum() {
        return eMonitorType.from_int(this.getMonitoringLevel());
    }

    protected General getDwdmRef() {
        return this.getDwdmTrkRef();
    }

    private Trunk getDwdmTrkRef() {
        return this.getNodeModelDelegate().getIorRepository().getDwdmTrkRef();
    }

    public short getOTNSdBerLevel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Short)this.sdBerLevel.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNSdBerLevel", userException);
        }
    }

    public void setOTNSdBerLevel(short s) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            this.sdBerLevel.set(new Short(s));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setOTNSdBerLevel", userException);
        }
    }

    public short getOTNSfBerLevel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Short)this.sfBerLevel.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNSfBerLevel", userException);
        }
    }

    public boolean canRequestReceivedTrace() {
        boolean bl = false;
        try {
            eEqState eEqState2 = this.getModuleModel().getState();
            switch (eEqState2.value()) {
                case 4: 
                case 5: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    public String getSendTrace() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("Attempted an operation that is deprecated");
    }

    public char[] getExpectedTrace() throws NoSuchInterface, WrongInterfaceType {
        IGenericTraceLine.Trace trace = this.getExpectedTraceAsTrace();
        return trace.getTrace();
    }

    public char[] getReceivedTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        IGenericTraceLine.Trace trace = this.getReceivedTraceAsTrace();
        return trace.getTrace();
    }

    public void setTTIFormat(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        throw new NoSuchInterface("method is no longer supported");
    }

    public int getTTIFormat() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("method is no longer supported");
    }

    public int getTTIMode() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("method is no longer supported");
    }

    public String getSendTTI() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("method is no longer supported");
    }

    public void setSendTTI(String string) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        throw new NoSuchInterface("method is no longer supported");
    }

    public void setTTIMode(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        throw new NoSuchInterface("method is no longer supported");
    }

    public void setExpectedTTI(String string) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        throw new NoSuchInterface("method is no longer supported");
    }

    public char[] getExpectedTTI() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("method is no longer supported");
    }

    public char[] getReceivedTTI() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        throw new NoSuchInterface("method is no longer supported");
    }

    public IRmonModel getRmonModel() {
        block10: {
            try {
                int n = this.getDataRate();
                switch (this.getModuleModel().getEqType()) {
                    case 118: 
                    case 181: {
                        if (n != 9) break;
                        return this.rmonModel;
                    }
                    case 120: 
                    case 121: {
                        if (n != 8 && n != 10 && n != 18 && n != 21) break;
                        return this.rmonModel;
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) break block10;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return null;
    }

    protected boolean isTrunk() {
        return true;
    }

    protected void updateStructure(long l) throws NoSuchInterface {
        this.setChanged();
        super.updateStructure(l);
    }

    public boolean supportsAutoTrace() throws AbstractCmsNoSuchEntityException {
        return this.getModuleModel().supportsAutoTrace();
    }

    public boolean supportsTxPower() {
        block5: {
            try {
                switch (this.getModuleModel().getEqType()) {
                    case 120: 
                    case 121: 
                    case 183: 
                    case 184: {
                        return false;
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block5;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return true;
    }

    public boolean supportOHCircuitTypes(OhCircuitType ohCircuitType) throws AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType {
        if (ohCircuitType.equals((Object)OhCircuitType.EOW_CIRCUIT_OBJ)) {
            switch (this.getModuleModel().getEqType()) {
                case 119: 
                case 182: {
                    return false;
                }
            }
        }
        return super.supportOHCircuitTypes(ohCircuitType);
    }

    public List getConnectionsList() {
        int n;
        try {
            n = this.getPortModel().getEntityIndex();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (db.on()) {
                db.println("Cannot get PortModel for " + this + ": " + abstractCmsNoSuchEntityException.getMessage());
            }
            return new LinkedList();
        }
        List list = ((ConnectionModelsDelegate)this.node.getConnectionModels()).getOchConnectionModels(n);
        if (db.on()) {
            db.println("ConnectionsList: " + list.size() + "(size), " + list);
        }
        return list;
    }

    public boolean supportsAutoALS() {
        try {
            return this.getOTNStatus() || super.supportsAutoALS();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return false;
    }

    private class SfBerLevel
    extends CachedValue {
        public SfBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Short(DwdmTrkLineModel.this.getDwdmTrkRef().getLineDeclareSfBerLevel(DwdmTrkLineModel.this.getIndex()));
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class SdBerLevel
    extends CachedValue {
        public SdBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Short(DwdmTrkLineModel.this.getDwdmTrkRef().getLineDeclareSdBerLevel(DwdmTrkLineModel.this.getIndex()));
        }

        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            DwdmTrkLineModel.this.getDwdmTrkRef().setLineDeclareSdBerLevel(DwdmTrkLineModel.this.getIndex(), (Short)object);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    class TTIFormat
    extends NonCachedValue {
        public TTIFormat(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            return DwdmTrkLineModel.this.getDwdmTrkRef().getTTITraceFormat(DwdmTrkLineModel.this.getIndex(), (eMonitorType)object);
        }

        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            eMonitorType eMonitorType2 = (eMonitorType)objectArray[0];
            eTraceFormat eTraceFormat2 = (eTraceFormat)objectArray[1];
            DwdmTrkLineModel.this.getDwdmTrkRef().setTTITraceFormat(DwdmTrkLineModel.this.getIndex(), eMonitorType2, eTraceFormat2);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    class TTIMode
    extends NonCachedValue {
        public TTIMode(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            eTraceMode eTraceMode2 = DwdmTrkLineModel.this.getDwdmTrkRef().getTTITraceMode(DwdmTrkLineModel.this.getIndex(), (eMonitorType)object);
            return eTraceMode2;
        }

        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            eMonitorType eMonitorType2 = (eMonitorType)objectArray[0];
            eTraceMode eTraceMode2 = (eTraceMode)objectArray[1];
            DwdmTrkLineModel.this.getDwdmTrkRef().setTTITraceMode(DwdmTrkLineModel.this.getIndex(), eMonitorType2, eTraceMode2);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    class ReceivedTTI
    extends NonCachedValue {
        public ReceivedTTI(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface {
            tTraceArrayHolder tTraceArrayHolder2 = new tTraceArrayHolder();
            DwdmTrkLineModel.this.getDwdmTrkRef().getReceivedTTITrace(DwdmTrkLineModel.this.getIndex(), (eMonitorType)object, tTraceArrayHolder2);
            return tTraceArrayHolder2.value;
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    class ExpectedTTI
    extends NonCachedValue {
        public ExpectedTTI(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            tTraceArrayHolder tTraceArrayHolder2 = new tTraceArrayHolder();
            DwdmTrkLineModel.this.getDwdmTrkRef().getExpectedTTITrace(DwdmTrkLineModel.this.getIndex(), (eMonitorType)object, tTraceArrayHolder2);
            return tTraceArrayHolder2.value;
        }

        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            eMonitorType eMonitorType2 = (eMonitorType)objectArray[0];
            String string = (String)objectArray[1];
            DwdmTrkLineModel.this.getDwdmTrkRef().setExpectedTTITrace(DwdmTrkLineModel.this.getIndex(), eMonitorType2, string);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class SendTTI
    extends NonCachedValue {
        public SendTTI(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            StringHolder stringHolder = new StringHolder();
            DwdmTrkLineModel.this.getDwdmTrkRef().getSendTTITrace(DwdmTrkLineModel.this.getIndex(), (eMonitorType)object, stringHolder);
            return stringHolder.value;
        }

        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            eMonitorType eMonitorType2 = (eMonitorType)objectArray[0];
            String string = (String)objectArray[1];
            DwdmTrkLineModel.this.getDwdmTrkRef().setSendTTITrace(DwdmTrkLineModel.this.getIndex(), eMonitorType2, string);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class CurrentPayloadLabel
    extends NonCachedValue {
        public CurrentPayloadLabel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            return new Byte(DwdmTrkLineModel.this.getDwdmTrkRef().getCurrentPayloadLabel(DwdmTrkLineModel.this.getIndex(), (eMonitorType)object));
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class FECThresholds
    extends NonCachedValue {
        public FECThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            sFECPmThresholds sFECPmThresholds2 = DwdmTrkLineModel.this.getDwdmTrkRef().getFECThresholds(DwdmTrkLineModel.this.getIndex(), (eIntervalType)object);
            return sFECPmThresholds2;
        }

        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            Object[] objectArray = (Object[])object;
            DwdmTrkLineModel.this.getDwdmTrkRef().setFECThresholds(DwdmTrkLineModel.this.getIndex(), (sFECPmThresholds)objectArray[0], (eIntervalType)objectArray[1]);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class OTNThresholds
    extends NonCachedValue {
        public OTNThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[0];
            sOTNThresholds sOTNThresholds2 = DwdmTrkLineModel.this.getDwdmTrkRef().getOTNThresholds(DwdmTrkLineModel.this.getIndex(), bl, (eIntervalType)objectArray[1], (eMonitorType)objectArray[2]);
            return sOTNThresholds2;
        }

        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[1];
            DwdmTrkLineModel.this.getDwdmTrkRef().setOTNThresholds(DwdmTrkLineModel.this.getIndex(), (sOTNThresholds)objectArray[0], bl, (eIntervalType)objectArray[2], (eMonitorType)objectArray[3]);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class FECStats
    extends NonCachedValue {
        public FECStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface {
            DwdmTrkLineModel.this.getDwdmTrkRef().clearFECStats(DwdmTrkLineModel.this.getIndex(), true, (eIntervalType)object);
        }

        protected Object getValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            short s = (Short)objectArray[1];
            sDwdmFECPmStats sDwdmFECPmStats2 = DwdmTrkLineModel.this.getDwdmTrkRef().getFECStats(DwdmTrkLineModel.this.getIndex(), (eIntervalType)objectArray[0], s);
            return sDwdmFECPmStats2;
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class OTNStats
    extends NonCachedValue {
        public OTNStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[0];
            DwdmTrkLineModel.this.getDwdmTrkRef().clearOTNStats(DwdmTrkLineModel.this.getIndex(), bl, (eIntervalType)objectArray[1]);
        }

        protected Object getValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[0];
            short s = (Short)objectArray[2];
            sOTNLinePmStats sOTNLinePmStats2 = DwdmTrkLineModel.this.getDwdmTrkRef().getOTNStats(DwdmTrkLineModel.this.getIndex(), bl, (eIntervalType)objectArray[1], s);
            return sOTNLinePmStats2;
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class MappingType
    extends CachedValue {
        public MappingType(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return DwdmTrkLineModel.this.getDwdmTrkRef().getMappingType(DwdmTrkLineModel.this.getIndex());
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xDetailedConfigError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            DwdmTrkLineModel.this.getDwdmTrkRef().enableOTN(DwdmTrkLineModel.this.getIndex(), (Boolean)objectArray[0], (eDwdmFecMode)objectArray[1], (eMappingType)objectArray[2]);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class OTNData
    extends CachedValue {
        public OTNData(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xDetailedConfigError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            DwdmTrkLineModel.this.getDwdmTrkRef().enableOTN(DwdmTrkLineModel.this.getIndex(), (Boolean)objectArray[0], (eDwdmFecMode)objectArray[1], (eMappingType)objectArray[2]);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class FECMode
    extends CachedValue {
        public FECMode(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return DwdmTrkLineModel.this.getDwdmTrkRef().getFECMode(DwdmTrkLineModel.this.getIndex());
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xDetailedConfigError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            DwdmTrkLineModel.this.getDwdmTrkRef().enableOTN(DwdmTrkLineModel.this.getIndex(), (Boolean)objectArray[0], (eDwdmFecMode)objectArray[1], (eMappingType)objectArray[2]);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class FTFLStatus
    extends CachedValue {
        public FTFLStatus(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Boolean(DwdmTrkLineModel.this.getDwdmTrkRef().getFTFLStatus(DwdmTrkLineModel.this.getIndex()));
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            DwdmTrkLineModel.this.getDwdmTrkRef().enableFTFL(DwdmTrkLineModel.this.getIndex(), (Boolean)object);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class OTNStatus
    extends CachedValue {
        public OTNStatus(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Boolean(DwdmTrkLineModel.this.getDwdmTrkRef().getOTNStatus(DwdmTrkLineModel.this.getIndex()));
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xDetailedConfigError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            DwdmTrkLineModel.this.getDwdmTrkRef().enableOTN(DwdmTrkLineModel.this.getIndex(), (Boolean)objectArray[0], (eDwdmFecMode)objectArray[1], (eMappingType)objectArray[2]);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class RegenPeer
    extends CachedValue {
        public RegenPeer(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Short(DwdmTrkLineModel.this.getDwdmTrkRef().getRegenPeerSlot(DwdmTrkLineModel.this.getIndex()));
        }

        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            DwdmTrkLineModel.this.getDwdmTrkRef().setRegenPeerSlot(DwdmTrkLineModel.this.getIndex(), (Short)object);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class Wavelength
    extends CachedValue {
        public Wavelength(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            if (db.on()) {
                db.println("Wavelength.getValue()");
            }
            return DwdmTrkLineModel.this.getDwdmTrkRef().getWavelength(DwdmTrkLineModel.this.getIndex());
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xNoSuchInterface, xDetailedConfigError {
            DwdmTrkLineModel.this.getDwdmTrkRef().setWavelength(DwdmTrkLineModel.this.getIndex(), (eWavelength)object);
            if (db.on()) {
                db.println("Wavelength.setValue(): " + ((eWavelength)object).value() + " done");
            }
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class TunableWlList
    extends CachedValue {
        public TunableWlList(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            int n = DwdmTrkLineModel.this.getIndex();
            if (db.on()) {
                db.println("TunableWlList.getValue() - before request for ObjIdx: 0x" + Integer.toHexString(n));
            }
            eWavelength[] eWavelengthArray = DwdmTrkLineModel.this.getIfRef().getWavelengthList(n);
            if (db.on()) {
                db.println("TunableWlList.getValue() - got Wl list");
            }
            return eWavelengthArray;
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }
}

