/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.SonetTopology.Blsr;
import cerent.cms.idl.SonetTopology.Element;
import cerent.cms.idl.SonetTopology.OnePlusOne;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.idl.SonetTopology.YCable;
import cerent.cms.idl.SonetTopology.eDetectionGuardTimer;
import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.idl.SonetTopology.eOnePlusOneType;
import cerent.cms.idl.SonetTopology.eRecoveryGuardTimer;
import cerent.cms.idl.SonetTopology.eVerifyGuardTimer;
import cerent.cms.idl.SonetTopology.sBlsrItem;
import cerent.cms.idl.SonetTopology.sBlsrLimits;
import cerent.cms.idl.SonetTopology.sBlsrProvision;
import cerent.cms.idl.SonetTopology.sBlsrProvisionHolder;
import cerent.cms.idl.SonetTopology.sOnePlusOneItem;
import cerent.cms.idl.SonetTopology.sOnePlusOneProvision;
import cerent.cms.idl.SonetTopology.sUnprotectedLineItem;
import cerent.cms.idl.SonetTopology.sYCableItem;
import cerent.cms.idl.SonetTopology.sYCableProvision;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.idl.SonetTopology.xDropsExceedMax;
import cerent.cms.idl.SonetTopology.xNoMoreVtCapableSts;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AbstractElementModels;
import cerent.cms.model.AbstractSlotPolicy;
import cerent.cms.model.BlsrLimits;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.BlsrProvisionFactory;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsNoSuchElementException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DropsExceedMax;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.IBlsrLimits;
import cerent.cms.model.IBlsrProvision;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IElementModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoMoreVtCapableSts;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.PoolModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RanSvcModuleModel;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.SlotModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.UnprotectedLineModel;
import cerent.cms.model.YCableModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.ComparisonUtil;
import cerent.util.EnumStrings;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.UserException;

public class ElementModelsDelegate
extends AbstractElementModels
implements IElementModels {
    private NodeModelDelegate nmd;
    private Map elementModels = new TreeMap();
    private CreateOnePlusOne createOnePlusOne;
    private BlsrLimitsCV blsrLimits;
    private CreateYCable createYCable;
    private CreateBlsr createBlsr;
    private FindElement findElement;
    private ElementType elementType;
    private EventDispatcher dispatcher;
    private static ModelSingletonCollection elementModelsDelegateSingletons;
    BLSRList blsrList;
    UnprotectedLineList unprotectedLineList;
    OnePlusOneList onePlusOneList;
    YCableList yCableList;
    private static final String MY_DEBUG_KEY = "EMD";

    public static synchronized ElementModelsDelegate getInstance(NodeModelDelegate nodeModelDelegate) {
        ElementModelsDelegate elementModelsDelegate;
        if (elementModelsDelegateSingletons == null) {
            elementModelsDelegateSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"ElementModelsDelegate");
        }
        if ((elementModelsDelegate = (ElementModelsDelegate)elementModelsDelegateSingletons.get((Object)nodeModelDelegate)) == null) {
            elementModelsDelegate = new ElementModelsDelegate(nodeModelDelegate);
            elementModelsDelegateSingletons.add((Object)nodeModelDelegate, (Object)elementModelsDelegate);
        }
        return elementModelsDelegate;
    }

    private ElementModelsDelegate(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(ElementModelsDelegate.class));
        this.nmd = nodeModelDelegate;
        this.db = new EMDDebug(nodeModelDelegate.db);
        this.index = 0;
        this.createOnePlusOne = new CreateOnePlusOne("ElementModels.createOnePlusOne");
        this.blsrLimits = new BlsrLimitsCV("ElementModels.blsrLimits");
        this.createYCable = new CreateYCable("ElementModels.createYCable");
        this.createBlsr = new CreateBlsr("ElementModels.createBlsr");
        this.findElement = new FindElement("ElementModels.findElement");
        this.elementType = new ElementType("ElementModels.elementType");
        this.dispatcher = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IllegalArgumentException {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " init() entry");
        }
        super.init0();
        Map map = this.elementModels;
        synchronized (map) {
            ElementModelFactory elementModelFactory = new ElementModelFactory(this.nmd);
            this.elementModels = elementModelFactory.getElementsMap();
        }
        this.initElementModels();
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectTopologyElementList, 0, (Observer)this);
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " init() exit");
        }
        if (this.db.on()) {
            map = this.getBlsrLimits();
            this.db.println("ElementModelsDelegate says the max_num_blsr is " + map.getMaxBlsr() + " and max_4F is " + map.getMax4FBlsr() + " and max nodes in 2f ring is " + map.getMaxNodesIn2FiberRing() + " and max nodes in 4f ring is " + map.getMaxNodesIn4FiberRing());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map map;
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " dispose(): entry");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectTopologyElementList, 0, (Observer)this);
            this.dispatcher = null;
        }
        Map map2 = this.elementModels;
        synchronized (map2) {
            map = this.elementModels;
            this.elementModels = new TreeMap();
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ElementModel elementModel = (ElementModel)entry.getValue();
            iterator.remove();
            elementModel.destroy();
        }
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    public Element getElementRef(int n) {
        try {
            return (Element)this.findElement.get(new Integer(n));
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getElementRef", userException);
        }
    }

    private void initElementModels() {
        Iterator iterator = this.getElementSet().iterator();
        while (iterator.hasNext()) {
            ((ElementModel)iterator.next()).init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementModel getElementModel(PoolModel poolModel) throws CmsNoSuchElementException {
        Map map = this.elementModels;
        synchronized (map) {
            Iterator iterator = this.getElementSet().iterator();
            while (iterator.hasNext()) {
                ElementModel elementModel = (ElementModel)iterator.next();
                if (!elementModel.containsPool(poolModel)) continue;
                return elementModel;
            }
        }
        throw new CmsNoSuchElementException("ElementModel does not exist for pool=" + poolModel + " on node=" + this.nmd.getHostName() + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementModel getElementModel(int n) throws CmsNoSuchElementException {
        ElementModel elementModel = null;
        Map map = this.elementModels;
        synchronized (map) {
            elementModel = (ElementModel)this.elementModels.get(new Integer(n));
        }
        if (elementModel == null) {
            throw new CmsNoSuchElementException("ElementModel does not exist for index=" + Integer.toHexString(n) + " on node=" + this.nmd.getHostName() + ".");
        }
        return elementModel;
    }

    public ElementModel getElementModel(IEntityModel iEntityModel) throws AbstractCmsNoSuchElementException {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getElementModel() for entityModel=" + iEntityModel.toString());
        }
        return this.getElementModel(iEntityModel.getEntityIndex());
    }

    public IElementModel getIElementModel(IEntityModel iEntityModel) throws AbstractCmsNoSuchElementException {
        return this.getElementModel(iEntityModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementModel getElementModel(String string) {
        Map map = this.elementModels;
        synchronized (map) {
            Iterator iterator = this.getElementSet().iterator();
            while (iterator.hasNext()) {
                try {
                    ElementModel elementModel = (ElementModel)iterator.next();
                    if (!string.equals(elementModel.getName())) continue;
                    return elementModel;
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                    this.db.fine("Caught " + (Object)((Object)cmsObjectNotExistException) + " in getElementModel");
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                }
            }
        }
        return null;
    }

    public ElementModel[] getElementArray() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " getElementArray()");
        }
        Set set = this.getElementSet();
        return set.toArray(new ElementModel[set.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getElementSet() {
        TreeSet treeSet = null;
        Map map = this.elementModels;
        synchronized (map) {
            treeSet = new TreeSet(this.elementModels.values());
        }
        return treeSet;
    }

    public Set getElementsOfType(eElementType eElementType2) {
        return this.getElementsOfType(eElementType2.value());
    }

    public Set getElementsOfType(int n) {
        return this.getElementsOfType(null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getElementsOfType(IChassisModel iChassisModel, int n) {
        TreeSet<ElementModel> treeSet = new TreeSet<ElementModel>();
        eElementType eElementType2 = eElementType.from_int(n);
        this.db.fine(this.nmd.dbName() + " getElementsOfType(" + EnumStrings.getStrings((Class)eElementType.class)[eElementType2.value()] + "): entry");
        Map map = this.elementModels;
        synchronized (map) {
            Iterator iterator = this.getElementSet().iterator();
            while (iterator.hasNext()) {
                ElementModel elementModel = (ElementModel)iterator.next();
                try {
                    if (eElementType2.value() != elementModel.getType() || iChassisModel != null && ((EntityModel)elementModel.getMainEntityModel()).getChassis() != iChassisModel) continue;
                    treeSet.add(elementModel);
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                    this.db.fine("Element no longer exists: " + (Object)((Object)cmsObjectNotExistException));
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.db.fine("Element no longer exists: " + (Object)((Object)abstractCmsNoSuchEntityException));
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        if (this.db.on()) {
            this.debugDump(this.nmd.dbName() + " getElementsOfType(): list", treeSet);
            this.db.println(this.nmd.dbName() + " getElementsOfType(" + EnumStrings.getStrings((Class)eElementType.class)[eElementType2.value()] + "): exit");
        }
        return treeSet;
    }

    public Set getEntitiesOfType(int n) {
        return this.getEntitiesOfType(eElementType.from_int(n));
    }

    public Set getEntitiesOfType(eElementType eElementType2) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " getEntitiesOfType()");
        }
        return this.toEntities(this.getElementsOfType(eElementType2));
    }

    public Set getUnprotectedLineElements() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getUnprotectedLineElements(): entry");
        }
        TreeMap treeMap = new TreeMap();
        this.getSortedModels(this.elementModels, treeMap, null, null, null);
        TreeSet treeSet = new TreeSet(treeMap.values());
        if (this.db.on) {
            this.debugDump(this.nmd.dbName() + "getUnprotectedLineElements()", treeSet);
            this.db.println(this.nmd.dbName() + "getUnprotectedLineElements(): exit");
        }
        return treeSet;
    }

    public Set getUnprotectedLineEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getUnprotectedLineEntities()");
        }
        return this.toEntities(this.getUnprotectedLineElements());
    }

    public Set getOnePlusOneElements() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOnePlusOneElements(): entry");
        }
        TreeMap treeMap = new TreeMap();
        this.getSortedModels(this.elementModels, null, treeMap, null, null);
        TreeSet treeSet = new TreeSet(treeMap.values());
        if (this.db.on) {
            this.debugDump(this.nmd.dbName() + "getOnePlusOneElements(): list", treeSet);
            this.db.println(this.nmd.dbName() + "getOnePlusOneElements(): exit");
        }
        return treeSet;
    }

    public Set getOnePlusOneEntities() {
        this.db.fine(this.nmd.dbName() + "getOnePlusOneEntities()");
        return this.toEntities(this.getOnePlusOneElements());
    }

    public Set getYCableElements() {
        this.db.fine(this.nmd.dbName() + "getYCableElements(): entry");
        Set set = this.getElementsOfType(eElementType.Y_CABLE);
        if (this.db.on) {
            this.debugDump(this.nmd.dbName() + "getYCableElements(): list", set);
            this.db.println(this.nmd.dbName() + "getYCableElements(): exit");
        }
        return set;
    }

    public Set getYCableEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getYCableEntities()");
        }
        return this.toEntities(this.getYCableElements());
    }

    public Set getBlsrElements() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getBlsrElements(): entry");
        }
        TreeMap treeMap = new TreeMap();
        this.getSortedModels(this.elementModels, null, null, null, treeMap);
        TreeSet treeSet = new TreeSet(treeMap.values());
        if (this.db.on) {
            this.debugDump(this.nmd.dbName() + "getBlsrElements(): list", treeSet);
            this.db.println(this.nmd.dbName() + "getBlsrElements(): exit");
        }
        return treeSet;
    }

    public Set getBlsrEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getBlsrEntities()");
        }
        return this.toEntities(this.getBlsrElements());
    }

    public Set getElementsOfEntityType(int n) {
        return this.getElementsOfEntityType(eEqType.from_int(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getElementsOfEntityType(eEqType eEqType2) {
        TreeSet<ElementModel> treeSet = new TreeSet<ElementModel>();
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getElementsOfEntityType(" + EnumStrings.getStrings((Class)eEqType.class)[eEqType2.value()] + "): entry");
        }
        Map map = this.elementModels;
        synchronized (map) {
            Iterator iterator = this.getElementSet().iterator();
            while (iterator.hasNext()) {
                ElementModel elementModel = (ElementModel)iterator.next();
                try {
                    if (this.db.on) {
                        this.db.println("element.getEntityEqType : " + elementModel.getEntityEqType());
                    }
                    if (eEqType2.value() != elementModel.getEntityEqType()) continue;
                    treeSet.add(elementModel);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getElementsOfEntityType");
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        if (this.db.on()) {
            this.debugDump("getElementsOfEntityType(" + EnumStrings.getStrings((Class)eEqType.class)[eEqType2.value()] + ")", treeSet);
        }
        return treeSet;
    }

    public IBlsrLimits getBlsrLimits() {
        BlsrLimits blsrLimits = null;
        sBlsrLimits sBlsrLimits2 = null;
        try {
            sBlsrLimits2 = (sBlsrLimits)this.blsrLimits.get();
            blsrLimits = new BlsrLimits(sBlsrLimits2);
        }
        catch (UserException userException) {
            this.db.fine("Caught " + (Object)((Object)userException) + " in getBlsrLimits");
            if (this.db.on) {
                SDebug.printStackTrace((Throwable)userException);
            }
            blsrLimits = new BlsrLimits(null);
        }
        if (blsrLimits.wasNullBlsrLimits()) {
            this.db.severe("Got a null BLSR limits");
        }
        return blsrLimits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpticalElements() {
        TreeSet<ElementModel> treeSet = new TreeSet<ElementModel>();
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOpticalElements()");
        }
        Map map = this.elementModels;
        synchronized (map) {
            Iterator iterator = this.getElementSet().iterator();
            while (iterator.hasNext()) {
                ElementModel elementModel = (ElementModel)iterator.next();
                try {
                    eElementType eElementType2 = elementModel.getTypeEnum();
                    int n = elementModel.getEntityEqType();
                    if (eElementType2 != eElementType.BLSR_2_WIRE && eElementType2 != eElementType.BLSR_4_WIRE && eElementType2 != eElementType.ONE_PLUS_ONE && (eElementType2 != eElementType.UNPROTECTED_LINE || this.isRanSvcModule(elementModel) || n != 28 && n != 29 && n != 30 && n != 61)) continue;
                    treeSet.add(elementModel);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getOpticalElements");
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    this.db.fine("Caught " + (Object)((Object)abstractCmsIOException) + " in getOpticalElements");
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        }
        if (this.db.on()) {
            this.debugDump("getOpticalElements()", treeSet);
        }
        return treeSet;
    }

    public Set getNonProtectStm1eEntities() {
        Set set = this.getElementsOfEntityType(eEqType.STM1E_PORT);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                ElementModel elementModel = (ElementModel)iterator.next();
                TdmPortModel tdmPortModel = (TdmPortModel)elementModel.getEntityModel();
                ModuleModel moduleModel = (ModuleModel)tdmPortModel.getModuleModel();
                if (!moduleModel.isProtectModule() && tdmPortModel.isOptical()) continue;
                iterator.remove();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getNonProtectStm1eEntities");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return this.toEntities(set);
    }

    public Set getOpticalEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOpticalEntities()");
        }
        return this.toEntities(this.getOpticalElements());
    }

    public Set getNonProtectOpticalEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getNonProtectOpticalEntities()");
        }
        return this.toNonProtectEntities(this.getOpticalElements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getDwdmElements() {
        TreeSet<ElementModel> treeSet = new TreeSet<ElementModel>();
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " getDwdmElements()");
        }
        Map map = this.elementModels;
        synchronized (map) {
            Iterator iterator = this.getElementSet().iterator();
            while (iterator.hasNext()) {
                ElementModel elementModel = (ElementModel)iterator.next();
                try {
                    eElementType eElementType2 = elementModel.getTypeEnum();
                    int n = elementModel.getEntityEqType();
                    if (eElementType2 != eElementType.Y_CABLE && eElementType2 != eElementType.SPLITTER && (eElementType2 != eElementType.UNPROTECTED_LINE || n != 122 && n != 123)) continue;
                    treeSet.add(elementModel);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getDwdmElements");
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    this.db.fine("Caught " + (Object)((Object)abstractCmsIOException) + " in getDwdmElements");
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        }
        if (this.db.on()) {
            this.debugDump("getDwdmElements()", treeSet);
        }
        return treeSet;
    }

    public Set getDwdmEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getDwdmEntities()");
        }
        return this.toEntities(this.getDwdmElements());
    }

    public Set getNonProtectDwdmEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getNonProtectDwdmEntities()");
        }
        return this.toNonProtectEntities(this.getDwdmElements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getBlsrCapableElements(eElementType eElementType2) {
        TreeSet<ElementModel> treeSet = new TreeSet<ElementModel>();
        Map map = this.elementModels;
        synchronized (map) {
            Iterator iterator = this.getElementSet().iterator();
            while (iterator.hasNext()) {
                ElementModel elementModel = (ElementModel)iterator.next();
                try {
                    int n = elementModel.getEntityEqType();
                    if ((n != 29 || eElementType2 != eElementType.BLSR_2_WIRE || this.nmd.getPlatform().is600()) && n != 30 && n != 61) continue;
                    treeSet.add(elementModel);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getBlsrCapableElements");
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return treeSet;
    }

    public Set getBlsrCapableEntities(eElementType eElementType2) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getBlsrCapableEntities()");
        }
        return this.toEntities(this.getBlsrCapableElements(eElementType2));
    }

    private boolean isSlotDiversityRequired() {
        if (this.nmd.getPlatform().is600()) {
            return false;
        }
        return !this.getNodeModel().provides(Feature.UPSR_SLOTDIV_NR);
    }

    public Set getOnePlusOneAvailableWorkingElements() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOnePlusOneAvailableWorkingElements()");
        }
        Set set = this.getOpticalElements();
        set.retainAll(this.getUnprotectedLineElements());
        if (this.db.on()) {
            this.debugDump("getOnePlusOneAvailableWorkingElements()", set);
        }
        return set;
    }

    public Set getOnePlusOneAvailableElements(eOnePlusOneType eOnePlusOneType2) {
        TreeSet<ElementModel> treeSet = new TreeSet<ElementModel>();
        Set set = null;
        TdmPortModel tdmPortModel = null;
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOnePlusOneAvailableElements()" + ": type=" + eOnePlusOneType2);
        }
        set = this.getOpticalElements();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ElementModel elementModel = (ElementModel)iterator.next();
            try {
                tdmPortModel = (TdmPortModel)elementModel.getEntityModel();
                if (tdmPortModel.isSonetDccTermination() || eOnePlusOneType2 == eOnePlusOneType.ONEPLUSONE_OPTIMIZED && (tdmPortModel.getEqType() != 28 || tdmPortModel.getPayloadType() != 7)) continue;
                treeSet.add(elementModel);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.warning("getAvailableOnePlusOnePorts: Entity not found for index=" + tdmPortModel.getIndex());
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            catch (Exception exception) {
                this.db.warning("Caught " + exception + " in getAvailableOnePlusOnePorts for Index=" + tdmPortModel.getIndex());
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        treeSet.retainAll(this.getUnprotectedLineElements());
        if (this.db.on()) {
            this.debugDump("getOnePlusOneAvailableElements()", treeSet);
        }
        return treeSet;
    }

    public Set getOnePlusOneAvailableEntities(eOnePlusOneType eOnePlusOneType2) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOnePlusOneAvailableEntities()");
        }
        return this.toEntities(this.getOnePlusOneAvailableElements(eOnePlusOneType2));
    }

    private void filterElementsForYCable(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                IEntityModel iEntityModel = ((ElementModel)iterator.next()).getEntityModel();
                if (iEntityModel instanceof DwdmPortModel) {
                    DwdmPortModel dwdmPortModel = (DwdmPortModel)iEntityModel;
                    DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)iEntityModel.getModuleModel();
                    if (!(dwdmModuleModel == null || !dwdmPortModel.isClientPort() || dwdmModuleModel.hasRegenPeer() || dwdmModuleModel.supportSplitter() || dwdmModuleModel.getEqType() == 243 && dwdmPortModel.getDwdmLineModel().getDataRate() == 21)) {
                        continue;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            iterator.remove();
        }
    }

    public Set getYCableAvailableElements() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " getYCableAvailableElements()");
        }
        Set set = this.getDwdmElements();
        set.retainAll(this.getUnprotectedLineElements());
        this.filterElementsForYCable(set);
        if (this.db.on()) {
            this.debugDump("getYCableAvailableElements()", set);
        }
        return set;
    }

    public Set getYCableAvailableEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " getYCableAvailableEntities()");
        }
        return this.toEntities(this.getYCableAvailableElements());
    }

    public Set getAvailableEntities(eElementType eElementType2) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getAvailableEntities()");
        }
        switch (eElementType2.value()) {
            case 1: {
                return this.toEntities(this.getOnePlusOneAvailableWorkingElements());
            }
            case 4: {
                return this.toEntities(this.getYCableAvailableElements());
            }
            case 2: 
            case 3: {
                return this.toEntities(this.getBlsrAvailableElements(eElementType2));
            }
            case 0: {
                return this.toEntities(this.getUnprotectedLineElements());
            }
        }
        return null;
    }

    public Set getBlsrAvailableElements(eElementType eElementType2) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getBlsrAvailableElements()");
        }
        Set set = this.getBlsrCapableElements(eElementType2);
        int n = this.getNodeModel().getFramingType();
        if (n == 0) {
            set.retainAll(this.getUnprotectedSonetElements());
        } else {
            set.retainAll(this.getUnprotectedLineElements());
        }
        set = this.excludeUcpElements(set);
        if (this.db.on()) {
            this.debugDump(this.nmd.dbName() + "getBlsrAvailableElements()", set);
        }
        return set;
    }

    private Collection getUnprotectedSonetElements() {
        Set set = this.getUnprotectedLineElements();
        ArrayList<ElementModel> arrayList = new ArrayList<ElementModel>();
        if (set == null) {
            return new ArrayList();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ElementModel elementModel = (ElementModel)iterator.next();
            try {
                if (elementModel.getEntityModel().getMediumType() != 1) continue;
                arrayList.add(elementModel);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getUnprotectedSonetElements");
                if (!this.db.on) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return arrayList;
    }

    public Set getBlsrAvailableEntities(eElementType eElementType2) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getBlsrAvailableEntities()");
        }
        return this.toEntities(this.getBlsrAvailableElements(eElementType2));
    }

    public Set getBlsrAvailableEntities(int n) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "Bridge for Blsr Wizard -- getBlsrAvailableEntities()");
        }
        return this.getBlsrAvailableEntities(eElementType.from_int(n));
    }

    public Set getOnePlusOneCompatibleElements(ElementModel elementModel) {
        Object object;
        Object object2;
        EntityModel entityModel;
        this.db.fine(this.nmd.dbName() + "Entering 1+1 Compatible elements:" + elementModel.toString());
        boolean bl = false;
        EntityModel entityModel2 = null;
        TdmLineModel tdmLineModel = null;
        int n = -1;
        EntityModel entityModel3 = null;
        try {
            n = elementModel.getEntityEqType();
            entityModel3 = (EntityModel)elementModel.getEntityModel();
            if (entityModel3 instanceof TdmPortModel) {
                entityModel = (TdmPortModel)entityModel3;
                tdmLineModel = entityModel.getTdmLineModel();
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getOnePlusOneCompatibleElements");
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return new TreeSet();
        }
        entityModel = entityModel3.getAncestorOfType(eEqType.IO_SLOT);
        int[] nArray = ((IPortModel)entityModel3).getPortNum();
        List list = entityModel3.getModuleModel().getDescendantsOfClassType(7);
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = (IPortModel)object3.next();
            if (ComparisonUtil.compare((int[])object2.getPortNum(), (int[])nArray) == 0) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + "Skipping self.");
                continue;
            }
            try {
                object = this.getElementModel((IEntityModel)object2);
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchElementException) + " in getOnePlusOneCompatibleElements");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                continue;
            }
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + " Testing sibling: " + ((ElementModel)object).toString());
            }
            if (((ElementModel)object).getType() != 1) continue;
            bl = true;
            try {
                entityModel2 = ((EntityModel)((OnePlusOneModel)object).getMainEntityModel()).getAncestorOfType(eEqType.IO_SLOT);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getOnePlusOneCompatibleElements");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                continue;
            }
            if (!this.db.on) continue;
            this.db.println(this.nmd.dbName() + "Narrowing to:" + ((Object)entityModel2).toString());
        }
        this.db.fine(this.nmd.dbName() + "Getting 1+1 available elements.");
        object3 = this.getOnePlusOneAvailableWorkingElements();
        object2 = new TreeSet();
        object = object3.iterator();
        while (object.hasNext()) {
            Object object4;
            IPortModel iPortModel;
            boolean bl2 = true;
            ElementModel elementModel2 = (ElementModel)object.next();
            this.db.fine(this.nmd.dbName() + " Testing candidate: " + elementModel2.toString());
            EntityModel entityModel4 = null;
            try {
                if (elementModel2.getEntityEqType() != n) {
                    this.db.fine(this.nmd.dbName() + "Incompatible port type.");
                    continue;
                }
                entityModel4 = (EntityModel)elementModel2.getEntityModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getOnePlusOneCompatibleElements");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                continue;
            }
            if (entityModel4.getChassis() != entityModel3.getChassis()) {
                this.db.fine(this.nmd.dbName() + " Excluding " + entityModel4 + " since it is not in the same shelf as " + entityModel3);
                continue;
            }
            if (entityModel4 == entityModel3) {
                this.db.fine(this.nmd.dbName() + "Excluding the port that we are retrieving on.");
                continue;
            }
            EntityModel entityModel5 = entityModel4.getAncestorOfType(eEqType.IO_SLOT);
            if (this.isSlotDiversityRequired()) {
                if (entityModel5 == entityModel) {
                    if (!this.db.on) continue;
                    this.db.println(this.nmd.dbName() + "Same slot.");
                    continue;
                }
                iPortModel = (IPortModel)entityModel4;
                object4 = iPortModel.getPortNum();
                if (iPortModel.getModuleModel().getEqType() == 220) {
                    object4 = new int[]{(int)object4[0]};
                }
                if (entityModel3.getModuleModel().getEqType() == 220) {
                    nArray = new int[]{nArray[0]};
                }
                if (ComparisonUtil.compare((int[])object4, (int[])nArray) != 0) {
                    this.db.fine(this.nmd.dbName() + "Different port.");
                    continue;
                }
            }
            if (entityModel3 != null && entityModel4 instanceof TdmPortModel && (object4 = (Object)(iPortModel = (TdmPortModel)entityModel4).getTdmLineModel()) != null && object4.getMediumType() != tdmLineModel.getMediumType()) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + "Incompatible port medium type.");
                continue;
            }
            if (this.isSlotDiversityRequired()) {
                if (n == 29) {
                    int n2 = entityModel3.getParent().getEqType();
                    int n3 = entityModel4.getParent().getEqType();
                    if (n2 == 85 && n3 != n2 || n2 == 10 && n3 == 85) continue;
                }
                if (n == 28) {
                    int n4 = entityModel3.getParent().getEqType();
                    int n5 = entityModel4.getParent().getEqType();
                    if (n4 == 106 && n5 != n4 || n4 == 9 && n5 == 106) continue;
                }
                if (bl) {
                    if (entityModel5 != entityModel2) {
                        if (!this.db.on) continue;
                        this.db.println(this.nmd.dbName() + "Not in same slot as basis' sibling's peer port.");
                        continue;
                    }
                } else {
                    List list2 = entityModel4.getModuleModel().getDescendantsOfClassType(7);
                    EntityModel entityModel6 = null;
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        block37: {
                            ElementModel elementModel3;
                            EntityModel entityModel7 = (EntityModel)iterator.next();
                            if (this.db.on) {
                                this.db.println(this.nmd.dbName() + " Testing candidate sibling " + entityModel7.toString());
                            }
                            try {
                                elementModel3 = this.getElementModel(entityModel7);
                            }
                            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                                this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchElementException) + " in getOnePlusOneCompatibleElements");
                                if (!this.db.on()) continue;
                                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                                continue;
                            }
                            if (elementModel3.getType() != 1) continue;
                            int n6 = ((TdmPortModel)entityModel7).getOnePlusOneProtectEntityIndex();
                            try {
                                entityModel6 = (EntityModel)this.nmd.getEntityTableModel().getEntityModelByIndex(n6).getParent();
                            }
                            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                                this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getOnePlusOneCompatibleElements");
                                if (!this.db.on) break block37;
                                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                            }
                        }
                        if (entityModel6 == entityModel) continue;
                        bl2 = false;
                        if (!this.db.on) break;
                        this.db.println(this.nmd.dbName() + "Candidate has sibling with " + "peer in another slot.");
                        break;
                    }
                }
            }
            if (entityModel3.getModuleModel().getEqType() == 219) {
                SlotModel slotModel = (SlotModel)entityModel3.getAncestorOfType(eEqType.IO_SLOT);
                SlotModel slotModel2 = (SlotModel)entityModel4.getAncestorOfType(eEqType.IO_SLOT);
                AbstractSlotPolicy abstractSlotPolicy = this.nmd.getSlotPolicy();
                if (abstractSlotPolicy.isHighSpeedSlot(entityModel3.getSlot()) != abstractSlotPolicy.isHighSpeedSlot(slotModel2.getSlot())) continue;
            }
            this.db.fine(this.nmd.dbName() + "Keep = " + bl2);
            if (!bl2) continue;
            object2.add(elementModel2);
        }
        if (this.db.on()) {
            this.debugDump(this.nmd.dbName() + "getOnePlusOneCompatibleElements()", (Collection)object2);
        }
        return object2;
    }

    public Set getOnePlusOneCompatibleEntities(ElementModel elementModel) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOnePlusOneCompatibleEntities()");
        }
        return this.toEntities(this.getOnePlusOneCompatibleElements(elementModel));
    }

    public Set getOnePlusOneCompatibleEntities(IElementModel iElementModel) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " getOnePlusOneCompatibleEntities()");
        }
        if (iElementModel instanceof ElementModel) {
            return this.toEntities(this.getOnePlusOneCompatibleElements((ElementModel)iElementModel));
        }
        return new TreeSet();
    }

    public Set getYCableCompatibleElements(ElementModel elementModel) {
        Object object;
        this.db.fine(this.nmd.dbName() + "getYCableCompatibleElements(" + elementModel.toString() + ")");
        boolean bl = false;
        EntityModel entityModel = null;
        AbstractDwdmLineModel abstractDwdmLineModel = null;
        DwdmModuleModel dwdmModuleModel = null;
        TreeSet<ElementModel> treeSet = new TreeSet<ElementModel>();
        int n = -1;
        EntityModel entityModel2 = null;
        try {
            n = elementModel.getEntityEqType();
            entityModel2 = (EntityModel)elementModel.getEntityModel();
            if (entityModel2 instanceof DwdmPortModel) {
                abstractDwdmLineModel = ((DwdmPortModel)entityModel2).getDwdmLineModel();
            }
            if (!(abstractDwdmLineModel instanceof DwdmCliLineModel)) {
                return treeSet;
            }
            dwdmModuleModel = (DwdmModuleModel)entityModel2.getModuleModel();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getYCableCompatibleElements");
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return treeSet;
        }
        EntityModel entityModel3 = entityModel2.getAncestorOfType(eEqType.IO_SLOT);
        int[] nArray = ((IPortModel)entityModel2).getPortNum();
        List list = dwdmModuleModel.getDescendantsOfClassType(7);
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            Object e = object2.next();
            if (!(e instanceof IPortModel)) continue;
            object = (IPortModel)e;
            if (ComparisonUtil.compare((int[])object.getPortNum(), (int[])nArray) == 0) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + " Skipping self.");
                continue;
            }
            ElementModel elementModel2 = null;
            try {
                elementModel2 = this.getElementModel((IEntityModel)object);
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                elementModel2 = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                elementModel2 = null;
            }
            if (elementModel2 == null) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + " Skipping non-existant element (" + object + ")");
                continue;
            }
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + " >>>>> Testing sibling: " + elementModel2);
            }
            if (elementModel2.getType() != 4) continue;
            bl = true;
            try {
                entityModel = ((EntityModel)((YCableModel)elementModel2).getMainEntityModel()).getAncestorOfType(eEqType.IO_SLOT);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getYCableCompatibleElements");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                continue;
            }
            if (!this.db.on) continue;
            this.db.println(this.nmd.dbName() + " Narrowing to:" + ((Object)entityModel).toString());
        }
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " ***** Getting Y Cable available elements.");
        }
        object2 = this.getYCableAvailableElements();
        boolean bl2 = ((DwdmPortModel)entityModel2).isDistExtensionEnabled();
        object = object2.iterator();
        while (object.hasNext()) {
            boolean bl3 = true;
            ElementModel elementModel3 = (ElementModel)object.next();
            this.db.fine(this.nmd.dbName() + " Testing candidate: " + elementModel3.toString());
            EntityModel entityModel4 = null;
            try {
                if (elementModel3.getEntityEqType() != n) {
                    this.db.fine(this.nmd.dbName() + " Incompatible port type.");
                    continue;
                }
                entityModel4 = (EntityModel)elementModel3.getEntityModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getYCableCompatibleElements");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                continue;
            }
            if (entityModel4 == entityModel2) {
                this.db.fine(this.nmd.dbName() + "Excluding the port that we are retrieving on.");
                continue;
            }
            if (entityModel4.getChassis() != entityModel2.getChassis()) {
                this.db.fine("Excluding the port because it is not in the same chassis as " + entityModel2);
                continue;
            }
            EntityModel entityModel5 = entityModel4.getAncestorOfType(eEqType.IO_SLOT);
            if (entityModel5 == entityModel3) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + " Same slot.");
                continue;
            }
            IPortModel iPortModel = (IPortModel)entityModel4;
            if (ComparisonUtil.compare((int[])iPortModel.getPortNum(), (int[])nArray) != 0) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + " Different port.");
                continue;
            }
            ModuleModel moduleModel = (ModuleModel)entityModel4.getModuleModel();
            if (dwdmModuleModel.getEqType() != moduleModel.getEqType()) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + " Incompatible card types.");
                continue;
            }
            if (dwdmModuleModel.supportsPortGroupMode()) {
                if (((DwdmPortModel)entityModel2).getPortGroupMode() != ((DwdmPortModel)entityModel4).getPortGroupMode()) {
                    if (!this.db.on) continue;
                    this.db.println(this.nmd.dbName() + " Incompatible port group mode.");
                    continue;
                }
            } else if (dwdmModuleModel.getCardOperMode() != moduleModel.getCardOperMode()) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + " Incompatible card mode.");
                continue;
            }
            if (dwdmModuleModel.requireDEDirectionCompatible() && bl2 != ((DwdmPortModel)entityModel4).isDistExtensionEnabled()) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + " Incompatible DE mode.");
                continue;
            }
            if (bl) {
                if (entityModel5 != entityModel) {
                    if (!this.db.on) continue;
                    this.db.println(this.nmd.dbName() + " Not in same slot as basis' sibling's peer port.");
                    continue;
                }
            } else {
                List list2 = entityModel4.getModuleModel().getDescendantsOfClassType(7);
                EntityModel entityModel6 = null;
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    block42: {
                        EntityModel entityModel7 = (EntityModel)iterator.next();
                        if (this.db.on) {
                            this.db.println(this.nmd.dbName() + " Testing candidate sibling " + entityModel7.toString());
                        }
                        ElementModel elementModel4 = null;
                        try {
                            elementModel4 = this.getElementModel(entityModel7);
                        }
                        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                            elementModel4 = null;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            elementModel4 = null;
                        }
                        if (elementModel4 == null) {
                            if (!this.db.on) continue;
                            this.db.println(this.nmd.dbName() + " Skipping non-existant element (" + entityModel7 + ")");
                            continue;
                        }
                        if (elementModel4.getType() != 4) continue;
                        int n2 = ((DwdmPortModel)entityModel7).getYCableProtectEntityIndex();
                        try {
                            entityModel6 = (EntityModel)this.nmd.getEntityTableModel().getEntityModelByIndex(n2).getParent();
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in getYCableCompatibleElements");
                            if (!this.db.on) break block42;
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                    }
                    if (entityModel6 == entityModel3) continue;
                    bl3 = false;
                    if (!this.db.on) break;
                    this.db.println(this.nmd.dbName() + " Candidate has sibling with " + "peer in another slot.");
                    break;
                }
            }
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + " Keep = " + bl3);
            }
            if (!bl3) continue;
            treeSet.add(elementModel3);
        }
        if (this.db.on()) {
            this.debugDump(this.nmd.dbName() + " getYCableCompatibleElements() -> ", treeSet);
        }
        return treeSet;
    }

    public Set getYCableCompatibleEntities(ElementModel elementModel) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getYCableCompatibleEntities()");
        }
        return this.toEntities(this.getYCableCompatibleElements(elementModel));
    }

    public Set toEntities(ElementModel elementModel) {
        TreeSet<ElementModel> treeSet = new TreeSet<ElementModel>();
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "toEntities() from=" + elementModel.toString());
        }
        treeSet.add(elementModel);
        if (this.db.on()) {
            this.debugDump(this.nmd.dbName() + "toEntities() to=", treeSet);
        }
        return this.toEntities(treeSet);
    }

    public Set excludeSDH(Set set) {
        TreeSet<EntityModel> treeSet = new TreeSet<EntityModel>();
        int n = this.getNodeModel().getFramingType();
        IFramingType iFramingType = FramingType.getFramingType((int)n);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            if (!(entityModel instanceof TdmPortModel)) continue;
            TdmPortModel tdmPortModel = (TdmPortModel)entityModel;
            TdmLineModel tdmLineModel = tdmPortModel.getTdmLineModel();
            if (iFramingType.getMediumType() != tdmLineModel.getMediumType()) continue;
            treeSet.add(entityModel);
        }
        if (this.db.on()) {
            this.debugDump("excludeSDH() exit=", treeSet);
        }
        return treeSet;
    }

    public Set excludeUcpElements(Set set) {
        TreeSet<ElementModel> treeSet = new TreeSet<ElementModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ElementModel elementModel = (ElementModel)iterator.next();
            if (!(elementModel instanceof ElementModel) || this.nmd.getUcpNodeModel().getUcpInterfaces().isUcpInterface(elementModel.getIndex())) continue;
            treeSet.add(elementModel);
        }
        return treeSet;
    }

    /*
     * Unable to fully structure code
     */
    public Set toEntities(Set var1_1, boolean var2_2) {
        var3_3 = new TreeSet<IEntityModel>();
        var5_4 = var1_1.iterator();
        block17: while (var5_4.hasNext()) {
            var4_5 = (ElementModel)var5_4.next();
            switch (var4_5.getType()) {
                case 0: {
                    try {
                        var3_3.add(((UnprotectedLineModel)var4_5).getMainEntityModel());
                    }
                    catch (AbstractCmsNoSuchEntityException var6_7) {
                        this.db.fine("Caught " + (Object)var6_7 + " in toEntities");
                        if (!this.db.on()) continue block17;
                        SDebug.printStackTrace((Throwable)var6_7);
                    }
                    continue block17;
                }
                case 1: {
                    try {
                        var3_3.add(((OnePlusOneModel)var4_5).getMainEntityModel());
                        if (!var2_2) continue block17;
                        var3_3.add(((OnePlusOneModel)var4_5).getProtectEntityModel());
                    }
                    catch (AbstractCmsNoSuchEntityException var6_8) {
                        this.db.fine("Caught " + (Object)var6_8 + " in toEntities");
                        if (!this.db.on()) continue block17;
                        SDebug.printStackTrace((Throwable)var6_8);
                    }
                    continue block17;
                }
                case 4: 
                case 5: {
                    try {
                        var3_3.add(((YCableModel)var4_5).getMainEntityModel());
                        if (!var2_2) continue block17;
                        var3_3.add(((YCableModel)var4_5).getProtectEntityModel());
                    }
                    catch (AbstractCmsNoSuchEntityException var6_9) {
                        this.db.fine("Caught " + (Object)var6_9 + " in toEntities");
                        if (!this.db.on()) continue block17;
                        SDebug.printStackTrace((Throwable)var6_9);
                    }
                    continue block17;
                }
                case 3: {
                    try {
                        if (var2_2) {
                            var3_3.add(((BlsrModel)var4_5).getEastProtectEntityModel());
                            var3_3.add(((BlsrModel)var4_5).getWestProtectEntityModel());
                        }
                    }
                    catch (AbstractCmsNoSuchEntityException var6_10) {
                        this.db.fine("Caught " + (Object)var6_10 + " in toEntities");
                        if (!this.db.on()) ** GOTO lbl58
                        SDebug.printStackTrace((Throwable)var6_10);
                    }
                }
lbl58:
                // 4 sources

                case 2: {
                    try {
                        var3_3.add(((BlsrModel)var4_5).getEastEntityModel());
                        var3_3.add(((BlsrModel)var4_5).getWestEntityModel());
                    }
                    catch (AbstractCmsNoSuchEntityException var6_11) {
                        this.db.fine("Caught " + (Object)var6_11 + " in toEntities");
                        if (!this.db.on()) continue block17;
                        SDebug.printStackTrace((Throwable)var6_11);
                    }
                    continue block17;
                }
            }
        }
        return var3_3;
    }

    public Set toNonProtectEntities(Set set) {
        return this.toEntities(set, false);
    }

    public Set toEntities(Set set) {
        return this.toEntities(set, true);
    }

    public boolean createOnePlusOne(int n, int n2, IRevertiveBehavior iRevertiveBehavior, boolean bl, String string) {
        sRevertiveBehavior sRevertiveBehavior2 = RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior);
        sOnePlusOneProvision sOnePlusOneProvision2 = new sOnePlusOneProvision(n, n2, sRevertiveBehavior2, bl, eOnePlusOneType.ONEPLUSONE_STANDARD, eVerifyGuardTimer.from_int(0), eRecoveryGuardTimer.from_int(0), eDetectionGuardTimer.from_int(0));
        try {
            OnePlusOne onePlusOne = this.createOnePlusOne(sOnePlusOneProvision2, string);
            return onePlusOne != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public OnePlusOne createOnePlusOne(sOnePlusOneProvision sOnePlusOneProvision2, String string) throws Busy, ProvisionError, NoMoreVtCapableSts, DropsExceedMax {
        try {
            Object[] objectArray = new Object[]{sOnePlusOneProvision2, string};
            return (OnePlusOne)this.createOnePlusOne.get(objectArray);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2, new Boolean(xBusy2.usedAsClockSource));
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (xNoMoreVtCapableSts xNoMoreVtCapableSts2) {
            throw new NoMoreVtCapableSts((UserException)xNoMoreVtCapableSts2);
        }
        catch (xDropsExceedMax xDropsExceedMax2) {
            throw new DropsExceedMax((UserException)xDropsExceedMax2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "createOnePlusOne", userException);
        }
    }

    public YCable createYCable(sYCableProvision sYCableProvision2, String string) throws Busy, ProvisionError, NoMoreVtCapableSts {
        try {
            Object[] objectArray = new Object[]{sYCableProvision2, string};
            return (YCable)this.createYCable.get(objectArray);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (xNoMoreVtCapableSts xNoMoreVtCapableSts2) {
            throw new NoMoreVtCapableSts((UserException)xNoMoreVtCapableSts2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "createYCable", userException);
        }
    }

    public void createBlsr(sBlsrProvision sBlsrProvision2, eElementType eElementType2, String string) throws Busy, ProvisionError {
        try {
            Object[] objectArray = new Object[]{sBlsrProvision2, eElementType2, string};
            Blsr blsr = (Blsr)this.createBlsr.get(objectArray);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "createBlsr", userException);
        }
    }

    public void createBlsr(IBlsrProvision iBlsrProvision, int n, String string) throws Busy, ProvisionError {
        this.createBlsr(BlsrProvisionFactory.getBlsrProvision(iBlsrProvision), eElementType.from_int(n), string);
    }

    private void debugDump(String string, Collection collection) {
        this.db.println("---- " + string + " ----");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Model model = (Model)iterator.next();
            this.db.println("        " + model.toString());
        }
    }

    private synchronized void debugDumpHexIndexes(String string, Collection collection) {
        this.db.println("---- " + string + " ----");
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            StringBuffer stringBuffer = new StringBuffer("        ");
            stringBuffer.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuffer.append(", ");
                stringBuffer.append(iterator.next());
            }
            this.db.println(stringBuffer.toString());
        }
        this.db.println("^^^^^" + string + "^^^^^");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpElementModels() {
        Map map = this.elementModels;
        synchronized (map) {
            this.debugDump("SONET Topology Elements for node " + this.nmd.dbName(), this.getElementSet());
            this.db.println("---------------------------------\n");
        }
    }

    public synchronized void add(ElementModel elementModel) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "add(" + elementModel.toString() + ")");
        }
        if (elementModel != null) {
            int[] nArray = elementModel.getIndices();
            for (int i = 0; i < nArray.length; ++i) {
                this.elementModels.put(new Integer(nArray[i]), elementModel);
            }
            this.dumpElementModels();
        }
    }

    private synchronized void remove(int n) {
        block2: {
            try {
                this.remove(this.getElementModel(n));
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                this.db.fine("Caught " + (Object)((Object)abstractCmsNoSuchElementException) + " in remove");
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
    }

    public void remove(ElementModel elementModel) {
        if (this.db.on()) {
            String string = "";
            if (elementModel != null) {
                try {
                    string = elementModel.toString();
                }
                catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                    string = "removed";
                }
                catch (NullPointerException nullPointerException) {
                    string = "removed";
                }
            } else {
                string = "null";
            }
            this.db.println(this.nmd.dbName() + "remove(" + string + "): entry");
        }
        this.internalRemove(elementModel);
        this.updateStructure();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRemove(ElementModel elementModel) {
        if (elementModel != null) {
            Object object;
            if (this.db.on()) {
                object = "";
                try {
                    object = elementModel.toString();
                }
                catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                    object = "removed";
                }
                catch (NullPointerException nullPointerException) {
                    object = "removed";
                }
                this.db.println(this.nmd.dbName() + "internalRemove(" + (String)object + "): entry");
            }
            object = this.elementModels;
            synchronized (object) {
                int[] nArray = elementModel.getIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    this.elementModels.remove(new Integer(nArray[i]));
                }
            }
            elementModel.destroy();
            if (this.db.on()) {
                this.dumpElementModels();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateStructure() {
        if (this.db.on) {
            this.db.println("updateStructure START");
        }
        ElementModelFactory elementModelFactory = new ElementModelFactory(this.nmd);
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        TreeMap treeMap3 = new TreeMap();
        TreeMap treeMap4 = new TreeMap();
        TreeSet treeSet = new TreeSet(new ElemComparator());
        TreeSet treeSet2 = new TreeSet(new ElemComparator());
        TreeSet treeSet3 = new TreeSet(new ElemComparator());
        TreeSet treeSet4 = new TreeSet(new ElemComparator());
        TreeSet treeSet5 = new TreeSet();
        TreeSet treeSet6 = new TreeSet();
        TreeSet treeSet7 = new TreeSet();
        TreeSet treeSet8 = new TreeSet();
        Map map = this.elementModels;
        synchronized (map) {
            this.getSortedModels(this.elementModels, treeMap, treeMap2, treeMap3, treeMap4);
            elementModelFactory.captureChanges(treeMap, treeMap2, treeMap3, treeMap4, treeSet, treeSet5, treeSet2, treeSet6, treeSet3, treeSet7, treeSet4, treeSet8);
            this.deleteUpdate(treeSet5);
            this.deleteUpdate(treeSet6);
            this.deleteUpdate(treeSet7);
            this.deleteUpdate(treeSet8);
            this.addUpdate(treeSet);
            this.addUpdate(treeSet2);
            this.addUpdate(treeSet3);
            this.addUpdate(treeSet4);
        }
        if (treeSet6.size() > 0 || treeSet7.size() > 0 || treeSet5.size() > 0 || treeSet8.size() > 0 || treeSet2.size() > 0 || treeSet3.size() > 0 || treeSet.size() > 0 || treeSet4.size() > 0) {
            this.setChanged();
            if (this.db.on) {
                this.db.println("# added " + (treeSet.size() + treeSet2.size() + treeSet3.size() + treeSet4.size()) + ", # deleted " + (treeSet5.size() + treeSet6.size() + treeSet7.size() + treeSet8.size()));
            }
        }
        if (this.db.on) {
            this.db.println("updateStructure FINISHED");
        }
    }

    private void getSortedModels(Map map, Map map2, Map map3, Map map4, Map map5) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ElementModel elementModel = (ElementModel)entry.getValue();
            if (map5 != null && elementModel instanceof BlsrModel) {
                map5.put(entry.getKey(), elementModel);
                continue;
            }
            if (map3 != null && elementModel instanceof OnePlusOneModel) {
                map3.put(entry.getKey(), elementModel);
                continue;
            }
            if (map4 != null && elementModel instanceof YCableModel) {
                map4.put(entry.getKey(), elementModel);
                continue;
            }
            if (map2 != null && elementModel instanceof UnprotectedLineModel) {
                map2.put(entry.getKey(), elementModel);
                continue;
            }
            if (!this.db.on || elementModel instanceof UnprotectedLineModel || elementModel instanceof OnePlusOneModel || elementModel instanceof YCableModel || elementModel instanceof BlsrModel) continue;
            this.db.severe("ERROR: Unknown type of EM: " + elementModel);
        }
    }

    private void deleteUpdate(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                this.internalRemove((ElementModel)iterator.next());
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                this.db.fine("Caught " + (Object)((Object)abstractCmsIOException) + " in deleteUpdate");
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
    }

    private void addUpdate(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            ElementModel elementModel = null;
            if (e instanceof sUnprotectedLineItem) {
                object = (sUnprotectedLineItem)e;
                elementModel = new UnprotectedLineModel(this.nmd, ((sUnprotectedLineItem)object).provision.main, (sUnprotectedLineItem)object);
            } else if (e instanceof sOnePlusOneItem) {
                object = (sOnePlusOneItem)e;
                elementModel = new OnePlusOneModel(this.nmd, ((sOnePlusOneItem)object).provision.main, (sOnePlusOneItem)object);
            } else if (e instanceof sYCableItem) {
                object = (sYCableItem)e;
                elementModel = new YCableModel(this.nmd, ((sYCableItem)object).provision.main, (sYCableItem)object);
            } else if (e instanceof sBlsrItem) {
                object = (sBlsrItem)e;
                elementModel = new BlsrModel(this.nmd, ((sBlsrItem)object).provision.eastPort, (sBlsrItem)object);
            }
            if (elementModel != null) {
                object = ((ElementModel)elementModel).getIndices();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    this.elementModels.put(new Integer((int)object[i]), elementModel);
                }
                ((ElementModel)elementModel).init();
                continue;
            }
            if (!this.db.on()) continue;
            this.db.println("Cannot find new added element in ElementModels:ElementModelFactory::addUpdate");
        }
    }

    public void update(Observable observable, Object object) {
        block14: {
            block13: {
                if (this.db.on) {
                    this.db.println(this.nmd.dbName() + "update(): entry");
                }
                if (!(observable instanceof CmsObservable)) break block13;
                int n = ((IObjectMessageInfo)object).getUpdateType();
                if (this.db.on) {
                    this.db.println(this.nmd.dbName() + "update(): Observable = " + observable.toString() + ", arg = " + EnumStrings.getStrings((Class)eUpdateType.class)[n]);
                }
                switch (n) {
                    case 0: {
                        if (this.db.on) {
                            this.db.println(this.nmd.dbName() + "update(): this DELETED.  " + "Should not happen!!!!!");
                            break;
                        }
                        break block14;
                    }
                    case 1: {
                        if (this.db.on) {
                            this.db.println(this.nmd.dbName() + "update(): this CHANGED.  " + "Should not happen!!!!!");
                            break;
                        }
                        break block14;
                    }
                    case 2: {
                        if (this.db.on) {
                            this.db.println(this.nmd.dbName() + "update(): ADDED");
                        }
                        this.updateStructure();
                        this.notifyObservers(ModelUpdateType.ADDED);
                        break;
                    }
                    default: {
                        if (this.db.on) {
                            this.db.println(this.nmd.dbName() + "update(): UNKNOWN NE UPDATE TYPE = " + n);
                            break;
                        }
                        break block14;
                    }
                }
                break block14;
            }
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + "update(): Unrecognized Observable = " + observable.toString() + ", arg = " + object.toString());
            }
        }
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "update(): exit");
        }
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    private SonetFactory getSFRef() {
        return this.nmd.getIorRepository().getSonetFactoryRef();
    }

    private boolean isRanSvcModule(ElementModel elementModel) throws AbstractCmsNoSuchEntityException {
        return elementModel.getEntityModel().getModuleModel() instanceof RanSvcModuleModel;
    }

    private class ElemComparator
    implements Comparator {
        private ElemComparator() {
        }

        public boolean equals(Object object) {
            return object instanceof ElemComparator;
        }

        public int compare(Object object, Object object2) {
            int n = -1;
            if (object instanceof sUnprotectedLineItem) {
                sUnprotectedLineItem sUnprotectedLineItem2 = (sUnprotectedLineItem)object;
                if (object2 instanceof sUnprotectedLineItem) {
                    sUnprotectedLineItem sUnprotectedLineItem3 = (sUnprotectedLineItem)object2;
                    n = ComparisonUtil.compare((int)sUnprotectedLineItem2.provision.main, (int)sUnprotectedLineItem3.provision.main);
                } else {
                    n = 1;
                }
            } else if (object instanceof sOnePlusOneItem) {
                sOnePlusOneItem sOnePlusOneItem2 = (sOnePlusOneItem)object;
                if (object2 instanceof sOnePlusOneItem) {
                    sOnePlusOneItem sOnePlusOneItem3 = (sOnePlusOneItem)object2;
                    n = ComparisonUtil.compare((int)ComparisonUtil.compare((int)sOnePlusOneItem2.provision.main, (int)sOnePlusOneItem3.provision.main), (int)ComparisonUtil.compare((int)sOnePlusOneItem2.provision.protect, (int)sOnePlusOneItem3.provision.protect));
                } else {
                    n = 1;
                }
            } else if (object instanceof sYCableItem) {
                sYCableItem sYCableItem2 = (sYCableItem)object;
                if (object2 instanceof sYCableItem) {
                    sYCableItem sYCableItem3 = (sYCableItem)object2;
                    n = ComparisonUtil.compare((int)ComparisonUtil.compare((int)sYCableItem2.provision.main, (int)sYCableItem3.provision.main), (int)ComparisonUtil.compare((int)sYCableItem2.provision.protect, (int)sYCableItem3.provision.protect));
                } else {
                    n = 1;
                }
            } else if (object instanceof sBlsrItem) {
                sBlsrItem sBlsrItem2 = (sBlsrItem)object;
                if (object2 instanceof sBlsrItem) {
                    sBlsrItem sBlsrItem3 = (sBlsrItem)object2;
                    n = ComparisonUtil.compare((int)ComparisonUtil.compare((int)ComparisonUtil.compare((int)sBlsrItem2.provision.eastPort, (int)sBlsrItem3.provision.eastPort), (int)ComparisonUtil.compare((int)sBlsrItem2.provision.westPort, (int)sBlsrItem3.provision.westPort)), (int)ComparisonUtil.compare((int)ComparisonUtil.compare((int)sBlsrItem2.provision.eastProtectPort, (int)sBlsrItem3.provision.eastProtectPort), (int)ComparisonUtil.compare((int)sBlsrItem2.provision.westProtectPort, (int)sBlsrItem3.provision.westProtectPort)));
                } else {
                    n = 1;
                }
            } else {
                n = -1;
            }
            return n;
        }
    }

    public class EMDDebug
    extends SDebug {
        EMDDebug(KDebug kDebug) {
            super(kDebug, ElementModelsDelegate.MY_DEBUG_KEY);
        }

        public final void dump() {
            this.dumpNoObs();
            ElementModelsDelegate.this.db.println("Observers:");
            ElementModelsDelegate.this.printObservers();
        }

        public final void dumpNoObs() {
            ElementModelsDelegate.this.dumpElementModels();
        }
    }

    private class ElementModelFactory {
        private NodeModelDelegate nmd;
        private sBlsrItem[] blsrArray;
        private sUnprotectedLineItem[] unprotectedArray;
        private sOnePlusOneItem[] onePlusOneArray;
        private sYCableItem[] yCableArray;
        private Map elementsCache = new TreeMap();

        public ElementModelFactory(NodeModelDelegate nodeModelDelegate) {
            this.nmd = nodeModelDelegate;
            ElementModelsDelegate.this.blsrList = new BLSRList("ElementModelsDelegate::ElementFactory.BLSRList");
            ElementModelsDelegate.this.unprotectedLineList = new UnprotectedLineList("ElementModelsDelegate::ElementFactory.UnprotectedLineList");
            ElementModelsDelegate.this.onePlusOneList = new OnePlusOneList("ElementModelsDelegate::ElementFactory.OnePlusOneList");
            ElementModelsDelegate.this.yCableList = new YCableList("ElementModelsDelegate::ElementFactory.YCableList");
        }

        private void fetchElementsFromNode() {
            block15: {
                StringBuffer stringBuffer;
                block14: {
                    try {
                        this.blsrArray = (sBlsrItem[])ElementModelsDelegate.this.blsrList.get();
                        if (ElementModelsDelegate.this.db.on) {
                            stringBuffer = new StringBuffer("Got the following from NE:");
                            stringBuffer.append("\n\tBLSR Len ");
                            stringBuffer.append(this.blsrArray.length);
                            ElementModelsDelegate.this.db.println(stringBuffer.toString());
                        }
                    }
                    catch (NO_IMPLEMENT nO_IMPLEMENT) {
                        if (ElementModelsDelegate.this.db.on) {
                            ElementModelsDelegate.this.db.println("NE doesn't support getBlsrList operation");
                        }
                    }
                    catch (UserException userException) {
                        ElementModelsDelegate.this.db.fine("Caught " + (Object)((Object)userException) + " in fetchElementsFromNode");
                        if (ElementModelsDelegate.this.db.on) {
                            SDebug cfr_ignored_0 = ElementModelsDelegate.this.db;
                            SDebug.printStackTrace((Throwable)userException);
                        }
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        ElementModelsDelegate.this.db.fine("Caught " + (Object)((Object)abstractCmsIOException) + " in fetchElementsFromNode");
                        if (!ElementModelsDelegate.this.db.on) break block14;
                        SDebug cfr_ignored_1 = ElementModelsDelegate.this.db;
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                }
                try {
                    this.unprotectedArray = (sUnprotectedLineItem[])ElementModelsDelegate.this.unprotectedLineList.get();
                    this.onePlusOneArray = (sOnePlusOneItem[])ElementModelsDelegate.this.onePlusOneList.get();
                    this.yCableArray = (sYCableItem[])ElementModelsDelegate.this.yCableList.get();
                    if (ElementModelsDelegate.this.db.on) {
                        stringBuffer = new StringBuffer("Got the following from NE:");
                        stringBuffer.append("\n\tUnprotected Len ");
                        stringBuffer.append(this.unprotectedArray.length);
                        stringBuffer.append("\n\t1+1 Len ");
                        stringBuffer.append(this.onePlusOneArray.length);
                        stringBuffer.append("\n\tY-Cable Len ");
                        stringBuffer.append(this.yCableArray.length);
                        ElementModelsDelegate.this.db.println(stringBuffer.toString());
                    }
                }
                catch (NO_IMPLEMENT nO_IMPLEMENT) {
                    if (ElementModelsDelegate.this.db.on) {
                        ElementModelsDelegate.this.db.println("NE doesn't support getYCableList operation");
                    }
                }
                catch (UserException userException) {
                    ElementModelsDelegate.this.db.fine("Caught " + (Object)((Object)userException) + " in fetchElementsFromNode");
                    if (ElementModelsDelegate.this.db.on) {
                        SDebug cfr_ignored_2 = ElementModelsDelegate.this.db;
                        SDebug.printStackTrace((Throwable)userException);
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    ElementModelsDelegate.this.db.fine("Caught " + (Object)((Object)abstractCmsIOException) + " in fetchElementsFromNode");
                    if (!ElementModelsDelegate.this.db.on) break block15;
                    SDebug cfr_ignored_3 = ElementModelsDelegate.this.db;
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        }

        public void captureChanges(TreeMap treeMap, TreeMap treeMap2, TreeMap treeMap3, TreeMap treeMap4, Set set, Set set2, Set set3, Set set4, Set set5, Set set6, Set set7, Set set8) {
            Integer n;
            Map map;
            Integer n2;
            TreeSet<Integer> treeSet;
            this.fetchElementsFromNode();
            if (this.unprotectedArray != null) {
                if (ElementModelsDelegate.this.db.on) {
                    ElementModelsDelegate.this.db.println("Checking Unprotected ...");
                }
                treeSet = new TreeSet<Integer>();
                for (int i = 0; i < this.unprotectedArray.length; ++i) {
                    n2 = new Integer(this.unprotectedArray[i].provision.main);
                    if (!treeMap.containsKey(n2)) {
                        set.add(this.unprotectedArray[i]);
                    }
                    treeSet.add(n2);
                }
                map = (Map)treeMap.clone();
                map.keySet().removeAll(treeSet);
                set2.addAll(map.values());
            }
            if (this.onePlusOneArray != null) {
                if (ElementModelsDelegate.this.db.on) {
                    ElementModelsDelegate.this.db.println("Checking 1+1 ...");
                }
                treeSet = new TreeSet();
                for (int i = 0; i < this.onePlusOneArray.length; ++i) {
                    n2 = new Integer(this.onePlusOneArray[i].provision.main);
                    n = new Integer(this.onePlusOneArray[i].provision.protect);
                    if (!treeMap2.containsKey(n2) && !treeMap2.containsKey(n)) {
                        set3.add(this.onePlusOneArray[i]);
                    }
                    treeSet.add(n2);
                    treeSet.add(n);
                }
                map = (Map)treeMap2.clone();
                map.keySet().removeAll(treeSet);
                set4.addAll(map.values());
            }
            if (this.yCableArray != null) {
                if (ElementModelsDelegate.this.db.on) {
                    ElementModelsDelegate.this.db.println("Checking Y-Cable ...");
                }
                treeSet = new TreeSet();
                for (int i = 0; i < this.yCableArray.length; ++i) {
                    n2 = new Integer(this.yCableArray[i].provision.main);
                    n = new Integer(this.yCableArray[i].provision.protect);
                    if (!treeMap3.containsKey(n2) && !treeMap3.containsKey(n)) {
                        set5.add(this.yCableArray[i]);
                    }
                    treeSet.add(n2);
                    treeSet.add(n);
                }
                map = (Map)treeMap3.clone();
                map.keySet().removeAll(treeSet);
                set6.addAll(map.values());
            }
            if (this.blsrArray != null) {
                if (ElementModelsDelegate.this.db.on) {
                    ElementModelsDelegate.this.db.println("Checking BLSR ...");
                }
                treeSet = new TreeSet();
                for (int i = 0; i < this.blsrArray.length; ++i) {
                    n2 = new Integer(this.blsrArray[i].provision.eastPort);
                    n = new Integer(this.blsrArray[i].provision.eastProtectPort);
                    Integer n3 = new Integer(this.blsrArray[i].provision.westPort);
                    Integer n4 = new Integer(this.blsrArray[i].provision.westProtectPort);
                    if (!(treeMap4.containsKey(n2) || treeMap4.containsKey(n) || treeMap4.containsKey(n3) || treeMap4.containsKey(n4))) {
                        set7.add(this.blsrArray[i]);
                    }
                    treeSet.add(n2);
                    treeSet.add(n);
                    treeSet.add(n3);
                    treeSet.add(n4);
                }
                Map map2 = (Map)treeMap4.clone();
                map2.keySet().removeAll(treeSet);
                set8.addAll(map2.values());
            }
        }

        public Map getElementsMap() {
            this.fetchElementsFromNode();
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.db.println("creating Unprotected ...");
            }
            this.createUnprotectedElements();
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.db.println("creating 1+1 ...");
            }
            this.createOnePlusOneElements();
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.db.println("creating Y-Cable ...");
            }
            this.createYCableElements();
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.db.println("creating BLSR ...");
            }
            this.createBlsrElements();
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.debugDumpHexIndexes("Elements Cache", this.elementsCache.keySet());
            }
            return this.elementsCache;
        }

        private void createBlsrElements() {
            if (this.blsrArray != null) {
                for (int i = 0; i < this.blsrArray.length; ++i) {
                    Integer n = new Integer(this.blsrArray[i].provision.eastPort);
                    Integer n2 = new Integer(this.blsrArray[i].provision.eastProtectPort);
                    Integer n3 = new Integer(this.blsrArray[i].provision.westPort);
                    Integer n4 = new Integer(this.blsrArray[i].provision.westProtectPort);
                    if (ElementModelsDelegate.this.db.on()) {
                        ElementModelsDelegate.this.db.println("Checking in cache for BlsrModel index=" + Integer.toHexString(this.blsrArray[i].provision.eastPort));
                    }
                    if (ElementModelsDelegate.this.db.on()) {
                        ElementModelsDelegate.this.db.println("eastPort=" + n + "eastProtectPort=" + n2 + "westPort=" + n3 + "westProtectPort=" + n4);
                    }
                    if (this.elementsCache.containsKey(n) || this.elementsCache.containsKey(n2) || this.elementsCache.containsKey(n3) || this.elementsCache.containsKey(n4)) continue;
                    if (ElementModelsDelegate.this.db.on()) {
                        ElementModelsDelegate.this.db.println("Creating BlsrModel for index=" + Integer.toHexString(this.blsrArray[i].provision.eastPort));
                    }
                    try {
                        BlsrModel blsrModel = new BlsrModel(this.nmd, this.blsrArray[i].provision.eastPort, this.blsrArray[i]);
                        if (n != 0) {
                            this.elementsCache.put(n, blsrModel);
                        }
                        if (n2 != 0) {
                            this.elementsCache.put(n2, blsrModel);
                        }
                        if (n3 != 0) {
                            this.elementsCache.put(n3, blsrModel);
                        }
                        if (n4 == 0) continue;
                        this.elementsCache.put(n4, blsrModel);
                        continue;
                    }
                    catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                        if (!ElementModelsDelegate.this.db.on) continue;
                        ElementModelsDelegate.this.db.fine("Caught OBJECT_NOT_EXIST for BLSR " + this.blsrArray[i].provision.eastPort);
                    }
                }
            }
        }

        private void createOnePlusOneElements() {
            if (this.onePlusOneArray != null) {
                for (int i = 0; i < this.onePlusOneArray.length; ++i) {
                    Integer n = new Integer(this.onePlusOneArray[i].provision.main);
                    Integer n2 = new Integer(this.onePlusOneArray[i].provision.protect);
                    if (this.elementsCache.containsKey(n) || this.elementsCache.containsKey(n2)) continue;
                    try {
                        OnePlusOneModel onePlusOneModel = new OnePlusOneModel(this.nmd, this.onePlusOneArray[i].provision.main, this.onePlusOneArray[i]);
                        this.elementsCache.put(n, onePlusOneModel);
                        this.elementsCache.put(n2, onePlusOneModel);
                        continue;
                    }
                    catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                        if (!ElementModelsDelegate.this.db.on) continue;
                        ElementModelsDelegate.this.db.fine("Caught OBJECT_NOT_EXIST for 1+1 " + this.onePlusOneArray[i].provision.main);
                    }
                }
            }
        }

        private void createYCableElements() {
            if (this.yCableArray != null) {
                for (int i = 0; i < this.yCableArray.length; ++i) {
                    Integer n = new Integer(this.yCableArray[i].provision.main);
                    Integer n2 = new Integer(this.yCableArray[i].provision.protect);
                    if (this.elementsCache.containsKey(n) || this.elementsCache.containsKey(n2)) continue;
                    try {
                        YCableModel yCableModel = new YCableModel(this.nmd, this.yCableArray[i].provision.main, this.yCableArray[i]);
                        this.elementsCache.put(n, yCableModel);
                        this.elementsCache.put(n2, yCableModel);
                        continue;
                    }
                    catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                        if (!ElementModelsDelegate.this.db.on) continue;
                        ElementModelsDelegate.this.db.fine("Caught OBJECT_NOT_EXIST for Y-Cable " + this.yCableArray[i].provision.main);
                    }
                }
            }
        }

        private void createUnprotectedElements() {
            if (this.unprotectedArray != null) {
                for (int i = 0; i < this.unprotectedArray.length; ++i) {
                    Integer n = new Integer(this.unprotectedArray[i].provision.main);
                    if (this.elementsCache.containsKey(n)) continue;
                    try {
                        UnprotectedLineModel unprotectedLineModel = new UnprotectedLineModel(this.nmd, this.unprotectedArray[i].provision.main, this.unprotectedArray[i]);
                        this.elementsCache.put(n, unprotectedLineModel);
                        continue;
                    }
                    catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                        if (!ElementModelsDelegate.this.db.on) continue;
                        ElementModelsDelegate.this.db.fine("Caught OBJECT_NOT_EXIST for Y-Cable " + this.unprotectedArray[i].provision.main);
                    }
                }
            }
        }
    }

    private class YCableList
    extends NonCachedValue {
        public YCableList(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue() throws UserException {
            return this.getValue(null);
        }

        protected Object getValue(Object object) throws UserException {
            return ElementModelsDelegate.this.getSFRef().getYCableList();
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    private class OnePlusOneList
    extends NonCachedValue {
        public OnePlusOneList(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue() throws UserException {
            return this.getValue(null);
        }

        protected Object getValue(Object object) throws UserException {
            return ElementModelsDelegate.this.getSFRef().getOnePlusOneList();
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    private class UnprotectedLineList
    extends NonCachedValue {
        public UnprotectedLineList(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue() throws UserException {
            return this.getValue(null);
        }

        protected Object getValue(Object object) throws UserException {
            return ElementModelsDelegate.this.getSFRef().getUnprotectedLineList();
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    private class BLSRList
    extends NonCachedValue {
        public BLSRList(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue() throws UserException {
            return this.getValue(null);
        }

        protected Object getValue(Object object) throws UserException {
            return ElementModelsDelegate.this.getSFRef().getBlsrList();
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    class ElementType
    extends NonCachedValue {
        public ElementType(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue(Object object) throws UserException {
            return ((Element)object).type();
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    class FindElement
    extends NonCachedValue {
        public FindElement(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue(Object object) throws UserException {
            return ElementModelsDelegate.this.getSFRef().getElement((Integer)object);
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    class CreateBlsr
    extends NonCachedValue {
        public CreateBlsr(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return ElementModelsDelegate.this.getSFRef().createBlsr(new sBlsrProvisionHolder((sBlsrProvision)objectArray[0]), (eElementType)objectArray[1]);
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    class CreateYCable
    extends NonCachedValue {
        public CreateYCable(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return ElementModelsDelegate.this.getSFRef().createYCable((sYCableProvision)objectArray[0], (String)objectArray[1]);
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    class BlsrLimitsCV
    extends CachedValue {
        public BlsrLimitsCV(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return ElementModelsDelegate.this.getSFRef().getBlsrLimits();
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    class CreateOnePlusOne
    extends NonCachedValue {
        public CreateOnePlusOne(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return ElementModelsDelegate.this.getSFRef().createOnePlusOne((sOnePlusOneProvision)objectArray[0], (String)objectArray[1]);
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }
}

