/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.xInvalidUpperBound;
import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.sEntity;
import cerent.cms.idl.Equipment.sEntityListElem;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.SonetMedia.eStm1eMode;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.CircuitType;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FramingType;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidUpperBound;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.YCableModel;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.util.AnnotatedException;
import cerent.util.EnumStrings;
import cerent.util.ILoNum;
import cerent.util.PathTraceUtil;
import cerent.util.SDebug;
import cerent.util.SONETTDMTerminology;
import cerent.util.TDMTerminology;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class EntityModel
extends Model
implements IEntityModel,
Comparable {
    protected int entityIndex;
    protected int positionInParent;
    protected NodeModelDelegate node = null;
    private EquipmentType equipmentType = null;
    protected String eqLabel = null;
    protected ChildrenIndex childrenIndex = null;
    protected ParentId parentId = null;
    protected PositionInParent positionInParentNCV = null;
    protected GenericClass genericClassNCV = null;
    protected AlarmProfileName alarmProfileName = null;
    protected SuppressAlarms suppressAlarms = null;
    protected eClass genericClass;
    protected EntityModel parent = null;
    protected ChassisModel chassis = null;
    protected Entity entityRef = null;
    private String description;
    static EntityModelComparator comparator = new EntityModelComparator();
    protected Set children = new TreeSet(comparator);
    protected EventDispatcher dispatcher;
    private EntityTableModel etm;
    private int cachedEqType = 0;
    private Integer _framingType;
    private static final SDebug edb = new SDebug("EntityModel");

    public String getAlarmProfileName() throws AbstractCmsIOException {
        try {
            return (String)this.alarmProfileName.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setAlarmProfileName(String string) throws InvalidUpperBound {
        try {
            this.alarmProfileName.set(string);
        }
        catch (xInvalidUpperBound xInvalidUpperBound2) {
            throw new InvalidUpperBound("Profile name cannot be longer than " + xInvalidUpperBound2.upperBound + " characters");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getSuppressAlarms() throws AbstractCmsIOException {
        boolean bl = true;
        try {
            bl = (Boolean)this.suppressAlarms.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return bl;
    }

    public void setSuppressAlarms(boolean bl) {
        try {
            if (EntityModel.edb.on) {
                edb.println("setSuppressAlarms(" + bl + ") for " + this);
            }
            this.suppressAlarms.set(new Boolean(bl));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public EntityModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(sDebug);
        this.node = nodeModelDelegate;
        this.entityRef = entity;
        this.entityIndex = n;
        this.genericClass = eClass2;
        this.positionInParent = n2;
        this.childrenIndex = new ChildrenIndex(this.node, "EntityModel.ChildrenIndex");
        this.parentId = new ParentId(this.node, "EntityModel.ParentId");
        this.positionInParentNCV = new PositionInParent(this.node, "EntityModel.PositionInParent");
        this.genericClassNCV = new GenericClass(this.node, "EntityModel.GenericClass");
        this.equipmentType = new EquipmentType(this.node, "EntityModel.EntityInfo", eEqType2);
        this.alarmProfileName = new AlarmProfileName(this.node, "EntityModel.AlarmProfileName");
        this.suppressAlarms = new SuppressAlarms(this.node, "EntityModel.SuppressAlarms");
        this.dispatcher = null;
        this.description = null;
        this._framingType = null;
        this.etm = nodeModelDelegate.getEntityTableModel();
    }

    private int getFramingType() {
        if (this._framingType == null) {
            this._framingType = new Integer(this.getNodeModel().getFramingType());
        }
        return this._framingType;
    }

    public EntityModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(EntityModel.class));
    }

    public EntityModel(NodeModelDelegate nodeModelDelegate, Entity entity, sEntity sEntity2, SDebug sDebug) {
        this(nodeModelDelegate, entity, sEntity2.index, sEntity2.eqType, sEntity2.genericClass, sEntity2.posInParent, sDebug);
    }

    public EntityModel(NodeModelDelegate nodeModelDelegate, sEntityListElem sEntityListElem2, SDebug sDebug) {
        this(nodeModelDelegate, sEntityListElem2.ent, sEntityListElem2.entityData, sDebug);
    }

    public EntityModel(NodeModelDelegate nodeModelDelegate, Entity entity, SDebug sDebug) {
        this(nodeModelDelegate, entity, entity.entityInfo(), sDebug);
    }

    public EntityModel() {
        super(new SDebug("EntityModel"));
    }

    public void init() {
        super.init0();
        if (EntityModel.edb.on) {
            edb.println("init() " + this + ": Now addObserver");
        }
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectEntity, this.getEntityIndex(), (Observer)this);
        }
        this.getChassis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initAll() {
        this.init();
        Set set = this.children;
        synchronized (set) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((EntityModel)iterator.next()).initAll();
            }
        }
    }

    void sendUpdates(Collection collection) {
        if (collection != null && collection.size() > 0) {
            edb.info(this + " sendUpdates(#children=" + collection.size() + ")");
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
        }
    }

    public void dispose() {
        edb.fine("disposing " + this);
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectEntity, this.getEntityIndex(), (Observer)this);
            this.dispatcher = null;
        }
        if (this.etm != null) {
            this.etm.removeModel(this);
        }
        this.equipmentType.dispose();
        this.alarmProfileName.dispose();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        edb.fine("destroying " + this);
        super.destroy();
        Set set = this.children;
        synchronized (set) {
            this.children.clear();
        }
        this.parent = null;
        this.entityRef = null;
        this.etm = null;
    }

    public Entity getEntityRef() {
        if (this.entityRef == null) {
            throw new CmsObjectNotExistException("Entity reference is null");
        }
        return this.entityRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(EntityModel entityModel) {
        entityModel.setParent(this);
        Set set = this.children;
        synchronized (set) {
            this.children.add(entityModel);
        }
    }

    protected static void destroyEntity(EntityModel entityModel) {
        if (entityModel != null) {
            try {
                entityModel.destroy();
            }
            catch (Exception exception) {
                edb.println("destroyEntity(" + entityModel.index + "): " + exception);
            }
        }
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.node;
    }

    public int getEntityIndex() {
        return this.entityIndex;
    }

    public int getIndex() {
        return this.entityIndex;
    }

    public IModuleModel getModuleModel() {
        return this.parent != null ? this.parent.getModuleModel() : null;
    }

    public int getSlot() {
        int n = 0;
        if (this.getGenericClass() == eClass.CONTAINER.value()) {
            if (this.parent != null && this.parent.getGenericClass() == eClass.BACKPLANE.value()) {
                n = this.getPositionInParent();
            } else if (edb.on()) {
                edb.println("Container is not a descendant of backplane");
            }
        } else if (this.parent != null) {
            n = this.parent.getSlot();
        } else if (edb.on()) {
            edb.println("Slot is not applicable to this entity");
        }
        return n;
    }

    public int getPort() {
        int n = 0;
        eClass eClass2 = this.genericClass;
        if (eClass2 != eClass.PORT && eClass2 != eClass.E_SENSOR && eClass2 != eClass.SENSOR_OUTPUT && eClass2 != eClass.FAN) {
            if (EntityModel.edb.on) {
                edb.println("Port is not applicable to this entity");
            }
        } else {
            n = this.getPositionInParent();
        }
        return n;
    }

    public int getOneBasedPortNum() {
        int n = this.getPort();
        if (this.getEqType() == 105) {
            ++n;
        } else if (this.getEqType() == 104) {
            ++n;
        }
        return n;
    }

    public int getEqType() {
        block3: {
            try {
                eEqType eEqType2 = this.getEqTypeEnum();
                if (eEqType2 != null) {
                    this.cachedEqType = eEqType2.value();
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.db.on()) break block3;
                this.db.println("Exception getting eqType: " + (Object)((Object)abstractCmsIOException));
            }
        }
        return this.cachedEqType;
    }

    public eEqType getEqTypeEnum() {
        eEqType eEqType2 = null;
        try {
            eEqType2 = (eEqType)this.equipmentType.get();
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
        }
        catch (BAD_PARAM bAD_PARAM) {
        }
        catch (UserException userException) {
            throw new CmsCommFailException(userException.toString());
        }
        return eEqType2;
    }

    public String getEqLabel() {
        String string;
        block3: {
            string = null;
            try {
                string = this.getEqTypeName();
                if (this.eqLabel != null && string != null && this.eqLabel.indexOf(string) != -1) {
                    string = this.eqLabel;
                }
            }
            catch (Exception exception) {
                edb.println("Exception in getEqLabel: " + exception);
                if (!edb.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string == null ? " " : string;
    }

    public void setEqLabel(String string) {
        if (string != null) {
            this.eqLabel = string;
        }
    }

    public int getGenericClass() {
        return this.genericClass.value();
    }

    public IEntityModel getParent() {
        if (!(this.parent != null || this.etm != null && this.equals(this.etm.getChassis()))) {
            throw new CmsObjectNotExistException("parent is null for Entity:" + Integer.toHexString(this.getIndex()));
        }
        return this.parent;
    }

    public IChassisModel getChassis() {
        if (this.chassis == null) {
            if (this instanceof ChassisModel) {
                this.chassis = (ChassisModel)this;
            } else {
                EntityModel entityModel = this.parent;
                while (entityModel != null && !(entityModel instanceof ChassisModel)) {
                    entityModel = entityModel.parent;
                }
                this.chassis = (ChassisModel)entityModel;
            }
        }
        return this.chassis;
    }

    public int getShelfId() {
        return this.getChassis().getShelfId();
    }

    public void setParent(IEntityModel iEntityModel) {
        this.parent = (EntityModel)iEntityModel;
    }

    public int getPositionInParent() {
        return this.positionInParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildren() {
        Set set = this.children;
        synchronized (set) {
            return new ArrayList(this.children);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildrenOfType(eEqType eEqType2, eClass eClass2) {
        ArrayList<EntityModel> arrayList = new ArrayList<EntityModel>();
        Set set = this.children;
        synchronized (set) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                EntityModel entityModel = (EntityModel)iterator.next();
                if (eEqType2 != entityModel.getEqTypeEnum() || eClass2 != entityModel.genericClass) continue;
                arrayList.add(entityModel);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildrenOfType(eEqType eEqType2) {
        ArrayList<EntityModel> arrayList = new ArrayList<EntityModel>();
        Set set = this.children;
        synchronized (set) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                EntityModel entityModel = (EntityModel)iterator.next();
                if (eEqType2 != entityModel.getEqTypeEnum()) continue;
                arrayList.add(entityModel);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildrenOfType(eClass eClass2) {
        ArrayList<EntityModel> arrayList = new ArrayList<EntityModel>();
        Set set = this.children;
        synchronized (set) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                EntityModel entityModel = (EntityModel)iterator.next();
                if (eClass2 != entityModel.genericClass) continue;
                arrayList.add(entityModel);
            }
        }
        return arrayList;
    }

    public List getDescendantsOfType(eEqType eEqType2, eClass eClass2) {
        ArrayList arrayList = new ArrayList();
        this.getDescendantsOfType(eEqType2, eClass2, arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getDescendantsOfType(eEqType eEqType2, eClass eClass2, List list) {
        if (this.getEqTypeEnum() == eEqType2 && this.genericClass == eClass2) {
            list.add(this);
        }
        Set set = this.children;
        synchronized (set) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((EntityModel)iterator.next()).getDescendantsOfType(eEqType2, eClass2, list);
            }
        }
        return list;
    }

    public List getDescendantsOfType(eEqType eEqType2) {
        ArrayList arrayList = new ArrayList();
        this.getDescendantsOfType(eEqType2, arrayList);
        return arrayList;
    }

    public List getDescendantsOfEqType(int n) {
        return this.getDescendantsOfType(eEqType.from_int(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getDescendantsOfType(eEqType eEqType2, List list) {
        if (this.getEqTypeEnum() == eEqType2) {
            list.add(this);
        }
        Set set = this.children;
        synchronized (set) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((EntityModel)iterator.next()).getDescendantsOfType(eEqType2, list);
            }
        }
        return list;
    }

    public List getDescendantsOfType(eClass eClass2) {
        ArrayList arrayList = new ArrayList();
        this.getDescendantsOfType(eClass2, arrayList);
        return arrayList;
    }

    public List getDescendantsOfClassType(int n) {
        return this.getDescendantsOfType(eClass.from_int(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getDescendantsOfType(eClass eClass2, List list) {
        if (this.genericClass == eClass2) {
            list.add(this);
        }
        Set set = this.children;
        synchronized (set) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((EntityModel)iterator.next()).getDescendantsOfType(eClass2, list);
            }
        }
        return list;
    }

    public List getMfgEntities() {
        ArrayList arrayList = new ArrayList();
        this.getMfgEntities(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getMfgEntities(List list) {
        if (this instanceof MfgEntityModel) {
            list.add(this);
        }
        Set set = this.children;
        synchronized (set) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((EntityModel)iterator.next()).getMfgEntities(list);
            }
        }
        return list;
    }

    public List getDescendants() {
        ArrayList arrayList = new ArrayList();
        this.getDescendants(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getDescendants(List list) {
        Set set = this.children;
        synchronized (set) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                IEntityModel iEntityModel = (IEntityModel)iterator.next();
                list.add(iEntityModel);
                ((EntityModel)iEntityModel).getDescendants(list);
            }
        }
        return list;
    }

    public EntityModel getAncestorOfType(eEqType eEqType2) {
        EntityModel entityModel = this.parent;
        while (entityModel != null && entityModel.getEqTypeEnum() != eEqType2) {
            entityModel = entityModel.parent;
        }
        return entityModel;
    }

    public IEntityModel getAncestorOfEqType(int n) {
        return this.getAncestorOfType(eEqType.from_int(n));
    }

    public EntityModel getAncestorOfType(eClass eClass2) {
        EntityModel entityModel = this.parent;
        while (entityModel != null && entityModel.genericClass.value() != eClass2.value()) {
            entityModel = entityModel.parent;
        }
        return entityModel;
    }

    public IEntityModel getAncestorOfClassType(int n) {
        return this.getAncestorOfType(eClass.from_int(n));
    }

    public EntityModel getAncestorOfType(eEqType eEqType2, eClass eClass2) {
        EntityModel entityModel = this.parent;
        while (entityModel != null && (eEqType2 != entityModel.getEqTypeEnum() || eClass2 != entityModel.genericClass)) {
            entityModel = entityModel.parent;
        }
        return entityModel;
    }

    protected void updateLocal() {
        if (EntityModel.edb.on) {
            edb.println("updateLocal() " + Integer.toHexString(this.getEntityIndex()));
        }
        this.alarmProfileName.update();
        eEqType eEqType2 = this.getEqTypeEnum();
        this.equipmentType.update();
        eEqType eEqType3 = this.getEqTypeEnum();
        if (EntityModel.edb.on) {
            SONETTDMTerminology sONETTDMTerminology = SONETTDMTerminology.instance();
            int n = eEqType2 != null ? eEqType2.value() : -1;
            int n2 = eEqType3 != null ? eEqType3.value() : -1;
            edb.println("type old=" + n + "/'" + EntityModel.eqType2Name((TDMTerminology)sONETTDMTerminology, eEqType2) + "' new=" + n2 + "/'" + EntityModel.eqType2Name((TDMTerminology)sONETTDMTerminology, eEqType3) + "'");
        }
        if (eEqType2 != null && eEqType3 != null && eEqType2.value() != eEqType3.value()) {
            if (EntityModel.edb.on) {
                edb.println("type changed, updating structure");
            }
            this.equipmentType.setValueExternally(eEqType2);
            this.updateStructure();
        } else {
            if (EntityModel.edb.on) {
                edb.println("type UNchanged, notifying observers");
            }
            this.setChanged();
            super.updateLocal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateStructure(EntityTableModel entityTableModel, long l) {
        TreeSet<Object> treeSet;
        TreeSet treeSet2;
        long l2;
        long l3;
        block29: {
            Object object;
            Serializable serializable;
            EntityModel entityModel;
            block28: {
                int n = this.getIndex();
                l3 = l;
                if (edb.isFineEnabled()) {
                    l2 = System.currentTimeMillis();
                    edb.fine("Finished 1: Discovery " + (l2 - l3) + "ms (Total " + (l2 - l) + "ms)");
                    l3 = l2;
                }
                entityModel = null;
                try {
                    entityModel = (EntityModel)entityTableModel.getEntityModelByIndex(this.getChassis().getIndex());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!edb.on()) break block28;
                    edb.println("Chassis does not appear in the ETM, we must be in the process of deleting it.");
                }
            }
            if (edb.isFineEnabled()) {
                l2 = System.currentTimeMillis();
                edb.fine("Finished 2: Find entity in new table " + (l2 - l3) + "ms (Total " + (l2 - l) + "ms)");
                l3 = l2;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            TreeSet<Object> treeSet3 = new TreeSet<Object>(comparator);
            if (this != entityModel) {
                if (entityModel == null) {
                    treeSet3.add(this.getChassis());
                }
                arrayList.add(this.getChassis());
            }
            while (arrayList.size() > 0) {
                serializable = (EntityModel)arrayList.remove(0);
                treeSet2 = ((EntityModel)serializable).children;
                synchronized (treeSet2) {
                    treeSet = ((EntityModel)serializable).children.iterator();
                    while (treeSet.hasNext()) {
                        object = (EntityModel)treeSet.next();
                        treeSet3.add(object);
                        arrayList.add(object);
                    }
                }
            }
            if (edb.isFineEnabled()) {
                l2 = System.currentTimeMillis();
                edb.fine("Finished 3: Make tree for old " + (l2 - l3) + "ms (Total " + (l2 - l) + "ms)");
                l3 = l2;
            }
            serializable = new TreeSet(comparator);
            if (entityModel != null) {
                if (this == entityModel) {
                    serializable.add(entityModel);
                }
                arrayList.add(entityModel);
            }
            while (arrayList.size() > 0) {
                treeSet2 = (EntityModel)arrayList.remove(0);
                treeSet = ((EntityModel)((Object)treeSet2)).children;
                synchronized (treeSet) {
                    object = ((EntityModel)((Object)treeSet2)).children.iterator();
                    while (object.hasNext()) {
                        EntityModel entityModel2 = (EntityModel)object.next();
                        serializable.add(entityModel2);
                        arrayList.add(entityModel2);
                    }
                }
            }
            if (edb.isFineEnabled()) {
                l2 = System.currentTimeMillis();
                edb.fine("Finished 4: Make tree for new " + (l2 - l3) + "ms (Total " + (l2 - l) + "ms)");
                l3 = l2;
            }
            treeSet2 = new TreeSet(comparator);
            treeSet2.addAll(serializable);
            treeSet2.removeAll(treeSet3);
            if (edb.isFineEnabled()) {
                l2 = System.currentTimeMillis();
                edb.fine("Finished 5: Find added " + (l2 - l3) + "ms (Total " + (l2 - l) + "ms)");
                l3 = l2;
            }
            treeSet = new TreeSet<Object>(comparator);
            treeSet.addAll(treeSet3);
            treeSet.removeAll((Collection<?>)((Object)serializable));
            if (edb.isFineEnabled()) {
                l2 = System.currentTimeMillis();
                edb.fine("Finished 6: Find deleted " + (l2 - l3) + "ms (Total " + (l2 - l) + "ms)");
                l3 = l2;
            }
            if (treeSet2.isEmpty() && treeSet.isEmpty()) {
                try {
                    object = (EntityModel)entityTableModel.getEntityModelByIndex(this.getIndex());
                    if (object != null) {
                        this.entityRef = ((EntityModel)object).entityRef;
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!edb.on()) break block29;
                    edb.println(this + " does not appear in the ETM, " + "we must be in the process of deleting it.");
                }
            }
        }
        if (this.update(this.node.getEntityTableModel(), treeSet2, treeSet) && this.needNotify()) {
            edb.finest("In updateStructure, notifying observers: added " + this + " to " + this.parent);
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
        }
        if (edb.isFineEnabled()) {
            l2 = System.currentTimeMillis();
            edb.fine("Finished 7: Send updates " + (l2 - l3) + "ms (Total " + (l2 - l) + "ms)");
        }
    }

    protected final void updateStructure() {
        block3: {
            if (edb.isFineEnabled()) {
                edb.fine("--------- updateStructure " + Integer.toHexString(this.index) + " ----------");
            }
            try {
                long l = System.currentTimeMillis();
                EntityTableModel entityTableModel = new EntityTableModel(this.node);
                IChassisModel iChassisModel = this.getChassis();
                int n = iChassisModel != null ? iChassisModel.getIndex() : 1;
                entityTableModel.discoverEntityTableByChassis(n);
                this.updateStructure(entityTableModel, l);
            }
            catch (NullPointerException nullPointerException) {
                edb.severe("Caught " + nullPointerException + " in updateStructure");
                if (!edb.on()) break block3;
                SDebug.printStackTrace((Throwable)nullPointerException);
            }
        }
    }

    private EntityModel getParentOf(EntityTableModel entityTableModel, EntityModel entityModel) {
        EntityModel entityModel2;
        if (entityModel.parent != null) {
            try {
                entityModel2 = (EntityModel)entityTableModel.getEntityModelByIndex(entityModel.parent.getIndex());
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                entityModel2 = null;
            }
        } else {
            entityModel2 = null;
        }
        return entityModel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(EntityTableModel entityTableModel, Collection collection, Collection collection2) {
        int n = collection.size();
        int n2 = collection2.size();
        if (edb.on()) {
            edb.println("Added " + n + " child" + (n == 1 ? "" : "ren") + ", and deleted " + n2 + " child" + (n2 == 1 ? "" : "ren") + ".");
        }
        if (n > 0 || n2 > 0) {
            Object object;
            EntityModel entityModel;
            EntityModel entityModel2;
            Object object2;
            Cloneable cloneable;
            if (n2 > 0) {
                cloneable = new TreeSet(new ChildComparator());
                ((TreeSet)cloneable).addAll(collection2);
                object2 = ((TreeSet)cloneable).iterator();
                while (object2.hasNext()) {
                    entityModel2 = (EntityModel)object2.next();
                    if (entityModel2.etm == null) continue;
                    entityModel = entityModel2.parent;
                    if (edb.on()) {
                        edb.println("Removing 0x" + Integer.toHexString(entityModel2.getIndex()));
                    }
                    if (entityModel != null) {
                        object = entityModel.children;
                        synchronized (object) {
                            entityModel.children.remove(entityModel2);
                        }
                    }
                    EntityModel.destroyEntity(entityModel2);
                }
            }
            if (n > 0) {
                ArrayList<EntityModel> arrayList;
                cloneable = new TreeMap(new ParentComparator());
                object2 = new TreeSet(new ParentComparator());
                ((TreeSet)object2).addAll(collection);
                object = ((TreeSet)object2).iterator();
                while (object.hasNext()) {
                    entityModel2 = (EntityModel)object.next();
                    entityModel = this.getParentOf(entityTableModel, entityModel2);
                    if (edb.on()) {
                        edb.println("Adding 0x" + Integer.toHexString(entityModel2.getIndex()));
                    }
                    if (entityModel != null) {
                        entityModel.add(entityModel2);
                        arrayList = (ArrayList)((TreeMap)cloneable).get(entityModel);
                        if (arrayList == null) {
                            arrayList = new ArrayList<EntityModel>();
                            ((TreeMap)cloneable).put(entityModel, arrayList);
                        }
                        arrayList.add(entityModel2);
                    }
                    if (entityTableModel != null) {
                        entityTableModel.addModel(entityModel2);
                    }
                    entityModel2.init();
                }
                object = ((TreeMap)cloneable).entrySet().iterator();
                while (object.hasNext()) {
                    arrayList = (Map.Entry)object.next();
                    ((EntityModel)arrayList.getKey()).sendUpdates((ArrayList)arrayList.getValue());
                }
            }
            return false;
        }
        return true;
    }

    protected void deleteLocal() {
    }

    protected boolean needNotify() {
        return false;
    }

    public final void update(Observable observable, Object object) {
        edb.fine("update(" + observable + ", " + object + ")");
        if (observable instanceof CmsObservable) {
            CmsObservable cmsObservable = (CmsObservable)((Object)observable);
            ObjectMessageInfo objectMessageInfo = (ObjectMessageInfo)object;
            int n = objectMessageInfo.getUpdateType();
            if (edb.on()) {
                edb.println("update(): this=" + this + ", From=" + observable + ", arg=" + EnumStrings.getStrings((Class)eUpdateType.class)[n]);
            }
            switch (n) {
                case 0: {
                    edb.fine("update(): " + this + " DELETED");
                    this.deletedReceived(cmsObservable, objectMessageInfo);
                    break;
                }
                case 1: {
                    edb.fine("update(): " + this + " CHANGED");
                    this.changedReceived(cmsObservable, objectMessageInfo);
                    break;
                }
                case 2: {
                    edb.fine("update(): " + this + " ADDED");
                    this.addedReceived(cmsObservable, objectMessageInfo);
                    break;
                }
                default: {
                    edb.warning("update(): ILLEGAL UpdateType: " + n);
                    break;
                }
            }
        } else {
            edb.warning("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    protected void addedReceived(CmsObservable cmsObservable, ObjectMessageInfo objectMessageInfo) {
        this.updateStructure();
    }

    protected void changedReceived(CmsObservable cmsObservable, ObjectMessageInfo objectMessageInfo) {
        this.updateLocal();
    }

    protected void deletedReceived(CmsObservable cmsObservable, ObjectMessageInfo objectMessageInfo) {
        this.deleteLocal();
        this.updateStructure();
    }

    public String toString() {
        return "Entity[" + this.toShortString() + "]";
    }

    public int hashCode() {
        return this.entityIndex;
    }

    public boolean equals(Object object) {
        if (object instanceof EntityModel) {
            return comparator.compare(this, object) == 0;
        }
        return false;
    }

    public String toShortString() {
        if (this.description == null) {
            String[] stringArray = EnumStrings.getStrings((Class)eEqType.class);
            String[] stringArray2 = EnumStrings.getStrings((Class)eClass.class);
            try {
                this.description = this.node.dbName() + "-0x" + Integer.toHexString(this.entityIndex) + ", " + stringArray[this.getEqType()] + "/" + stringArray2[this.genericClass.value()] + " @" + this.positionInParent;
            }
            catch (CmsCommFailException cmsCommFailException) {
                edb.println("Caught CmsCommFailException in toString");
                if (edb.on()) {
                    SDebug.printStackTrace((Throwable)((Object)cmsCommFailException));
                }
                this.description = "UNKNOWN";
            }
        }
        return this.description;
    }

    public String getEqTypeName() {
        try {
            return EntityModel.eqType2Name(Model.getTDMTerminology(this), this.getEqTypeEnum());
        }
        catch (AnnotatedException annotatedException) {
            return "?";
        }
    }

    public static String eqType2Name(TDMTerminology tDMTerminology, int n) {
        switch (n) {
            case 130: {
                return "OPT-BST";
            }
            case 129: {
                return "OPT-PRE";
            }
            case 239: {
                return "OPT-BST L";
            }
            case 240: {
                return "OPT-AMP L";
            }
            case 196: {
                return "OPT-BST E";
            }
            case 127: {
                return "OSCM";
            }
            case 128: {
                return "OSC-CSM";
            }
            case 137: {
                return "AD-1B";
            }
            case 138: {
                return "AD-4B";
            }
            case 134: {
                return "AD-1C";
            }
            case 135: {
                return "AD-2C";
            }
            case 136: {
                return "AD-4C";
            }
        }
        return EqTypeHelper.eqTypeToName((TDMTerminology)tDMTerminology, (int)n);
    }

    public static final String eqType2Name(TDMTerminology tDMTerminology, eEqType eEqType2) {
        if (eEqType2 == null) {
            return null;
        }
        int n = eEqType2.value();
        return EntityModel.eqType2Name(tDMTerminology, n);
    }

    public static final eEqType name2EqType(NodeModelDelegate nodeModelDelegate, String string) {
        if (string.compareTo("OPT-BST") == 0) {
            string = "Optical booster";
        }
        if (string.compareTo("OPT-PRE") == 0) {
            string = "Optical preamplifier";
        }
        if (string.compareTo("OPT-BST L") == 0) {
            string = "Optical booster L";
        }
        if (string.compareTo("OPT-AMP L") == 0) {
            string = "Optical amplifier L";
        }
        if (string.compareTo("OPT-BST E") == 0) {
            string = "Optical booster ENH";
        }
        if (string.compareTo("OSC-CSM") == 0) {
            string = "OSC + Combiner/Separator";
        }
        if (string.compareTo("OSCM") == 0) {
            string = "OSC Module";
        }
        if (string.compareTo("AD-1B") == 0) {
            string = "OADM 1 band";
        }
        if (string.compareTo("AD-4B") == 0) {
            string = "OADM 4 bands";
        }
        if (string.compareTo("AD-1C") == 0) {
            string = "OADM 1 channel";
        }
        if (string.compareTo("AD-2C") == 0) {
            string = "OADM 2 channels";
        }
        if (string.compareTo("AD-4C") == 0) {
            string = "OADM 4 channels";
        }
        int n = nodeModelDelegate.getPlatform().eqTypeName2EqType(string);
        return eEqType.from_int(n);
    }

    public int getMediumType() {
        int n = 1;
        int n2 = this.getEqType();
        if (n2 == 28 || n2 == 29 || n2 == 30 || n2 == 61) {
            IPortModel iPortModel = (IPortModel)this;
            TdmLineModel tdmLineModel = (TdmLineModel)iPortModel.getInterfaceModel();
            try {
                n = tdmLineModel.getLineInfoMediumType();
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return n;
    }

    public int getPayloadType() {
        IFramingType iFramingType = FramingType.getFramingType((int)this.getFramingType());
        int n = 0;
        int n2 = this.getMediumType();
        int n3 = this.getEqType();
        switch (n3) {
            case 28: 
            case 29: 
            case 30: 
            case 61: {
                if (iFramingType.isSonet() && n2 == 0) {
                    n = 7;
                    break;
                }
                n = iFramingType.getOpticalPayloadType();
                break;
            }
            case 114: {
                eStm1eMode eStm1eMode2 = null;
                try {
                    eStm1eMode2 = ((TdmPortModel)this).getTdmLineModel().getStm1eMode();
                }
                catch (Exception exception) {
                    edb.severe("Can't get STM1E mode from a STM1E port");
                    SDebug.printStackTrace((Throwable)exception);
                }
                if (eStm1eMode2 == eStm1eMode.STM_MODE) {
                    n = 9;
                    break;
                }
                if (eStm1eMode2 == eStm1eMode.E4_FRAMED_MODE) {
                    n = 15;
                    break;
                }
                if (eStm1eMode2 != eStm1eMode.E4_UNFRAMED_MODE) break;
                n = 16;
                break;
            }
            case 31: {
                n = 2;
                break;
            }
            case 32: {
                n = 3;
                break;
            }
            case 33: {
                n = 4;
                break;
            }
            case 4: 
            case 5: 
            case 34: 
            case 218: {
                n = 5;
                break;
            }
            case 197: {
                n = 5;
                break;
            }
            case 35: 
            case 36: {
                n = 13;
                break;
            }
            case 14: 
            case 15: {
                n = 6;
                break;
            }
            case 63: {
                n = 8;
                break;
            }
            case 105: {
                n = 14;
                break;
            }
            case 165: 
            case 231: {
                n = 18;
                break;
            }
            case 64: 
            case 68: 
            case 83: 
            case 108: 
            case 109: {
                n = 10;
                break;
            }
            case 65: {
                n = 11;
                break;
            }
            case 66: 
            case 67: {
                n = 12;
                break;
            }
            case 144: {
                n = 17;
                break;
            }
            default: {
                n = 0;
                edb.severe("getPayloadType(): UNKNOWN payload type returned for " + this.getEqTypeName() + ", eqType " + n3);
            }
        }
        return n;
    }

    public ILoNum getMaxLo(int n) {
        return null;
    }

    public int getMaxVt() {
        throw new DeprecatedMethodCalled("FTG deprecated: EntityModel.getMaxVt()");
    }

    public List getConnectionsList() {
        return new LinkedList();
    }

    public boolean isCompatiblePGEntity(IEntityModel iEntityModel) {
        boolean bl = false;
        if (this.getEqType() == 65) {
            bl = iEntityModel.getEqType() == 65 || iEntityModel instanceof IPortModel && ((IPortModel)iEntityModel).isOptical();
        } else if (this.getEqType() == 66 || this.getEqType() == 67) {
            bl = iEntityModel.getEqType() == 66 || iEntityModel.getEqType() == 67 || iEntityModel instanceof IPortModel && ((IPortModel)iEntityModel).isOptical();
        } else if (this instanceof IPortModel && ((IPortModel)this).isOptical()) {
            bl = iEntityModel instanceof IModuleModel && ((IModuleModel)iEntityModel).isValidPGElectricalCard();
        }
        return bl;
    }

    protected UNKNOWN doUnknown(String string, UserException userException) {
        edb.warning("Caught " + (Object)((Object)userException) + " in " + string);
        if (edb.on()) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return new UNKNOWN("Caught " + (Object)((Object)userException) + " in " + string);
    }

    public boolean supportsJ1PathTrace(CircuitType circuitType) {
        return PathTraceUtil.supportsJ1PathTrace((IEntityModel)this, (ICircuitType)circuitType);
    }

    public boolean onPortlessPort() {
        IModuleModel iModuleModel = this.getModuleModel();
        return iModuleModel != null && iModuleModel.getEqType() == 145 && this.getPort() > 12;
    }

    public boolean onPairPortlessPorts(IEntityModel iEntityModel) {
        if (this.onPortlessPort() && iEntityModel.onPortlessPort()) {
            IEntityModel iEntityModel2;
            EntityModel entityModel;
            if (this.getPort() < iEntityModel.getPort()) {
                entityModel = this;
                iEntityModel2 = iEntityModel;
            } else {
                entityModel = iEntityModel;
                iEntityModel2 = this;
            }
            if (iEntityModel2.getPort() % 2 == 0 && entityModel.getPort() + 1 == iEntityModel2.getPort()) {
                return true;
            }
        }
        return false;
    }

    public boolean conditionExist(String string) {
        IAlarmStore iAlarmStore = this.node.getElementAlarmStore();
        int n = this.node.getAlarmDecoder().getCondition(string, 0);
        ArrayList arrayList = iAlarmStore.getAlarmByCondition(n);
        Iterator iterator = arrayList.iterator();
        EventInfo eventInfo = null;
        while (iterator.hasNext()) {
            eventInfo = (EventInfo)iterator.next();
            if (eventInfo.getIndex() != this.getIndex() || eventInfo.getState() == 'C') continue;
            return true;
        }
        return false;
    }

    boolean supportXC() {
        return false;
    }

    public boolean inRPRMode() {
        int n = this.getEqType();
        boolean bl = false;
        IModuleModel iModuleModel = this.getModuleModel();
        if (iModuleModel != null) {
            bl = iModuleModel.isRPRMode();
        }
        return bl;
    }

    public IEntityModel isProtected() {
        IEntityModel iEntityModel = null;
        ModuleModel moduleModel = (ModuleModel)this.getModuleModel();
        if (this instanceof PortModel) {
            try {
                PortModel portModel = (PortModel)this;
                InterfaceModel interfaceModel = (InterfaceModel)portModel.getInterfaceModel();
                ElementModel elementModel = interfaceModel.getElementModel();
                if (elementModel instanceof OnePlusOneModel) {
                    OnePlusOneModel onePlusOneModel = (OnePlusOneModel)elementModel;
                    iEntityModel = this == onePlusOneModel.getProtectEntityModel() ? onePlusOneModel.getMainEntityModel() : onePlusOneModel.getProtectEntityModel();
                } else if (elementModel instanceof YCableModel) {
                    YCableModel yCableModel = (YCableModel)elementModel;
                    iEntityModel = this == yCableModel.getProtectEntityModel() ? yCableModel.getMainEntityModel() : yCableModel.getProtectEntityModel();
                } else if (moduleModel.getProtectionGroupModel() != null) {
                    ProtectionGroupModel protectionGroupModel = moduleModel.getProtectionGroupModel();
                    iEntityModel = protectionGroupModel.getProtectModuleModel();
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return iEntityModel;
    }

    public IEntityModel isYCableProtected() {
        IEntityModel iEntityModel;
        block6: {
            iEntityModel = null;
            ModuleModel moduleModel = (ModuleModel)this.getModuleModel();
            if (this instanceof PortModel) {
                try {
                    YCableModel yCableModel;
                    PortModel portModel = (PortModel)this;
                    InterfaceModel interfaceModel = (InterfaceModel)portModel.getInterfaceModel();
                    ElementModel elementModel = interfaceModel.getElementModel();
                    if (elementModel instanceof YCableModel && (yCableModel = (YCableModel)elementModel).getType() == 4) {
                        iEntityModel = this == yCableModel.getProtectEntityModel() ? yCableModel.getMainEntityModel() : yCableModel.getProtectEntityModel();
                    }
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    if (this.db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) break block6;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return iEntityModel;
    }

    public int compareTo(Object object) {
        try {
            return comparator.compare(this, object);
        }
        catch (ClassCastException classCastException) {
            return 1;
        }
    }

    static class ChildComparator
    extends ParentComparator {
        ChildComparator() {
        }

        public int compare(Object object, Object object2) throws ClassCastException {
            int n;
            EntityModel entityModel = (EntityModel)object;
            EntityModel entityModel2 = (EntityModel)object2;
            int n2 = entityModel.getIndex();
            int n3 = n2 == (n = entityModel2.getIndex()) ? 0 : (this.isAncestorOf(entityModel, entityModel2) ? 1 : (this.isAncestorOf(entityModel2, entityModel) ? -1 : (n2 < n ? 1 : -1)));
            return n3;
        }
    }

    static class ParentComparator
    implements Comparator {
        ParentComparator() {
        }

        public int compare(Object object, Object object2) throws ClassCastException {
            int n;
            EntityModel entityModel = (EntityModel)object;
            EntityModel entityModel2 = (EntityModel)object2;
            int n2 = entityModel.getIndex();
            int n3 = n2 == (n = entityModel2.getIndex()) ? 0 : (this.isAncestorOf(entityModel, entityModel2) ? -1 : (this.isAncestorOf(entityModel2, entityModel) ? 1 : (n2 < n ? -1 : 1)));
            return n3;
        }

        protected boolean isAncestorOf(EntityModel entityModel, EntityModel entityModel2) {
            while (entityModel2.parent != null) {
                if (entityModel.index == entityModel2.parent.index) {
                    return true;
                }
                entityModel2 = entityModel2.parent;
            }
            return false;
        }
    }

    public static class EntityModelComparator
    implements Comparator {
        private int cmp(EntityModel entityModel, EntityModel entityModel2) {
            int n = 0;
            int n2 = entityModel.getPositionInParent();
            int n3 = entityModel2.getPositionInParent();
            int n4 = entityModel.getEntityIndex();
            int n5 = entityModel2.getEntityIndex();
            int n6 = entityModel.getEqType();
            int n7 = entityModel2.getEqType();
            if (n2 < n3) {
                n = -1;
            } else if (n2 > n3) {
                n = 1;
            } else if (n4 < n5) {
                n = -1;
            } else if (n4 > n5) {
                n = 1;
            } else if (n6 < n7) {
                n = -1;
            } else if (n6 > n7) {
                n = 1;
            } else if (entityModel.parent != null) {
                n = entityModel2.parent != null ? this.cmp(entityModel.parent, entityModel2.parent) : -1;
            } else if (entityModel2.parent != null) {
                n = 1;
            }
            return n;
        }

        public int compare(Object object, Object object2) throws ClassCastException {
            EntityModel entityModel;
            EntityModel entityModel2;
            int n = 0;
            if (object != object2 && (n = this.cmp(entityModel2 = (EntityModel)object, entityModel = (EntityModel)object2)) == 0) {
                int n2;
                int n3 = entityModel2.getNodeModelDelegate().getNodeId();
                if (n3 < (n2 = entityModel.getNodeModelDelegate().getNodeId())) {
                    n = -1;
                } else if (n3 > n2) {
                    n = 1;
                }
            }
            return n;
        }
    }

    class SuppressAlarms
    extends NonCachedValue {
        public SuppressAlarms(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(EntityModel.this.getEntityRef().suppressAlarms());
        }

        protected void setValue(Object object) throws UserException {
            if (edb.on) {
                edb.println("SuppressAlarms::setValue(" + (Boolean)object + ") -- EntityModel.this.getEntityRef() = " + EntityModel.this.getEntityRef());
            }
            EntityModel.this.getEntityRef().suppressAlarms((Boolean)object);
        }

        public Object outer() {
            return EntityModel.this;
        }
    }

    class AlarmProfileName
    extends CachedValue {
        public AlarmProfileName(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return EntityModel.this.getEntityRef().getAlarmProfileName();
        }

        protected void setValue(Object object) throws UserException {
            EntityModel.this.getEntityRef().setAlarmProfileName((String)object);
        }

        public Object outer() {
            return EntityModel.this;
        }
    }

    class EquipmentType
    extends CachedValue {
        public EquipmentType(NodeModelDelegate nodeModelDelegate, String string, eEqType eEqType2) {
            super(nodeModelDelegate, string, eEqType2);
        }

        protected Object getValue() throws UserException {
            return EntityModel.this.getEntityRef().entityInfo().eqType;
        }

        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return EntityModel.this;
        }
    }

    class GenericClass
    extends NonCachedValue {
        public GenericClass(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return EntityModel.this.genericClass;
        }

        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return EntityModel.this;
        }
    }

    class PositionInParent
    extends NonCachedValue {
        public PositionInParent(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Integer(EntityModel.this.positionInParent);
        }

        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return EntityModel.this;
        }
    }

    class ParentId
    extends NonCachedValue {
        public ParentId(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Integer(EntityModel.this.parent != null ? EntityModel.this.parent.getIndex() : -1);
        }

        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return EntityModel.this;
        }
    }

    class ChildrenIndex
    extends NonCachedValue {
        public ChildrenIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object getValue() throws UserException {
            Set set = EntityModel.this.children;
            synchronized (set) {
                int[] nArray = new int[EntityModel.this.children.size()];
                int n = 0;
                Iterator iterator = EntityModel.this.children.iterator();
                while (iterator.hasNext()) {
                    nArray[n++] = ((Model)iterator.next()).getIndex();
                }
                return nArray;
            }
        }

        public Object outer() {
            return EntityModel.this;
        }
    }
}

