/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eReversionMode;
import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.Equipment.EntityTable;
import cerent.cms.idl.Equipment.IModule;
import cerent.cms.idl.Equipment.ProtectionGroup;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eProtectionType;
import cerent.cms.idl.Equipment.sEntity;
import cerent.cms.idl.Equipment.sEntityListElem;
import cerent.cms.idl.Equipment.sProtGroupListElem;
import cerent.cms.idl.Equipment.sProtectionConfig;
import cerent.cms.idl.Equipment.sShelfPosition;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.Equipment.xInvalidData;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.SonetTopology.eOnePlusOneType;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ErrorMsgFormatter;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.Feature;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IModelPersistenceStrategy;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.IVcatTermAttributes;
import cerent.cms.model.IVcatTermModels;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.ShelfSlotBundle;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.ElementComparator;
import cerent.util.ComparisonUtil;
import cerent.util.EMC;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.UserException;

public class EntityTableModel
extends Model
implements IEntityTableModel {
    public static final int NC_SHELF_ID = 1;
    private NodeModelDelegate nmd;
    private TreeMap entityModelTable = new TreeMap();
    private LastChange lastChange;
    private ProtectionGroupList protectionGroupList;
    private ProvisionProtectionGroup provisionProtectionGroup;
    private ProvisionShelf provisionShelf;
    private ProvisionModule provisionModule;
    private ProvisionPluggable provisionPluggable;
    private ProvisionPort provisionPort;
    private UnprovisionPort unprovisionPort;
    private EntityList entityList;
    private ChassisEntities chassisEntities;
    private EntitiesByIndex entitiesByIndex;
    private TestAllLeds testAllLeds;
    private static ModelSingletonCollection entityTableModelSingletons;
    private EventDispatcher dispatcher;
    private GetPortTypeList getPortTypeList;

    private EntityTable getEntityTableRef() {
        return this.nmd.getIorRepository().getEntityTableRef();
    }

    public static synchronized EntityTableModel getInstance(NodeModelDelegate nodeModelDelegate) {
        EntityTableModel entityTableModel;
        if (entityTableModelSingletons == null) {
            entityTableModelSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"EntityTableModel");
        }
        if ((entityTableModel = (EntityTableModel)entityTableModelSingletons.get((Object)nodeModelDelegate)) == null) {
            entityTableModel = new EntityTableModel(nodeModelDelegate);
            entityTableModelSingletons.add((Object)nodeModelDelegate, (Object)entityTableModel);
        }
        return entityTableModel;
    }

    protected EntityTableModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(EntityTableModel.class));
        this.nmd = nodeModelDelegate;
        this.lastChange = new LastChange(this.nmd, "EntityTableModel.lastChange");
        this.protectionGroupList = new ProtectionGroupList(this.nmd, "EntityTableModel.protectionGroupList");
        this.provisionProtectionGroup = new ProvisionProtectionGroup(this.nmd, "EntityTableModel.provisionProtectionGroup");
        this.provisionShelf = new ProvisionShelf(this.nmd, "EntityTableModel.provisionShelf");
        this.provisionModule = new ProvisionModule(this.nmd, "EntityTableModel.provisionModule");
        this.provisionPluggable = new ProvisionPluggable(this.nmd, "EntityTableModel.provisionPluggable");
        this.provisionPort = new ProvisionPort(nodeModelDelegate, "EntityTableModel.provisionPort");
        this.unprovisionPort = new UnprovisionPort(nodeModelDelegate, "EntityTableModel.unprovisionPort");
        this.getPortTypeList = new GetPortTypeList(nodeModelDelegate, "EntityTableModel.getPortTypeList");
        this.entityList = new EntityList(this.nmd, "EntityTableModel.entityList");
        this.chassisEntities = new ChassisEntities(this.nmd, "EntityTableModel.chassisEntities");
        this.entitiesByIndex = new EntitiesByIndex(this.nmd, "EntityTableModel.entitiesByIndex");
        this.testAllLeds = new TestAllLeds(this.nmd, "EntityTableModel.testAllLeds");
        this.index = 0;
        this.dispatcher = null;
    }

    private EntityTableModel() {
        super(new SDebug("EntityTableModel"));
        this.index = 0;
        this.dispatcher = null;
        System.out.println("WARNING: You had better be running the Circuit Provisioning Unit Test.");
    }

    public void init() throws IllegalStateException {
        this.db.addCommand(this, "dump", "Dump entity table as a tree");
        this.db.addCommand(this, "printTable", "Print entity table (with indices)");
        super.init0();
        this.discoverEntityTable();
        ChassisModels chassisModels = this.nmd.getChassisModelsInstance();
        Iterator iterator = this.getEntityModelsByClass(eClass.CHASSIS).iterator();
        while (iterator.hasNext()) {
            ChassisModel chassisModel = (ChassisModel)iterator.next();
            chassisModel.initAll();
            chassisModels.addChassis(chassisModel);
        }
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectEntityTable, 0, (Observer)this);
        }
    }

    public void destroy() {
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.db.info("dispose() entry");
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectEntityTable, 0, (Observer)this);
        }
        TreeSet treeSet = new TreeSet(new EntityModel.ChildComparator());
        Object object = this;
        synchronized (object) {
            treeSet.addAll(this.entityModelTable.values());
            this.entityModelTable.clear();
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            EntityModel.destroyEntity((EntityModel)object.next());
        }
        treeSet = null;
        this.db.removeCommand(this, "dump");
        this.db.removeCommand(this, "printTable");
        super.dispose();
        this.db.info("dispose() exit");
    }

    private String toString(eEqType eEqType2) {
        return EnumStrings.getStrings((Class)eEqType.class)[eEqType2.value()];
    }

    private String toString(eClass eClass2) {
        return EnumStrings.getStrings((Class)eClass.class)[eClass2.value()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void discoverEntityTable() throws IllegalStateException {
        try {
            this.db.fine("***** discoverEntityTable *****");
            sEntityListElem[] sEntityListElemArray = this;
            synchronized (this) {
                this.entityModelTable.clear();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                sEntityListElemArray = this.getChassisEntities();
                this.db.fine("NE has " + sEntityListElemArray.length + " shelves.");
                for (int i = 0; i < sEntityListElemArray.length; ++i) {
                    this.discoverEntityTableByChassis(sEntityListElemArray[i].entityData.index);
                }
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.dispose();
            throw abstractCmsIOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void discoverEntityTableByChassis(int n) throws IllegalStateException {
        try {
            Comparable<Integer> comparable;
            sEntity sEntity2;
            sEntityListElem sEntityListElem2;
            int n2;
            long l;
            long l2 = l = System.currentTimeMillis();
            this.db.fine("discoverEntityTableByChassis(" + Integer.toHexString(n) + ")");
            sEntityListElem[] sEntityListElemArray = this.getEntitiesByIndex(n);
            TreeMap<Integer, EntityModel> treeMap = new TreeMap<Integer, EntityModel>();
            long l3 = System.currentTimeMillis();
            this.db.fine("Finished Phase 1: getEntitiesByIndex " + (l3 - l2) + "ms (Total " + (l3 - l) + "ms) #entites=" + sEntityListElemArray.length);
            l2 = l3;
            for (n2 = 0; n2 < sEntityListElemArray.length; ++n2) {
                sEntityListElem2 = sEntityListElemArray[n2];
                sEntity2 = sEntityListElem2.entityData;
                comparable = new Integer(sEntity2.index);
                EntityModel entityModel = this.nmd.getEntityModelFactory().makeEntityModel(sEntityListElem2.ent, sEntity2.index, sEntity2.eqType, sEntity2.genericClass, sEntity2.posInParent);
                treeMap.put((Integer)comparable, entityModel);
            }
            l3 = System.currentTimeMillis();
            this.db.fine("Finished Phase 2: Build Entity Model and TreeMap " + (l3 - l2) + "ms (Total " + (l3 - l) + "ms) #entities=" + treeMap.size());
            l2 = l3;
            for (n2 = 0; n2 < sEntityListElemArray.length; ++n2) {
                sEntityListElem2 = sEntityListElemArray[n2];
                sEntity2 = sEntityListElem2.entityData;
                comparable = (EntityModel)treeMap.get(new Integer(sEntity2.index));
                int n3 = sEntity2.parent;
                if (0 == n3) continue;
                EntityModel entityModel = (EntityModel)treeMap.get(new Integer(n3));
                if (entityModel == null) {
                    String string = "id=" + Integer.toHexString(sEntity2.index) + "/spcType=" + this.toString(sEntity2.eqType) + "/genType=" + this.toString(sEntity2.genericClass) + "/parent=" + Integer.toHexString(sEntity2.parent);
                    this.db.severe("parent not found: " + string);
                    throw new IllegalStateException("EntityTable contains an entry with a non-existent parent(" + string + ")");
                }
                entityModel.add((EntityModel)comparable);
            }
            l3 = System.currentTimeMillis();
            this.db.fine("Finished Phase 3: Build Entity Model parent/child tree " + (l3 - l2) + "ms (Total " + (l3 - l) + "ms)");
            l2 = l3;
            EntityTableModel entityTableModel = this;
            synchronized (entityTableModel) {
                this.entityModelTable.putAll(treeMap);
            }
            l3 = System.currentTimeMillis();
            this.db.fine("Finished Phase 4: Replace the entity tree map " + (l3 - l2) + "ms (Total " + (l3 - l) + "ms) #entities=" + this.entityModelTable.size());
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.dispose();
            throw abstractCmsIOException;
        }
    }

    protected void addModel(IEntityModel iEntityModel) {
        this.entityModelTable.put(new Integer(iEntityModel.getIndex()), iEntityModel);
    }

    public void removeModel(IEntityModel iEntityModel) {
        if (iEntityModel != null) {
            this.db.fine("removeModel(" + iEntityModel + ")");
            this.entityModelTable.remove(new Integer(iEntityModel.getIndex()));
        }
    }

    public synchronized List getEntityModelTable() {
        return new ArrayList(this.entityModelTable.values());
    }

    public synchronized List getModuleEntities() {
        ArrayList<EntityModel> arrayList = new ArrayList<EntityModel>();
        Iterator iterator = this.entityModelTable.values().iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            eClass eClass2 = entityModel.genericClass;
            if (eClass2 == eClass.PORT || eClass2 == eClass.E_SENSOR || eClass2 == eClass.SENSOR_OUTPUT) continue;
            arrayList.add(entityModel);
        }
        return arrayList;
    }

    public synchronized List getPortEntities() {
        ArrayList<EntityModel> arrayList = new ArrayList<EntityModel>();
        Iterator iterator = this.entityModelTable.values().iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            eClass eClass2 = entityModel.genericClass;
            if (eClass2 != eClass.PORT && eClass2 != eClass.E_SENSOR && eClass2 != eClass.SENSOR_OUTPUT) continue;
            arrayList.add(entityModel);
        }
        return arrayList;
    }

    public synchronized List getEntityModelsByClass(eClass eClass2) {
        ArrayList<EntityModel> arrayList = new ArrayList<EntityModel>();
        Iterator iterator = this.entityModelTable.values().iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            eClass eClass3 = entityModel.genericClass;
            if (eClass3 != eClass2) continue;
            arrayList.add(entityModel);
        }
        return arrayList;
    }

    public synchronized List filterEntitiesByClass(eClass[] eClassArray) {
        ArrayList<EntityModel> arrayList = new ArrayList<EntityModel>();
        int n = eClassArray.length;
        Iterator iterator = this.entityModelTable.values().iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            eClass eClass2 = entityModel.genericClass;
            for (int i = 0; i < n; ++i) {
                if (eClass2 != eClassArray[i]) continue;
                arrayList.add(entityModel);
            }
        }
        return arrayList;
    }

    private long getLastChange() {
        try {
            return (Long)this.lastChange.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getlastChange", userException);
        }
    }

    public sProtGroupListElem[] getProtectionGroupList() {
        try {
            return (sProtGroupListElem[])this.protectionGroupList.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getProtectionGroupList", userException);
        }
    }

    public Integer[] getElementIndices() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator = this.entityModelTable.values().iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            eClass eClass2 = entityModel.genericClass;
            if (eClass2 != eClass.PORT && eClass2 != eClass.E_MODULE) continue;
            arrayList.add(new Integer(entityModel.getEntityIndex()));
        }
        return arrayList.toArray(new Integer[0]);
    }

    public IEntityModel getEntityModelByIndex(int n) throws AbstractCmsNoSuchEntityException {
        IEntityModel iEntityModel = null;
        iEntityModel = (IEntityModel)this.entityModelTable.get(new Integer(n));
        if (iEntityModel == null) {
            throw new CmsNoSuchEntityException("Entity Model does not exist for index = 0x" + Integer.toHexString(n) + ".\nThis is a normal result of some race conditions.");
        }
        return iEntityModel;
    }

    public IEntityModel getEntityModelBySlot(int n) throws AbstractCmsNoSuchEntityException {
        return this.getEntityModelBySlot(1, n);
    }

    public IEntityModel getEntityModelBySlot(int n, int n2) throws AbstractCmsNoSuchEntityException {
        ChassisModels chassisModels = this.nmd.getChassisModelsInstance();
        return this.getEntityModelBySlot(chassisModels.getChassisByShelfId(n), n2);
    }

    public IEntityModel getEntityModelBySlot(IChassisModel iChassisModel, int n) throws AbstractCmsNoSuchEntityException {
        EntityModel entityModel = null;
        if (iChassisModel != null) {
            EntityModel entityModel2 = (EntityModel)iChassisModel.getChildren().get(0);
            Iterator iterator = entityModel2.getChildrenOfType(eClass.CONTAINER).iterator();
            while (iterator.hasNext()) {
                EntityModel entityModel3 = (EntityModel)iterator.next();
                if (entityModel3.getPositionInParent() != n) continue;
                entityModel = entityModel3;
                break;
            }
        } else {
            throw new CmsNoSuchEntityException("Entity Model does not exist for " + iChassisModel + ", slot " + n);
        }
        return entityModel;
    }

    public int removePersistentStateInEmptySlots() {
        ChassisModels chassisModels = this.nmd.getChassisModelsInstance();
        IChassisModel[] iChassisModelArray = chassisModels.getChassisModelsArray();
        int n = 0;
        for (int i = 0; i < iChassisModelArray.length; ++i) {
            n += this.removePersistentStateInEmptySlots(iChassisModelArray[i].getShelfId());
        }
        return n;
    }

    public int removePersistentStateInEmptySlots(int n) {
        ChassisModels chassisModels = this.nmd.getChassisModelsInstance();
        IChassisModel iChassisModel = chassisModels.getChassisByShelfId(n);
        EntityModel entityModel = (EntityModel)iChassisModel.getChildren().get(0);
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getNodeModel();
        IModelPersistenceStrategy iModelPersistenceStrategy = nodeModelDelegate.getModelPersistenceStrategy(InterfaceModel.class);
        int n2 = 0;
        if (!iModelPersistenceStrategy.doesGetReallyPersisted(null)) {
            return n2;
        }
        Iterator iterator = entityModel.getChildrenOfType(eClass.CONTAINER).iterator();
        int n3 = nodeModelDelegate.getPersistenceId();
        while (iterator.hasNext()) {
            EntityModel entityModel2 = (EntityModel)iterator.next();
            List list = entityModel2 == null ? null : entityModel2.getChildren();
            IEntityModel iEntityModel = list == null || list.size() == 0 ? null : list.get(0);
            if (entityModel2 == null || iEntityModel != null) continue;
            short s = (short)entityModel2.getPositionInParent();
            ModuleModel.deleteIfPersistedState(this.db, iModelPersistenceStrategy, n3, s);
            ++n2;
        }
        return n2;
    }

    public boolean hasCardNamed(String string) {
        boolean bl = false;
        ChassisModels chassisModels = this.nmd.getChassisModelsInstance();
        IChassisModel[] iChassisModelArray = chassisModels.getChassisModelsArray();
        for (int i = 0; !bl && i < iChassisModelArray.length; ++i) {
            bl = this.hasCardNamed(iChassisModelArray[i], string);
        }
        return bl;
    }

    public boolean hasCardNamed(IChassisModel iChassisModel, String string) {
        EntityModel entityModel = (EntityModel)iChassisModel.getChildren().get(0);
        Iterator iterator = entityModel.getChildrenOfType(eClass.CONTAINER).iterator();
        while (iterator.hasNext()) {
            ModuleModel moduleModel;
            EntityModel entityModel2 = (EntityModel)iterator.next();
            List list = entityModel2.getChildren();
            if (list.size() <= 0 || !(list.get(0) instanceof ModuleModel) || !(moduleModel = (ModuleModel)list.get(0)).isCardNamed(string)) continue;
            return true;
        }
        return false;
    }

    public IEntityModel getChassis() {
        return this.nmd.getNcChassis();
    }

    public void provisionProtectionGroupModel(String string, eProtectionType eProtectionType2, eReversionMode eReversionMode2, int n, IModuleModel iModuleModel, IModuleModel[] iModuleModelArray) throws ProvisionError, ResourceInUse {
        try {
            this.db.info("provisionProtectionGroupModel(): entry");
            sProtectionConfig sProtectionConfig2 = new sProtectionConfig();
            sProtectionConfig2.name = string;
            sProtectionConfig2.protectType = eProtectionType2;
            sProtectionConfig2.reversion = new sRevertiveBehavior(eReversionMode2, n);
            ModuleModel moduleModel = (ModuleModel)iModuleModel;
            sProtectionConfig2.protectModule = moduleModel.getIModuleRef();
            sProtectionConfig2.mainModules = new IModule[iModuleModelArray.length];
            for (int i = 0; i < iModuleModelArray.length; ++i) {
                ModuleModel moduleModel2 = (ModuleModel)iModuleModelArray[i];
                sProtectionConfig2.mainModules[i] = moduleModel2.getIModuleRef();
            }
            this.db.fine("Before calling pgRef = provisionProtectionGroup");
            ProtectionGroup protectionGroup = (ProtectionGroup)this.provisionProtectionGroup.get(sProtectionConfig2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "provisionProtectionGroupModel", userException);
        }
    }

    public ProtectionGroupModel[] getProtectionGroupModelArray() {
        this.db.info("getProtectionGroupModelArray(): entry");
        return this.nmd.getProtectionGroupModels().getProtectionGroupModelArray();
    }

    private boolean is454SdhChassis() {
        return this.getChassis().getEqType() == 71;
    }

    public IModuleModel[] getAvailableProtectModules(eProtectionType eProtectionType2) {
        ArrayList<IModuleModel> arrayList = new ArrayList<IModuleModel>();
        ChassisModels chassisModels = this.nmd.getChassisModelsInstance();
        IChassisModel[] iChassisModelArray = chassisModels.getChassisModelsArray();
        this.db.fine("getAvailableProtectModules(): entry");
        for (int i = 0; i < iChassisModelArray.length; ++i) {
            arrayList.addAll(Arrays.asList(this.getAvailableProtectModules(iChassisModelArray[i], eProtectionType2)));
        }
        return arrayList.toArray(new ModuleModel[arrayList.size()]);
    }

    public IModuleModel[] getAvailableProtectModules(IChassisModel iChassisModel, eProtectionType eProtectionType2) {
        List list = new ArrayList();
        this.db.fine("getAvailableProtectModules(" + iChassisModel + ", " + eProtectionType2 + "): entry");
        if (iChassisModel != null) {
            list = ((EntityModel)((Object)iChassisModel)).getDescendantsOfType(eClass.E_MODULE);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ModuleModel)) {
                iterator.remove();
                continue;
            }
            ModuleModel moduleModel = (ModuleModel)e;
            EntityModel entityModel = moduleModel.getAncestorOfType(eClass.CONTAINER);
            int n = entityModel.getPositionInParent();
            boolean bl = false;
            block0 : switch (eProtectionType2.value()) {
                case 1: {
                    if ((entityModel.getEqType() != 21 || (n & 1) != 1) && ((n & 1) != 0 || moduleModel.getEqType() != 113) || moduleModel.getState() == eEqState.DELETED) {
                        bl = true;
                    } else {
                        switch (moduleModel.getEqType()) {
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 12: 
                            case 13: 
                            case 57: 
                            case 58: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 83: 
                            case 145: 
                            case 197: {
                                if (n < 7 || n <= 12) break;
                                break;
                            }
                            case 113: {
                                if ((n & 1) == 0 && n > 13) {
                                    bl = true;
                                }
                                if ((n & 1) != 1 || n >= 5) break;
                                bl = true;
                                break;
                            }
                            default: {
                                bl = true;
                            }
                        }
                    }
                    if (bl || n != 5 && n != 13 || !this.is454SdhChassis()) break;
                    bl = true;
                    break;
                }
                case 0: {
                    if (moduleModel.getState() == eEqState.DELETED) {
                        bl = true;
                        break;
                    }
                    if (moduleModel.getEqType() == 248) break;
                    switch (moduleModel.getEqType()) {
                        case 5: 
                        case 7: 
                        case 13: 
                        case 58: 
                        case 64: 
                        case 67: 
                        case 108: 
                        case 109: 
                        case 145: 
                        case 185: 
                        case 197: 
                        case 218: {
                            break block0;
                        }
                        case 113: {
                            bl = true;
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (!bl && moduleModel.getProtectionGroupModel() == null) continue;
            iterator.remove();
        }
        if (this.db.on()) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                this.db.println("    " + iterator.next());
            }
            this.db.println("getAvailableProtectModules(): exit");
        }
        return list.toArray(new ModuleModel[0]);
    }

    public List getModuleModelSupportedRegenGroup() {
        IEntityModel[] iEntityModelArray = this.nmd.getChassisModels();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            List list = ((EntityModel)iEntityModelArray[i]).getDescendantsOfType(eClass.E_MODULE);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof DwdmModuleModel) || !((DwdmModuleModel)e).supportRegenGroup()) continue;
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    public List getCompatibleModuleModelForRegenGroup(DwdmModuleModel dwdmModuleModel) {
        List list = this.getModuleModelSupportedRegenGroup();
        int n = dwdmModuleModel.getEqType();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DwdmModuleModel dwdmModuleModel2 = (DwdmModuleModel)iterator.next();
            eEqState eEqState2 = dwdmModuleModel2.getState();
            if (dwdmModuleModel2 != dwdmModuleModel && dwdmModuleModel2.getEqType() == n && eEqState2 != eEqState.DELETED) continue;
            iterator.remove();
        }
        return list;
    }

    public IModuleModel[] getCompatibleMainModules(ModuleModel moduleModel, eProtectionType eProtectionType2) {
        List list = new ArrayList();
        int n = moduleModel.getSlot();
        eEqType eEqType2 = eEqType.from_int(moduleModel.getEqType());
        list = ((EntityModel)((Object)moduleModel.getChassis())).getDescendantsOfType(eClass.E_MODULE);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ModuleModel)) {
                iterator.remove();
                continue;
            }
            ModuleModel moduleModel2 = (ModuleModel)e;
            if (moduleModel2 == moduleModel) {
                iterator.remove();
                continue;
            }
            EntityModel entityModel = moduleModel2.getAncestorOfType(eClass.CONTAINER);
            int n2 = entityModel.getPositionInParent();
            eEqType eEqType3 = eEqType.from_int(moduleModel2.getEqType());
            boolean bl = false;
            switch (eProtectionType2.value()) {
                case 1: {
                    if (entityModel.getEqType() != 21 || (n2 >= 9 || n2 != n + 1) && (n2 <= 9 || n2 != n - 1) && eEqType2.value() != 113 || moduleModel2.getState() == eEqState.DELETED) {
                        bl = true;
                    } else if (eEqType2 != eEqType3) {
                        switch (eEqType2.value()) {
                            case 64: 
                            case 83: {
                                bl = eEqType3 != eEqType.E1_LINE_CARD && eEqType3 != eEqType.E1N_LINE_CARD;
                                break;
                            }
                            case 108: 
                            case 109: {
                                bl = eEqType3 != eEqType.E1_42_LINE_CARD && eEqType3 != eEqType.E1N_42_LINE_CARD;
                                break;
                            }
                            case 66: 
                            case 67: {
                                bl = eEqType3 != eEqType.DS3I_LINE_CARD && eEqType3 != eEqType.DS3IN_LINE_CARD;
                                break;
                            }
                            case 197: {
                                bl = eEqType3 != eEqType.DS1I_LINE_CARD;
                                break;
                            }
                            case 4: {
                                bl = eEqType3 != eEqType.DS1N_LINE_CARD;
                                break;
                            }
                            case 5: {
                                bl = eEqType3 != eEqType.DS1_LINE_CARD;
                                break;
                            }
                            case 6: {
                                bl = eEqType3 != eEqType.DS3N_LINE_CARD;
                                break;
                            }
                            case 7: {
                                bl = eEqType3 != eEqType.DS3_LINE_CARD;
                                break;
                            }
                            case 57: {
                                bl = eEqType3 != eEqType.DS3NE_LINE_CARD && eEqType3 != eEqType.DS3N_LINE_CARD && eEqType3 != eEqType.DS3_LINE_CARD;
                                break;
                            }
                            case 58: {
                                bl = eEqType3 != eEqType.DS3E_LINE_CARD && eEqType3 != eEqType.DS3N_LINE_CARD && eEqType3 != eEqType.DS3_LINE_CARD;
                                break;
                            }
                            case 12: {
                                bl = eEqType3 != eEqType.EC1N_LINE_CARD;
                                break;
                            }
                            case 13: {
                                bl = eEqType3 != eEqType.EC1_LINE_CARD;
                                break;
                            }
                            case 145: {
                                bl = eEqType3 != eEqType.DS3XM_LINE_CARD && eEqType3 != eEqType.DS3XM12_LINE_CARD;
                                break;
                            }
                            default: {
                                bl = true;
                                break;
                            }
                        }
                    } else if (eEqType2.value() == 113) {
                        boolean bl2 = bl = n2 != n - 1;
                    }
                    if (bl || n2 != 6 && n2 != 12 || !this.is454SdhChassis()) break;
                    bl = true;
                    break;
                }
                case 0: {
                    if (moduleModel2.getState() == eEqState.DELETED) {
                        bl = true;
                    } else {
                        if (eEqType2 == eEqType.RAN_SVC_LINE_CARD && eEqType2 == eEqType3) break;
                        if (eEqType2.value() == 145 && eEqType2 == eEqType3) {
                            bl = n != 3 && n != 15 || (n2 <= 0 || n2 >= 7) && (n2 <= 11 || n2 >= 18);
                        } else if (!(entityModel.getEqType() == 21 && (n == 3 && n2 > 0 && n2 < 7 || n == 15 && n2 > 11 && n2 < 18 || n == 4 && n2 > 0 && n2 < 4 || n == 17 && n2 > 12 && n2 < 17))) {
                            bl = true;
                        } else if (eEqType2 != eEqType3) {
                            switch (eEqType2.value()) {
                                case 64: {
                                    bl = eEqType3 != eEqType.E1_LINE_CARD && eEqType3 != eEqType.E1N_LINE_CARD;
                                    break;
                                }
                                case 108: 
                                case 109: {
                                    bl = eEqType3 != eEqType.E1_42_LINE_CARD && eEqType3 != eEqType.E1N_42_LINE_CARD;
                                    break;
                                }
                                case 66: 
                                case 67: {
                                    bl = eEqType3 != eEqType.DS3I_LINE_CARD && eEqType3 != eEqType.DS3IN_LINE_CARD;
                                    break;
                                }
                                case 218: {
                                    bl = eEqType3 != eEqType.DS1_LINE_CARD && eEqType3 != eEqType.DS1N_LINE_CARD;
                                    break;
                                }
                                case 197: {
                                    bl = eEqType3 != eEqType.DS1I_LINE_CARD;
                                    break;
                                }
                                case 5: {
                                    bl = eEqType3 != eEqType.DS1_LINE_CARD;
                                    break;
                                }
                                case 7: {
                                    bl = eEqType3 != eEqType.DS3_LINE_CARD;
                                    break;
                                }
                                case 58: {
                                    bl = eEqType3 != eEqType.DS3E_LINE_CARD && eEqType3 != eEqType.DS3_LINE_CARD;
                                    break;
                                }
                                case 13: {
                                    bl = eEqType3 != eEqType.EC1_LINE_CARD && eEqType3 != eEqType.DS3_EC1_48_LINE_CARD;
                                    break;
                                }
                                case 185: {
                                    bl = eEqType3 != eEqType.DS3E_LINE_CARD && eEqType3 != eEqType.DS3NE_LINE_CARD && eEqType3 != eEqType.DS3_LINE_CARD && eEqType3 != eEqType.DS3N_LINE_CARD && eEqType3 != eEqType.EC1_LINE_CARD && eEqType3 != eEqType.EC1N_LINE_CARD;
                                    break;
                                }
                                case 113: {
                                    bl = eEqType3 != eEqType.STM1E_12_LINE_CARD;
                                    break;
                                }
                                case 145: {
                                    bl = eEqType3 != eEqType.DS3XM_LINE_CARD;
                                    break;
                                }
                                default: {
                                    bl = true;
                                }
                            }
                        }
                    }
                    if (bl || n2 != 6 && n2 != 12 || !this.is454SdhChassis()) break;
                    bl = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (!bl && moduleModel2.getProtectionGroupModel() == null) continue;
            iterator.remove();
        }
        return list.toArray(new ModuleModel[list.size()]);
    }

    public boolean provisionShelf(short s, short s2, short s3) throws InvalidData, ProvisionError, NotSupportedOnEquipment {
        try {
            this.provisionShelf.get(new Object[]{new Short(s), new sShelfPosition(s2, s3)});
            return true;
        }
        catch (xInvalidData xInvalidData2) {
            throw new InvalidData((UserException)xInvalidData2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_FAIL_SHELF_ADD_PARAM_1, new Object[]{xProvisionError2.dataError});
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "provisionShelf", userException);
        }
    }

    public IModule provisionModule(int n, eEqType eEqType2) throws xProvisionError, xInUse {
        try {
            Object[] objectArray = new Object[]{new Integer(n), eEqType2};
            return (IModule)this.provisionModule.get(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw xProvisionError2;
        }
        catch (xInUse xInUse2) {
            throw xInUse2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "provisionModule", userException);
        }
    }

    public boolean provisionPluggable(PluggableSlotModel pluggableSlotModel, eEqType eEqType2) throws ProvisionError, ResourceInUse {
        try {
            this.provisionPluggable.get(new Object[]{new Integer(pluggableSlotModel.getEntityIndex()), eEqType2});
            return true;
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "provisionPluggable", userException);
        }
    }

    public boolean provisionPort(IPortContainer iPortContainer, int n, eEqType eEqType2) throws ProvisionError, ResourceInUse {
        try {
            Object[] objectArray = new Object[]{new Integer(iPortContainer.getEntityIndex()), new Integer(n), eEqType2};
            return (Boolean)this.provisionPort.get(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "provisionPort", userException);
        }
    }

    public boolean unprovisionPort(PortModel portModel) throws ProvisionError, ResourceInUse {
        int n = portModel.getEntityIndex();
        try {
            return (Boolean)this.unprovisionPort.get(new Integer(n));
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "unprovisionPort", userException);
        }
    }

    public eEqType[] getPortTypeList(int n, int n2) throws ProvisionError {
        try {
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
            return (eEqType[])this.getPortTypeList.get(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw ErrorMsgFormatter.getEquipmentProvisionError(xProvisionError2, null);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void doLampTest() throws BAD_OPERATION {
        try {
            this.testAllLeds.set();
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            throw bAD_OPERATION;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "doLampTest", userException);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            if (this.db.on()) {
                this.db.println("update(): this=" + this + ", From=" + observable + ", arg=" + EnumStrings.getStrings((Class)eUpdateType.class)[n]);
            }
            switch (n) {
                case 0: {
                    this.db.fine("update(): this DELETED, noop for EntityTableModel");
                    break;
                }
                case 1: {
                    this.db.fine("update(): this CHANGED, noop for EntityTableModel");
                    break;
                }
                case 2: {
                    this.db.fine("update(): this STRUCTURE CHANGED, noop for EntityTableModel");
                    break;
                }
                default: {
                    this.db.fine("update(): ILLEGAL UpdateType");
                }
            }
        }
    }

    private sEntityListElem[] getEntityArray() throws AbstractCmsIOException {
        sEntityListElem[] sEntityListElemArray = null;
        int n = 0;
        while (true) {
            try {
                sEntityListElemArray = (sEntityListElem[])this.entityList.get();
            }
            catch (UserException userException) {
                throw NodeModelDelegate.doUnknown(this.db, "getEntityArray", userException);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                if (n > 5) {
                    throw abstractCmsIOException;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
                continue;
            }
            break;
        }
        return sEntityListElemArray;
    }

    private sEntityListElem[] getChassisEntities() throws AbstractCmsIOException {
        sEntityListElem[] sEntityListElemArray = null;
        int n = 0;
        while (true) {
            try {
                sEntityListElemArray = (sEntityListElem[])this.chassisEntities.get();
            }
            catch (UserException userException) {
                throw NodeModelDelegate.doUnknown(this.db, "getChassisEntities", userException);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                if (n > 5) {
                    throw abstractCmsIOException;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
                continue;
            }
            break;
        }
        return sEntityListElemArray;
    }

    private sEntityListElem[] getEntitiesByIndex(int n) throws AbstractCmsIOException {
        sEntityListElem[] sEntityListElemArray = null;
        int n2 = 0;
        while (true) {
            try {
                sEntityListElemArray = (sEntityListElem[])this.entitiesByIndex.get(new Integer(n));
            }
            catch (UserException userException) {
                throw NodeModelDelegate.doUnknown(this.db, "getEntitiesByIndex", userException);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                if (n2 > 5) {
                    throw abstractCmsIOException;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
                continue;
            }
            break;
        }
        return sEntityListElemArray;
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    private List getEntityList() {
        try {
            return Arrays.asList((sEntityListElem[])this.entityList.get());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getEntityList", userException);
        }
    }

    public List getAvailEntitiesForLo(int n, boolean bl) {
        LinkedList linkedList = new LinkedList();
        if (!this.nmd.provides(Feature.XCVT) && !this.nmd.provides(Feature.XCVXC)) {
            this.db.warning("Node does not support VT XC's");
        } else {
            IConnectionModels iConnectionModels = this.nmd.getConnectionModels();
            IEntityModel[] iEntityModelArray = iConnectionModels.getAvailEntitiesForLoPath(n);
            LinkedList linkedList2 = new LinkedList();
            this.db.fine("entities after getAvailEntitiesForLoPath(pathSize=" + n + "): " + iEntityModelArray.length + "(length), " + iEntityModelArray);
            this.screenAvailEntities(iEntityModelArray, linkedList2, bl);
            this.db.fine("screenList: " + linkedList2.size() + "(size), " + linkedList2);
            this.loFilterEntities(linkedList2, linkedList);
            this.db.fine("returnList: " + linkedList.size() + "(size), " + linkedList);
        }
        return linkedList;
    }

    public List getAvailEntitiesForVt(int n, boolean bl) {
        throw new DeprecatedMethodCalled("FTG deprecated EntityTableModel.getAvailEntitiesForVt(int pathSize, boolean protectedPortsOnly)");
    }

    public List getAvailEntitiesForHo(short s, int n, boolean bl) {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        IConnectionModels iConnectionModels = this.nmd.getConnectionModels();
        IEntityModel[] iEntityModelArray = iConnectionModels.getAvailEntitiesForHoPath(s);
        this.db.fine("entities after getAvailEntitiesForHoPath(pathSize=" + s + "): " + iEntityModelArray.length + "(length), " + iEntityModelArray);
        this.screenAvailEntities(iEntityModelArray, linkedList2, bl);
        this.db.fine("screenList: " + linkedList2.size() + "(size), " + linkedList2);
        this.hoFilterEntities(linkedList2, linkedList, n);
        this.db.fine("returnList: " + linkedList.size() + "(size), " + linkedList);
        return linkedList;
    }

    public ITdmPortModel[] getAvailableOnePlusOnePorts(eOnePlusOneType eOnePlusOneType2) {
        return this.getAvailableOnePlusOnePorts(null, eOnePlusOneType2);
    }

    public ITdmPortModel[] getAvailableOnePlusOnePorts(IChassisModel iChassisModel, eOnePlusOneType eOnePlusOneType2) {
        Object object;
        TreeSet treeSet = new TreeSet(new ElementComparator());
        treeSet.addAll(this.nmd.getElementModelsDelegate().getOnePlusOneAvailableElements(eOnePlusOneType2));
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            try {
                object = (TdmPortModel)((ElementModel)iterator.next()).getEntityModel();
                if (iChassisModel != null && ((EntityModel)object).getChassis() != iChassisModel) continue;
                linkedList.add(object);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.println("Caught " + (Object)((Object)abstractCmsNoSuchEntityException));
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            catch (Exception exception) {
                this.db.println("Caught " + exception);
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        object = linkedList.toArray(new TdmPortModel[0]);
        if (this.db.on()) {
            this.db.println("getAvailableOnePlusOnePorts: " + ((Object)object).length);
            for (int i = 0; i < ((Object)object).length; ++i) {
                this.db.println("#" + i + ":" + object[i]);
            }
        }
        return object;
    }

    public List getAvailEntitiesForSts(short s, int n, boolean bl) {
        throw new DeprecatedMethodCalled("FTG deprecated EntityTableModel.getAvailEntitiesForSts((short pathSize, int circuitDir, boolean protectedPortsOnly)");
    }

    public IDwdmPortModel[] getAvailableYCablePorts() {
        return this.getAvailableYCablePorts(null);
    }

    public IDwdmPortModel[] getAvailableYCablePorts(IChassisModel iChassisModel) {
        TreeSet treeSet = new TreeSet(new ElementComparator());
        treeSet.addAll(this.nmd.getElementModelsDelegate().getYCableAvailableElements());
        LinkedList<DwdmPortModel> linkedList = new LinkedList<DwdmPortModel>();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            try {
                DwdmPortModel dwdmPortModel = (DwdmPortModel)((ElementModel)iterator.next()).getEntityModel();
                if (dwdmPortModel.isSonetDccTermination() || iChassisModel != null && dwdmPortModel.getChassis() != iChassisModel) continue;
                linkedList.add(dwdmPortModel);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.println("Caught " + (Object)((Object)abstractCmsNoSuchEntityException));
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            catch (Exception exception) {
                this.db.println("Caught " + exception);
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (this.db.on()) {
            this.db.println("portsList: " + linkedList.size() + "(size), " + linkedList);
        }
        return linkedList.toArray(new DwdmPortModel[0]);
    }

    public List getFirstAvailPairPPorts(short s) {
        EntityModel entityModel;
        LinkedList<EntityModel> linkedList = new LinkedList<EntityModel>();
        LinkedList linkedList2 = new LinkedList();
        TreeMap<Integer, EntityModel> treeMap = new TreeMap<Integer, EntityModel>();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        EntityModel entityModel2 = null;
        EntityModel entityModel3 = null;
        IConnectionModels iConnectionModels = this.nmd.getConnectionModels();
        IEntityModel[] iEntityModelArray = iConnectionModels.getAvailEntitiesForHoPath(s);
        this.db.info("getFirstAvailPairPPorts after getAvailEntitiesForHoPath(pathSize=" + s + "): " + iEntityModelArray.length + "(length), " + iEntityModelArray);
        this.screenAvailEntities(iEntityModelArray, linkedList2, false);
        this.db.info("getFirstAvailPairPPorts after screen: " + linkedList2.size() + "(size), " + linkedList2);
        for (int i = 0; i < linkedList2.size(); ++i) {
            entityModel = (EntityModel)linkedList2.get(i);
            if (entityModel == null || !entityModel.onPortlessPort()) continue;
            treeMap.put(new Integer(entityModel.getIndex()), entityModel);
        }
        Iterator iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            entityModel = (EntityModel)iterator.next();
            if (entityModel.getPort() % 2 == 1) {
                this.db.fine("find an entity on an odd port " + entityModel.getPort());
                entityModel2 = entityModel;
                continue;
            }
            entityModel3 = entityModel;
            if (entityModel2 == null || entityModel2.getSlot() != entityModel3.getSlot() || !entityModel2.onPairPortlessPorts(entityModel3) || treeSet.contains(new Integer(entityModel2.getSlot()))) continue;
            linkedList.add(entityModel2);
            linkedList.add(entityModel3);
            treeSet.add(new Integer(entityModel2.getSlot()));
        }
        this.db.fine("return " + linkedList.size() + " entities");
        return linkedList;
    }

    public void screenAvailEntities(IEntityModel[] iEntityModelArray, List list, boolean bl) {
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            ProtectionGroupModel protectionGroupModel;
            ModuleModel moduleModel;
            EntityModel entityModel = (EntityModel)iEntityModelArray[i];
            if (entityModel == null) continue;
            int n = entityModel.getEqType();
            if (n == 4 || n == 5 || n == 197 || n == 83 || n == 64 || n == 108 || n == 109 || n == 65 || n == 66 || n == 67) {
                moduleModel = (ModuleModel)entityModel;
                if (moduleModel == null || ((protectionGroupModel = moduleModel.getProtectionGroupModel()) != null ? moduleModel == protectionGroupModel.getProtectModuleModel() : bl)) {
                    continue;
                }
            } else if (n == 34 || n == 32 || n == 31 || n == 33 || n == 114) {
                moduleModel = (ModuleModel)entityModel.getModuleModel();
                if (moduleModel == null || ((protectionGroupModel = moduleModel.getProtectionGroupModel()) != null ? moduleModel == protectionGroupModel.getProtectModuleModel() : bl)) {
                    continue;
                }
            } else if (n == 28 || n == 29 || n == 30 || n == 61) {
                ElementModel elementModel;
                ElementModelsDelegate elementModelsDelegate = this.nmd.getElementModelsDelegate();
                if (elementModelsDelegate == null) continue;
                int n2 = entityModel.getEntityIndex();
                try {
                    elementModel = elementModelsDelegate.getElementModel(n2);
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    this.db.info("screenAvailPorts - OCN ElementModel not found");
                    elementModel = null;
                }
                if (elementModel != null) {
                    block19: {
                        if (elementModel.getType() == 1) {
                            int n3;
                            OnePlusOneModel onePlusOneModel = (OnePlusOneModel)elementModel;
                            try {
                                n3 = onePlusOneModel.getProtectEntityIndex();
                            }
                            catch (AbstractCmsIOException abstractCmsIOException) {
                                n3 = -1;
                            }
                            if (n3 == n2) {
                                continue;
                            }
                        } else if (elementModel.getType() == 3 && !bl) {
                            BlsrModel blsrModel = (BlsrModel)elementModel;
                            int n4 = blsrModel.getProtectEntityIndex(entityModel.getEntityIndex());
                            try {
                                IEntityModel iEntityModel = this.getEntityModelByIndex(n4);
                                list.add(iEntityModel);
                            }
                            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                                this.db.println("Unable to find Protect Entity for 4F BLSR:" + n4);
                                if (!this.db.on()) break block19;
                                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                            }
                        }
                    }
                    if (bl && elementModel.getType() == 0) continue;
                }
            }
            list.add(entityModel);
        }
    }

    public void lapFilterEntities(List list, List list2) {
        int n;
        IEntityModel iEntityModel;
        this.loFilterEntities(list, list2);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            iEntityModel = (IEntityModel)iterator.next();
            n = iEntityModel.getPayloadType();
            if (n != 5 && n != 10 && n != 11 && n != 12 && n != 15 && n != 16 && n != 14 && n != 18) continue;
            iterator.remove();
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            iEntityModel = (IEntityModel)iterator.next();
            n = iEntityModel.getPayloadType();
            if (n != 3) continue;
            list2.add(iEntityModel);
        }
    }

    private void loFilterEntities(List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel = (IEntityModel)iterator.next();
            int n = iEntityModel.getPayloadType();
            if (n != 1 && n != 7 && n != 2 && n != 4 && n != 5 && n != 9 && n != 12 && n != 10 && n != 11 && n != 14 && n != 18) continue;
            list2.add(iEntityModel);
        }
    }

    private void hoFilterEntities(List list, List list2, int n) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel = (IEntityModel)iterator.next();
            int n2 = iEntityModel.getPayloadType();
            if (n2 == 6 || n2 == 8 || n2 == 13 || n2 == 18 || n2 == 17) {
                if (n != 1) continue;
                list2.add(iEntityModel);
                continue;
            }
            list2.add(iEntityModel);
        }
    }

    public void filterDropEntities(List list, IEntityModel iEntityModel, int n, int n2, List list2) {
    }

    public IEntityModel getModule(IChassisModel iChassisModel, int n) throws AbstractCmsNoSuchEntityException {
        List list;
        IEntityModel iEntityModel = this.getEntityModelBySlot(iChassisModel, n);
        IEntityModel iEntityModel2 = null;
        if (iEntityModel != null && (list = iEntityModel.getChildren()).size() > 0) {
            iEntityModel2 = (IEntityModel)list.get(0);
        }
        return iEntityModel2;
    }

    public long getLastInterfaceChange(IChassisModel iChassisModel, int n) throws AbstractCmsNoSuchEntityException {
        long l = 0L;
        ModuleModel moduleModel = (ModuleModel)this.getModule(iChassisModel, n);
        if (moduleModel != null) {
            l = moduleModel.getLastInterfaceChange();
        }
        return l;
    }

    public Map getAllLastInterfaceChanges() {
        HashMap<ShelfSlotBundle, Long> hashMap = new HashMap<ShelfSlotBundle, Long>();
        ChassisModels chassisModels = this.nmd.getChassisModelsInstance();
        IChassisModel[] iChassisModelArray = chassisModels.getChassisModelsArray();
        for (int i = 0; i < iChassisModelArray.length; ++i) {
            int n = iChassisModelArray[i].getShelfId();
            EntityModel entityModel = (EntityModel)iChassisModelArray[i].getChildren().get(0);
            Iterator iterator = entityModel.getChildrenOfType(eClass.CONTAINER).iterator();
            while (iterator.hasNext()) {
                ModuleModel moduleModel;
                EntityModel entityModel2 = (EntityModel)iterator.next();
                List list = entityModel2.getChildren();
                if (list.size() <= 0 || !(list.get(0) instanceof ModuleModel) || (moduleModel = (ModuleModel)list.get(0)) == null) continue;
                long l = moduleModel.getLastInterfaceChange();
                int n2 = moduleModel.getSlot();
                hashMap.put(new ShelfSlotBundle(n, n2), new Long(l));
            }
        }
        return hashMap;
    }

    public IEntityModel getPort(IChassisModel iChassisModel, int n, int[] nArray) throws AbstractCmsNoSuchEntityException {
        EntityModel entityModel = (EntityModel)this.getModule(iChassisModel, n);
        if (entityModel != null) {
            List list = entityModel.getDescendantsOfType(eClass.PORT);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PortModel portModel = (PortModel)iterator.next();
                if (ComparisonUtil.compare((int[])portModel.getPortNum(), (int[])nArray) != 0) continue;
                return portModel;
            }
        }
        return null;
    }

    protected IEntityModel findEntityInPosition(IEntityModel iEntityModel, int n) {
        IEntityModel iEntityModel2 = null;
        if (iEntityModel != null) {
            List list = iEntityModel.getChildren();
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                IEntityModel iEntityModel3 = (IEntityModel)list.get(i);
                if (iEntityModel3.getPositionInParent() != n) continue;
                iEntityModel2 = iEntityModel3;
                break;
            }
        }
        return iEntityModel2;
    }

    public List getAvailEntitiesForHoVcat(short s, IVcatTermAttributes iVcatTermAttributes, boolean bl) {
        LinkedList linkedList = new LinkedList();
        IVcatTermModels iVcatTermModels = this.nmd.getVcatTermModels();
        int n = iVcatTermAttributes.getDirection();
        IEntityModel[] iEntityModelArray = iVcatTermModels.getAvailEntitiesForHoVcat(iVcatTermAttributes, s);
        this.db.info("entities after getAvailEntitiesForHoVcat(pathSize=" + s + "): " + iEntityModelArray.length + "(length), " + iEntityModelArray);
        List<IEntityModel> list = Arrays.asList(iEntityModelArray);
        this.hoFilterEntities(list, linkedList, n);
        this.db.fine("returnList: " + linkedList.size() + "(size), " + linkedList);
        return linkedList;
    }

    public List getAvailEntitiesForLoVcat(int n, IVcatTermAttributes iVcatTermAttributes, boolean bl) {
        LinkedList linkedList = new LinkedList();
        if (!this.nmd.provides(Feature.XCVT) && !this.nmd.provides(Feature.XCVXC)) {
            this.db.warning("Node does not support VT XC's");
        } else {
            IVcatTermModels iVcatTermModels = this.nmd.getVcatTermModels();
            int n2 = iVcatTermAttributes.getDirection();
            IEntityModel[] iEntityModelArray = iVcatTermModels.getAvailEntitiesForLoVcat(iVcatTermAttributes, n);
            this.db.fine("entities after getAvailEntitiesForLoVcat(pathSize=" + n + "): " + iEntityModelArray.length + "(length), " + iEntityModelArray);
            List<IEntityModel> list = Arrays.asList(iEntityModelArray);
            this.loFilterEntities(list, linkedList);
            this.db.fine("returnList: " + linkedList.size() + "(size), " + linkedList);
        }
        return linkedList;
    }

    public boolean hasStandbyControllerCard(int n, eEqType eEqType2) {
        return this.getControllerCard(n, eEqType2, eEqState.STANDBY) != null;
    }

    public boolean hasStandbyControllerCard(eEqType eEqType2) {
        return this.hasStandbyControllerCard(1, eEqType2);
    }

    public boolean hasStandbyTCC2P(int n) {
        EntityModel entityModel = this.getControllerCard(n, eEqType.TCC_CARD, eEqState.STANDBY);
        return this.isTCC2P(entityModel);
    }

    public boolean hasActiveTCC2P(int n) {
        EntityModel entityModel = this.getControllerCard(n, eEqType.TCC_CARD, eEqState.ACTIVE);
        return this.isTCC2P(entityModel);
    }

    private EntityModel getControllerCard(int n, eEqType eEqType2, eEqState eEqState2) {
        EntityModel entityModel = null;
        ChassisModels chassisModels = this.nmd.getChassisModelsInstance();
        EntityModel entityModel2 = (EntityModel)((Object)chassisModels.getChassisByShelfId(n));
        if (entityModel2 == null) {
            this.db.warning("getControllerCard- chassis is not present");
            throw new CmsObjectNotExistException("chassis is null");
        }
        try {
            List list = entityModel2.getDescendantsOfType(eEqType2);
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    PluggableModel pluggableModel;
                    EntityModel entityModel3 = (EntityModel)list.get(i);
                    if (!(entityModel3 instanceof PluggableModel) || (pluggableModel = (PluggableModel)entityModel3).getState() != eEqState2) continue;
                    entityModel = entityModel3;
                    return entityModel;
                }
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.fine("Caught " + (Object)((Object)abstractCmsIOException) + " in getControllerCard");
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            throw abstractCmsIOException;
        }
        return entityModel;
    }

    public boolean isTCC2P(EntityModel entityModel) {
        String string;
        PluggableModel pluggableModel;
        Map map;
        boolean bl = false;
        if (entityModel instanceof PluggableModel && (map = (pluggableModel = (PluggableModel)entityModel).getExtraInfoMap()).containsKey("SWTYPE") && (string = (String)map.get("SWTYPE")).equals("1")) {
            bl = true;
        }
        return bl;
    }

    public void debugDumpEntityTree(IEntityModel iEntityModel) {
        this.db.println("--- Entity Tree " + (iEntityModel instanceof IChassisModel ? "(Shelf " + ((IChassisModel)iEntityModel).getShelfId() + ") " : "") + "---");
        this.debugDumpEntityTree(iEntityModel, 0);
        this.db.println("^^^ Entity Tree " + (iEntityModel instanceof IChassisModel ? "(Shelf " + ((IChassisModel)iEntityModel).getShelfId() + ") " : "") + "^^^");
    }

    private void debugDumpEntityTree(IEntityModel iEntityModel, int n) {
        if (null != iEntityModel) {
            String string = "";
            for (int i = 0; i < n; ++i) {
                string = string + "| ";
            }
            this.db.println(string + iEntityModel.toString());
            Iterator iterator = iEntityModel.getChildren().iterator();
            while (iterator.hasNext()) {
                this.debugDumpEntityTree((IEntityModel)iterator.next(), n + 1);
            }
        }
    }

    public String toString() {
        return "EntityTable";
    }

    public final void dump() {
        ChassisModels chassisModels = this.nmd.getChassisModelsInstance();
        IChassisModel[] iChassisModelArray = chassisModels.getChassisModelsArray();
        for (int i = 0; i < iChassisModelArray.length; ++i) {
            this.debugDumpEntityTree(iChassisModelArray[i]);
        }
    }

    public final void printTable() {
        this.db.println("------ EntityModelTable -------");
        Iterator iterator = this.entityModelTable.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            Object v = this.entityModelTable.get(n);
            this.db.println("index = 0x" + Integer.toHexString(n) + ", type = " + v.getClass().getName());
        }
        this.db.println("^^^^^^ EntityModelTable ^^^^^^");
    }

    public void testEntity(IEntityModel iEntityModel) {
        this.db.println("testEntity(" + iEntityModel + ")");
    }

    class TestAllLeds
    extends NonCachedValue {
        public TestAllLeds(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() {
            EntityTableModel.this.getEntityTableRef().testAllLeds();
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }

    class EntitiesByIndex
    extends NonCachedValue {
        public EntitiesByIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return EntityTableModel.this.getEntityTableRef().getEntitiesByIndex(n);
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }

    class ChassisEntities
    extends NonCachedValue {
        public ChassisEntities(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            return EntityTableModel.this.getEntityTableRef().getShelfEntities();
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }

    class EntityList
    extends NonCachedValue {
        public EntityList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return EntityTableModel.this.getEntityTableRef().entityList();
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }

    class GetPortTypeList
    extends NonCachedValue {
        public GetPortTypeList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            return EntityTableModel.this.getEntityTableRef().getPortTypeList(n, n2);
        }
    }

    class UnprovisionPort
    extends NonCachedValue {
        public UnprovisionPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            boolean bl = EntityTableModel.this.getEntityTableRef().unprovisionPort(n);
            return new Boolean(bl);
        }
    }

    class ProvisionPort
    extends NonCachedValue {
        public ProvisionPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            eEqType eEqType2 = (eEqType)objectArray[2];
            boolean bl = EntityTableModel.this.getEntityTableRef().provisionPort(n, n2, eEqType2);
            return new Boolean(bl);
        }
    }

    class ProvisionPluggable
    extends NonCachedValue {
        public ProvisionPluggable(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xInUse, xProvisionError {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            eEqType eEqType2 = (eEqType)objectArray[1];
            return EntityTableModel.this.getEntityTableRef().provisionPluggable(n, eEqType2);
        }
    }

    class ProvisionModule
    extends NonCachedValue {
        public ProvisionModule(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0] + 1;
            return EntityTableModel.this.getEntityTableRef().provisionModule(n, (eEqType)objectArray[1]);
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }

    class ProvisionShelf
    extends NonCachedValue {
        public ProvisionShelf(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xInvalidData, xProvisionError, xNotSupportedOnEquipment {
            Object[] objectArray = (Object[])object;
            return EntityTableModel.this.getEntityTableRef().provisionShelf((Short)objectArray[0], (sShelfPosition)objectArray[1]);
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }

    class ProvisionProtectionGroup
    extends NonCachedValue {
        public ProvisionProtectionGroup(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return EntityTableModel.this.getEntityTableRef().provisionProtectionGroup((sProtectionConfig)object, false);
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }

    class ProtectionGroupList
    extends NonCachedValue {
        public ProtectionGroupList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return EntityTableModel.this.getEntityTableRef().protectionGroupList();
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }

    class LastChange
    extends NonCachedValue {
        public LastChange(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Long(EntityTableModel.this.getEntityTableRef().lastChange());
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }
}

