/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.sEnvAlrmInputConfig;
import cerent.cms.model.AiciModuleModel;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class EnvAlarmTable
implements Observer {
    private static final String DEF_ALARM_DESC = "Failure detected External to the NE";
    private static final String[] alarmCodes = new String[]{"EXTERNAL", "AIRCOMPR", "AIRCOND", "AIRDRYR", "BATDSCHRG", "BATTERY", "CLFAN", "CPMAJOR", "CPMINOR", "ENGINE", "ENGOPRG", "EXPLGS", "FIRDETR", "FIRE", "FLOOD", "FUSE", "GEN", "HIAIR", "HIHUM", "HITEMP", "HIWTR", "INTRUDER", "LWBATVG", "LWFUEL", "LWHUM", "LWPRES", "LWTEMP", "LWWTR", "MISC", "OPENDR", "POWER", "PUMP", "PWR-48", "RECT", "RECTHI", "RECTLO", "SMOKE", "TOXICGAS", "VENTN", "ENGTRANS", "FUELLEAK", "GASALARM", "HATCH", "LEVELCON", "LVDADSL", "LVDBYPAS", "PWR-139", "PWR-190", "PWRMJ", "PWRMN", "RINGGENMJ", "RINGENMN", "RTACADSL", "RTACCRIT", "RTACPWR", "RTACPWRENG", "RTBAYPWR", "RTRVENG", "TEMP", "TREPEATER"};
    private String[] alarmDesc;
    private List alarmModels;
    private EntityModel envSlotModel;
    private EntityModel cardModel;
    private ChassisModel chassis;
    private static final SDebug db = new SDebug("EnvAlarmTable");

    public EnvAlarmTable(ChassisModel chassisModel) {
        this.chassis = chassisModel;
    }

    public String getEnvAlarmDesc(int n) {
        block3: {
            try {
                if (this.alarmDesc != null) {
                    int n2 = this.getIndex(n);
                    return this.alarmDesc[n2];
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)indexOutOfBoundsException);
            }
        }
        return DEF_ALARM_DESC;
    }

    public static String getEnvAlarmCode(int n) {
        try {
            return alarmCodes[n];
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return alarmCodes[0];
        }
    }

    public static int getEnvAlarmCodeSize() {
        return alarmCodes.length;
    }

    public void update(Observable observable, Object object) {
        block6: {
            block7: {
                block5: {
                    if (observable != this.envSlotModel) break block5;
                    if (!object.equals(ModelUpdateType.ADDED)) break block6;
                    this.findCardModel();
                    this.unregisterAlarmModels();
                    this.registerAlarmModels();
                    break block6;
                }
                if (observable != this.cardModel) break block7;
                if (object.equals(ModelUpdateType.ADDED)) {
                    this.unregisterAlarmModels();
                    this.registerAlarmModels();
                }
                if (!object.equals(ModelUpdateType.DELETED)) break block6;
                this.unregisterCardModel();
                break block6;
            }
            if (observable instanceof EnvAlarmModel) {
                if (object.equals(ModelUpdateType.DELETED)) {
                    this.unregisterAlarmModels();
                } else {
                    Iterator iterator = this.alarmModels.iterator();
                    while (iterator.hasNext()) {
                        int n;
                        EnvAlarmModel envAlarmModel = (EnvAlarmModel)iterator.next();
                        if (envAlarmModel != observable) continue;
                        String string = this.fetchDesc(envAlarmModel);
                        if (string == this.alarmDesc[n = this.getIndex(envAlarmModel.getPositionInParent())]) break;
                        this.alarmDesc[n] = string;
                        break;
                    }
                }
            }
        }
    }

    private void registerAlarmModels() {
        List list = this.envSlotModel.getDescendantsOfType(eEqType.ENVIRONMENT_ALARM);
        if (list.size() > 0) {
            this.alarmModels = list;
            this.alarmDesc = new String[this.alarmModels.size()];
            Iterator iterator = this.alarmModels.iterator();
            while (iterator.hasNext()) {
                EnvAlarmModel envAlarmModel = (EnvAlarmModel)iterator.next();
                envAlarmModel.addObserver(this);
                int n = this.getIndex(envAlarmModel.getPositionInParent());
                this.alarmDesc[n] = this.fetchDesc(envAlarmModel);
            }
        }
    }

    private void unregisterAlarmModels() {
        if (this.alarmModels != null) {
            for (int i = 0; i < this.alarmModels.size(); ++i) {
                ((EnvAlarmModel)this.alarmModels.get(i)).deleteObserver(this);
            }
            this.alarmModels = null;
            this.alarmDesc = null;
        }
    }

    private void unregisterCardModel() {
        if (this.cardModel != null) {
            this.cardModel.deleteObserver(this);
            this.cardModel = null;
        }
    }

    private String fetchDesc(EnvAlarmModel envAlarmModel) {
        try {
            sEnvAlrmInputConfig sEnvAlrmInputConfig2 = envAlarmModel.settings();
            return sEnvAlrmInputConfig2.description;
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return DEF_ALARM_DESC;
        }
    }

    public void init() {
        List list = null;
        IPlatform iPlatform = this.chassis.getPlatform();
        list = iPlatform.is600() ? this.chassis.getDescendantsOfType(eEqType.CAP) : (iPlatform.is310cl() ? this.chassis.getDescendantsOfType(eEqType.CTX_SLOT) : (iPlatform.is310ma() ? this.chassis.getDescendantsOfType(eEqType.BIC_CMN) : this.chassis.getDescendantsOfType(eEqType.AIC_SLOT)));
        this.envSlotModel = null;
        if (list.size() == 1) {
            this.envSlotModel = (EntityModel)list.get(0);
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ModuleModel moduleModel = (ModuleModel)iterator.next();
                if (moduleModel.isProtectModule()) continue;
                this.envSlotModel = moduleModel;
                break;
            }
        }
        this.findCardModel();
        if (this.envSlotModel != null) {
            this.envSlotModel.addObserver(this);
            this.registerAlarmModels();
        }
    }

    public void dispose() {
        this.unregisterAlarmModels();
        this.unregisterCardModel();
        if (this.envSlotModel != null) {
            this.envSlotModel.deleteObserver(this);
            this.envSlotModel = null;
        }
    }

    private void findCardModel() {
        EntityModel entityModel;
        if (this.cardModel != null || this.envSlotModel == null) {
            return;
        }
        if (this.envSlotModel.getChildren() != null && !this.envSlotModel.getChildren().isEmpty() && (entityModel = (EntityModel)this.envSlotModel.getChildren().get(0)) instanceof AiciModuleModel) {
            this.cardModel = entityModel;
            this.cardModel.addObserver(this);
        }
    }

    private int getIndex(int n) {
        if (this.cardModel != null) {
            return n - 19;
        }
        return n - 1;
    }
}

