/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Rmon.sAlarmAdminInfo;
import cerent.cms.idl.Rmon.sAlarmInfo;
import cerent.cms.idl.Rmon.xDuplicateAlarm;
import cerent.cms.idl.Rmon.xInvalidAlarmThresholds;
import cerent.cms.idl.Rmon.xNoMoreAlarms;
import cerent.cms.idl.Rmon.xNoSuchAlarm;
import cerent.cms.idl.Rmon.xNoSuchStatsId;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DuplicateAlarm;
import cerent.cms.model.EtherPmStatsSeries;
import cerent.cms.model.EtherThresholdModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchStatsId;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import org.omg.CORBA.UserException;

public class EtherPmModel
extends Model {
    private NodeModelDelegate nmd;
    private StatsSeriesList statsSeriesList;
    private CreateAlarm createAlarm;
    private DeleteAlarm deleteAlarm;
    private AlarmCombinedInfoList alarmCombinedInfoList;
    private AlarmList alarmList;
    private AlarmInfoList alarmInfoList;
    private EtherThresholdList etherThresholdList;
    private Map etherThresholdMap;
    private boolean isEtherThresholdMapInitialized;
    private EtherPmStatsSeries[] etherPmStatsSeriesArr;
    private EventDispatcher dispatcher;
    private static ModelSingletonCollection etherPmModelSingletons;

    private EtherPmModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(EtherPmModel.class));
        this.index = 0;
        this.nmd = nodeModelDelegate;
        this.statsSeriesList = new StatsSeriesList(nodeModelDelegate, "EtherPmModel::statsSeriesList");
        this.alarmList = new AlarmList(nodeModelDelegate, "EtherPmModel::alarmList");
        this.createAlarm = new CreateAlarm(nodeModelDelegate, "EtherPmModel::createAlarm");
        this.deleteAlarm = new DeleteAlarm(nodeModelDelegate, "EtherPmModel::deleteAlarm");
        this.alarmCombinedInfoList = new AlarmCombinedInfoList(nodeModelDelegate, "EtherPmModel::alarmCombinedInfoList");
        this.alarmInfoList = new AlarmInfoList(nodeModelDelegate, "EtherPmModel::alarmInfoList");
        this.etherThresholdList = new EtherThresholdList(nodeModelDelegate, "EtherPmModel::etherThresholdList");
        this.etherThresholdMap = new TreeMap();
        this.isEtherThresholdMapInitialized = false;
    }

    public static synchronized EtherPmModel getInstance(NodeModelDelegate nodeModelDelegate) {
        EtherPmModel etherPmModel;
        if (etherPmModelSingletons == null) {
            etherPmModelSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"EtherPmModel");
        }
        if ((etherPmModel = (EtherPmModel)etherPmModelSingletons.get((Object)nodeModelDelegate)) == null) {
            etherPmModel = new EtherPmModel(nodeModelDelegate);
            etherPmModelSingletons.add((Object)nodeModelDelegate, (Object)etherPmModel);
        }
        return etherPmModel;
    }

    public short[] getStatsSeriesList() {
        try {
            return (short[])this.statsSeriesList.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public short createAlarm(sAlarmAdminInfo sAlarmAdminInfo2) throws xNoMoreAlarms, NoSuchStatsId, xInvalidAlarmThresholds, DuplicateAlarm {
        try {
            return (Short)this.createAlarm.get(sAlarmAdminInfo2);
        }
        catch (xNoMoreAlarms xNoMoreAlarms2) {
            throw xNoMoreAlarms2;
        }
        catch (xNoSuchStatsId xNoSuchStatsId2) {
            throw new NoSuchStatsId((UserException)xNoSuchStatsId2);
        }
        catch (xInvalidAlarmThresholds xInvalidAlarmThresholds2) {
            throw xInvalidAlarmThresholds2;
        }
        catch (xDuplicateAlarm xDuplicateAlarm2) {
            throw new DuplicateAlarm(ErrorMsg.getString((EID)EMC.EID_DUPLICATE_ALARM));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void deleteAlarm(short s) throws xNoSuchAlarm {
        try {
            Short s2 = new Short(s);
            this.deleteAlarm.set(s2);
        }
        catch (xNoSuchAlarm xNoSuchAlarm2) {
            throw xNoSuchAlarm2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEtherThresholdList() {
        Map map = this.etherThresholdMap;
        synchronized (map) {
            if (!this.isEtherThresholdMapInitialized) {
                this.discoverEtherThresholds(this.etherThresholdMap, true);
            }
            this.isEtherThresholdMapInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EtherThresholdModel[] getEtherThresholdList() {
        Map map = this.etherThresholdMap;
        synchronized (map) {
            return this.etherThresholdMap.values().toArray(new EtherThresholdModel[0]);
        }
    }

    private void discoverEtherThresholds(Map map, boolean bl) {
        try {
            sAlarmInfo[] sAlarmInfoArray = (sAlarmInfo[])this.alarmInfoList.get();
            for (int i = 0; i < sAlarmInfoArray.length; ++i) {
                EtherThresholdModel etherThresholdModel = new EtherThresholdModel(this.nmd, sAlarmInfoArray[i].alarmIndex, sAlarmInfoArray[i].adminInfo, null);
                if (bl) {
                    etherThresholdModel.init();
                }
                map.put(new Short(sAlarmInfoArray[i].alarmIndex), etherThresholdModel);
            }
        }
        catch (UserException userException) {
            this.db.println("user exception in discoverEtherThresholds");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public EtherPmStatsSeries[] getEtherPmStatsSeries() {
        if (this.etherPmStatsSeriesArr == null) {
            this.discoverEtherStats();
        }
        return this.etherPmStatsSeriesArr;
    }

    private void discoverEtherStats() {
        short[] sArray = null;
        sArray = this.getStatsSeriesList();
        if (sArray != null) {
            this.etherPmStatsSeriesArr = new EtherPmStatsSeries[sArray.length];
            for (int i = 0; i < sArray.length; ++i) {
                EtherPmStatsSeries etherPmStatsSeries;
                this.etherPmStatsSeriesArr[i] = etherPmStatsSeries = new EtherPmStatsSeries(this.getNodeModelDelegate(), sArray[i]);
            }
        }
    }

    public void init() {
        super.init0();
        this.dispatcher = this.getNodeModelDelegate().getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectRmonAlarm, this.index, (Observer)this);
        }
        this.initEtherThresholdList();
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectRmonAlarm, this.index, (Observer)this);
            this.dispatcher = null;
        }
        this.destroyEtherThresholdModels();
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyEtherThresholdModels() {
        Map map = this.etherThresholdMap;
        synchronized (map) {
            Iterator iterator = this.etherThresholdMap.values().iterator();
            while (iterator.hasNext()) {
                EtherThresholdModel etherThresholdModel = (EtherThresholdModel)iterator.next();
                etherThresholdModel.destroy();
            }
            this.etherThresholdMap.clear();
            this.isEtherThresholdMapInitialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEtherThreshold(EtherThresholdModel etherThresholdModel) {
        Map map = this.etherThresholdMap;
        synchronized (map) {
            Object v = this.etherThresholdMap.remove(new Short(etherThresholdModel.getThresholdIndex()));
        }
    }

    public void update(Observable observable, Object object) {
        if (this.db.on) {
            this.db.println("EtherPmModel::update");
        }
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 2: {
                    if (this.db.on) {
                        this.db.println("Making structural changes.");
                    }
                    this.updateStructure();
                    break;
                }
                case 1: {
                    this.updateLocal();
                    break;
                }
                case 0: {
                    break;
                }
            }
        } else if (this.db.on) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    protected void updateLocal() {
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    private void updateStructure() {
        if (this.db.on) {
            this.db.println("Sending UpdateStructure");
        }
        this.updateEtherThresholdStructure();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateEtherThresholdStructure() {
        HashMap hashMap = new HashMap();
        boolean bl = false;
        Map map = this.etherThresholdMap;
        synchronized (map) {
            EtherThresholdModel etherThresholdModel;
            Object e;
            this.discoverEtherThresholds(hashMap, false);
            Collection collection = this.getAddedObjects(this.etherThresholdMap.keySet(), hashMap.keySet());
            Collection collection2 = this.getDeletedObjects(this.etherThresholdMap.keySet(), hashMap.keySet());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                etherThresholdModel = (EtherThresholdModel)hashMap.get(e);
                etherThresholdModel.init();
                this.etherThresholdMap.put(e, etherThresholdModel);
                bl = true;
            }
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                etherThresholdModel = (EtherThresholdModel)this.etherThresholdMap.get(e);
                this.etherThresholdMap.remove(e);
                etherThresholdModel.destroy();
            }
        }
        return bl;
    }

    private Collection getAddedObjects(Set set, Set set2) {
        HashSet hashSet = new HashSet(set2);
        hashSet.removeAll(set);
        return hashSet;
    }

    private Collection getDeletedObjects(Set set, Set set2) {
        HashSet hashSet = new HashSet(set);
        hashSet.removeAll(set2);
        return hashSet;
    }

    public INodeModel getNodeModel() {
        return this.getNodeModelDelegate();
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    class EtherThresholdList
    extends NonCachedValue {
        public EtherThresholdList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return EtherPmModel.this.getEtherThresholdList();
        }

        public Object outer() {
            return EtherPmModel.this;
        }
    }

    class AlarmInfoList
    extends NonCachedValue {
        public AlarmInfoList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getEtherPmRef().getAlarmInfoList();
        }

        public Object outer() {
            return EtherPmModel.this;
        }
    }

    class AlarmCombinedInfoList
    extends NonCachedValue {
        public AlarmCombinedInfoList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getEtherPmRef().getAlarmCombinedInfoList();
        }

        public Object outer() {
            return EtherPmModel.this;
        }
    }

    class AlarmList
    extends NonCachedValue {
        public AlarmList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getEtherPmRef().getAlarmList();
        }

        public Object outer() {
            return EtherPmModel.this;
        }
    }

    class DeleteAlarm
    extends NonCachedValue {
        public DeleteAlarm(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getEtherPmRef().deleteAlarm((Short)object);
        }

        public Object outer() {
            return EtherPmModel.this;
        }
    }

    class CreateAlarm
    extends NonCachedValue {
        public CreateAlarm(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return new Short(this.node.getIorRepository().getEtherPmRef().createAlarm((sAlarmAdminInfo)object));
        }

        public Object outer() {
            return EtherPmModel.this;
        }
    }

    class StatsSeriesList
    extends NonCachedValue {
        public StatsSeriesList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getEtherPmRef().getStatsSeriesList();
        }

        public Object outer() {
            return EtherPmModel.this;
        }
    }
}

