/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Alarm.sAlarmMessage;
import cerent.cms.idl.Common.sTime;
import cerent.cms.model.AlarmMessageFactory;
import cerent.cms.model.CtcTimeZone;
import cerent.cms.model.CtcTimeZoneFactory;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.AlarmDecoder;
import cerent.cms.model.event.EventFilter;
import cerent.cms.model.event.EventInfo;
import cerent.cms.ui.event.IAlarmDecoder;
import cerent.util.SDebug;
import cerent.util.matcher.AbstractMatcher;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class EventUtilities {
    private SimpleDateFormat formatter;
    private final String DATEFORMAT = "MM/dd/yy HH:mm:ss z";
    private GregorianCalendar calendar;
    private Date date;
    private NodeModelDelegate node;
    private CtcTimeZoneFactory tzFactory;
    protected static final SDebug db = new SDebug("EventUtilities");
    private static ModelSingletonCollection eventUtilitiesSingletons;
    private long cachedLocalTimeValue = 0L;
    private String cachedLocalTime = "";
    private long cachedNeTimeValue = 0L;
    private String cachedNeTime = "";

    public static synchronized EventUtilities getInstance(NodeModelDelegate nodeModelDelegate) {
        EventUtilities eventUtilities;
        if (eventUtilitiesSingletons == null) {
            eventUtilitiesSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"EventUtilities");
        }
        if ((eventUtilities = (EventUtilities)eventUtilitiesSingletons.get((Object)nodeModelDelegate)) == null) {
            eventUtilities = new EventUtilities(nodeModelDelegate);
            eventUtilitiesSingletons.add((Object)nodeModelDelegate, (Object)eventUtilities);
        }
        return eventUtilities;
    }

    private EventUtilities(NodeModelDelegate nodeModelDelegate) {
        this.node = nodeModelDelegate;
        this.calendar = null;
        this.date = new Date();
        this.formatter = new SimpleDateFormat("MM/dd/yy HH:mm:ss z");
        this.formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void convertAlarmsToEventInfo(ArrayList arrayList, sAlarmMessage[] sAlarmMessageArray, long l, boolean bl, boolean bl2) {
        this.convertAlarmsToEventInfo(arrayList, sAlarmMessageArray, l, true, true, false, bl, bl2, 0L, 0L);
    }

    public void convertAlarmsToEventInfo(ArrayList arrayList, sAlarmMessage[] sAlarmMessageArray, long l, boolean bl, boolean bl2, long l2, long l3) {
        this.convertAlarmsToEventInfo(arrayList, sAlarmMessageArray, l, true, true, false, bl, bl2, l2, l3);
    }

    public void convertAlarmsToEventInfo(ArrayList arrayList, sAlarmMessage[] sAlarmMessageArray, long l, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.convertAlarmsToEventInfo(arrayList, sAlarmMessageArray, l, bl, bl2, bl3, bl4, bl5, 0L, 0L);
    }

    public void convertAlarmsToEventInfo(ArrayList arrayList, sAlarmMessage[] sAlarmMessageArray, long l, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, long l2, long l3) {
        EventFilter eventFilter = null;
        boolean bl6 = l2 > 0L;
        AlarmDecoder alarmDecoder = this.node.getAlarmDecoder();
        if (bl6) {
            eventFilter = this.createFilter(l2, l3);
        }
        int n = sAlarmMessageArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String string2;
            long l4;
            if (sAlarmMessageArray[i].timeStamp == 0) {
                l4 = l;
                string2 = this.getLocalTime(l4);
                string = this.getNeTime();
                sAlarmMessageArray[i].timeStamp = (int)l4;
            } else {
                l4 = this.convertSecondsToMilliSeconds(sAlarmMessageArray[i].timeStamp);
                string2 = this.formatAbsoluteNeTimeasCtcTimeZoneString(l4);
                string = this.formatAbsoluteNeTimeasNeTimeZoneString(l4);
            }
            char c = sAlarmMessageArray[i].alarmState.state;
            if (c == '\u0002') {
                if (!bl) {
                    continue;
                }
            } else {
                int n2 = sAlarmMessageArray[i].alarmState.severity.value();
                if (!bl3 && n2 < 2 || !bl2 && n2 >= 2) continue;
            }
            EventInfo eventInfo = new EventInfo((INodeModel)this.node, l4, string2, string, AlarmMessageFactory.getIAlarmMessage(sAlarmMessageArray[i]), (IAlarmDecoder)alarmDecoder);
            eventInfo.setNewAlm(bl5);
            if (bl6 && eventFilter != null) {
                if (!this.fallsWithinDuration(eventInfo, eventFilter)) continue;
                arrayList.add(eventInfo);
                continue;
            }
            arrayList.add(eventInfo);
        }
    }

    protected EventFilter createFilter(long l, long l2) {
        EventFilter eventFilter = new EventFilter("EventUtilities", null, 1);
        AbstractMatcher abstractMatcher = null;
        if (l2 > 0L && l <= l2) {
            abstractMatcher = eventFilter.createTimeMatcher(new Long(l), new Long(l2));
            eventFilter.buildAndSetMatchers(null, abstractMatcher, null, null);
            return eventFilter;
        }
        if (db.on()) {
            db.println("Invalid values passed in startTime:" + l + " endTime: " + l2);
        }
        return null;
    }

    protected boolean fallsWithinDuration(EventInfo eventInfo, EventFilter eventFilter) {
        if (eventFilter.doesMatch(eventInfo)) {
            if (db.on()) {
                db.println(eventInfo.getCondDesc());
            }
            return true;
        }
        return false;
    }

    public long convertSecondsToMilliSeconds(long l) {
        return l * 1000L;
    }

    public synchronized String getLocalTime(long l) {
        long l2 = l - this.cachedLocalTimeValue;
        if (l2 > 500L) {
            this.date.setTime(l);
            this.formatter.setTimeZone(TimeZone.getDefault());
            this.cachedLocalTime = this.formatter.format(this.date);
            this.cachedLocalTimeValue = l;
        }
        return this.cachedLocalTime;
    }

    public synchronized String getNeTime() {
        long l = System.currentTimeMillis();
        long l2 = l - this.cachedNeTimeValue;
        if (l2 > 1000L) {
            try {
                sTime sTime2 = this.node.getTime();
                if (this.calendar == null) {
                    this.calendar = new GregorianCalendar();
                }
                CtcTimeZone ctcTimeZone = this.node.getCtcTimeZone();
                SimpleDateFormat simpleDateFormat = ctcTimeZone.getDateTimeFormatter();
                this.calendar.setTimeZone(ctcTimeZone);
                this.calendar.set(sTime2.year, sTime2.month - 1, sTime2.day, sTime2.hour, sTime2.minute, sTime2.second);
                this.cachedNeTime = simpleDateFormat.format(this.calendar.getTime());
                this.cachedNeTimeValue = l;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.cachedNeTime;
    }

    public String formatAbsoluteNeTimeasCtcTimeZoneString(long l) {
        this.date.setTime(l);
        this.formatter.setTimeZone(TimeZone.getDefault());
        return this.formatter.format(this.date);
    }

    public String formatAbsoluteNeTimeasNeTimeZoneString(long l) {
        this.date.setTime(l);
        CtcTimeZone ctcTimeZone = this.node.getCtcTimeZone();
        SimpleDateFormat simpleDateFormat = ctcTimeZone.getDateTimeFormatter();
        return simpleDateFormat.format(this.date);
    }

    public String convertSecondsToFormattedTimeZoneString(long l) {
        long l2 = l * 1000L;
        this.date.setTime(l2);
        CtcTimeZone ctcTimeZone = this.node.getCtcTimeZone();
        SimpleDateFormat simpleDateFormat = ctcTimeZone.getDateTimeFormatter();
        return simpleDateFormat.format(this.date);
    }

    public String convertSecondsToLongDateFormat(long l) {
        long l2 = l * 1000L;
        Date date = new Date(l2);
        return this.node.getCtcTimeZone().getDateTimeFormatter(1, 1).format(date);
    }

    public boolean useNeTimeZone() {
        return EventFilter.useNeTimeZone();
    }
}

