/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Dwdm.eGccRate;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.Busy;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.InvalidOhTerm;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhMaxConnections;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import java.util.Set;

public class GccTermConnectionModel
extends AbstractTermConnectionModel {
    private static OhChannelType GCC_192K_TERM_CHANNEL_TYPE = OhChannelType.SDCC_OBJ;
    private static OhChannelType GCC_576K_TERM_CHANNEL_TYPE = OhChannelType.LDCC_OBJ;
    private static ModelSingletonCollection gccConnectionModelSingletons;

    public static synchronized GccTermConnectionModel getInstance(NodeModelDelegate nodeModelDelegate) {
        GccTermConnectionModel gccTermConnectionModel;
        if (gccConnectionModelSingletons == null) {
            gccConnectionModelSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"GccTermConnectionModel");
        }
        if ((gccTermConnectionModel = (GccTermConnectionModel)gccConnectionModelSingletons.get((Object)nodeModelDelegate)) == null) {
            gccTermConnectionModel = new GccTermConnectionModel(nodeModelDelegate);
            gccConnectionModelSingletons.add((Object)nodeModelDelegate, (Object)gccTermConnectionModel);
        }
        return gccTermConnectionModel;
    }

    private GccTermConnectionModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) {
        GccTermConnectionModel gccTermConnectionModel = (GccTermConnectionModel)nodeModelDelegate.getGccTermConnectionModel();
        gccTermConnectionModel.init();
    }

    public boolean entityExistsInTerminations(IEntityModel iEntityModel) {
        return this.getTermModel(iEntityModel.getIndex()) != null;
    }

    public IEntityModel[] getTermCandidates() {
        ElementModelsDelegate elementModelsDelegate = this.nmd.getElementModelsDelegate();
        Set set = this.dwdmTrunkPorts(elementModelsDelegate.getNonProtectDwdmEntities());
        set.removeAll(this.nonOTNPorts(set));
        set.removeAll(this.dwdmUnframedPorts(set));
        OhConnectionModelsDelegate ohConnectionModelsDelegate = (OhConnectionModelsDelegate)this.nmd.getOhConnectionModels();
        set.removeAll(ohConnectionModelsDelegate.getUsedOpticalPorts(GCC_192K_TERM_CHANNEL_TYPE));
        set.removeAll(ohConnectionModelsDelegate.getUsedOpticalPorts(GCC_576K_TERM_CHANNEL_TYPE));
        Set set2 = this.excludeUcpTerms(set);
        return set2.toArray(new IEntityModel[0]);
    }

    protected String getTypeName() {
        return "GCC";
    }

    public void createTermination(IEntityModel iEntityModel, eGccRate eGccRate2, boolean bl) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections, ProvisionError {
        this.createTermination(iEntityModel, bl, false, eGccRate2);
    }

    public OhChannelType getChannelType(eGccRate eGccRate2) {
        return eGccRate2 == eGccRate.GCC_RATE_192K ? GCC_192K_TERM_CHANNEL_TYPE : GCC_576K_TERM_CHANNEL_TYPE;
    }

    protected boolean termQualifies(OhTermModel ohTermModel) {
        return this.isGccTerm(ohTermModel) && !this.isOscTerm(ohTermModel);
    }
}

