/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;

public class HoPathDefModel
implements IHoPathDefModel {
    protected short pathWidth;
    protected IHoNum startingHo;
    protected IPoolModel pool;
    protected INodeModel node;
    protected short sts;
    protected short pathIdentifier;

    public HoPathDefModel(IPoolModel iPoolModel, short s, IHoNum iHoNum, short s2) {
        this.pool = iPoolModel;
        this.node = iPoolModel.getNodeModel();
        this.pathWidth = s;
        this.setStartingHo(iHoNum);
        this.pathIdentifier = s2;
    }

    public IPoolModel getPool() {
        return this.pool;
    }

    public short getPathWidth() {
        return this.pathWidth;
    }

    public IHoNum getStartingHo() {
        return this.startingHo;
    }

    public void setStartingHo(IHoNum iHoNum) {
        this.startingHo = iHoNum;
        this._setStartingSts();
    }

    protected void _setStartingSts() {
        this.sts = this.startingHo == null ? (short)0 : this.startingHo.getIdlHoNum();
    }

    public short getStartingSts() {
        return this.sts;
    }

    public void setPathWidth(short s) {
        this.pathWidth = s;
    }

    public void setPool(IPoolModel iPoolModel) {
        this.pool = iPoolModel;
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public static IHoNum physicalHo(IHoPathDefModel iHoPathDefModel) {
        return HoPathDefModel.physicalHo(iHoPathDefModel.getPool(), iHoPathDefModel.getStartingHo());
    }

    public static IHoNum physicalHo(IPoolModel iPoolModel, IHoNum iHoNum) {
        if (iHoNum == null) {
            return iHoNum;
        }
        IHoNum iHoNum2 = iPoolModel.includedPath().getStartingHo();
        return HoLoFactory.addOffset(iHoNum2, iHoNum);
    }

    public String toString() {
        return " Pool : " + this.getPool() + ", starting STS " + this.getStartingHo() + " Width " + this.getPathWidth() + ", pathIdentifier " + this.getPathIdentifier();
    }

    public short getPathIdentifier() {
        return this.pathIdentifier;
    }

    public void setPathIdentifier(short s) {
        this.pathIdentifier = s;
    }

    public boolean equals(Object object) {
        if (object instanceof IHoPathDefModel) {
            IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)object;
            return iHoPathDefModel.getPathWidth() == this.pathWidth && iHoPathDefModel.getStartingHo().equals(this.startingHo) && iHoPathDefModel.getPool().equals(this.pool) && iHoPathDefModel.getNodeModel().getNodeId() == this.node.getNodeId() && iHoPathDefModel.getPathIdentifier() == this.pathIdentifier;
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.startingHo.hashCode();
        n = 37 * n + this.pool.hashCode();
        n = 37 * n + this.node.getNodeId();
        n = 37 * n + this.pathIdentifier;
        n = 37 * n + this.pathWidth;
        return n;
    }
}

