/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.Synchronization.eBits;
import cerent.cms.idl.Synchronization.eManSwitchType;
import cerent.cms.idl.Synchronization.eRef;
import cerent.cms.idl.Synchronization.eTimingState;
import cerent.cms.idl.Synchronization.sBitsConfig;
import cerent.cms.idl.Synchronization.sDemandData;
import cerent.cms.idl.Synchronization.sReferenceInfo;
import cerent.cms.model.AdminState;
import cerent.cms.model.CtcTimeZone;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

class HtmlSynchronizationReport {
    private final String DATEFORMAT = "MM/dd/yy HH:mm:ss z";
    private SynchronizationModel syncModel;
    private static final String defaultReport = "<html><center><strong>No Timing Status Available</center></strong></html>";
    private StringBuffer htmlBuffer;
    private final String START_CENTER = "<CENTER>";
    private final String END_CENTER = "</CENTER>";
    private final String START_PARAGRAPH = "<P>";
    private final String END_PARAGRAPH = "</P>";
    private final String START_TABLE = "<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=2 ALIGN=CENTER WIDTH=100%>";
    private final String END_TABLE = "</TABLE>";
    private final String START_ROW = "<TR>";
    private final String END_ROW = "</TR>";
    private final String START_CELL = "<TD>";
    private final String END_CELL = "</TD>";
    private final String START_STRONG = "<STRONG>";
    private final String END_STRONG = "</STRONG>";
    private final String START_EM = "<EM>";
    private final String END_EM = "</EM>";
    private final String SPACE = "<SPACER TYPE=VERTICAL SIZE=10>";
    private EventUtilities eventUtilities;
    private boolean useNeTimeZone;
    private Date date = null;
    private SimpleDateFormat dateFormat = null;
    protected Map timingModeAttributeMap;
    private int shelfId;
    private static final SDebug db = new SDebug("SyncReport");

    HtmlSynchronizationReport(SynchronizationModel synchronizationModel) {
        this.syncModel = synchronizationModel;
        this.eventUtilities = EventUtilities.getInstance(this.syncModel.getNodeModelDelegate());
        this.htmlBuffer = new StringBuffer();
        this.useNeTimeZone = false;
        this.timingModeAttributeMap = this.syncModel.getNodeModelDelegate().getPlatform().getTimingModeAttributeMap();
        this.date = new Date();
        this.dateFormat = new SimpleDateFormat("MM/dd/yy HH:mm:ss z");
    }

    HtmlSynchronizationReport(SynchronizationModel synchronizationModel, int n) {
        this(synchronizationModel);
        this.shelfId = n;
    }

    private void setTimeStampPolicy() {
        this.useNeTimeZone = this.eventUtilities.useNeTimeZone();
    }

    private String formatTime(long l) {
        String string = "UNKNOWN TIME";
        if (l == 0L) {
            string = "";
        } else {
            long l2 = this.eventUtilities.convertSecondsToMilliSeconds(l);
            string = this.useNeTimeZone ? this.eventUtilities.formatAbsoluteNeTimeasNeTimeZoneString(l2) : this.eventUtilities.formatAbsoluteNeTimeasCtcTimeZoneString(l2);
        }
        return string;
    }

    private String getTitle() {
        String string = this.syncModel.getNodeModelDelegate().getName();
        if (this.syncModel.getNodeModelDelegate().isMultishelf()) {
            return "Timing Status Report for Node " + string + ", Shelf " + this.shelfId;
        }
        return "Timing Status Report for Node " + string;
    }

    private String getTitleTimeStamp() {
        String string = "UNKNOWN TIME";
        string = this.useNeTimeZone ? this.eventUtilities.getNeTime() : this.getLocalTime(System.currentTimeMillis());
        return string;
    }

    private String getTimingMode() {
        String string = null;
        try {
            string = this.timingModeAttributeMap.get(new Integer(this.syncModel.getConfig().timingMode.value())).toString();
        }
        catch (NoSuchEquipment noSuchEquipment) {
            db.println("Caught unexpected exception in getTimingMode()!");
            if (db.on()) {
                SDebug.printStackTrace((Throwable)noSuchEquipment);
            }
            string = "UNKNOWN";
        }
        return string;
    }

    private String getTimingReference(eRef eRef2) {
        db.fine("Timing Reference Value: " + eRef2.value());
        return ElementDefaults.getAttributeMap(this.syncModel).getAttributeForVal("timingRef", eRef2.value()).toString();
    }

    private String getTimingState(eTimingState eTimingState2) {
        db.fine("Timing State Value: " + eTimingState2.value());
        return ElementDefaults.getAttributeMap(this.syncModel).getAttributeForVal("timingState", eTimingState2.value()).toString();
    }

    private String getTimingStateChanged(long l) {
        db.fine("Timing State Changed: " + l + " " + this.formatTime(l));
        return this.formatTime(l);
    }

    private String getSwitchType(eManSwitchType eManSwitchType2) {
        db.fine("Manual Switch Type Value: " + eManSwitchType2.value());
        return ElementDefaults.getAttributeMap(this.syncModel).getAttributeForVal("timingManSwitchType", eManSwitchType2.value()).toString();
    }

    private String getReferenceNumber(sReferenceInfo sReferenceInfo2) {
        db.fine("Reference Number: " + sReferenceInfo2.refNum);
        db.fine("IsProtect: " + sReferenceInfo2.isProtect);
        return new Integer(sReferenceInfo2.refNum).toString() + (sReferenceInfo2.isProtect ? " (Protect)" : "");
    }

    private String getCurrentlySelected(sReferenceInfo sReferenceInfo2) {
        db.fine("currentSelected: " + sReferenceInfo2.currentSelected);
        return sReferenceInfo2.currentSelected ? "X" : "";
    }

    private String getFacility(sReferenceInfo sReferenceInfo2) {
        db.fine("Facility: " + Integer.toHexString(sReferenceInfo2.index));
        EntityModel entityModel = this.syncModel.getRefEntity(sReferenceInfo2.index);
        EntityCellRenderer entityCellRenderer = new EntityCellRenderer("slot ", true);
        return entityModel != null ? entityCellRenderer.getString(entityModel, "slot ") : "UNKNOWN";
    }

    private String getAdminState(eRef eRef2) {
        db.fine("ERef Value for Admin State: " + eRef2.value());
        eBits eBits2 = eBits.BITS_1;
        if (eRef2 == eRef.EXT_1) {
            eBits2 = eBits.BITS_1;
        } else if (eRef2 == eRef.EXT_2) {
            eBits2 = eBits.BITS_2;
        } else {
            return "Indeterminable";
        }
        sBitsConfig sBitsConfig2 = null;
        try {
            sBitsConfig2 = this.syncModel.getBitsConfig(eBits2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            db.fine(xNoSuchInterface2.toString());
            return "Unknown";
        }
        if (sBitsConfig2 == null) {
            db.severe("Null bits config returned for " + eBits2.value());
            return "Unknown";
        }
        return this.getBITSAdminState(sBitsConfig2.adminStateBitsOut);
    }

    private String getAdminState(sReferenceInfo sReferenceInfo2) {
        return this.getBITSAdminState(sReferenceInfo2.adminStatus);
    }

    private String getBITSAdminState(eAdminState eAdminState2) {
        TDMTerminology tDMTerminology = this.syncModel.getNodeModelDelegate().getTDMTerminology();
        return AdminState.enumAdminStateToStr(eAdminState2, tDMTerminology);
    }

    private String getReferenceCondition(sReferenceInfo sReferenceInfo2) {
        db.fine("Reference Condition Value: " + sReferenceInfo2.refCondition.value());
        if (sReferenceInfo2.adminStatus == eAdminState.ADMIN_OOS_DSBLD) {
            return "";
        }
        return ElementDefaults.getAttributeMap(this.syncModel).getAttributeForVal("timingReferenceCondition", sReferenceInfo2.refCondition.value()).toString();
    }

    private String getReferenceConditionChanged(sReferenceInfo sReferenceInfo2) {
        db.fine("Reference Condition Changed: " + sReferenceInfo2.stableTime + " " + this.formatTime(sReferenceInfo2.stableTime));
        if (sReferenceInfo2.adminStatus == eAdminState.ADMIN_OOS_DSBLD) {
            return "";
        }
        return this.formatTime(sReferenceInfo2.stableTime);
    }

    private String getIsSsmOn(sReferenceInfo sReferenceInfo2) {
        db.fine("Is Ssm On: " + sReferenceInfo2.ssmOn);
        if (sReferenceInfo2.adminStatus == eAdminState.ADMIN_OOS_DSBLD) {
            return "";
        }
        return sReferenceInfo2.ssmOn ? "Enabled" : "Disabled";
    }

    private String getSsmQualityLevel(sReferenceInfo sReferenceInfo2) {
        db.fine("Ssm Quality Level Value: " + sReferenceInfo2.ssmQuality.value());
        if (sReferenceInfo2.adminStatus == eAdminState.ADMIN_OOS_DSBLD) {
            return "";
        }
        if (this.syncModel.getNodeModelDelegate().getPlatform().is600() && !sReferenceInfo2.ssmOn && sReferenceInfo2.index != this.syncModel.getInternalClockReference().getIndex()) {
            return "";
        }
        if (sReferenceInfo2.isSSMValid) {
            return ElementDefaults.getAttributeMap(this.syncModel).getAttributeForVal("timingSsmQuality", sReferenceInfo2.ssmQuality.value()).toString();
        }
        return "SSM_FAILED";
    }

    private String getSsmChanged(sReferenceInfo sReferenceInfo2) {
        db.fine("Ssm Changed: " + sReferenceInfo2.ssmStableTime + " " + this.formatTime(sReferenceInfo2.ssmStableTime));
        if (sReferenceInfo2.adminStatus == eAdminState.ADMIN_OOS_DSBLD) {
            return "";
        }
        if (sReferenceInfo2.ssmOn || sReferenceInfo2.index == this.syncModel.getInternalClockReference().getIndex()) {
            return this.formatTime(sReferenceInfo2.ssmStableTime);
        }
        return "";
    }

    private void startHtml() {
        this.htmlBuffer.append("<html>");
    }

    private void startParagraph() {
        this.htmlBuffer.append("<P>");
    }

    private void addLine(String string) {
        this.htmlBuffer.append(string);
    }

    private void endParagraph() {
        this.htmlBuffer.append("</P>");
    }

    private void endBody() {
        this.htmlBuffer.append("</body>");
    }

    private void endHtml() {
        this.htmlBuffer.append("</html>");
    }

    private void addHtmlTitle() {
        this.addLine("<head><title>" + this.getTitle() + "</title></head>");
    }

    private void addReportHeader() {
        this.addLine("<center><strong>" + this.getTitle() + "</strong></center>");
    }

    private void addReportHeaderTimeStamp() {
        this.addLine("<CENTER>" + this.getTitleTimeStamp() + "</CENTER>");
    }

    private void addReference(sDemandData sDemandData2) {
        this.addLine("<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=2 ALIGN=CENTER WIDTH=100%>");
        this.addLine("<TR>");
        this.addLine("<TD><STRONG>Clock: </STRONG>" + this.getTimingReference(sDemandData2.eRefList) + "</TD>");
        if (sDemandData2.eRefList == eRef.EXT_1 || sDemandData2.eRefList == eRef.EXT_2) {
            this.addLine("<TD><STRONG>State: </STRONG>" + this.getAdminState(sDemandData2.eRefList) + "</TD>");
        }
        this.addLine("<TD><STRONG>Status: </STRONG>" + this.getTimingState(sDemandData2.timingState) + "</TD>");
        this.addLine("<TD><STRONG>Status Changed At: </STRONG>" + this.getTimingStateChanged(sDemandData2.tsStableTime) + "</TD>");
        this.addLine("<TD><STRONG>Switch Type: </STRONG>" + this.getSwitchType(sDemandData2.manType) + "</TD>");
        this.addLine("</TR>");
        this.addLine("</TABLE>\n");
        this.startReferenceDetails();
        if (sDemandData2.refList != null) {
            for (int i = 0; i < sDemandData2.refList.length; ++i) {
                if (sDemandData2.refList[i].refNum > 0) {
                    this.addReferenceDetails(sDemandData2.refList[i]);
                    continue;
                }
                db.fine("Skipping reference " + sDemandData2.refList[i].refNum + "  at " + i);
            }
        }
        this.endReferenceDetails();
    }

    private void startReferenceDetails() {
        this.addLine("<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=2 ALIGN=CENTER WIDTH=100%>");
        this.addLine("<TR>");
        this.addLine("<TD><STRONG>Reference</STRONG></TD>");
        this.addLine("<TD><STRONG>Selected</STRONG></TD>");
        this.addLine("<TD><STRONG>Facility</STRONG></TD>");
        this.addLine("<TD><STRONG>State</STRONG></TD>");
        this.addLine("<TD><STRONG>Condition</STRONG></TD>");
        this.addLine("<TD><STRONG>Condition Changed</STRONG></TD>");
        this.addLine("<TD><STRONG>SSM</STRONG></TD>");
        this.addLine("<TD><STRONG>SSM Quality</STRONG></TD>");
        this.addLine("<TD><STRONG>SSM Changed</STRONG></TD>");
        this.addLine("</TR>");
    }

    private void addReferenceDetails(sReferenceInfo sReferenceInfo2) {
        this.addLine("<TR>");
        this.addLine("<TD>" + this.getReferenceNumber(sReferenceInfo2) + "</TD>");
        this.addLine("<TD>" + this.getCurrentlySelected(sReferenceInfo2) + "</TD>");
        this.addLine("<TD>" + this.getFacility(sReferenceInfo2) + "</TD>");
        this.addLine("<TD>" + this.getAdminState(sReferenceInfo2) + "</TD>");
        this.addLine("<TD>" + this.getReferenceCondition(sReferenceInfo2) + "</TD>");
        this.addLine("<TD>" + this.getReferenceConditionChanged(sReferenceInfo2) + "</TD>");
        this.addLine("<TD>" + this.getIsSsmOn(sReferenceInfo2) + "</TD>");
        this.addLine("<TD>" + this.getSsmQualityLevel(sReferenceInfo2) + "</TD>");
        this.addLine("<TD>" + this.getSsmChanged(sReferenceInfo2) + "</TD>");
        this.addLine("</TR>\n");
    }

    private void endReferenceDetails() {
        this.addLine("</TABLE>\n");
    }

    private void addTimingMode() {
        this.addLine("<CENTER><STRONG>Timing Mode: </STRONG>" + this.getTimingMode() + "</CENTER>");
    }

    private void addTimeStampNote() {
        String string = this.useNeTimeZone ? "Times are expressed in terms of the node's clock" : "Times are expressed in terms of the CTC host's clock";
        this.addLine("<SPACER TYPE=VERTICAL SIZE=10><CENTER><EM>" + string + "</EM>" + "</CENTER>");
    }

    public String generateReport() throws NoSuchEquipment {
        this.setTimeStampPolicy();
        db.info("HtmlTimingReport.generateReport()");
        sDemandData[] sDemandDataArray = this.syncModel.getOnDemandData();
        if (sDemandDataArray == null) {
            db.severe("No demand data!");
            this.htmlBuffer = new StringBuffer(defaultReport);
        } else {
            db.fine("Formatting demand data, length " + sDemandDataArray.length);
            this.htmlBuffer = new StringBuffer();
            this.startHtml();
            this.addHtmlTitle();
            this.addReportHeader();
            this.addReportHeaderTimeStamp();
            this.addTimingMode();
            for (int i = 0; i < sDemandDataArray.length; ++i) {
                this.startParagraph();
                this.addReference(sDemandDataArray[i]);
                this.endParagraph();
            }
            this.addTimeStampNote();
            this.endBody();
            this.endHtml();
        }
        db.fine("Length " + this.htmlBuffer.length() + ": " + this.htmlBuffer.toString());
        return this.htmlBuffer.toString();
    }

    private String getLocalTime(long l) {
        this.date.setTime(l);
        this.dateFormat.setTimeZone(CtcTimeZone.getDefault());
        return this.dateFormat.format(this.date);
    }
}

