/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AccessMechanism;
import cerent.cms.model.AccessState;
import cerent.cms.model.IIosModule;
import cerent.cms.model.IosAccessModel;
import cerent.cms.model.IosConfigModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityModel;
import cerent.util.SDebug;

public class IosModuleModel
extends ModuleModel
implements IIosModule {
    private IosConfigModel iosConfigModel;
    private IosAccessModel iosAccessModel;

    public IosModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(IosModuleModel.class));
    }

    public IosModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, sDebug);
    }

    public synchronized IosConfigModel getIosConfig() {
        if (this.supportsIOS() && null == this.iosConfigModel) {
            this.iosConfigModel = new IosConfigModel(this.node, this.entityIndex);
        }
        return this.iosConfigModel;
    }

    public synchronized IosAccessModel getIosAccess() {
        if (this.supportsIOS() && null == this.iosAccessModel) {
            this.iosAccessModel = new IosAccessModel(this.node, this.entityIndex);
        }
        return this.iosAccessModel;
    }

    public void dispose() {
        if (null != this.iosConfigModel) {
            this.iosConfigModel.dispose();
        }
        if (null != this.iosAccessModel) {
            this.iosAccessModel.dispose();
        }
        super.dispose();
    }

    public void destroy() {
        super.destroy();
        if (this.iosConfigModel != null) {
            this.iosConfigModel.destroy();
        }
        if (this.iosAccessModel != null) {
            this.iosAccessModel.destroy();
        }
    }

    public boolean supportsIOS() {
        return true;
    }

    private AccessState getShellAccessState() {
        return ((SecurityModel)this.getNodeModel().getSecurityModel()).getAccessState(AccessMechanism.SHELL_ACCESS);
    }

    public boolean isConsoleEnabled() {
        return this.getShellAccessState().intValue() != AccessState.DISABLED.intValue();
    }

    public boolean isConsoleSecure() {
        return this.getShellAccessState().intValue() == AccessState.SECURE.intValue();
    }
}

