/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Epos.RPR;
import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.EtherMedia.General;
import cerent.cms.model.L2scLineModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.util.SDebug;
import java.util.Observer;

public class L2scPortModel
extends PortModel {
    public L2scPortModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(L2scPortModel.class));
    }

    public L2scPortModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, sDebug);
        this.index = n;
    }

    public void init() {
        super.init();
        if (this.db.on) {
            this.db.println("L2scPortModel::init() " + this + ": Now addObserver for ObjectType.ObjectInterface");
        }
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectInterface, this.getEntityIndex(), (Observer)this);
        }
    }

    public void dispose() {
        if (this.db.on) {
            this.db.println("L2scPortModel::dispose() " + this + ": Now deleteObserver for ObjectType.ObjectInterface");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectInterface, this.getEntityIndex(), (Observer)this);
        }
        super.dispose();
    }

    public L2scLineModel getL2scLineModel() {
        return (L2scLineModel)this.getInterfaceModel();
    }

    public String toString() {
        return "L2sc" + super.toString();
    }

    public boolean isInLoopback() {
        return this.getL2scLineModel().getLoopbackAsInt() != 0;
    }

    public boolean supportsMonitorCircuits() {
        return false;
    }

    protected RPR getRPRRef() {
        return this.getL2scLineModel().getRPRRef();
    }

    protected General getEtherMediaRef() {
        return this.getL2scLineModel().getEtherMediaRef();
    }

    public boolean maybeSetAdminState(int n, int n2, int n3) {
        this.db.info("L2scPortModel.maybeSetAdminState(): " + this.getClass().getName());
        return false;
    }

    public String getPortTypeString(int n) {
        if (this.getParent().getEqType() != 238) {
            return "";
        }
        switch (n) {
            case 0: 
            case 1: {
                return " (DCN)";
            }
            case 9: {
                return " (NC)";
            }
            case 10: {
                return " (PROT)";
            }
            case 11: {
                return "";
            }
        }
        return " (SSC)";
    }
}

