/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Node.sLanRipConfig;
import cerent.cms.idl.Node.sRouteEntry;
import cerent.cms.idl.Node.xInvalidRipCost;
import cerent.cms.idl.Node.xLanOspfAlreadyRun;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ILanRipConfig;
import cerent.cms.model.ILanRipConfigModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRouteEntry;
import cerent.cms.model.InvalidRipCost;
import cerent.cms.model.LanOspfAlreadyRun;
import cerent.cms.model.LanRipConfigFactory;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.RouteEntryFactory;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LanRipConfigModel
extends Model
implements ILanRipConfigModel {
    private LanRipConfig lanRipConfig;
    private RipRoutingTable ripRoutingTable;
    private NodeModelDelegate nmd;
    private EventDispatcher dispatcher;
    private static ModelSingletonCollection lanRipConfigModelSingletons;

    public static synchronized LanRipConfigModel getInstance(NodeModelDelegate nodeModelDelegate) {
        LanRipConfigModel lanRipConfigModel;
        if (lanRipConfigModelSingletons == null) {
            lanRipConfigModelSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"LanRipConfigModel");
        }
        if ((lanRipConfigModel = (LanRipConfigModel)lanRipConfigModelSingletons.get((Object)nodeModelDelegate)) == null) {
            lanRipConfigModel = new LanRipConfigModel(nodeModelDelegate);
            lanRipConfigModelSingletons.add((Object)nodeModelDelegate, (Object)lanRipConfigModel);
        }
        return lanRipConfigModel;
    }

    private LanRipConfigModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(LanRipConfigModel.class));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.lanRipConfig = new LanRipConfig(this.nmd, "LanRipConfigModel.lanRipConfig");
        this.ripRoutingTable = new RipRoutingTable(this.nmd, "LanRipConfigModel.ripRoutingTable");
        this.dispatcher = null;
    }

    public void init() {
        this.dispatcher = this.nmd.getDispatcher();
        super.init0();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSystem, 1, (Observer)this);
        }
    }

    public void dispose() {
        if (this.db.on) {
            this.db.println("Enter LanRipConfigModel dispose()");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSystem, 1, (Observer)this);
            this.dispatcher = null;
        }
        this.lanRipConfig.dispose();
        super.dispose();
        if (this.db.on) {
            this.db.println("Exit LanRipConfigModel dispose()");
        }
    }

    public void destroy() {
        super.destroy();
        this.lanRipConfig = null;
        this.ripRoutingTable = null;
        this.nmd = null;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 1: {
                    if (this.db.on()) {
                        this.db.println("LanRipConfigModel Making local changes.");
                    }
                    this.updateLocal();
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("LanRipConfigModel update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    protected void updateLocal() {
        this.lanRipConfig.update();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public ILanRipConfig getLanRipConfig() {
        try {
            sLanRipConfig sLanRipConfig2 = (sLanRipConfig)this.lanRipConfig.get();
            return LanRipConfigFactory.getILanRipConfig(sLanRipConfig2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setLanRipConfig(ILanRipConfig iLanRipConfig) throws LanOspfAlreadyRun, InvalidRipCost {
        try {
            sLanRipConfig sLanRipConfig2 = LanRipConfigFactory.getLanRipConfig(iLanRipConfig);
            this.lanRipConfig.set(sLanRipConfig2);
        }
        catch (xLanOspfAlreadyRun xLanOspfAlreadyRun2) {
            throw new LanOspfAlreadyRun((UserException)xLanOspfAlreadyRun2);
        }
        catch (xInvalidRipCost xInvalidRipCost2) {
            throw new InvalidRipCost((UserException)xInvalidRipCost2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public IRouteEntry[] getRipRoutingTable() {
        try {
            sRouteEntry[] sRouteEntryArray = (sRouteEntry[])this.ripRoutingTable.get();
            if (this.db.on()) {
                this.db.println("getRipRoutingTable():\n    length = " + sRouteEntryArray.length);
                String string = "";
                for (int i = 0; i < sRouteEntryArray.length; ++i) {
                    if (i > 0) {
                        string = string + ", ";
                    }
                    string = string + sRouteEntryArray[i].ifName;
                }
                this.db.println(string);
            }
            return sRouteEntryArray != null ? RouteEntryFactory.getIRouteEntryArray(sRouteEntryArray) : null;
        }
        catch (UserException userException) {
            this.db.println("Caught UserException in getRipRoutingTable");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    class RipRoutingTable
    extends NonCachedValue {
        public RipRoutingTable(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getNodeNetRef().ripRoutingTable();
        }

        public Object outer() {
            return LanRipConfigModel.this;
        }
    }

    class LanRipConfig
    extends CachedValue {
        public LanRipConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getNodeNetRef().setLanRipConfig((sLanRipConfig)object);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getNodeNetRef().lanRipConfig();
        }

        public Object outer() {
            return LanRipConfigModel.this;
        }
    }
}

