/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.OSI.LapdFactory;
import cerent.cms.idl.OSI.sLapdTerm;
import cerent.cms.idl.OSI.xLspSizeExceedsMtu;
import cerent.cms.idl.OSI.xNoSuchLapdTerm;
import cerent.cms.idl.SonetMedia.xInvalidDcc;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConfigError;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidDcc;
import cerent.cms.model.LspSizeExceedsMtu;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchLAPDTerm;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LapdTermModel
extends Model {
    private final int CREATING = 1;
    private final int EDITING = 2;
    private final int DELETING = 3;
    private NodeModelDelegate nodeModel;
    private LapdList lapdList;
    private ManipulateLapd manipulateLapd;
    private MinMtu minMtu;
    private EventDispatcher dispatcher;
    private static ModelSingletonCollection lapdModelSingletons;

    public static synchronized LapdTermModel getInstance(NodeModelDelegate nodeModelDelegate) {
        LapdTermModel lapdTermModel;
        if (lapdModelSingletons == null) {
            lapdModelSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"LapdModel");
        }
        if ((lapdTermModel = (LapdTermModel)lapdModelSingletons.get((Object)nodeModelDelegate)) == null) {
            lapdTermModel = new LapdTermModel(nodeModelDelegate);
            lapdModelSingletons.add((Object)nodeModelDelegate, (Object)lapdTermModel);
        }
        return lapdTermModel;
    }

    private LapdTermModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(LapdTermModel.class));
        this.nodeModel = nodeModelDelegate;
        this.lapdList = new LapdList(nodeModelDelegate, "LapdTermModel::lapdList");
        this.manipulateLapd = new ManipulateLapd(nodeModelDelegate, "LapdTermModel::manipulateLapd");
        this.minMtu = new MinMtu(nodeModelDelegate, "LapdTermModel::minMtu");
    }

    public INodeModel getNodeModel() {
        return this.getNodeModelDelegate();
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nodeModel;
    }

    private LapdFactory getLapdRef() {
        return this.nodeModel.getIorRepository().getLAPDRef();
    }

    public void init() {
        super.init0();
        this.dispatcher = this.nodeModel.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectLapdTermList, 1, (Observer)this);
        }
        this.lapdList.init();
    }

    public sLapdTerm getLapdByIndex(int n) {
        sLapdTerm[] sLapdTermArray = this.getLapdList();
        if (sLapdTermArray == null) {
            return null;
        }
        for (int i = 0; i < sLapdTermArray.length; ++i) {
            if (sLapdTermArray[i].ifIndex != n) continue;
            return sLapdTermArray[i];
        }
        return null;
    }

    public sLapdTerm[] getLapdList() {
        try {
            return (sLapdTerm[])this.lapdList.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public short getMinMTU() {
        try {
            return (Short)this.minMtu.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 1500;
        }
    }

    public void editLapdTerm(sLapdTerm sLapdTerm2) throws NoSuchLAPDTerm, ConfigError, InvalidDcc, LspSizeExceedsMtu {
        try {
            this.manipulateLapd.set(sLapdTerm2);
        }
        catch (xNoSuchLapdTerm xNoSuchLapdTerm2) {
            throw new NoSuchLAPDTerm((UserException)xNoSuchLapdTerm2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError("LAPD Configuration Error", (UserException)xConfigError2);
        }
        catch (xInvalidDcc xInvalidDcc2) {
            throw new InvalidDcc((UserException)xInvalidDcc2);
        }
        catch (xLspSizeExceedsMtu xLspSizeExceedsMtu2) {
            throw new LspSizeExceedsMtu((UserException)xLspSizeExceedsMtu2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectLapdTermList, 1, (Observer)this);
        }
        this.lapdList.dispose();
        super.dispose();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            switch (((ObjectMessageInfo)object).getUpdateType()) {
                case 0: 
                case 1: 
                case 2: {
                    this.lapdList.update();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        }
    }

    class MinMtu
    extends NonCachedValue {
        public MinMtu(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Short(LapdTermModel.this.getLapdRef().getMinMtu());
        }

        public Object outer() {
            return LapdTermModel.this;
        }
    }

    class ManipulateLapd
    extends NonCachedValue {
        public ManipulateLapd(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            LapdTermModel.this.db.info("Editing LAPD Term " + ((sLapdTerm)object).ifIndex);
            LapdTermModel.this.getLapdRef().editLapdTerm((sLapdTerm)object);
        }

        public Object outer() {
            return LapdTermModel.this;
        }
    }

    class LapdList
    extends CachedValue {
        public LapdList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return LapdTermModel.this.getLapdRef().getLapdTerms();
        }

        public Object outer() {
            return LapdTermModel.this;
        }
    }
}

