/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Dwdm.eGccRate;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FramingType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.ITdmLineModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhTermModel;
import cerent.util.SDebug;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LdccTermConnectionModel
extends AbstractTermConnectionModel {
    private static OhChannelType LDCC_TERM_CHANNEL = OhChannelType.LDCC_OBJ;
    private static OhChannelType LDCC_TUNNEL1_CHANNEL = OhChannelType.LDCC_TUNNEL1_OBJ;
    private static OhChannelType LDCC_TUNNEL2_CHANNEL = OhChannelType.LDCC_TUNNEL2_OBJ;
    private static OhChannelType LDCC_TUNNEL3_CHANNEL = OhChannelType.LDCC_TUNNEL3_OBJ;
    private static OhChannelType UDC_MS_CHANNEL = OhChannelType.UDC_MS_OBJ;
    private static ModelSingletonCollection dccConnectionModelSingletons;

    public static synchronized LdccTermConnectionModel getInstance(NodeModelDelegate nodeModelDelegate) {
        LdccTermConnectionModel ldccTermConnectionModel;
        if (dccConnectionModelSingletons == null) {
            dccConnectionModelSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"LdccTermConnectionModel");
        }
        if ((ldccTermConnectionModel = (LdccTermConnectionModel)dccConnectionModelSingletons.get((Object)nodeModelDelegate)) == null) {
            ldccTermConnectionModel = new LdccTermConnectionModel(nodeModelDelegate);
            dccConnectionModelSingletons.add((Object)nodeModelDelegate, (Object)ldccTermConnectionModel);
        }
        return ldccTermConnectionModel;
    }

    private LdccTermConnectionModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) {
        LdccTermConnectionModel ldccTermConnectionModel = (LdccTermConnectionModel)nodeModelDelegate.getLdccTermConnectionModel();
        ldccTermConnectionModel.init();
    }

    public boolean entityExistsInTerminations(IEntityModel iEntityModel) {
        return this.getTermModel(iEntityModel.getIndex()) != null;
    }

    public IEntityModel[] getTermCandidates() {
        Object object;
        Object object2;
        HashSet<EntityModel> hashSet = new HashSet<EntityModel>();
        ElementModelsDelegate elementModelsDelegate = this.nmd.getElementModelsDelegate();
        Set set = this.getNonTransparentTermDwdmEntities();
        set.removeAll(this.otnEnabledPorts(this.dwdmTrunkPorts(set)));
        IFramingType iFramingType = FramingType.getFramingType((int)this.nmd.getFramingType());
        if (iFramingType.isSonet()) {
            object2 = elementModelsDelegate.getNonProtectOpticalEntities();
            object2.addAll(set);
            object = object2.iterator();
            while (object.hasNext()) {
                try {
                    EntityModel entityModel = (EntityModel)object.next();
                    if (entityModel.getMediumType() != 1) continue;
                    if (this.db.on()) {
                        this.db.println("Found a Sonet port " + entityModel + " adding ...");
                    }
                    hashSet.add(entityModel);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        } else {
            hashSet.addAll(elementModelsDelegate.getNonProtectOpticalEntities());
            hashSet.addAll(set);
        }
        object2 = (OhConnectionModelsDelegate)this.nmd.getOhConnectionModels();
        hashSet.removeAll(((OhConnectionModelsDelegate)object2).getUsedOpticalPorts(LDCC_TERM_CHANNEL));
        hashSet.removeAll(((OhConnectionModelsDelegate)object2).getUsedOpticalPorts(LDCC_TUNNEL1_CHANNEL));
        hashSet.removeAll(((OhConnectionModelsDelegate)object2).getUsedOpticalPorts(LDCC_TUNNEL2_CHANNEL));
        hashSet.removeAll(((OhConnectionModelsDelegate)object2).getUsedOpticalPorts(LDCC_TUNNEL3_CHANNEL));
        hashSet.removeAll(((OhConnectionModelsDelegate)object2).getUsedOpticalPorts(UDC_MS_CHANNEL));
        hashSet.removeAll(this.getNotSupportedTdmPorts(hashSet));
        object = this.excludeUcpTerms(hashSet);
        return object.toArray(new IEntityModel[0]);
    }

    protected String getTypeName() {
        return this.nmd.getTDMTerminology().getGeneralTerms(10);
    }

    public OhChannelType getChannelType(eGccRate eGccRate2) {
        return LDCC_TERM_CHANNEL;
    }

    protected boolean termQualifies(OhTermModel ohTermModel) {
        return ohTermModel.getChannelType() == 4 && !this.isGccTerm(ohTermModel) && !this.isOscTerm(ohTermModel);
    }

    private Set getNotSupportedTdmPorts(Set set) {
        HashSet<ITdmPortModel> hashSet = new HashSet<ITdmPortModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ITdmPortModel iTdmPortModel;
            ITdmLineModel iTdmLineModel;
            Object e = iterator.next();
            if (!(e instanceof ITdmPortModel) || (iTdmLineModel = (iTdmPortModel = (ITdmPortModel)e).getITdmLineModel()).supportsOhChannel(4)) continue;
            hashSet.add(iTdmPortModel);
        }
        return hashSet;
    }
}

