/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Lmp.General;
import cerent.cms.idl.Lmp.eControlChannelOperationalState;
import cerent.cms.idl.Lmp.sControlChannelAttrs;
import cerent.cms.idl.Lmp.sControlChannelResp;
import cerent.cms.idl.Lmp.xLmpException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LmpCtrlChannelModels;
import cerent.cms.model.LmpException;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.ObjectMessageInfo;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LmpCtrlChannelModel
extends Model {
    private static final ObjectType _eventType = ObjectType.ObjectControlChannelList;
    private NodeModelDelegate _nmd;
    private LmpCtrlChannelModels _models;
    private EventDispatcher _dispatcher;
    private Value _value;

    LmpCtrlChannelModel(NodeModelDelegate nodeModelDelegate, LmpCtrlChannelModels lmpCtrlChannelModels, int n) {
        super(nodeModelDelegate.getChildDebug(LmpCtrlChannelModel.class));
        this._nmd = nodeModelDelegate;
        this._models = lmpCtrlChannelModels;
        this._dispatcher = null;
        this.index = n;
        this._value = new Value(this._nmd, "Lmp::ControlChannel" + Integer.toHexString(n));
    }

    General getLmpMgrRef() {
        return this._nmd.getIorRepository().getLmpMgrRef();
    }

    public INodeModel getNodeModel() {
        return this._nmd;
    }

    public void init() {
        if (this._dispatcher == null) {
            this._dispatcher = this._nmd.getDispatcher();
        }
        if (this._dispatcher != null) {
            this._dispatcher.addObserver(_eventType, this.index, (Observer)this);
        }
        this._value.init();
        if (this.db.on()) {
            this.db.println("init(" + this + ")");
        }
        super.init0();
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(" + this + ")");
        }
        this._value.update();
        this.setChanged();
        super.updateLocal();
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("update(" + this + ", arg=" + object + ", from=" + observable + ")");
        }
        if (observable instanceof CmsObservable && object instanceof ObjectMessageInfo) {
            ObjectMessageInfo objectMessageInfo = (ObjectMessageInfo)object;
            switch (objectMessageInfo.getUpdateType()) {
                case 2: {
                    break;
                }
                case 1: {
                    this.updateLocal();
                    break;
                }
                case 0: {
                    this._models.deleted(this);
                }
            }
        }
    }

    public void dispose() {
        if (this._dispatcher != null) {
            this._dispatcher.deleteObserver(_eventType, this.index, (Observer)this);
            this._dispatcher = null;
        }
        this._value.dispose();
        if (this.db.on()) {
            this.db.println("dispose(" + this + ")");
        }
        super.dispose();
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy(" + this + ")");
        }
        super.destroy();
    }

    private sControlChannelResp get() throws LmpException {
        try {
            return (sControlChannelResp)this._value.get();
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "get", userException);
        }
    }

    public void set(sControlChannelAttrs sControlChannelAttrs2) throws LmpException {
        try {
            this._value.set(sControlChannelAttrs2);
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "set", userException);
        }
    }

    public eAdminState getAdminState() throws LmpException {
        return this.get().attrs.admin_status;
    }

    public int getLocalPortId() throws LmpException {
        return this.get().attrs.ifIndex;
    }

    public int getLocalCtrlChannelId() throws LmpException {
        return this.get().local_id;
    }

    public sIpAddr getRemoteNodeId() throws LmpException {
        return this.get().attrs.remote_ne;
    }

    public sIpAddr getRemoteNodeIpAddress() throws LmpException {
        return this.get().attrs.remote_ip;
    }

    public int getRemoteCtrlChannelId() throws LmpException {
        return this.get().remote_id;
    }

    public int getHello() throws LmpException {
        return this.get().attrs.requested_hello & 0xFFFF;
    }

    public int getHelloMin() throws LmpException {
        return this.get().attrs.hello_min & 0xFFFF;
    }

    public int getHelloMax() throws LmpException {
        return this.get().attrs.hello_max & 0xFFFF;
    }

    public int getHelloAct() throws LmpException {
        return this.get().actual_hello & 0xFFFF;
    }

    public int getHelloDead() throws LmpException {
        return this.get().attrs.requested_hello_dead & 0xFFFF;
    }

    public int getHelloDeadMin() throws LmpException {
        return this.get().attrs.hello_dead_min & 0xFFFF;
    }

    public int getHelloDeadMax() throws LmpException {
        return this.get().attrs.hello_dead_max & 0xFFFF;
    }

    public int getHelloDeadAct() throws LmpException {
        return this.get().actual_hello_dead & 0xFFFF;
    }

    public eControlChannelOperationalState getOperationalState() throws LmpException {
        return this.get().operational_status;
    }

    public String toString() {
        return "LmpCtrlChannel#" + this.index;
    }

    private class Value
    extends CachedValue {
        public Value(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xLmpException {
            return LmpCtrlChannelModel.this.getLmpMgrRef().getControlChannel(LmpCtrlChannelModel.this.getIndex());
        }

        protected void setValue(Object object) throws xLmpException {
            LmpCtrlChannelModel.this.getLmpMgrRef().setControlChannel(LmpCtrlChannelModel.this.getIndex(), (sControlChannelAttrs)object);
            LmpCtrlChannelModel.this._value.update();
        }

        public Object outer() {
            return LmpCtrlChannelModel.this;
        }
    }
}

