/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Lmp.General;
import cerent.cms.idl.Lmp.eDataLinkOperationalState;
import cerent.cms.idl.Lmp.eDataLinkType;
import cerent.cms.idl.Lmp.sDataLinkAttrs;
import cerent.cms.idl.Lmp.sDataLinkResp;
import cerent.cms.idl.Lmp.xLmpException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LmpDataLinkModels;
import cerent.cms.model.LmpException;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.ObjectMessageInfo;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LmpDataLinkModel
extends Model {
    private static final ObjectType _eventType = ObjectType.ObjectDataLinkList;
    private NodeModelDelegate _nmd;
    private LmpDataLinkModels _models;
    private EventDispatcher _dispatcher;
    private Value _value;

    LmpDataLinkModel(NodeModelDelegate nodeModelDelegate, LmpDataLinkModels lmpDataLinkModels, int n) {
        super(nodeModelDelegate.getChildDebug(LmpDataLinkModel.class));
        this._nmd = nodeModelDelegate;
        this._models = lmpDataLinkModels;
        this._dispatcher = null;
        this.index = n;
        this._value = new Value(this._nmd, "Lmp::DataLink" + Integer.toHexString(n));
    }

    General getLmpMgrRef() {
        return this._nmd.getIorRepository().getLmpMgrRef();
    }

    public INodeModel getNodeModel() {
        return this._nmd;
    }

    public void init() {
        if (this._dispatcher == null) {
            this._dispatcher = this._nmd.getDispatcher();
        }
        if (this._dispatcher != null) {
            this._dispatcher.addObserver(_eventType, this.index, (Observer)this);
        }
        this._value.init();
        if (this.db.on()) {
            this.db.println("init(" + this + ")");
        }
        super.init0();
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(" + this + ")");
        }
        this._value.update();
        this.setChanged();
        super.updateLocal();
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("update(" + this + ", arg=" + object + ", from=" + observable + ")");
        }
        if (observable instanceof CmsObservable && object instanceof ObjectMessageInfo) {
            ObjectMessageInfo objectMessageInfo = (ObjectMessageInfo)object;
            switch (objectMessageInfo.getUpdateType()) {
                case 2: {
                    break;
                }
                case 1: {
                    this.updateLocal();
                    break;
                }
                case 0: {
                    this._models.deleted(this);
                }
            }
        }
    }

    public void dispose() {
        if (this._dispatcher != null) {
            this._dispatcher.deleteObserver(_eventType, this.index, (Observer)this);
            this._dispatcher = null;
        }
        this._value.dispose();
        if (this.db.on()) {
            this.db.println("dispose(" + this + ")");
        }
        super.dispose();
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy(" + this + ")");
        }
        super.destroy();
    }

    private sDataLinkResp get() throws LmpException {
        try {
            return (sDataLinkResp)this._value.get();
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "get", userException);
        }
    }

    public void set(sDataLinkAttrs sDataLinkAttrs2) throws LmpException {
        try {
            this._value.set(sDataLinkAttrs2);
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "set", userException);
        }
    }

    public int getLocalPortId() throws LmpException {
        return this.get().attrs.tIndex;
    }

    public int getLocalDataLinkId() throws LmpException {
        return this.get().local_id;
    }

    public eDataLinkType getType() throws LmpException {
        return this.get().attrs.type;
    }

    public int getLocalTeLinkId() throws LmpException {
        return this.get().attrs.te_link_id;
    }

    public int getRemoteDataLinkId() throws LmpException {
        return this.get().attrs.remote_id;
    }

    public eDataLinkOperationalState getOperationalState() throws LmpException {
        return this.get().operational_status;
    }

    public String toString() {
        return "LmpDataLink#" + this.index;
    }

    private class Value
    extends CachedValue {
        public Value(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xLmpException {
            return LmpDataLinkModel.this.getLmpMgrRef().getDataLink(LmpDataLinkModel.this.getIndex());
        }

        protected void setValue(Object object) throws xLmpException {
            LmpDataLinkModel.this.getLmpMgrRef().setDataLink(LmpDataLinkModel.this.getIndex(), (sDataLinkAttrs)object);
            LmpDataLinkModel.this._value.update();
        }

        public Object outer() {
            return LmpDataLinkModel.this;
        }
    }
}

