/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.Lmp.General;
import cerent.cms.idl.Lmp.sDataLinkAttrs;
import cerent.cms.idl.Lmp.xLmpException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LmpDataLinkModel;
import cerent.cms.model.LmpException;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.event.ObjectMessageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LmpDataLinkModels
extends Model {
    private static ModelSingletonCollection _singletons;
    private static final ObjectType _eventType;
    private NodeModelDelegate _nmd;
    private EventDispatcher _dispatcher;
    private HashMap _models;
    private Create _create;
    private Get _get;
    private Delete _delete;
    private UserException _getException;

    private LmpDataLinkModels(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(LmpDataLinkModels.class));
        this._nmd = nodeModelDelegate;
        this._dispatcher = null;
        this._models = new HashMap();
        this._create = new Create(this._nmd, "Lmp::DataLinkManager::Create");
        this._get = new Get(this._nmd, "Lmp::DataLinkManager::Get");
        this._delete = new Delete(this._nmd, "Lmp::DataLinkManager::Delete");
        this._getException = null;
        this.index = 0;
    }

    General getLmpMgrRef() {
        return this._nmd.getIorRepository().getLmpMgrRef();
    }

    public INodeModel getNodeModel() {
        return this._nmd;
    }

    public void init() {
        if (this._dispatcher == null) {
            this._dispatcher = this._nmd.getDispatcher();
        }
        if (this._dispatcher != null) {
            this._dispatcher.addObserver(_eventType, 0, (Observer)this);
        }
        this.updateLocal();
        if (this.db.on()) {
            this.db.println("init(" + this + ")");
        }
        super.init0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache() {
        ArrayList arrayList = new ArrayList();
        ArrayList<LmpDataLinkModel> arrayList2 = new ArrayList<LmpDataLinkModel>();
        Iterator iterator = this._models;
        synchronized (iterator) {
            try {
                Integer n;
                Object object;
                this._get.update();
                int[] nArray = (int[])this._get.get();
                this._getException = null;
                HashSet hashSet = new HashSet(this._models.keySet());
                HashSet hashSet2 = new HashSet();
                for (int i = 0; i < nArray.length; ++i) {
                    object = new Integer(nArray[i]);
                    if (hashSet.contains(object)) {
                        hashSet.remove(object);
                        continue;
                    }
                    hashSet2.add(object);
                }
                StringBuffer stringBuffer = null;
                if (this.db.on()) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append('-');
                }
                object = hashSet.iterator();
                while (object.hasNext()) {
                    n = (Integer)object.next();
                    if (this.db.on()) {
                        stringBuffer.append(' ');
                        stringBuffer.append(n);
                    }
                    arrayList.add(this._models.remove(n));
                }
                if (this.db.on()) {
                    if (stringBuffer.length() > 1) {
                        this.db.println(stringBuffer.toString());
                    }
                    stringBuffer.setLength(0);
                    stringBuffer.append('+');
                }
                object = hashSet2.iterator();
                while (object.hasNext()) {
                    n = (Integer)object.next();
                    LmpDataLinkModel lmpDataLinkModel = new LmpDataLinkModel(this._nmd, this, n);
                    if (this.db.on()) {
                        stringBuffer.append(' ');
                        stringBuffer.append(n);
                    }
                    arrayList2.add(lmpDataLinkModel);
                    this._models.put(n, lmpDataLinkModel);
                }
                if (this.db.on() && stringBuffer.length() > 1) {
                    this.db.println(stringBuffer.toString());
                }
            }
            catch (xLmpException xLmpException2) {
                this.db.println("Failed to get LMP data links: " + (Object)((Object)xLmpException2));
                this._getException = xLmpException2;
            }
            catch (UserException userException) {
                this.db.println("Failed to get LMP data links: " + (Object)((Object)userException));
                this._getException = userException;
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((LmpDataLinkModel)iterator.next()).destroy();
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ((LmpDataLinkModel)iterator.next()).init();
        }
        if (!arrayList2.isEmpty()) {
            this.setChanged();
            super.updateLocal();
        }
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(" + this + ")");
        }
        this.updateCache();
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("update(" + this + ", arg=" + object + ", from=" + observable + ")");
        }
        if (observable instanceof CmsObservable && object instanceof ObjectMessageInfo) {
            ObjectMessageInfo objectMessageInfo = (ObjectMessageInfo)object;
            switch (objectMessageInfo.getUpdateType()) {
                case 2: {
                    this.updateLocal();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this._dispatcher != null) {
            this._dispatcher.deleteObserver(_eventType, 0, (Observer)this);
            this._dispatcher = null;
        }
        this._get.dispose();
        HashMap hashMap = this._models;
        synchronized (hashMap) {
            this._models.clear();
        }
        if (this.db.on()) {
            this.db.println("dispose(" + this + ")");
        }
        super.dispose();
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy(" + this + ")");
        }
        super.destroy();
    }

    public int createDataLink(sDataLinkAttrs sDataLinkAttrs2) throws LmpException, WrongInterfaceType, NoSuchInterface {
        try {
            return (Integer)this._create.get(sDataLinkAttrs2);
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "createDataLink", userException);
        }
    }

    public LmpDataLinkModel[] getDataLinks() throws LmpException {
        HashMap hashMap = this._models;
        synchronized (hashMap) {
            if (this._getException != null) {
                this.updateCache();
            }
            if (this._getException == null) {
                LmpDataLinkModel[] lmpDataLinkModelArray = this._models.values().toArray(new LmpDataLinkModel[this._models.size()]);
                if (this.db.on()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append('=');
                    for (int i = 0; i < lmpDataLinkModelArray.length; ++i) {
                        stringBuffer.append(' ');
                        stringBuffer.append(lmpDataLinkModelArray[i].getIndex());
                    }
                    this.db.println(stringBuffer.toString());
                }
                return lmpDataLinkModelArray;
            }
            if (this._getException instanceof xLmpException) {
                throw new LmpException((xLmpException)this._getException);
            }
            throw NodeModelDelegate.doUnknown(this.db, "getDataLinks", this._getException);
        }
    }

    public void deleteDataLink(int n) throws LmpException {
        try {
            this._delete.set(new Integer(n));
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "deleteDataLink", userException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataLink(int n) throws LmpException {
        boolean bl = false;
        HashMap hashMap = this._models;
        synchronized (hashMap) {
            Iterator iterator = this._models.values().iterator();
            while (iterator.hasNext()) {
                LmpDataLinkModel lmpDataLinkModel = (LmpDataLinkModel)iterator.next();
                if (lmpDataLinkModel.getLocalPortId() != n) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public int[] getCandidates() throws LmpException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ElementModelsDelegate elementModelsDelegate = this._nmd.getElementModelsDelegate();
        Object object = elementModelsDelegate.getNonProtectDwdmEntities().iterator();
        while (object.hasNext()) {
            DwdmPortModel dwdmPortModel = (DwdmPortModel)object.next();
            int n = dwdmPortModel.getIndex();
            if (!dwdmPortModel.isClientPort() || this.isDataLink(n)) continue;
            arrayList.add(new Integer(n));
        }
        object = new int[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object[n++] = (Integer)iterator.next();
        }
        return object;
    }

    void deleted(LmpDataLinkModel lmpDataLinkModel) {
        this.updateCache();
    }

    public static synchronized LmpDataLinkModels getInstance(NodeModelDelegate nodeModelDelegate) {
        LmpDataLinkModels lmpDataLinkModels;
        if (_singletons == null) {
            _singletons = ModelSingletonCollection.getMSCInstanceByName((String)"LmpDataLinkModels");
        }
        if ((lmpDataLinkModels = (LmpDataLinkModels)_singletons.get((Object)nodeModelDelegate)) == null) {
            lmpDataLinkModels = new LmpDataLinkModels(nodeModelDelegate);
            _singletons.add((Object)nodeModelDelegate, (Object)lmpDataLinkModels);
        }
        return lmpDataLinkModels;
    }

    public String toString() {
        return "LmpDataLinks#" + this.index;
    }

    static {
        _eventType = ObjectType.ObjectDataLinkList;
    }

    private class Delete
    extends NonCachedValue {
        public Delete(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xLmpException {
            LmpDataLinkModels.this.getLmpMgrRef().deleteDataLink((Integer)object);
        }

        public Object outer() {
            return LmpDataLinkModels.this;
        }
    }

    private class Get
    extends CachedValue {
        public Get(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xLmpException {
            return LmpDataLinkModels.this.getLmpMgrRef().getDataLinks();
        }

        public Object outer() {
            return LmpDataLinkModels.this;
        }
    }

    private class Create
    extends NonCachedValue {
        public Create(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xLmpException, xWrongInterfaceType, xNoSuchInterface {
            return new Integer(LmpDataLinkModels.this.getLmpMgrRef().createDataLink((sDataLinkAttrs)object));
        }

        public Object outer() {
            return LmpDataLinkModels.this;
        }
    }
}

