/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Lmp.General;
import cerent.cms.idl.Lmp.eProductConfigOperationalState;
import cerent.cms.idl.Lmp.eWdmRoleType;
import cerent.cms.idl.Lmp.sProductConfigAttrs;
import cerent.cms.idl.Lmp.sProductConfigResp;
import cerent.cms.idl.Lmp.xLmpException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LmpException;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.ObjectMessageInfo;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LmpModel
extends Model {
    private static ModelSingletonCollection _singletons;
    private static final ObjectType _eventType;
    private NodeModelDelegate _nmd;
    private EventDispatcher _dispatcher;
    private Value _value;

    private LmpModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(LmpModel.class));
        this._nmd = nodeModelDelegate;
        this._dispatcher = null;
        this.index = 0;
        this._value = new Value(this._nmd, "Lmp::General");
    }

    General getLmpMgrRef() {
        return this._nmd.getIorRepository().getLmpMgrRef();
    }

    public INodeModel getNodeModel() {
        return this._nmd;
    }

    public void init() {
        if (this._dispatcher == null) {
            this._dispatcher = this._nmd.getDispatcher();
        }
        if (this._dispatcher != null) {
            this._dispatcher.addObserver(_eventType, 7, (Observer)this);
        }
        this._value.init();
        if (this.db.on()) {
            this.db.println("init(" + this + ")");
        }
        super.init0();
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(" + this + ")");
        }
        this._value.update();
        this.setChanged();
        super.updateLocal();
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("update(" + this + ", arg=" + object + ", from=" + observable + ")");
        }
        if (observable instanceof CmsObservable && object instanceof ObjectMessageInfo) {
            ObjectMessageInfo objectMessageInfo = (ObjectMessageInfo)object;
            switch (objectMessageInfo.getUpdateType()) {
                case 2: {
                    break;
                }
                case 1: {
                    this.updateLocal();
                    break;
                }
            }
        }
    }

    public void dispose() {
        if (this._dispatcher != null) {
            this._dispatcher.deleteObserver(_eventType, 7, (Observer)this);
            this._dispatcher = null;
        }
        this._value.dispose();
        if (this.db.on()) {
            this.db.println("dispose(" + this + ")");
        }
        super.dispose();
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy(" + this + ")");
        }
        super.destroy();
    }

    private sProductConfigResp get() throws LmpException {
        try {
            return (sProductConfigResp)this._value.get();
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "get", userException);
        }
    }

    public void set(sProductConfigAttrs sProductConfigAttrs2) throws LmpException {
        try {
            this._value.set(sProductConfigAttrs2);
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "set", userException);
        }
    }

    public boolean isEnabled() throws LmpException {
        return this.get().attrs.enabled;
    }

    public boolean isWdm() throws LmpException {
        return this.get().attrs.wdm;
    }

    public eWdmRoleType getWdmRole() throws LmpException {
        return this.get().attrs.wdm_role;
    }

    public sIpAddr getLocalNodeId() throws LmpException {
        return this.get().attrs.node_id;
    }

    public eProductConfigOperationalState getOperationalState() throws LmpException {
        return this.get().operational_status;
    }

    public static synchronized LmpModel getInstance(NodeModelDelegate nodeModelDelegate) {
        LmpModel lmpModel;
        if (_singletons == null) {
            _singletons = ModelSingletonCollection.getMSCInstanceByName((String)"LmpModel");
        }
        if ((lmpModel = (LmpModel)_singletons.get((Object)nodeModelDelegate)) == null) {
            lmpModel = new LmpModel(nodeModelDelegate);
            _singletons.add((Object)nodeModelDelegate, (Object)lmpModel);
        }
        return lmpModel;
    }

    public String toString() {
        return "Lmp#" + this.index;
    }

    static {
        _eventType = ObjectType.ObjectSystem;
    }

    private class Value
    extends CachedValue {
        public Value(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xLmpException {
            return LmpModel.this.getLmpMgrRef().getProductConfig();
        }

        protected void setValue(Object object) throws xLmpException {
            LmpModel.this.getLmpMgrRef().setProductConfig((sProductConfigAttrs)object);
            LmpModel.this._value.update();
        }

        public Object outer() {
            return LmpModel.this;
        }
    }
}

