/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Lmp.General;
import cerent.cms.idl.Lmp.eMuxCap;
import cerent.cms.idl.Lmp.eTELinkOperationalState;
import cerent.cms.idl.Lmp.sTELinkAttrs;
import cerent.cms.idl.Lmp.sTELinkResp;
import cerent.cms.idl.Lmp.xLmpException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LmpException;
import cerent.cms.model.LmpTeLinkModels;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.ObjectMessageInfo;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LmpTeLinkModel
extends Model {
    private static final ObjectType _eventType = ObjectType.ObjectTELinkList;
    private NodeModelDelegate _nmd;
    private LmpTeLinkModels _models;
    private EventDispatcher _dispatcher;
    private Value _value;

    LmpTeLinkModel(NodeModelDelegate nodeModelDelegate, LmpTeLinkModels lmpTeLinkModels, int n) {
        super(nodeModelDelegate.getChildDebug(LmpTeLinkModel.class));
        this._nmd = nodeModelDelegate;
        this._models = lmpTeLinkModels;
        this._dispatcher = null;
        this.index = n;
        this._value = new Value(this._nmd, "Lmp::TeLink" + Integer.toHexString(n));
    }

    General getLmpMgrRef() {
        return this._nmd.getIorRepository().getLmpMgrRef();
    }

    public INodeModel getNodeModel() {
        return this._nmd;
    }

    public void init() {
        if (this._dispatcher == null) {
            this._dispatcher = this._nmd.getDispatcher();
        }
        if (this._dispatcher != null) {
            this._dispatcher.addObserver(_eventType, this.index, (Observer)this);
        }
        this._value.init();
        if (this.db.on()) {
            this.db.println("init(" + this + ")");
        }
        super.init0();
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(" + this + ")");
        }
        this._value.update();
        this.setChanged();
        super.updateLocal();
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("update(" + this + ", arg=" + object + ", from=" + observable + ")");
        }
        if (observable instanceof CmsObservable && object instanceof ObjectMessageInfo) {
            ObjectMessageInfo objectMessageInfo = (ObjectMessageInfo)object;
            switch (objectMessageInfo.getUpdateType()) {
                case 2: {
                    break;
                }
                case 1: {
                    this.updateLocal();
                    break;
                }
                case 0: {
                    this._models.deleted(this);
                }
            }
        }
    }

    public void dispose() {
        if (this._dispatcher != null) {
            this._dispatcher.deleteObserver(_eventType, this.index, (Observer)this);
            this._dispatcher = null;
        }
        this._value.dispose();
        if (this.db.on()) {
            this.db.println("dispose(" + this + ")");
        }
        super.dispose();
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy(" + this + ")");
        }
        super.destroy();
    }

    private sTELinkResp get() throws LmpException {
        try {
            return (sTELinkResp)this._value.get();
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "get", userException);
        }
    }

    public void set(sTELinkAttrs sTELinkAttrs2) throws LmpException {
        try {
            this._value.set(sTELinkAttrs2);
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "set", userException);
        }
    }

    public eAdminState getAdminState() throws LmpException {
        return this.get().attrs.admin_status;
    }

    public int getLocalTeLinkId() throws LmpException {
        return this.get().local_id;
    }

    public sIpAddr getRemoteNodeId() throws LmpException {
        return this.get().attrs.remote_ne;
    }

    public int getRemoteTeLinkId() throws LmpException {
        return this.get().attrs.rem_un_id;
    }

    public boolean getDwdm() throws LmpException {
        return this.get().dwdm;
    }

    public eMuxCap getMuxCap() throws LmpException {
        return this.get().attrs.mux_cap;
    }

    public eTELinkOperationalState getOperationalState() throws LmpException {
        return this.get().operational_status;
    }

    public String toString() {
        return "LmpTeLink#" + this.index;
    }

    private class Value
    extends CachedValue {
        public Value(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xLmpException {
            return LmpTeLinkModel.this.getLmpMgrRef().getTELink(LmpTeLinkModel.this.getIndex());
        }

        protected void setValue(Object object) throws xLmpException {
            LmpTeLinkModel.this.getLmpMgrRef().setTELink(LmpTeLinkModel.this.getIndex(), (sTELinkAttrs)object);
            LmpTeLinkModel.this._value.update();
        }

        public Object outer() {
            return LmpTeLinkModel.this;
        }
    }
}

