/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.EtherMedia.General;
import cerent.cms.idl.EtherMedia.sSonetPathsPosChipInfo;
import cerent.cms.idl.EtherMedia.sSonetPathsPosPortInfo;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.IosModuleModel;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2EtherPortModel;
import cerent.cms.model.ML2FastELineModel;
import cerent.cms.model.ML2GigELineModel;
import cerent.cms.model.ML2LineModel;
import cerent.cms.model.ML2PosLineModel;
import cerent.cms.model.ML2PosPortModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PortModel;
import cerent.cms.model.UnsupportedOperation;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.UserException;

public class ML2ModuleModel
extends IosModuleModel {
    private SonetPathsPosPortInfoList sonetPathsPosPortInfoList;
    private SonetPathsPosChipInfoList sonetPathsPosChipInfoList;

    public ML2ModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(ML2ModuleModel.class));
        this.sonetPathsPosPortInfoList = new SonetPathsPosPortInfoList(nodeModelDelegate, "ML2ModuleModel::getSonetPathsPosPortInfoList");
        this.sonetPathsPosChipInfoList = new SonetPathsPosChipInfoList(nodeModelDelegate, "ML2ModuleModel::getSonetPathsPosChipInfoList");
    }

    public sSonetPathsPosPortInfo[] getSonetPathsPosPortInfoList() throws NoSuchEquipment, UnsupportedOperation {
        try {
            return (sSonetPathsPosPortInfo[])this.sonetPathsPosPortInfoList.get(new Integer(this.entityIndex));
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new UnsupportedOperation((UserException)xNotSupportedOnEquipment2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getSonetPathsPosPortList", userException);
        }
    }

    public sSonetPathsPosChipInfo[] getSonetPathsPosChipInfoList() throws NoSuchEquipment, UnsupportedOperation {
        try {
            return (sSonetPathsPosChipInfo[])this.sonetPathsPosChipInfoList.get(new Integer(this.entityIndex));
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new UnsupportedOperation((UserException)xNotSupportedOnEquipment2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getSonetPathsPosChipList", userException);
        }
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        if (this.db.on()) {
            this.db.println("ML2ModuleModel::getPortModels " + eEqType2);
        }
        PortModel[] portModelArray = null;
        portModelArray = eEqType2 == eEqType.L1P_ETHER_PORT || eEqType2 == eEqType.CE_1000_ETHER_PORT ? this.getChildrenOfType(eEqType2).toArray(new ML2EtherPortModel[0]) : (eEqType2 == eEqType.L1P_POS_PORT || eEqType2 == eEqType.CE_1000_POS_PORT ? this.getChildrenOfType(eEqType2).toArray(new ML2PosPortModel[0]) : this.getDescendantsOfClassType(7).toArray(new PortModel[0]));
        if (this.db.on() && portModelArray == null) {
            this.db.println("ML2ModuleModel::getPortModels, no ports found");
        }
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    public ML2EtherPortModel[] getEtherPortModels() {
        int n = this.getEqType();
        if (n == 229) {
            return (ML2EtherPortModel[])this.getPortModels(eEqType.CE_1000_ETHER_PORT);
        }
        return (ML2EtherPortModel[])this.getPortModels(eEqType.L1P_ETHER_PORT);
    }

    public ML2PosPortModel[] getPosPortModels() {
        int n = this.getEqType();
        if (n == 229) {
            return (ML2PosPortModel[])this.getPortModels(eEqType.CE_1000_POS_PORT);
        }
        return (ML2PosPortModel[])this.getPortModels(eEqType.L1P_POS_PORT);
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        PortModel[] portModelArray = this.getPortModels(eEqType2);
        ML2LineModel[] mL2LineModelArray = null;
        if (eEqType2 == eEqType.L1P_ETHER_PORT) {
            mL2LineModelArray = new ML2FastELineModel[portModelArray.length];
            for (int i = 0; i < portModelArray.length; ++i) {
                mL2LineModelArray[i] = (ML2FastELineModel)portModelArray[i].getInterfaceModel();
            }
        } else if (eEqType2 == eEqType.CE_1000_ETHER_PORT) {
            mL2LineModelArray = new ML2GigELineModel[portModelArray.length];
            for (int i = 0; i < portModelArray.length; ++i) {
                mL2LineModelArray[i] = (ML2GigELineModel)portModelArray[i].getInterfaceModel();
            }
        } else if (eEqType2 == eEqType.L1P_POS_PORT || eEqType2 == eEqType.CE_1000_POS_PORT) {
            mL2LineModelArray = new ML2PosLineModel[portModelArray.length];
            for (int i = 0; i < portModelArray.length; ++i) {
                mL2LineModelArray[i] = (ML2PosLineModel)portModelArray[i].getInterfaceModel();
            }
        } else {
            mL2LineModelArray = new ML2LineModel[portModelArray.length];
            for (int i = 0; i < portModelArray.length; ++i) {
                mL2LineModelArray[i] = (ML2LineModel)portModelArray[i].getInterfaceModel();
            }
        }
        return mL2LineModelArray == null ? new InterfaceModel[]{} : mL2LineModelArray;
    }

    public ML2EtherLineModel[] getEtherLineModels() {
        int n = this.getEqType();
        if (n == 229) {
            return (ML2EtherLineModel[])this.getLineModels(eEqType.CE_1000_ETHER_PORT);
        }
        return (ML2EtherLineModel[])this.getLineModels(eEqType.L1P_ETHER_PORT);
    }

    public ML2PosLineModel[] getPosLineModels() {
        int n = this.getEqType();
        if (n == 229) {
            return (ML2PosLineModel[])this.getLineModels(eEqType.CE_1000_POS_PORT);
        }
        return (ML2PosLineModel[])this.getLineModels(eEqType.L1P_POS_PORT);
    }

    public List getConnectionsList() {
        LinkedList linkedList = new LinkedList();
        ML2PosPortModel[] mL2PosPortModelArray = this.getPosPortModels();
        if (mL2PosPortModelArray != null) {
            for (int i = 0; i < mL2PosPortModelArray.length; ++i) {
                List list = mL2PosPortModelArray[i].getConnectionsList();
                if (list == null) continue;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    linkedList.add(iterator.next());
                }
            }
        }
        return linkedList;
    }

    public boolean isResourceInUse() {
        ML2PosPortModel[] mL2PosPortModelArray = this.getPosPortModels();
        if (mL2PosPortModelArray != null) {
            for (int i = 0; i < mL2PosPortModelArray.length; ++i) {
                List list = mL2PosPortModelArray[i].getConnectionsList();
                if (list == null || list.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInMapperMode() {
        int n = this.getEqType();
        return n == 163 || n == 187 || n == 229;
    }

    protected General getEtherMediaRef() {
        return this.getNodeModelDelegate().getIorRepository().getEtherMediaRef();
    }

    public InterfaceModel[] getPathTraceLines() {
        return this.getPosLineModels();
    }

    boolean isPortNumUnique(int n) {
        return false;
    }

    public boolean isComboModule() {
        return true;
    }

    public boolean supportsIOS() {
        return this.getEqType() == 164;
    }

    class SonetPathsPosChipInfoList
    extends NonCachedValue {
        public SonetPathsPosChipInfoList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchEquipment, xNotSupportedOnEquipment {
            return ML2ModuleModel.this.getEtherMediaRef().getSonetPathsPosChipInfoList((Integer)object);
        }
    }

    class SonetPathsPosPortInfoList
    extends NonCachedValue {
        public SonetPathsPosPortInfoList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchEquipment, xNotSupportedOnEquipment {
            return ML2ModuleModel.this.getEtherMediaRef().getSonetPathsPosPortInfoList((Integer)object);
        }

        public Object outer() {
            return ML2ModuleModel.this;
        }
    }
}

