/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.CmsNoPermissionException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.IValue;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.KDebug;
import cerent.util.ThreadLocalCounter;
import cerent.util.stats.StatsMgr;
import java.lang.reflect.Field;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.REBIND;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;

public abstract class NonCachedValue
implements IValue {
    protected NodeModelDelegate node;
    protected static ThreadLocalCounter counter = new ThreadLocalCounter();

    public NonCachedValue(NodeModelDelegate nodeModelDelegate, String string) {
        this(nodeModelDelegate);
    }

    public NonCachedValue(NodeModelDelegate nodeModelDelegate) {
        this.node = nodeModelDelegate;
    }

    protected Object getValue() throws UserException {
        return null;
    }

    protected Object getValue(Object object) throws UserException {
        return null;
    }

    public Object get() throws AbstractCmsIOException, UserException {
        return this.get(null);
    }

    public Object get(Object object) throws AbstractCmsIOException, UserException {
        counter.increment();
        if (this.node.isReadyForCorbaRequest()) {
            Throwable throwable = null;
            Object object2 = null;
            if (StatsMgr.instance().isStarted()) {
                object2 = StatsMgr.instance().beginOperation((Object)this, this.node.getNameNoCV(), false, true);
            }
            try {
                Object object3 = null;
                object3 = object == null ? this.getValue() : this.getValue(object);
                Object object4 = object3;
                return object4;
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                throwable = oBJECT_NOT_EXIST;
                throw new CmsObjectNotExistException("Attempt to access the " + this.getAttributeName() + " attribute for an object that does not exist.");
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                this.node.setCommunicationFailure((Exception)((Object)cOMM_FAILURE));
                throwable = cOMM_FAILURE;
                throw new CmsCommFailException(this.node.getHostName() + " Communications error (COMM_FAILURE) while attempting to " + "get the " + this.getAttributeName() + " attribute.");
            }
            catch (REBIND rEBIND) {
                this.node.setCommunicationFailure((Exception)((Object)rEBIND));
                throwable = rEBIND;
                throw new CmsCommFailException(this.node.getHostName() + " Rebind error while attempting to get the " + this.getAttributeName() + " attribute.");
            }
            catch (TIMEOUT tIMEOUT) {
                throwable = tIMEOUT;
                this.node.setCommunicationFailure((Exception)((Object)tIMEOUT));
                throw new CmsCommFailException(this.node.getHostName() + " Timeout error while attempting to get the " + this.getAttributeName() + " attribute.");
            }
            catch (TRANSIENT tRANSIENT) {
                throwable = tRANSIENT;
                this.node.setCommunicationFailure((Exception)((Object)tRANSIENT));
                throw new CmsCommFailException(this.node.getHostName() + " Transient error while attempting to get the " + this.getAttributeName() + " attribute.");
            }
            catch (NO_PERMISSION nO_PERMISSION) {
                throwable = nO_PERMISSION;
                this.node.setPermissionFailure();
                throw new CmsNoPermissionException(this.node.getHostName() + " No Permission error while attempting to get the " + this.getAttributeName() + " attribute.");
            }
            finally {
                if (object2 != null) {
                    StatsMgr.instance().endOperation(object2, null, (Exception)throwable);
                }
            }
        }
        throw new CmsCommFailException(this.node.getHostName() + " The Node was not initialized while attempting to " + "get the " + this.getAttributeName() + " attribute.");
    }

    protected void setValue(Object object) throws UserException {
    }

    protected void setValue() throws UserException {
    }

    public void set() throws AbstractCmsIOException, UserException {
        this.set(null);
    }

    public void set(Object object) throws AbstractCmsIOException, UserException {
        if (this.node.isReadyForCorbaRequest()) {
            Throwable throwable = null;
            Object object2 = null;
            if (StatsMgr.instance().isStarted()) {
                object2 = StatsMgr.instance().beginOperation((Object)this, this.node.getNameNoCV(), false, true);
            }
            try {
                if (object == null) {
                    this.setValue();
                }
                this.setValue(object);
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                throwable = oBJECT_NOT_EXIST;
                throw new CmsObjectNotExistException("Attempt to set the " + this.getAttributeName() + " attribute for an object that does not " + "exist.");
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                throwable = cOMM_FAILURE;
                this.node.setCommunicationFailure((Exception)((Object)cOMM_FAILURE));
                throw new CmsCommFailException(this.node.getHostName() + " Communications error (COMM_FAILURE) while attempting to " + "set the " + this.getAttributeName() + " attribute.");
            }
            catch (REBIND rEBIND) {
                throwable = rEBIND;
                this.node.setCommunicationFailure((Exception)((Object)rEBIND));
                throw new CmsCommFailException(this.node.getHostName() + " Rebind error while attempting to set the " + this.getAttributeName() + " attribute.");
            }
            catch (TIMEOUT tIMEOUT) {
                throwable = tIMEOUT;
                this.node.setCommunicationFailure((Exception)((Object)tIMEOUT));
                throw new CmsCommFailException(this.node.getHostName() + " Timeout error while attempting to set the " + this.getAttributeName() + " attribute.");
            }
            catch (TRANSIENT tRANSIENT) {
                throwable = tRANSIENT;
                this.node.setCommunicationFailure((Exception)((Object)tRANSIENT));
                throw new CmsCommFailException(this.node.getHostName() + " Transient error while attempting to set the " + this.getAttributeName() + " attribute.");
            }
            catch (NO_PERMISSION nO_PERMISSION) {
                throwable = nO_PERMISSION;
                this.node.setPermissionFailure();
                throw new CmsNoPermissionException(this.node.getHostName() + " No Permission error while attempting to set the " + this.getAttributeName() + " attribute.");
            }
            finally {
                if (object2 != null) {
                    StatsMgr.instance().endOperation(object2, null, (Exception)throwable);
                }
            }
        } else {
            throw new CmsCommFailException(this.node.getHostName() + " The Node was not initialized while attempting to set the " + this.getAttributeName() + " attribute.");
        }
    }

    public NodeModelDelegate getNode() {
        return this.node;
    }

    public String toString() {
        return "NonCachedValue[" + this.getAttributeName() + "]";
    }

    public String getAttributeName() {
        String string = this.getClass().getName();
        int n = string.indexOf(36);
        if (n >= 0) {
            int n2 = string.lastIndexOf(46, n);
            if (n2 >= 0) {
                string = string.substring(n2 + 1);
            }
            string = string.replace('$', '.');
        }
        return string;
    }

    public static Object getTopLevelContainer(Object object, KDebug kDebug) {
        boolean bl = false;
        Object object2 = object;
        Class<?> clazz = object.getClass();
        Field field = null;
        Field field2 = null;
        Object object3 = null;
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (!bl) {
            ++n3;
            Field[] fieldArray = clazz.getDeclaredFields();
            Field field3 = null;
            n = -1;
            n2 = fieldArray.length;
            for (int i = 0; field3 == null && i < n2; ++i) {
                String string = fieldArray[i].getName();
                if (!string.startsWith("this$")) continue;
                n = Integer.parseInt(string.substring(5));
                field3 = fieldArray[i];
            }
            if (field3 == null) {
                bl = true;
                continue;
            }
            if (n == 0) {
                bl = true;
                field2 = field = field3;
                continue;
            }
            field3.setAccessible(true);
            Object object4 = null;
            try {
                object4 = field3.get(object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            field2 = field3;
            field3 = null;
            object2 = object4;
            if (object2 == null) {
                bl = true;
                continue;
            }
            clazz = object2.getClass();
        }
        if (field != null) {
            field.setAccessible(true);
            try {
                object3 = field.get(object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (object3 == null) {
            if (field != null) {
                return field2;
            }
            if (kDebug != null) {
                kDebug.println("failed to locate outer instance for class: " + clazz.getName() + " pass: " + n3 + " depth: " + n + " numFields: " + n2 + " containerField: " + field);
            }
        }
        return object3;
    }

    public static void resetCounter() {
        counter.reset();
    }

    public static int getCounter() {
        return counter.get();
    }

    public static void setCounter(int n) {
        counter.set(n);
    }

    public void dispose() {
    }

    public void update() {
    }
}

