/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AlreadyInUse;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.util.SDebug;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class OchPortsHelper {
    private static final SDebug db = new SDebug("OchPortsHelper");

    public static IEntityModel getOutLinePort(int n, IEntityModel iEntityModel) {
        return OchPortsHelper.getOutLinePort(0, n, iEntityModel);
    }

    public static IEntityModel getProtectedOutLinePort(int n, IEntityModel iEntityModel) {
        return OchPortsHelper.getOutLinePort(1, n, iEntityModel);
    }

    public static IEntityModel getOutLinePort(int n, int n2, IEntityModel iEntityModel) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        try {
            int n3;
            int[] nArray = OchPortsHelper.getOutPoints(n2, iEntityModel, iNodeModel);
            if (db.on()) {
                db.println("Found " + nArray.length + " outpoints for channel " + n2 + ", port 0x" + Integer.toHexString(iEntityModel.getEntityIndex()));
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    db.println(n3 + ": 0x" + Integer.toHexString(nArray[n3]));
                }
            }
            if (OchPortsHelper.isAddPort(iEntityModel)) {
                return iEntityTableModel.getEntityModelByIndex(nArray[n]);
            }
            n3 = nArray[n];
            int n4 = iEntityModel.getEntityIndex();
            int[] nArray2 = iNodeModel.getINodeOpticsTopologyModel().getOchncLineReverseEntitiesPair(n3, n4);
            if (db.on()) {
                db.println("Found " + nArray2.length + " reverse pairs for 0x" + Integer.toHexString(n3) + ", 0x" + Integer.toHexString(n4));
                for (int i = 0; i < nArray2.length; ++i) {
                    db.println(i + ": 0x" + Integer.toHexString(nArray2[i]));
                }
            }
            return iEntityTableModel.getEntityModelByIndex(nArray2[1]);
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public static IEntityModel getInLinePort(int n, IEntityModel iEntityModel) {
        return OchPortsHelper.getInLinePort(0, n, iEntityModel);
    }

    public static IEntityModel getProtectedInLinePort(int n, IEntityModel iEntityModel) {
        return OchPortsHelper.getInLinePort(1, n, iEntityModel);
    }

    private static IEntityModel getInLinePort(int n, int n2, IEntityModel iEntityModel) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        try {
            int n3;
            int[] nArray = OchPortsHelper.getOutPoints(n2, iEntityModel, iNodeModel);
            if (db.on()) {
                db.println("Found " + nArray.length + " outpoints for channel " + n2 + ", port 0x" + Integer.toHexString(iEntityModel.getEntityIndex()));
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    db.println(n3 + ": 0x" + Integer.toHexString(nArray[n3]));
                }
            }
            if (!OchPortsHelper.isAddPort(iEntityModel)) {
                return iEntityTableModel.getEntityModelByIndex(nArray[n]);
            }
            n3 = iEntityModel.getEntityIndex();
            int n4 = nArray[n];
            int[] nArray2 = iNodeModel.getINodeOpticsTopologyModel().getOchncLineReverseEntitiesPair(n3, n4);
            if (db.on()) {
                db.println("Found " + nArray2.length + " reverse pairs for 0x" + Integer.toHexString(n3) + ", 0x" + Integer.toHexString(n4));
                for (int i = 0; i < nArray2.length; ++i) {
                    db.println(i + ": 0x" + Integer.toHexString(nArray2[i]));
                }
            }
            return iEntityTableModel.getEntityModelByIndex(nArray2[0]);
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public static IEntityModel getReversePort(int n, IEntityModel iEntityModel) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        try {
            int n2;
            int n3;
            int[] nArray = OchPortsHelper.getOutPoints(n, iEntityModel, iNodeModel);
            if (db.on()) {
                db.println("Found " + nArray.length + " outpoints for channel " + n + ", port 0x" + Integer.toHexString(iEntityModel.getEntityIndex()));
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    db.println(n3 + ": 0x" + Integer.toHexString(nArray[n3]));
                }
            }
            if (OchPortsHelper.isAddPort(iEntityModel)) {
                n3 = iEntityModel.getEntityIndex();
                n2 = nArray[0];
            } else {
                n3 = nArray[0];
                n2 = iEntityModel.getEntityIndex();
            }
            int[] nArray2 = iNodeModel.getINodeOpticsTopologyModel().getOchncLineReverseEntitiesPair(n3, n2);
            if (db.on()) {
                db.println("Found " + nArray2.length + " reverse pairs for 0x" + Integer.toHexString(n3) + ", 0x" + Integer.toHexString(n2));
                for (int i = 0; i < nArray2.length; ++i) {
                    db.println(i + ": 0x" + Integer.toHexString(nArray2[i]));
                }
            }
            IEntityModel iEntityModel2 = null;
            iEntityModel2 = OchPortsHelper.isAddPort(iEntityModel) ? iEntityTableModel.getEntityModelByIndex(nArray2[1]) : iEntityTableModel.getEntityModelByIndex(nArray2[0]);
            if (db.on()) {
                db.println("Reverse channel for port " + iEntityModel + " is " + iEntityModel2);
            }
            return iEntityModel2;
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public static boolean isAddPort(INodeModel iNodeModel, int n) {
        try {
            return OchPortsHelper.isAddPort(iNodeModel.getEntityTable().getEntityModelByIndex(n));
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return false;
        }
    }

    public static boolean isAddPort(IEntityModel iEntityModel) {
        int n = iEntityModel.getEqType();
        int n2 = iEntityModel.getModuleModel().getEqType();
        boolean bl = false;
        if (n2 == 131 || n2 == 242 || n2 == 191) {
            bl = true;
        } else if (n2 == 132 || n2 == 241 || n2 == 192) {
            bl = false;
        } else if (n2 == 133 || n == 141) {
            bl = iEntityModel.getEntityIndex() % 2 == 0;
        } else if (OchPortsHelper.isOtsPort(iEntityModel)) {
            IPortModel iPortModel = (IPortModel)iEntityModel;
            IOpticsModel iOpticsModel = (IOpticsModel)iPortModel.getInterfaceModel();
            if (Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.OCH_TRAIL_PROVISIONING)) {
                bl = iOpticsModel.isPortTypeRX();
            } else {
                throw new FeatureNotSupported("IOpticsModel.isPortTypeRX() is not supported");
            }
        }
        if (db.on()) {
            db.println("isAddPort: " + iEntityModel + ", card " + iEntityModel.getModuleModel() + ", eqType " + n + ": " + bl);
        }
        return bl;
    }

    public static boolean isOpticPort(INodeModel iNodeModel, int n) {
        IEntityModel iEntityModel;
        boolean bl;
        block4: {
            bl = false;
            iEntityModel = null;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                if (iEntityModel instanceof IPortModel) {
                    IPortModel iPortModel = (IPortModel)iEntityModel;
                    bl = iPortModel.getInterfaceModel() instanceof IOpticsModel;
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("isOpticPort: exception getting entity model" + exception);
            }
        }
        if (db.on()) {
            db.println("isOpticPort(" + iNodeModel.getName() + ", " + Integer.toHexString(n) + " [" + iEntityModel + "]: " + bl);
        }
        return bl;
    }

    public static boolean isOtsPort(IEntityModel iEntityModel) {
        boolean bl;
        int n = iEntityModel.getEqType();
        boolean bl2 = bl = n == 142 || n == 140;
        if (db.on()) {
            db.println("isOtsPort: " + iEntityModel + ", eqType " + n + ": " + bl);
        }
        return bl;
    }

    public static boolean isOchPort(IEntityModel iEntityModel) {
        return !OchPortsHelper.isOtsPort(iEntityModel);
    }

    public static boolean isOchPort(INodeModel iNodeModel, int n) {
        boolean bl;
        block2: {
            bl = false;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                bl = OchPortsHelper.isOchPort(iEntityModel);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("isOchPort: exception getting entity model" + exception);
            }
        }
        return bl;
    }

    public static boolean isAvailableForOchncSource(INodeModel iNodeModel, int n, boolean bl) {
        boolean bl2;
        List list = OchPortsHelper.getAddPortsForOchnc(iNodeModel, n);
        if (!bl) {
            bl2 = list.size() > 0;
        } else {
            List list2 = OchPortsHelper.getDropPortsForOchnc(iNodeModel, n);
            boolean bl3 = bl2 = list.size() > 0 && list2.size() > 0;
        }
        if (db.on()) {
            db.println("isAvailableForOchncSource(" + iNodeModel + ") :" + bl2);
        }
        return bl2;
    }

    public static boolean isAvailableForOchncDrop(INodeModel iNodeModel, int n, boolean bl) {
        boolean bl2;
        List list = OchPortsHelper.getDropPortsForOchnc(iNodeModel, n);
        if (!bl) {
            bl2 = list.size() > 0;
        } else {
            List list2 = OchPortsHelper.getAddPortsForOchnc(iNodeModel, n);
            boolean bl3 = bl2 = list2.size() > 0 && list.size() > 0;
        }
        if (db.on()) {
            db.println("isAvailableForOchncDrop(" + iNodeModel + ") :" + bl2);
        }
        return bl2;
    }

    public static List getAddPortsForOchnc(INodeModel iNodeModel, int n) {
        int n2;
        Serializable serializable;
        int[] nArray;
        IEntityTableModel iEntityTableModel;
        block7: {
            iEntityTableModel = iNodeModel.getEntityTable();
            nArray = new int[]{};
            try {
                nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailEntitiesForOchnc(n, 0);
            }
            catch (Exception exception) {
                if (!db.on()) break block7;
                db.println("Cannot get available entities for OCHNC: " + exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on()) {
            serializable = new StringBuffer();
            for (n2 = 0; n2 < nArray.length; ++n2) {
                ((StringBuffer)serializable).append(" ");
                ((StringBuffer)serializable).append(Integer.toHexString(nArray[n2]));
            }
            db.println("Node " + iNodeModel + " - ADD entities for " + n + ": [" + serializable + "]");
        }
        serializable = new LinkedList();
        for (n2 = 0; nArray != null && n2 < nArray.length; ++n2) {
            try {
                serializable.add(iEntityTableModel.getEntityModelByIndex(nArray[n2]));
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return serializable;
    }

    public static List getDropPortsForOchnc(INodeModel iNodeModel, int n) {
        int n2;
        Serializable serializable;
        int[] nArray;
        IEntityTableModel iEntityTableModel;
        block7: {
            iEntityTableModel = iNodeModel.getEntityTable();
            nArray = new int[]{};
            try {
                nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailEntitiesForOchnc(n, 1);
            }
            catch (Exception exception) {
                if (!db.on()) break block7;
                db.println("Cannot get available entities for OCHNC: " + exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on()) {
            serializable = new StringBuffer();
            for (n2 = 0; n2 < nArray.length; ++n2) {
                ((StringBuffer)serializable).append(" ");
                ((StringBuffer)serializable).append(Integer.toHexString(nArray[n2]));
            }
            db.println("Node " + iNodeModel + " - DROP entities for " + n + ": [" + serializable + "]");
        }
        serializable = new LinkedList();
        for (n2 = 0; nArray != null && n2 < nArray.length; ++n2) {
            try {
                serializable.add(iEntityTableModel.getEntityModelByIndex(nArray[n2]));
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return serializable;
    }

    public static List getAddPortsForOchnc(INodeModel iNodeModel) {
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        if (iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING)) {
            int[] nArray;
            IEntityTableModel iEntityTableModel;
            block9: {
                iEntityTableModel = iNodeModel.getEntityTable();
                nArray = new int[]{};
                try {
                    nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailAddEntitiesForOchnc();
                }
                catch (Exception exception) {
                    if (!db.on()) break block9;
                    db.println("Cannot get available entities for OCHNC: " + exception.getMessage());
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (db.on()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(Integer.toHexString(nArray[i]));
                }
                db.println("Node " + iNodeModel + " - ADD entities for " + ": [" + stringBuffer + "]");
            }
            for (int i = 0; nArray != null && i < nArray.length; ++i) {
                try {
                    linkedList.add(iEntityTableModel.getEntityModelByIndex(nArray[i]));
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        } else {
            throw new FeatureNotSupported("OchPortsHelper.getAddPortsForOchnc() is not supported");
        }
        return linkedList;
    }

    private static int[] getOutPoints(int n, IEntityModel iEntityModel, INodeModel iNodeModel) throws NoSuchEquipment {
        int[] nArray;
        block4: {
            nArray = new int[]{};
            try {
                nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailOchncPathEntities(n, iEntityModel.getEntityIndex());
            }
            catch (AlreadyInUse alreadyInUse) {
                if (db.on()) {
                    db.println("The OCHNC Path for channel " + iEntityModel + " is already in use");
                }
                if (alreadyInUse.hasEntityIndex()) {
                    nArray = new int[]{alreadyInUse.getEntityIndex()};
                }
                if (!db.on()) break block4;
                db.println("AlreadyInUse exception did not report the index of the entity using the OCHNC path!");
            }
        }
        return nArray;
    }
}

