/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.Optics.sOChEqualizationAttributes;
import cerent.cms.idl.Optics.sOChEqualizationInfo;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.ui.Wavelength;
import cerent.util.SDebug;
import java.util.Observable;
import org.omg.CORBA.UserException;

public class OchsPwrMonitoringModel
extends Model {
    private NodeModelDelegate nmd;
    private OchsEqualizationInfo ochsEqualizationInfo;
    private static ModelSingletonCollection ochsPwrMonitoringModelSingleton;
    private int ringDirection;
    protected static final SDebug db;
    private static final int ADD = 0;
    private static final int PT = 1;
    private static final int OUT = 2;
    private static final int WAVELENGTHS = 32;
    private static final double LOWEST_PWR = -25.0;

    private OchsPwrMonitoringModel(NodeModelDelegate nodeModelDelegate) {
        super(db);
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.ochsEqualizationInfo = new OchsEqualizationInfo(this.nmd, "OchsPwrMonitoringModel::ochEqualizationInfo");
    }

    public static synchronized OchsPwrMonitoringModel getInstance(NodeModelDelegate nodeModelDelegate) {
        OchsPwrMonitoringModel ochsPwrMonitoringModel;
        if (ochsPwrMonitoringModelSingleton == null) {
            ochsPwrMonitoringModelSingleton = ModelSingletonCollection.getMSCInstanceByName((String)"OchsPwrMonitoringModel");
        }
        if ((ochsPwrMonitoringModel = (OchsPwrMonitoringModel)ochsPwrMonitoringModelSingleton.get((Object)nodeModelDelegate)) == null) {
            ochsPwrMonitoringModel = new OchsPwrMonitoringModel(nodeModelDelegate);
            ochsPwrMonitoringModelSingleton.add((Object)nodeModelDelegate, (Object)ochsPwrMonitoringModel);
            if (db.on()) {
                db.println("getInstance(): first time create it.");
            }
        } else if (db.on()) {
            db.println("getInstance(): already created.");
        }
        return ochsPwrMonitoringModel;
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public synchronized void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("Got update from " + observable + " arg=" + object);
        }
    }

    public void init() throws CTCUserException {
        if (db.on()) {
            db.println("init()");
        }
        super.init0();
    }

    public int getRingDirection() {
        return this.ringDirection;
    }

    public double[][] getEqualizationPwrValues(int n, int n2) throws CTCUserException {
        double[][] dArrayArray = new double[][]{new double[32], new double[32], new double[32]};
        if (db.on()) {
            db.println("getEqualizationPwrValues()");
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 32; ++j) {
                dArrayArray[i][j] = -25.0;
            }
        }
        sOChEqualizationInfo sOChEqualizationInfo2 = this.getOchEqualizationInfo(n);
        this.ringDirection = sOChEqualizationInfo2.direction.value();
        sOChEqualizationAttributes[] sOChEqualizationAttributesArray = sOChEqualizationInfo2.ochEqualizationAttributesList;
        if (db.on()) {
            db.println("getEqualizationPwrValues: got " + sOChEqualizationAttributesArray.length + " values");
        }
        int n3 = -1;
        for (int i = 0; i < sOChEqualizationAttributesArray.length; ++i) {
            if (n2 == 1) {
                n3 = Wavelength.getLambdaLChannelOffset(sOChEqualizationAttributesArray[i].lambdaId.value());
            } else if (n2 == 0) {
                n3 = Wavelength.getLambdaCChannelOffset(sOChEqualizationAttributesArray[i].lambdaId.value());
            }
            if (db.on()) {
                db.print("Lambda Offset:" + n3);
            }
            if (sOChEqualizationAttributesArray[i].addPower != -1000000 && (double)sOChEqualizationAttributesArray[i].addPower / 10.0 > -25.0) {
                dArrayArray[0][n3] = (double)sOChEqualizationAttributesArray[i].addPower / 10.0;
            }
            if (sOChEqualizationAttributesArray[i].passThroughPower != -1000000 && (double)sOChEqualizationAttributesArray[i].passThroughPower / 10.0 > -25.0) {
                dArrayArray[1][n3] = (double)sOChEqualizationAttributesArray[i].passThroughPower / 10.0;
            }
            if (sOChEqualizationAttributesArray[i].outputPower == -1000000 || !((double)sOChEqualizationAttributesArray[i].outputPower / 10.0 > -25.0)) continue;
            dArrayArray[2][n3] = (double)sOChEqualizationAttributesArray[i].outputPower / 10.0;
        }
        return dArrayArray;
    }

    public void dispose() {
        if (db.on()) {
            db.println("dispose()");
        }
        super.dispose();
    }

    public void destroy() {
        if (db.on()) {
            db.println("destroy()");
        }
        super.destroy();
    }

    public sOChEqualizationInfo getOchEqualizationInfo(int n) throws CTCUserException {
        try {
            return (sOChEqualizationInfo)this.ochsEqualizationInfo.getValue(new Integer(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new CTCUserException((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new CTCUserException((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "getOchEqualizationInfo", userException);
        }
    }

    static {
        db = new SDebug("OchsPwrMonitoringModel");
    }

    private class OchsEqualizationInfo
    extends NonCachedValue {
        public OchsEqualizationInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            if (OchsPwrMonitoringModel.db.on) {
                db.println(this.getClass() + "::getValue");
            }
            return this.node.getIorRepository().getOpticsChannelRef().getOChEqualizationAttributes((Integer)object);
        }

        public Object outer() {
            return OchsPwrMonitoringModel.this;
        }
    }
}

