/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.SonetMedia.sOverheadTerm;
import cerent.cms.idl.SonetTopology.OverheadTermination;
import cerent.cms.idl.SonetTopology.sOverheadIpTunnel;
import cerent.cms.idl.SonetTopology.sOverheadIpTunnelItem;
import cerent.cms.idl.SonetTopology.sOverheadTermItem;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.Connections;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IOhIpTunnelTerm;
import cerent.cms.model.IOhIpTunnelTermModel;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhTermFactory;
import cerent.cms.model.OhTermModel;
import cerent.util.SDebug;
import org.omg.CORBA.UserException;

public class OhIpTunnelTermModel
extends OhTermModel
implements IOhIpTunnelTermModel {
    private OhIpTunnelTerm ohIpTunnelTerm;
    private NodeModelDelegate node;
    private IIpAddr srcIp;
    private IIpAddr dstIp;
    private int maxBwPercent;
    private sOverheadIpTunnel tunnel;

    public OhIpTunnelTermModel(NodeModelDelegate nodeModelDelegate, sOverheadIpTunnelItem sOverheadIpTunnelItem2, Connections connections) {
        this(nodeModelDelegate, sOverheadIpTunnelItem2.overheadTerm.termination, connections);
        this.setAttributes(sOverheadIpTunnelItem2);
    }

    public OhIpTunnelTermModel(NodeModelDelegate nodeModelDelegate, sOverheadTermItem sOverheadTermItem2, Connections connections) {
        this(nodeModelDelegate, sOverheadTermItem2.termination, connections);
        this.setAttributes(sOverheadTermItem2);
    }

    public OhIpTunnelTermModel(NodeModelDelegate nodeModelDelegate, OverheadTermination overheadTermination, Connections connections) {
        block3: {
            super(nodeModelDelegate, overheadTermination, connections);
            this.ohIpTunnelTerm = null;
            this.node = null;
            this.srcIp = null;
            this.dstIp = null;
            this.maxBwPercent = 0;
            try {
                this.tunnel = overheadTermination.getIpTunnel();
            }
            catch (xUnsupportedOperation xUnsupportedOperation2) {
                if (!this.db.on()) break block3;
                this.db.println(" Unable to obtain tunnel");
            }
        }
        if (this.tunnel != null) {
            this.srcIp = IpAddrFactory.getIIpAddr(this.tunnel.srcNodeIp);
            this.dstIp = IpAddrFactory.getIIpAddr(this.tunnel.destNodeIp);
            this.maxBwPercent = this.tunnel.maxBwPercent;
        }
        this.node = nodeModelDelegate;
        this.ohIpTunnelTerm = new OhIpTunnelTerm(nodeModelDelegate, "OhIpTunnelTermModel.ohTerm");
    }

    public void init() {
        super.init();
        this.ohIpTunnelTerm.init();
    }

    protected void updateLocal() {
        super.updateLocal();
        this.ohIpTunnelTerm.update();
        this.srcIp = this.getOhIpTunnelTerm().getSrcNodeIP();
        this.dstIp = this.getOhIpTunnelTerm().getDstNodeIP();
        this.maxBwPercent = this.getOhIpTunnelTerm().getMaxBwPercent();
        if (this.db.on()) {
            this.db.println(this.toString());
        }
    }

    public void dispose() {
        this.ohIpTunnelTerm.dispose();
        super.dispose();
    }

    public IOhIpTunnelTerm getOhIpTunnelTerm() {
        try {
            sOverheadIpTunnel sOverheadIpTunnel2 = (sOverheadIpTunnel)this.ohIpTunnelTerm.getValue();
            sOverheadTerm sOverheadTerm2 = OhTermFactory.getOhTerm(this.getOhTerm());
            return OhTermFactory.getIOhIpTunnelTerm(sOverheadTerm2, sOverheadIpTunnel2, this.node);
        }
        catch (UserException userException) {
            this.db.severe("OhTermModel: user exception in getOhTerm");
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            return null;
        }
    }

    public void setIpTunnelTerm(IOhIpTunnelTerm iOhIpTunnelTerm) {
        block3: {
            try {
                sOverheadIpTunnel sOverheadIpTunnel2 = OhTermFactory.getOhIpTunnel(iOhIpTunnelTerm);
                if (this.db.on()) {
                    this.db.println("tunnel: " + sOverheadIpTunnel2.maxBwPercent);
                }
                Object[] objectArray = new Object[]{sOverheadIpTunnel2};
                this.ohIpTunnelTerm.set(objectArray);
            }
            catch (UserException userException) {
                this.db.severe("OhTermModel: user exception in setOhTerm");
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)userException);
            }
        }
    }

    public void setAttributes(sOverheadIpTunnelItem sOverheadIpTunnelItem2) {
        sOverheadTermItem sOverheadTermItem2 = sOverheadIpTunnelItem2.overheadTerm;
        this.objIndex.setValueExternally(new Integer(sOverheadTermItem2.objIndex));
        this.circuitId.setValueExternally(sOverheadTermItem2.circuitId);
        this.ohTerm.setValueExternally(sOverheadTermItem2);
        this.ohIpTunnelTerm.setValueExternally(sOverheadIpTunnelItem2.ipTunnel);
        this.srcIp = IpAddrFactory.getIIpAddr(sOverheadIpTunnelItem2.ipTunnel.srcNodeIp);
        this.dstIp = IpAddrFactory.getIIpAddr(sOverheadIpTunnelItem2.ipTunnel.destNodeIp);
        this.maxBwPercent = sOverheadIpTunnelItem2.ipTunnel.maxBwPercent;
    }

    public boolean usedChannel(int n, OhChannelType ohChannelType) {
        return this.getChannelType() == ohChannelType.getIndex() && this.getOpticalPortIndex() == n;
    }

    protected void printString(SDebug sDebug) {
        sDebug.fine("OhTerm : " + this.getOhIpTunnelTerm());
        sDebug.fine("Circuit Name " + this.getName());
        sDebug.fine("Observers are :");
        this.printObservers();
    }

    public String toString() {
        try {
            if (this.description == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Overhead IP TunnelTermination: NodeId=");
                stringBuffer.append(Integer.toHexString(this.getNodeModel().getNodeId()));
                stringBuffer.append(" OhTerm=");
                stringBuffer.append(this.getOhTerm());
                stringBuffer.append(" OhIpTunnelTerm=");
                stringBuffer.append(this.getOhIpTunnelTerm());
                stringBuffer.append(" CircuitName=");
                stringBuffer.append(this.getName());
                stringBuffer.append("Source IP= ");
                stringBuffer.append(this.getOhIpTunnelTerm().getSrcNodeIP());
                stringBuffer.append("Dest IP= ");
                stringBuffer.append(this.getOhIpTunnelTerm().getDstNodeIP());
                this.description = stringBuffer.toString();
            }
            return this.description;
        }
        catch (CmsObjectNotExistException cmsObjectNotExistException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
            return "DELETED";
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof OhIpTunnelTermModel)) {
            return false;
        }
        OhIpTunnelTermModel ohIpTunnelTermModel = (OhIpTunnelTermModel)object;
        return this.getNodeModel().equals(ohIpTunnelTermModel.getNodeModel()) && this.getIndex() == ohIpTunnelTermModel.getIndex();
    }

    public IIpAddr getSrcIp() {
        this.srcIp = this.getOhIpTunnelTerm().getSrcNodeIP();
        return this.srcIp;
    }

    public IIpAddr getDstIp() {
        this.dstIp = this.getOhIpTunnelTerm().getDstNodeIP();
        return this.dstIp;
    }

    public int getMaxBwPercent() {
        this.maxBwPercent = this.getOhIpTunnelTerm().getMaxBwPercent();
        return this.maxBwPercent;
    }

    private class OhIpTunnelTerm
    extends CachedValue {
        public OhIpTunnelTerm(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            if (OhIpTunnelTermModel.this.db.on()) {
                OhIpTunnelTermModel.this.db.finer("Making CORBA call for overhead termination");
            }
            return OhIpTunnelTermModel.this.getOhTerminationRef().getIpTunnel();
        }

        protected void setValue(Object object) throws UserException {
            block2: {
                Object[] objectArray = (Object[])object;
                try {
                    OhIpTunnelTermModel.this.getOhTerminationRef().setIpTunnel((sOverheadIpTunnel)objectArray[0]);
                }
                catch (xUnsupportedOperation xUnsupportedOperation2) {
                    if (!OhIpTunnelTermModel.this.db.on()) break block2;
                    OhIpTunnelTermModel.this.db.println("Unsupported Operation");
                }
            }
        }
    }
}

