/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.Optics.OpticalChannel;
import cerent.cms.idl.Optics.sOpticalChannelAttributes;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConfigError;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import org.omg.CORBA.UserException;

public class OpticsChannelModel
extends AbstractOpticsLineModel {
    private ActualWaveLength actWaveLength;
    private ExpectedWaveLength expectedWaveLength;
    private OpticalChannel opticalChannel;
    private static final SDebug db = new SDebug("OpticsChannelModel");

    protected OpticsChannelModel(NodeModelDelegate nodeModelDelegate, int n) {
        this(nodeModelDelegate, n, (sInterface)null);
    }

    public OpticsChannelModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2) {
        super(nodeModelDelegate, n, sInterface2, nodeModelDelegate.getIorRepository().getOpticsChannelRef(), db);
        this.opticalChannel = nodeModelDelegate.getIorRepository().getOpticsChannelRef();
        this.actWaveLength = new ActualWaveLength(this.getNodeModelDelegate(), "ActualWaveLength");
        this.expectedWaveLength = new ExpectedWaveLength(this.getNodeModelDelegate(), "ExpectedWaveLength");
    }

    public void destroy() {
        super.destroy();
    }

    protected void updateLocal(long l) {
        this.expectedWaveLength.update();
        this.actWaveLength.update();
        super.updateLocal(l);
    }

    public boolean isWavelengthSupported() throws NoSuchInterface, WrongInterfaceType {
        return true;
    }

    public int getActualWaveLength() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((eWavelength)this.actWaveLength.get()).value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GETACTUAL_WAVELENGTH), userException);
        }
    }

    public eWavelength getActualWaveLengthEnum() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eWavelength)this.actWaveLength.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GETACTUAL_WAVELENGTH), userException);
        }
    }

    public int getExpectedWaveLength() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((eWavelength)this.expectedWaveLength.get()).value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GETEXPECTED_WAVELENGTH), userException);
        }
    }

    public eWavelength getExpectedWaveLengthEnum() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eWavelength)this.expectedWaveLength.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GETEXPECTED_WAVELENGTH), userException);
        }
    }

    public void setExpectedWaveLength(eWavelength eWavelength2) throws NoSuchInterface, WrongInterfaceType, ConfigError, InternalCommError {
        try {
            this.expectedWaveLength.set(eWavelength2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_SETEXPECTED_WAVELENGTH), userException);
        }
    }

    public void setAttributes(sOpticalChannelAttributes sOpticalChannelAttributes2, long l) {
        super.setAttributes(sOpticalChannelAttributes2.general, l);
        this.expectedWaveLength.setValueExternally(sOpticalChannelAttributes2.expectedLambda);
        this.actWaveLength.setValueExternally(sOpticalChannelAttributes2.actualLambda);
    }

    public void dispose() {
        this.actWaveLength.dispose();
        this.expectedWaveLength.dispose();
        super.dispose();
    }

    public String toString() {
        return "OpticsChannelModel" + super.toString();
    }

    private class ExpectedWaveLength
    extends CachedValue {
        private ExpectedWaveLength(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OpticsChannelModel.this.opticalChannel.getExpectedWavelength(OpticsChannelModel.this.getIndex());
        }

        protected void setValue(Object object) throws UserException {
            OpticsChannelModel.this.opticalChannel.setExpectedWavelength(OpticsChannelModel.this.getIndex(), (eWavelength)object);
        }
    }

    private class ActualWaveLength
    extends CachedValue {
        private ActualWaveLength(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OpticsChannelModel.this.opticalChannel.getActualWavelength(OpticsChannelModel.this.getIndex());
        }
    }
}

