/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Optics.ALS_SUPPORTED;
import cerent.cms.idl.Optics.AmplifiedOpticalLine;
import cerent.cms.idl.Optics.eLaserStatus;
import cerent.cms.idl.Optics.eOSRIStatus;
import cerent.cms.idl.Optics.eOpticalAmplifierControlMode;
import cerent.cms.idl.Optics.eOpticalAmplifierRole;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.OscTermConnectionModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.SettingDisabled;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class OpticsModuleModel
extends ModuleModel
implements ALS_SUPPORTED {
    static final byte LINE = 0;
    static final byte AMPLIFIED_LINE = 1;
    static final byte MULTIPLEX_SECTION = 2;
    static final byte CHANNEL = 3;
    public static final byte BST_ALS_INTERFACE_INDEX = 5;
    public static final byte PRE_ALS_INTERFACE_INDEX = 1;
    private boolean isLaserSupportedInited = false;
    private boolean isOpticsLinePowerSupportedInited = false;
    private boolean isOpticsLineVOASupportedInited = false;
    private boolean isOpticsAmplifiedLinePowerSupportedInited = false;
    private boolean isOpticsChannelPowerSupportedInited = false;
    private boolean isOpticsChannelAddPowerSupportedInited = false;
    private boolean isOpticsChannelVOASupportedInited = false;
    private boolean isOMSPowerSupportedInited = false;
    private boolean laserSupportedValue = false;
    private boolean opticsLinePowerSupportedValue = false;
    private boolean opticsLineVOASupportedValue = false;
    private boolean opticsAmplifiedLinePowerSupportedValue = false;
    private boolean opticsChannelPowerSupportedValue = false;
    private boolean opticsChannelAddPowerSupportedValue = false;
    private boolean opticsChannelVOASupportedValue = false;
    private boolean oMSPowerSupportedValue = false;
    private static final SDebug db = new SDebug("OpticsModuleModel");

    public OpticsModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, db);
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        portModelArray = eEqType2 == eEqType.OSCM_PORT || eEqType2 == eEqType.OADM_PORT || eEqType2 == eEqType.AMP_PORT || eEqType2 == eEqType.MUX_DMX_PORT ? this.getChildrenOfType(eEqType2).toArray(new OpticsPortModel[0]) : (eEqType2 == eEqType.OC3_PORT ? this.getChildrenOfType(eEqType2).toArray(new TdmPortModel[0]) : super.getPortModels(eEqType2));
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    public boolean isOpticsCard() {
        return true;
    }

    public eOpticalAmplifierRole getAmpliRole() throws NoSuchInterface, WrongInterfaceType {
        OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray = this.getOpticsAmplifiedLineModels();
        if (opticsAmplifiedLineModelArray.length > 0) {
            return opticsAmplifiedLineModelArray[0].getAmpliRole();
        }
        return eOpticalAmplifierRole.NO_AMPLI;
    }

    public void setAmpliRole(eOpticalAmplifierRole eOpticalAmplifierRole2) throws ConfigError, WrongInterfaceType, NoSuchInterface, SettingDisabled {
        OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray = this.getOpticsAmplifiedLineModels();
        if (opticsAmplifiedLineModelArray.length > 0) {
            opticsAmplifiedLineModelArray[0].setAmpliRole(eOpticalAmplifierRole2);
        }
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        PortModel[] portModelArray = this.getPortModels(eEqType2);
        InterfaceModel[] interfaceModelArray = null;
        if (eEqType2 == eEqType.OC3_PORT) {
            interfaceModelArray = new TdmLineModel[portModelArray.length];
            for (int i = 0; i < portModelArray.length; ++i) {
                interfaceModelArray[i] = (TdmLineModel)portModelArray[i].getInterfaceModel();
            }
        } else {
            interfaceModelArray = super.getLineModels(eEqType2);
        }
        return interfaceModelArray == null ? new InterfaceModel[]{} : interfaceModelArray;
    }

    private AmplifiedOpticalLine getOpticsAmpliRef() {
        return this.node.getIorRepository().getOpticsAmpliRef();
    }

    public OpticsPortModel[] getOpticsChildren() {
        ArrayList<PortModel> arrayList = new ArrayList<PortModel>();
        arrayList.addAll(Arrays.asList(this.getPortModels(eEqType.OSCM_PORT)));
        arrayList.addAll(Arrays.asList(this.getPortModels(eEqType.OADM_PORT)));
        arrayList.addAll(Arrays.asList(this.getPortModels(eEqType.AMP_PORT)));
        arrayList.addAll(Arrays.asList(this.getPortModels(eEqType.MUX_DMX_PORT)));
        return arrayList.toArray(new OpticsPortModel[0]);
    }

    public TdmPortModel[] getOC3Children() {
        return (TdmPortModel[])this.getPortModels(eEqType.OC3_PORT);
    }

    private Vector getOpticsModels(byte by) {
        Vector<AbstractOpticsLineModel> vector = new Vector<AbstractOpticsLineModel>();
        OpticsPortModel[] opticsPortModelArray = this.getOpticsChildren();
        block6: for (int i = 0; i < opticsPortModelArray.length; ++i) {
            switch (by) {
                case 0: {
                    if (!(opticsPortModelArray[i].getOpticsLineModel() instanceof OpticsLineModel)) continue block6;
                    vector.add(opticsPortModelArray[i].getOpticsLineModel());
                    continue block6;
                }
                case 1: {
                    if (!(opticsPortModelArray[i].getOpticsLineModel() instanceof OpticsAmplifiedLineModel)) continue block6;
                    vector.add(opticsPortModelArray[i].getOpticsLineModel());
                    continue block6;
                }
                case 2: {
                    if (!(opticsPortModelArray[i].getOpticsLineModel() instanceof OpticsMultiplexSectionModel)) continue block6;
                    vector.add(opticsPortModelArray[i].getOpticsLineModel());
                    continue block6;
                }
                case 3: {
                    if (!(opticsPortModelArray[i].getOpticsLineModel() instanceof OpticsChannelModel)) continue block6;
                    vector.add(opticsPortModelArray[i].getOpticsLineModel());
                }
            }
        }
        return vector;
    }

    public OpticsLineModel[] getOpticsLineModels() {
        return this.getOpticsModels((byte)0).toArray(new OpticsLineModel[0]);
    }

    public OpticsLineModel[] getOpticsPmLineModels() {
        OpticsLineModel[] opticsLineModelArray = this.getOpticsLineModels();
        ArrayList<OpticsLineModel> arrayList = new ArrayList<OpticsLineModel>();
        for (int i = 0; i < opticsLineModelArray.length; ++i) {
            if (!opticsLineModelArray[i].isPMSupported()) continue;
            arrayList.add(opticsLineModelArray[i]);
        }
        return arrayList.toArray(new OpticsLineModel[0]);
    }

    public OpticsAmplifiedLineModel[] getOpticsAmplifiedLineModels() {
        return this.getOpticsModels((byte)1).toArray(new OpticsAmplifiedLineModel[0]);
    }

    public OpticsChannelModel[] getOpticsChannelModels() {
        return this.getOpticsModels((byte)3).toArray(new OpticsChannelModel[0]);
    }

    public OpticsMultiplexSectionModel[] getOpticsOMSModels() {
        return this.getOpticsModels((byte)2).toArray(new OpticsMultiplexSectionModel[0]);
    }

    public boolean isOpticsLinePowerSupported() {
        if (!this.isOpticsLinePowerSupportedInited) {
            this.opticsLinePowerSupportedValue = this.opticsLinePowerSupportedInit();
            this.isOpticsLinePowerSupportedInited = true;
        }
        return this.opticsLinePowerSupportedValue;
    }

    public boolean isOpticsLineVOASupported() {
        if (!this.isOpticsLineVOASupportedInited) {
            this.opticsLineVOASupportedValue = this.opticsLineVOASupportedInit();
            this.isOpticsLineVOASupportedInited = true;
        }
        return this.opticsLineVOASupportedValue;
    }

    public boolean isOpticsAmplifiedLinePowerSupported() {
        if (!this.isOpticsAmplifiedLinePowerSupportedInited) {
            this.opticsAmplifiedLinePowerSupportedValue = this.opticsAmplifiedLinePowerSupportedInit();
            this.isOpticsAmplifiedLinePowerSupportedInited = true;
        }
        return this.opticsAmplifiedLinePowerSupportedValue;
    }

    public boolean isOpticsChannelPowerSupported() {
        if (!this.isOpticsChannelPowerSupportedInited) {
            this.opticsChannelPowerSupportedValue = this.opticsChannelPowerSupportedInit();
            this.isOpticsChannelPowerSupportedInited = true;
        }
        return this.opticsChannelPowerSupportedValue;
    }

    public boolean isOpticsChannelAddPowerSupported() {
        if (!this.isOpticsChannelAddPowerSupportedInited) {
            this.opticsChannelAddPowerSupportedValue = this.opticsChannelAddPowerSupportedInit();
            this.isOpticsChannelAddPowerSupportedInited = true;
        }
        return this.opticsChannelAddPowerSupportedValue;
    }

    public boolean isOpticsChannelVOASupported() {
        if (!this.isOpticsChannelVOASupportedInited) {
            this.opticsChannelVOASupportedValue = this.opticsChannelVOASupportedInit();
            this.isOpticsChannelVOASupportedInited = true;
        }
        return this.opticsChannelVOASupportedValue;
    }

    public boolean isOMSPowerSupported() {
        if (!this.isOMSPowerSupportedInited) {
            this.oMSPowerSupportedValue = this.oMSPowerSupportedInit();
            this.isOMSPowerSupportedInited = true;
        }
        return this.oMSPowerSupportedValue;
    }

    public boolean isLaserSupported() {
        if (!this.isLaserSupportedInited) {
            this.laserSupportedValue = this.laserSupportedInit();
            this.isLaserSupportedInited = true;
        }
        return this.laserSupportedValue;
    }

    private boolean opticsLinePowerSupportedInit() {
        OpticsLineModel[] opticsLineModelArray = this.getOpticsModels((byte)0).toArray(new OpticsLineModel[0]);
        for (int i = 0; i < opticsLineModelArray.length; ++i) {
            try {
                if ((opticsLineModelArray[i].getFeatures() & 0x20) != 32) continue;
                return true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    private boolean opticsLineVOASupportedInit() {
        OpticsLineModel[] opticsLineModelArray = this.getOpticsModels((byte)0).toArray(new OpticsLineModel[0]);
        for (int i = 0; i < opticsLineModelArray.length; ++i) {
            try {
                if ((opticsLineModelArray[i].getFeatures() & 1) != 1) continue;
                return true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    private boolean opticsAmplifiedLinePowerSupportedInit() {
        OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray = this.getOpticsModels((byte)1).toArray(new OpticsAmplifiedLineModel[0]);
        for (int i = 0; i < opticsAmplifiedLineModelArray.length; ++i) {
            try {
                if ((opticsAmplifiedLineModelArray[i].getFeatures() & 0x20) != 32) continue;
                return true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    private boolean opticsChannelPowerSupportedInit() {
        OpticsChannelModel[] opticsChannelModelArray = this.getOpticsModels((byte)3).toArray(new OpticsChannelModel[0]);
        for (int i = 0; i < opticsChannelModelArray.length; ++i) {
            try {
                if ((opticsChannelModelArray[i].getFeatures() & 0x20) != 32) continue;
                return true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    private boolean opticsChannelAddPowerSupportedInit() {
        OpticsChannelModel[] opticsChannelModelArray = this.getOpticsModels((byte)3).toArray(new OpticsChannelModel[0]);
        for (int i = 0; i < opticsChannelModelArray.length; ++i) {
            try {
                if ((opticsChannelModelArray[i].getFeatures() & 0x10) != 16) continue;
                return true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    private boolean opticsChannelVOASupportedInit() {
        OpticsChannelModel[] opticsChannelModelArray = this.getOpticsModels((byte)3).toArray(new OpticsChannelModel[0]);
        for (int i = 0; i < opticsChannelModelArray.length; ++i) {
            try {
                if ((opticsChannelModelArray[i].getFeatures() & 1) != 1) continue;
                return true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    public boolean oMSPowerSupportedInit() {
        OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray = this.getOpticsModels((byte)2).toArray(new OpticsMultiplexSectionModel[0]);
        for (int i = 0; i < opticsMultiplexSectionModelArray.length; ++i) {
            try {
                if ((opticsMultiplexSectionModelArray[i].getFeatures() & 0x20) != 32) continue;
                return true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    public AbstractOpticsLineModel getALSInterface() throws NoSuchInterface, WrongInterfaceType {
        OpticsPortModel[] opticsPortModelArray = this.getOpticsChildren();
        for (int i = 0; i < opticsPortModelArray.length; ++i) {
            if ((opticsPortModelArray[i].getOpticsLineModel().getFeatures() & 2) != 2) continue;
            return opticsPortModelArray[i].getOpticsLineModel();
        }
        return null;
    }

    private boolean laserSupportedInit() {
        OpticsPortModel[] opticsPortModelArray = this.getOpticsChildren();
        int n = 0;
        while (n < opticsPortModelArray.length) {
            try {
                if ((opticsPortModelArray[n].getOpticsLineModel().getFeatures() & 0x80) == 128) {
                    return true;
                }
                ++n;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    public TdmLineModel[] getTdmLineModels() {
        return (TdmLineModel[])this.getLineModels(eEqType.OC3_PORT);
    }

    public eLaserStatus getLaserStatus() throws NoSuchInterface, WrongInterfaceType, InternalCommError, FeatureUnsupported {
        AbstractOpticsLineModel abstractOpticsLineModel = this.getALSInterface();
        if (abstractOpticsLineModel != null) {
            return abstractOpticsLineModel.getLaserStatus();
        }
        return null;
    }

    public void manualRestart() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        AbstractOpticsLineModel abstractOpticsLineModel = this.getALSInterface();
        if (abstractOpticsLineModel != null) {
            abstractOpticsLineModel.execManualRestart();
        }
    }

    public void setOSRIStatus(eOSRIStatus eOSRIStatus2) throws NoSuchInterface, WrongInterfaceType, InternalCommError, FeatureUnsupported {
        AbstractOpticsLineModel abstractOpticsLineModel = this.getALSInterface();
        if (abstractOpticsLineModel != null) {
            abstractOpticsLineModel.setOSRIStatus(eOSRIStatus2);
        }
    }

    public eOSRIStatus getOSRIStatus() throws NoSuchInterface, WrongInterfaceType, FeatureUnsupported {
        AbstractOpticsLineModel abstractOpticsLineModel = this.getALSInterface();
        if (abstractOpticsLineModel != null) {
            return abstractOpticsLineModel.getOSRIStatus();
        }
        return null;
    }

    public eOpticalAmplifierControlMode getControlMode() throws NoSuchInterface, WrongInterfaceType {
        OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray = this.getOpticsAmplifiedLineModels();
        if (opticsAmplifiedLineModelArray.length > 0) {
            return opticsAmplifiedLineModelArray[0].getControlMode();
        }
        return null;
    }

    public String toString() {
        return "OpticsModuleModel" + super.toString();
    }

    public List getConnectionsList() {
        LinkedList<IOchncConnectionModel> linkedList = new LinkedList<IOchncConnectionModel>();
        OpticsPortModel[] opticsPortModelArray = this.getOpticsChildren();
        if (opticsPortModelArray != null) {
            for (int i = 0; i < opticsPortModelArray.length; ++i) {
                List list = ((ConnectionModelsDelegate)this.node.getConnectionModels()).getOchncConnectionModels(opticsPortModelArray[i].getEntityIndex());
                if (list == null) continue;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    IOchncConnectionModel iOchncConnectionModel = (IOchncConnectionModel)iterator.next();
                    if (linkedList.contains(iOchncConnectionModel)) continue;
                    linkedList.add(iOchncConnectionModel);
                }
            }
        }
        return linkedList;
    }

    public boolean hasOSCMOC3UsedPorts() {
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        return ((OscTermConnectionModel)nodeModelDelegate.getOscTermConnectionModel()).hasUsedOc3Ports(this);
    }

    public boolean hasDWDMPatchCord() {
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        return nodeModelDelegate.getOpticalPatchCordModel().hasCardDWDMOpticalPatch(Integer.parseInt(this.getLocation()));
    }
}

