/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.sOrderwireConfig;
import cerent.cms.model.OrderwireDbConfig;

public class OrderwireConfigFactory {
    public static final int AIC_CONVERT = 0;
    public static final int AICI_CONVERT = 1;
    private static final int L4RX = 0;
    private static final int L4TX = 1;
    private static final int L2RX = 2;
    private static final int L2TX = 3;
    public static final int[] minValues_aic = new int[]{-16, -16, 0, -10};
    public static final int[] minValues_aici = new int[]{-16, 0, 0, -15};
    private static final int[] rawValuesL4RX_aic = new int[]{189, 168, 150, 134, 119, 106, 95, 84, 75, 67, 60, 53, 47, 42, 38, 34, 30, 27, 24, 21, 19, 17, 15, 13};
    private static final int[] rawValuesL4RX_aici = new int[]{190, 170, 151, 135, 120, 107, 95, 85, 76, 68, 60, 54, 48, 42, 38, 34, 30};
    private static final int[] rawValuesL4TX_aic = new int[]{14, 16, 17, 20, 22, 25, 28, 31, 35, 39, 44, 49, 55, 62, 69, 78, 87, 98, 110, 123, 139, 155, 174, 196};
    private static final int[] rawValuesL4TX_aici = new int[]{85, 96, 107, 120, 135, 152, 170, 192};
    private static final int[] rawValuesL2RX_aic = new int[]{233, 208, 185, 165, 147, 131, 117, 104, 93, 83, 74};
    private static final int[] rawValuesL2RX_aici = new int[]{117, 111, 104, 99, 92, 88, 83, 78, 74, 70, 66};
    private static final int[] rawValuesL2TX_aic = new int[]{72, 81, 91, 102, 115, 129, 145, 162, 182, 204, 229};
    private static final int[] rawValuesL2TX_aici = new int[]{95, 100, 106, 113, 119, 126, 134, 141, 150, 159, 169, 179, 189, 200, 212, 223};
    protected static final int[][] rawValues_aic = new int[][]{rawValuesL4RX_aic, rawValuesL4TX_aic, rawValuesL2RX_aic, rawValuesL2TX_aic};
    protected static final int[][] rawValues_aici = new int[][]{rawValuesL4RX_aici, rawValuesL4TX_aici, rawValuesL2RX_aici, rawValuesL2TX_aici};

    private OrderwireConfigFactory() {
    }

    public static sOrderwireConfig convert(OrderwireDbConfig orderwireDbConfig, int n) {
        short s = (short)OrderwireConfigFactory.getRaw(0, n, orderwireDbConfig.getLevel4wRcv());
        short s2 = (short)OrderwireConfigFactory.getRaw(1, n, orderwireDbConfig.getLevel4wXmt());
        short s3 = (short)OrderwireConfigFactory.getRaw(2, n, orderwireDbConfig.getLevel2wRcv());
        short s4 = (short)OrderwireConfigFactory.getRaw(3, n, orderwireDbConfig.getLevel2wXmt());
        return new sOrderwireConfig(s, s2, s3, s4, orderwireDbConfig.getBuzzer());
    }

    public static OrderwireDbConfig convert(sOrderwireConfig sOrderwireConfig2, int n) {
        float f = OrderwireConfigFactory.getDb(0, n, sOrderwireConfig2.level4wRcv);
        float f2 = OrderwireConfigFactory.getDb(1, n, sOrderwireConfig2.level4wXmt);
        float f3 = OrderwireConfigFactory.getDb(2, n, sOrderwireConfig2.level2wRcv);
        float f4 = OrderwireConfigFactory.getDb(3, n, sOrderwireConfig2.level2wXmt);
        return new OrderwireDbConfig(f, f2, f3, f4, sOrderwireConfig2.buzzer);
    }

    private static float getDb(int n, int n2, int n3) {
        int[] nArray = n2 == 0 ? rawValues_aic[n] : rawValues_aici[n];
        int n4 = 0;
        try {
            while (true) {
                int n5 = nArray[n4];
                int n6 = nArray[n4 + 1];
                if (!(n5 <= n3 && n3 < n6 || n6 < n3 && n3 <= n5)) {
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        float f = n2 == 0 ? (float)(minValues_aic[n] + n4) : (n == 2 || n == 3 ? (float)(minValues_aici[n] + n4) / 2.0f : (float)(minValues_aici[n] + n4));
        return f;
    }

    private static int getRaw(int n, int n2, double d) {
        int n3 = n2 == 0 ? (int)d - minValues_aic[n] : (n == 2 || n == 3 ? (int)(d * 2.0) - minValues_aici[n] : (int)d - minValues_aici[n]);
        return n2 == 0 ? rawValues_aic[n][n3] : rawValues_aici[n][n3];
    }
}

