/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Dwdm.eGccRate;
import cerent.cms.idl.OpticsTopology.sOscPort;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.TdmPortModel;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class OscTermConnectionModel
extends AbstractTermConnectionModel {
    private static final OhChannelType OSC_TERM_CHANNEL = OhChannelType.SDCC_OBJ;
    private static ModelSingletonCollection oscTermModelSingletons;

    private OscTermConnectionModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
    }

    public static synchronized OscTermConnectionModel getInstance(NodeModelDelegate nodeModelDelegate) {
        OscTermConnectionModel oscTermConnectionModel;
        if (oscTermModelSingletons == null) {
            oscTermModelSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"OscTermConnectionModel");
        }
        if ((oscTermConnectionModel = (OscTermConnectionModel)oscTermModelSingletons.get((Object)nodeModelDelegate)) == null) {
            oscTermConnectionModel = new OscTermConnectionModel(nodeModelDelegate);
            oscTermModelSingletons.add((Object)nodeModelDelegate, (Object)oscTermConnectionModel);
        }
        return oscTermConnectionModel;
    }

    public boolean entityExistsInTerminations(IEntityModel iEntityModel) {
        return ((OhConnectionModelsDelegate)this.nmd.getOhConnectionModels()).getUsedOpticalPorts(OSC_TERM_CHANNEL).contains(iEntityModel);
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    public IEntityModel[] getTermCandidates() {
        HashSet hashSet = new HashSet(this.getAllOC3Ports());
        hashSet.removeAll(this.getUsedOc3Ports());
        return hashSet.toArray(new IEntityModel[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getUsedOc3Ports() {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        HashSet hashSet = this.getTerms();
        synchronized (hashSet) {
            Iterator iterator = this.getTerms().iterator();
            while (iterator.hasNext()) {
                OhTermModel ohTermModel = (OhTermModel)iterator.next();
                IEntityModel iEntityModel = ohTermModel.getOpticalPortModel();
                arrayList.add(iEntityModel);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUsedOc3Ports(ModuleModel moduleModel) {
        boolean bl = false;
        HashSet hashSet = this.getTerms();
        synchronized (hashSet) {
            Iterator iterator = this.getTerms().iterator();
            while (iterator.hasNext() && !bl) {
                OhTermModel ohTermModel = (OhTermModel)iterator.next();
                IEntityModel iEntityModel = ohTermModel.getOpticalPortModel();
                if (iEntityModel.getModuleModel() != moduleModel) continue;
                bl = true;
            }
        }
        return bl;
    }

    private List getAllOC3Ports() {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        sOscPort[] sOscPortArray = null;
        try {
            sOscPortArray = this.nmd.getDwdmOpticalSetupModel().getOscPortList();
        }
        catch (FeatureUnsupported featureUnsupported) {
            this.db.info(featureUnsupported.toString());
        }
        catch (CannotPerform cannotPerform) {
            SDebug.printStackTrace((Throwable)cannotPerform);
        }
        IEntityModel iEntityModel = null;
        if (sOscPortArray != null) {
            for (int i = 0; i < sOscPortArray.length; ++i) {
                block7: {
                    try {
                        iEntityModel = this.nmd.getEntityTableModel().getEntityModelByIndex(sOscPortArray[i].oscPort);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!this.db.on()) break block7;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                if (iEntityModel == null || !(iEntityModel instanceof TdmPortModel)) continue;
                arrayList.add(iEntityModel);
            }
        }
        return arrayList;
    }

    protected String getTypeName() {
        return "OSC";
    }

    public OhChannelType getChannelType(eGccRate eGccRate2) {
        return OhChannelType.SDCC_OBJ;
    }

    protected boolean termQualifies(OhTermModel ohTermModel) {
        return this.isOscTerm(ohTermModel);
    }
}

